/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.InputStream;
import rene.gui.Global;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;

public class LogoWindow
extends Window
implements Runnable {
    ZirkelFrame ZF;
    Image I;

    public LogoWindow(ZirkelFrame zf) {
        super(zf);
        this.setSize(300, 150);
        Dimension d2 = this.getSize();
        String name = "zirkelframe";
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - 300) / 2, (dim.height - 150) / 2);
        this.loadLogo();
        this.setVisible(true);
    }

    public void loadLogo() {
        try {
            int k;
            InputStream in = this.getClass().getResourceAsStream("/rene/zirkel/logowindow.jpg");
            int pos = 0;
            int n = in.available();
            byte[] b2 = new byte[200000];
            while (n > 0 && (k = in.read(b2, pos, n)) >= 0) {
                pos += k;
                n = in.available();
            }
            in.close();
            this.I = Toolkit.getDefaultToolkit().createImage(b2, 0, pos);
            MediaTracker T = new MediaTracker(this);
            T.addImage(this.I, 0);
            T.waitForAll();
        }
        catch (Exception e2) {
            this.setVisible(false);
            this.I = null;
        }
    }

    public void paint(Graphics g) {
        if (this.I == null) {
            return;
        }
        g.drawImage(this.I, 0, 0, this);
        if (Global.getJavaVersion() >= 1.2) {
            Graphics2D G = (Graphics2D)g;
            G.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.setFont(new Font("Dialog", 0, 11));
        String s = Zirkel.name("version") + " " + Zirkel.name("program.version");
        g.setColor(Color.darkGray);
        g.drawString(s, 135, 80);
        g.setFont(new Font("Dialog", 0, 11));
        g.setColor(Color.GRAY);
        s = "java : " + System.getProperty("java.vm.version");
        g.drawString(s, 135, 95);
    }

    public void run() {
    }
}

