/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel;

import java.awt.Label;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import rene.util.xml.XmlReader;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTagPI;
import rene.util.xml.XmlTagText;
import rene.util.xml.XmlTree;
import rene.zirkel.ZirkelApplet;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.SegmentObject;
import rene.zirkel.tools.AnimatorTool;
import rene.zirkel.tools.ObjectTracker;
import rene.zirkel.tools.Tracker;

public class DemoRunner
implements Runnable,
MouseListener {
    ZirkelCanvas ZC;
    ZirkelApplet ZA;
    boolean Stopped = false;
    boolean Continue = false;
    boolean Hold = false;
    int delay = 10;
    Label L;
    XmlTree Tree;
    AnimatorTool A;

    public DemoRunner(ZirkelCanvas zc, ZirkelApplet za, String filename, Label label) {
        this.ZC = zc;
        this.ZA = za;
        this.L = label;
        try {
            URL url = filename.toUpperCase().startsWith("HTTP") ? new URL(filename) : new URL(this.ZA.getCodeBase(), filename);
            InputStream in = url.openStream();
            XmlReader xml = new XmlReader();
            xml.init(in);
            XmlTree tree = xml.scan();
            Enumeration e2 = tree.getContent();
            while (e2.hasMoreElements()) {
                tree = (XmlTree)e2.nextElement();
                if (tree.getTag() instanceof XmlTagPI) continue;
                if (!tree.getTag().name().equals("Demo")) {
                    throw new ConstructionException("Demo tag not found");
                }
                XmlTag tag = tree.getTag();
                if (!tag.hasParam("delay")) break;
                try {
                    this.delay = Integer.parseInt(tag.getValue("delay"));
                    break;
                }
                catch (Exception ex) {
                    // empty catch block
                    break;
                }
            }
            this.Tree = tree;
            e2 = tree.getContent();
            if (!e2.hasMoreElements()) {
                return;
            }
            while (e2.hasMoreElements()) {
                tree = (XmlTree)e2.nextElement();
                if (tree.getTag().name().equals("File")) continue;
                throw new ConstructionException("Illegal tag " + tree.getTag().name());
            }
            in.close();
        }
        catch (ConstructionException e3) {
            label.setText(e3.toString());
        }
        catch (Exception e4) {
            label.setText("Error loading " + filename);
        }
        zc.addMouseListener(this);
        new Thread(this).start();
    }

    public void run() {
        Enumeration e2 = this.Tree.getContent();
        this.ZC.setFrozen(true);
        while (true) {
            this.Continue = false;
            int D = this.delay;
            if (e2.hasMoreElements()) {
                try {
                    XmlTree tree = (XmlTree)e2.nextElement();
                    XmlTag tag = tree.getTag();
                    String filename = tag.getValue("name");
                    URL url = filename.toUpperCase().startsWith("HTTP") ? new URL(filename) : new URL(this.ZA.getCodeBase(), filename);
                    InputStream in = url.openStream();
                    this.ZC.clearMacros();
                    this.ZC.load(in);
                    in.close();
                    this.ZC.recompute();
                    if (tag.hasParam("delay")) {
                        try {
                            this.delay = Integer.parseInt(tag.getValue("delay"));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    Enumeration en = tree.getContent();
                    while (en.hasMoreElements()) {
                        tree = (XmlTree)en.nextElement();
                        if (!(tree.getTag() instanceof XmlTagText)) continue;
                        this.L.setText(((XmlTagText)tree.getTag()).getContent());
                    }
                    this.startZC();
                }
                catch (Exception ex) {
                    this.L.setText("Error loading file!");
                }
                try {
                    for (int i = 0; i < this.delay * 2 || this.Hold; ++i) {
                        Thread.sleep(500L);
                        if (i == 0) {
                            this.ZC.setFrozen(false);
                            this.ZC.repaint();
                        }
                        if (this.Stopped) {
                            return;
                        }
                        if (!this.Continue) continue;
                        this.Hold = false;
                        break;
                    }
                    this.ZC.setFrozen(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.delay = D;
                continue;
            }
            e2 = this.Tree.getContent();
        }
    }

    public void startZC() {
        block17: {
            Construction C = this.ZC.getConstruction();
            this.ZC.setInteractive(false);
            if (C.TrackP != null) {
                try {
                    ConstructionObject P = C.find(C.TrackP);
                    if (!(P instanceof PointObject) && !(P instanceof PrimitiveLineObject)) {
                        throw new ConstructionException("");
                    }
                    ConstructionObject[] po = new ConstructionObject[C.TrackPO.size()];
                    for (int i = 0; i < po.length; ++i) {
                        ConstructionObject o = C.find((String)C.TrackPO.elementAt(i));
                        if (o == null || !(o instanceof PointObject) && !(o instanceof PrimitiveLineObject) && !(o instanceof PointObject)) {
                            throw new ConstructionException("");
                        }
                        po[i] = o;
                    }
                    PointObject PM = (PointObject)C.find(C.TrackPM);
                    if (C.TrackO != null) {
                        ConstructionObject O = C.find(C.TrackO);
                        if (P == null || PM == null || O == null) {
                            throw new ConstructionException("");
                        }
                        ObjectTracker ot = new ObjectTracker(P, PM, O, this.ZC, C.Animate, C.Paint, po);
                        if (C.Animate) {
                            ot.Interactive = false;
                        }
                        ot.setOmit(C.Omit);
                        this.ZC.setTool(ot);
                        this.ZC.allowRightMouse(false);
                        this.ZC.validate();
                        this.ZC.repaint();
                        break block17;
                    }
                    if (P == null) {
                        throw new ConstructionException("");
                    }
                    this.ZC.setTool(new Tracker(P, po));
                    if (PM != null) {
                        PM.setSelected(true);
                    }
                    this.ZC.validate();
                    this.ZC.repaint();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            } else if (C.AnimateP != null) {
                try {
                    PointObject P = (PointObject)C.find(C.AnimateP);
                    if (P == null || !P.moveable()) {
                        throw new ConstructionException("");
                    }
                    Enumeration e3 = C.AnimateV.elements();
                    while (e3.hasMoreElements()) {
                        String s = (String)e3.nextElement();
                        ConstructionObject o = C.find(s);
                        if (o != null && (o instanceof SegmentObject || o instanceof PrimitiveCircleObject || o instanceof PointObject)) continue;
                        throw new ConstructionException("");
                    }
                    this.A = new AnimatorTool(P, C.AnimateV, this.ZC, C.AnimateNegative, C.AnimateOriginal, C.AnimateDelay);
                    this.ZC.setTool(this.A);
                    this.ZC.allowRightMouse(false);
                    this.A.setInteractive(false);
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
        this.ZC.repaint();
    }

    public void stop() {
        this.Stopped = true;
    }

    public void mousePressed(MouseEvent e2) {
    }

    public void mouseReleased(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void mouseClicked(MouseEvent e2) {
        if (e2.isMetaDown()) {
            this.Hold = true;
        } else {
            this.Continue = true;
        }
    }
}

