/*
 * Decompiled with CFR 0.152.
 */
package rene.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.PrintWriter;
import rene.gui.Global;
import rene.gui.Panel3D;
import rene.viewer.TextDisplay;
import rene.viewer.TextPosition;
import rene.viewer.Wheel;
import rene.viewer.WheelListener;

public class Viewer
extends Panel
implements AdjustmentListener,
MouseListener,
MouseMotionListener,
ActionListener,
KeyListener,
WheelListener {
    TextDisplay TD;
    Scrollbar Vertical;
    Scrollbar Horizontal;
    TextPosition Start;
    TextPosition End;
    PopupMenu PM;
    int X;
    int Y;
    Panel P3D;
    boolean Dragging = false;

    public Viewer(boolean vs, boolean hs) {
        this.TD = new TextDisplay(this);
        this.setLayout(new BorderLayout());
        this.P3D = new Panel3D(this.TD);
        this.add("Center", this.P3D);
        if (vs) {
            this.Vertical = new Scrollbar(1, 0, 100, 0, 1100);
            this.add("East", this.Vertical);
            this.Vertical.addAdjustmentListener(this);
        }
        if (hs) {
            this.Horizontal = new Scrollbar(0, 0, 100, 0, 1100);
            this.add("South", this.Horizontal);
            this.Horizontal.addAdjustmentListener(this);
        }
        this.TD.addMouseListener(this);
        this.TD.addMouseMotionListener(this);
        this.End = null;
        this.Start = null;
        this.PM = new PopupMenu();
        MenuItem mi = new MenuItem(Global.name("block.copy", "Copy"));
        mi.addActionListener(this);
        this.PM.add(mi);
        this.PM.addSeparator();
        mi = new MenuItem(Global.name("block.begin", "Begin Block"));
        mi.addActionListener(this);
        this.PM.add(mi);
        mi = new MenuItem(Global.name("block.end", "End Block"));
        mi.addActionListener(this);
        this.PM.add(mi);
        this.add(this.PM);
        Wheel W = new Wheel(this);
        this.addMouseWheelListener(W);
    }

    public Viewer() {
        this(true, true);
    }

    public Viewer(String dummy) {
    }

    public void setFont(Font f2) {
        this.TD.init(f2);
    }

    public void appendLine(String s) {
        this.TD.appendLine0(s);
    }

    public void appendLine(String s, Color c2) {
        this.TD.appendLine0(s, c2);
    }

    public void append(String s) {
        this.append(s, Color.black);
    }

    public void append(String s, Color c2) {
        this.TD.append(s, c2);
    }

    public void doUpdate(boolean showlast) {
        this.TD.doUpdate(showlast);
        this.setVerticalScrollbar();
    }

    public void adjustmentValueChanged(AdjustmentEvent e2) {
        if (e2.getSource() == this.Vertical) {
            switch (e2.getAdjustmentType()) {
                case 1: {
                    this.TD.verticalUp();
                    break;
                }
                case 2: {
                    this.TD.verticalDown();
                    break;
                }
                case 4: {
                    this.TD.verticalPageUp();
                    break;
                }
                case 3: {
                    this.TD.verticalPageDown();
                    break;
                }
                default: {
                    int v = this.Vertical.getValue();
                    this.Vertical.setValue(v);
                    this.TD.setVertical(v);
                    return;
                }
            }
            this.setVerticalScrollbar();
        } else if (e2.getSource() == this.Horizontal) {
            this.Horizontal.setValue(this.TD.setHorizontal(this.Horizontal.getValue()));
        }
    }

    public void setVerticalScrollbar() {
        if (this.Vertical == null) {
            return;
        }
        int h = this.TD.computeVerticalSize();
        this.Vertical.setValues(this.TD.computeVertical(), h, 0, 1000 + h);
    }

    public void setText(String S) {
        this.TD.unmark();
        this.End = null;
        this.Start = null;
        this.TD.setText(S);
        this.setVerticalScrollbar();
    }

    public void save(PrintWriter fo) {
        this.TD.save(fo);
    }

    public void appendLine0(String s) {
        this.TD.appendLine0(s);
    }

    public void appendLine0(String s, Color c2) {
        this.TD.appendLine0(s, c2);
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mousePressed(MouseEvent e2) {
        if (e2.isPopupTrigger() || e2.isMetaDown()) {
            this.PM.show(e2.getComponent(), e2.getX(), e2.getY());
            this.X = e2.getX();
            this.Y = e2.getY();
        } else {
            this.TD.unmark(this.Start, this.End);
            this.Start = this.TD.getposition(e2.getX(), e2.getY());
            this.Start.oneleft();
            this.End = null;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(150, 200);
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 200);
    }

    public void mouseReleased(MouseEvent e2) {
        this.Dragging = false;
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void mouseMoved(MouseEvent e2) {
    }

    public void mouseDragged(MouseEvent e2) {
        this.TD.unmark(this.Start, this.End);
        TextPosition h = this.TD.getposition(e2.getX(), e2.getY());
        if (h != null) {
            this.End = h;
        }
        this.TD.mark(this.Start, this.End);
    }

    public void actionPerformed(ActionEvent e2) {
        String o = e2.getActionCommand();
        if (o.equals(Global.name("block.copy", "Copy"))) {
            this.TD.copy(this.Start, this.End);
        } else if (o.equals(Global.name("block.begin", "Begin Block"))) {
            this.TD.unmark(this.Start, this.End);
            this.Start = this.TD.getposition(this.X, this.Y);
            this.Start.oneleft();
            if (this.End == null && this.TD.L.last() != null) {
                this.End = this.TD.lastpos();
            }
            this.TD.mark(this.Start, this.End);
        } else if (o.equals(Global.name("block.end", "End Block"))) {
            this.TD.unmark(this.Start, this.End);
            this.End = this.TD.getposition(this.X, this.Y);
            if (this.Start == null && this.TD.L.first() != null) {
                this.Start = new TextPosition(this.TD.L.first(), 0, 0);
            }
            this.TD.mark(this.Start, this.End);
        }
    }

    public void keyPressed(KeyEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
        if (e2.isControlDown() && e2.getKeyCode() == 67 && this.Start != null && this.End != null) {
            this.TD.copy(this.Start, this.End);
        }
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void setTabWidth(int t) {
        this.TD.setTabWidth(t);
    }

    public void showFirst() {
        this.TD.showFirst();
        this.setVerticalScrollbar();
        this.TD.repaint();
    }

    public void showLast() {
        this.TD.showlast();
        this.setVerticalScrollbar();
        this.TD.repaint();
    }

    public boolean hasFocus() {
        return false;
    }

    public void setBackground(Color c2) {
        this.TD.setBackground(c2);
        this.P3D.setBackground(c2);
        super.setBackground(c2);
    }

    public void up(int n) {
        for (int i = 0; i < n; ++i) {
            this.TD.verticalUp();
        }
        this.setVerticalScrollbar();
    }

    public void down(int n) {
        for (int i = 0; i < n; ++i) {
            this.TD.verticalDown();
        }
        this.setVerticalScrollbar();
    }

    public void pageUp() {
        this.TD.verticalPageUp();
        this.setVerticalScrollbar();
    }

    public void pageDown() {
        this.TD.verticalPageDown();
        this.setVerticalScrollbar();
    }

    public void resized() {
    }

    public static void main(String[] args) {
        Frame f2 = new Frame();
        f2.setLayout(new BorderLayout());
        Viewer v = new Viewer(true, false);
        f2.add("Center", v);
        f2.setSize(300, 300);
        f2.setVisible(true);
        v.append("test test test test test test test");
        v.appendLine("test test test test test test test");
        v.appendLine("test test test test test test test");
        v.appendLine("test test test test test test test");
    }
}

