/*
 * Decompiled with CFR 0.152.
 */
package rene.viewer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.PrintWriter;
import rene.gui.Global;
import rene.util.list.ListClass;
import rene.util.list.ListElement;
import rene.viewer.ClipboardCopy;
import rene.viewer.Line;
import rene.viewer.TextPosition;
import rene.viewer.Viewer;

public class TextDisplay
extends Canvas
implements ClipboardOwner,
ComponentListener {
    ListClass L = new ListClass();
    Font F = null;
    FontMetrics FM;
    Viewer V;
    int Leading;
    int Height;
    int Ascent;
    int Descent;
    int LineCount;
    int TopLineCount;
    int PageSize;
    ListElement TopLine;
    Image I;
    Graphics IG;
    int W;
    int H;
    public int Tabsize = 4;
    public int Offset;
    boolean LineFinished = true;
    int[] Widths;
    int[] HW;
    long LastScrollTime;
    Color Background;
    int TabWidth = 0;

    public TextDisplay(Viewer v) {
        this.V = v;
        this.LineCount = 0;
        this.TopLineCount = 0;
        this.TopLine = null;
        this.I = null;
        this.H = 0;
        this.W = 0;
        this.PageSize = 10;
        this.HW = new int[1024];
        this.addKeyListener(v);
        this.addComponentListener(this);
    }

    void init(Font f2) {
        this.F = f2;
        this.FM = this.getFontMetrics(this.F);
        this.Leading = this.FM.getLeading() + Global.getParameter("fixedfont.spacing", -1);
        this.Height = this.FM.getHeight();
        this.Ascent = this.FM.getAscent();
        this.Descent = this.FM.getDescent();
        this.Widths = this.FM.getWidths();
        this.Background = Global.Background != null ? Global.Background : SystemColor.window;
    }

    public Color getBackground() {
        if (Global.Background != null) {
            return Global.Background;
        }
        return SystemColor.window;
    }

    int[] getwidth(char[] a2) {
        try {
            for (int i = 0; i < a2.length; ++i) {
                this.HW[i] = a2[i] < '\u0100' ? this.Widths[a2[i]] : this.FM.charWidth(a2[i]);
            }
        }
        catch (Exception e2) {
            return this.HW;
        }
        return this.HW;
    }

    public synchronized void appendLine0(String S) {
        this.appendLine0(S, Color.black);
    }

    public synchronized void appendLine0(String S, Color c2) {
        Line l = new Line(S, this, c2);
        this.L.append(new ListElement(l));
        ++this.LineCount;
        if (this.LineCount == 1) {
            this.TopLine = this.L.first();
        }
        this.LineFinished = true;
        if (this.TabWidth > 0) {
            l.expandTabs(this.TabWidth);
        }
    }

    public synchronized void appendLine(String s) {
        this.appendLine0(s);
        this.V.setVerticalScrollbar();
    }

    public void append(String S, Color c2) {
        this.append(S, c2, true);
    }

    public void append(String S, Color c2, boolean suddenupdate) {
        int p;
        do {
            if ((p = S.indexOf(10)) < 0) {
                this.appendlast(S, c2);
                this.LineFinished = false;
                break;
            }
            this.appendlast(S.substring(0, p), c2);
            this.LineFinished = true;
        } while (!(S = S.substring(p + 1)).equals(""));
        if (suddenupdate) {
            this.doUpdate(true);
        }
        this.repaint();
    }

    public void doUpdate(boolean showlast) {
        long m;
        if (showlast && (m = System.currentTimeMillis()) - this.LastScrollTime > 10000L) {
            this.showlast();
        }
        this.repaint();
        this.V.setVerticalScrollbar();
    }

    public void setText(String s) {
        this.TopLine = null;
        this.TopLineCount = 0;
        this.LineCount = 0;
        this.L = new ListClass();
        if (!s.equals("")) {
            this.append(s, Color.black);
        }
        this.repaint();
    }

    public synchronized void appendlast(String s, Color c2) {
        if (this.LineFinished || this.L.last() == null) {
            Line l = new Line(s, this, c2);
            this.L.append(new ListElement(l));
            ++this.LineCount;
            if (this.LineCount == 1) {
                this.TopLine = this.L.first();
            }
            if (this.TabWidth > 0) {
                l.expandTabs(this.TabWidth);
            }
        } else {
            ((Line)this.L.last().content()).append(s);
        }
    }

    public void showlast() {
        ListElement e2 = this.L.last();
        if (e2 == null) {
            return;
        }
        this.TopLineCount = this.LineCount;
        for (int i = 0; i < this.PageSize - 1 && e2.previous() != null; ++i) {
            e2 = e2.previous();
            --this.TopLineCount;
        }
        this.TopLine = e2;
        this.repaint();
    }

    public void makeimage() {
        Dimension D = this.getSize();
        if (this.I == null || D.width != this.W || D.height != this.H) {
            try {
                this.W = D.width;
                this.H = D.height;
                this.I = this.createImage(this.W, this.H);
                this.IG = this.I.getGraphics();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        this.IG.setColor(Color.black);
        this.IG.clearRect(0, 0, this.W, this.H);
        this.IG.setFont(this.F);
        try {
            this.PageSize = this.H / (this.Height + this.Leading);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void paint(Graphics g) {
        if (this.F == null) {
            this.init(this.getFont());
        }
        this.makeimage();
        ListElement e2 = this.TopLine;
        this.antialias(true);
        int h = this.Leading + this.Ascent;
        int totalh = this.getSize().height - this.Descent;
        if (this.Background == null) {
            this.Background = this.getBackground();
        }
        this.IG.setColor(this.Background);
        this.IG.fillRect(0, 0, this.W, this.H);
        for (int lines = 0; lines < this.PageSize && e2 != null; e2 = e2.next(), ++lines) {
            Line l = (Line)e2.content();
            l.draw(this.IG, 2, h);
            h += this.Leading + this.Height;
        }
        g.drawImage(this.I, 0, 0, this);
    }

    public void antialias(boolean flag) {
        if (Global.getParameter("font.smooth", true)) {
            this.IG = (Graphics2D)this.IG;
            ((Graphics2D)this.IG).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, flag ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public void showLine(ListElement line) {
        ListElement e2 = this.TopLine;
        int h = this.Leading + this.Ascent;
        int totalh = this.getSize().height - this.Descent;
        if (this.Background == null) {
            this.Background = this.getBackground();
        }
        for (int lines = 0; lines < this.PageSize && e2 != null; e2 = e2.next(), ++lines) {
            if (e2 == line) {
                return;
            }
            h += this.Leading + this.Height;
        }
        this.TopLine = e2 == line && this.TopLine.next() != null ? this.TopLine.next() : line;
    }

    public ListElement getline(int y) {
        if (this.TopLine == null) {
            return null;
        }
        ListElement e2 = this.TopLine;
        int h = this.Leading + this.Height;
        if (h == 0) {
            return null;
        }
        h = y / h;
        for (int i = 0; i < h; ++i) {
            if (e2.next() == null) {
                return e2;
            }
            e2 = e2.next();
        }
        return e2;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    int computeVertical() {
        if (this.LineCount > 0) {
            return this.TopLineCount * 1000 / this.LineCount;
        }
        return 0;
    }

    public int setVertical(int v) {
        if (this.TopLine == null) {
            return 0;
        }
        int NewTop = this.LineCount * v / 1000;
        if (NewTop > this.TopLineCount) {
            for (int i = this.TopLineCount; i < NewTop && this.TopLine.next() != null; ++i) {
                this.TopLine = this.TopLine.next();
                ++this.TopLineCount;
            }
            this.repaint();
        } else if (NewTop < this.TopLineCount) {
            for (int i = this.TopLineCount; i > NewTop && this.TopLine.previous() != null; --i) {
                this.TopLine = this.TopLine.previous();
                --this.TopLineCount;
            }
            this.repaint();
        }
        this.LastScrollTime = System.currentTimeMillis();
        return v;
    }

    public void verticalUp() {
        if (this.TopLine == null) {
            return;
        }
        if (this.TopLine.next() == null) {
            return;
        }
        this.TopLine = this.TopLine.next();
        ++this.TopLineCount;
        this.repaint();
        this.LastScrollTime = System.currentTimeMillis();
    }

    public void verticalDown() {
        if (this.TopLine == null) {
            return;
        }
        if (this.TopLine.previous() == null) {
            return;
        }
        this.TopLine = this.TopLine.previous();
        --this.TopLineCount;
        this.repaint();
        this.LastScrollTime = System.currentTimeMillis();
    }

    public void verticalPageUp() {
        if (this.TopLine == null) {
            return;
        }
        for (int i = 0; i < this.PageSize - 1 && this.TopLine.next() != null; ++i) {
            this.TopLine = this.TopLine.next();
            ++this.TopLineCount;
        }
        this.repaint();
        this.LastScrollTime = System.currentTimeMillis();
    }

    public void verticalPageDown() {
        if (this.TopLine == null) {
            return;
        }
        for (int i = 0; i < this.PageSize - 1 && this.TopLine.previous() != null; ++i) {
            this.TopLine = this.TopLine.previous();
            --this.TopLineCount;
        }
        this.repaint();
        this.LastScrollTime = System.currentTimeMillis();
    }

    int computeVerticalSize() {
        if (this.LineCount == 0) {
            return 100;
        }
        int h = this.PageSize * 2000 / this.LineCount;
        if (h < 10) {
            h = 10;
        }
        return h;
    }

    public int setHorizontal(int v) {
        this.Offset = v / 5;
        this.repaint();
        return v;
    }

    public void save(PrintWriter fo) {
        for (ListElement e2 = this.L.first(); e2 != null; e2 = e2.next()) {
            fo.println(new String(((Line)e2.content()).a));
        }
    }

    public TextPosition getposition(int x, int y) {
        int i;
        if (this.L.first() == null) {
            return null;
        }
        if (y < 0) {
            return new TextPosition(this.TopLine, this.TopLineCount, 0);
        }
        if (this.TopLine == null) {
            return null;
        }
        ListElement e2 = this.TopLine;
        int h = this.Leading + this.Height;
        if (h == 0) {
            return null;
        }
        h = y / h;
        for (i = 0; i < h; ++i) {
            if (e2.next() == null || i == this.PageSize - 1) {
                return new TextPosition(e2, this.TopLineCount + i, ((Line)e2.content()).length());
            }
            e2 = e2.next();
        }
        return new TextPosition(e2, this.TopLineCount + i, ((Line)e2.content()).getpos(x, 2));
    }

    public void unmark() {
        for (ListElement e2 = this.L.first(); e2 != null; e2 = e2.next()) {
            ((Line)e2.content()).block(0, 0);
        }
        this.repaint();
    }

    public void unmark(TextPosition Start2, TextPosition End2) {
        ListElement e2;
        TextPosition P2;
        TextPosition P1;
        if (Start2 == null || End2 == null) {
            return;
        }
        if (Start2.before(End2)) {
            P1 = Start2;
            P2 = End2;
        } else if (End2.before(Start2)) {
            P1 = End2;
            P2 = Start2;
        } else {
            return;
        }
        for (e2 = P1.L; e2 != null && e2 != P2.L; e2 = e2.next()) {
            ((Line)e2.content()).block(0, 0);
        }
        if (e2 != null) {
            ((Line)e2.content()).block(0, 0);
        }
        this.repaint();
    }

    public void mark(TextPosition Start2, TextPosition End2) {
        TextPosition P2;
        TextPosition P1;
        if (Start2 == null || End2 == null) {
            return;
        }
        if (Start2.before(End2)) {
            P1 = Start2;
            P2 = End2;
        } else if (End2.before(Start2)) {
            P1 = End2;
            P2 = Start2;
        } else {
            return;
        }
        ListElement e2 = P1.L;
        ((Line)e2.content()).block(P1.LPos, 1);
        if (e2 != P2.L) {
            e2 = e2.next();
        }
        while (e2 != null && e2 != P2.L) {
            ((Line)e2.content()).block(0, 4);
            e2 = e2.next();
        }
        if (e2 != null) {
            ((Line)e2.content()).block(P2.LPos, 2);
        }
        this.repaint();
        this.requestFocus();
    }

    void copy(TextPosition Start2, TextPosition End2) {
        ListElement e2;
        TextPosition P2;
        TextPosition P1;
        if (Start2 == null || End2 == null) {
            return;
        }
        if (Start2.before(End2)) {
            P1 = Start2;
            P2 = End2;
        } else if (End2.before(Start2)) {
            P1 = End2;
            P2 = Start2;
        } else {
            return;
        }
        String s = "";
        for (e2 = P1.L; e2 != null && e2 != P2.L; e2 = e2.next()) {
            s = s + ((Line)e2.content()).getblock() + "\n";
        }
        if (e2 != null) {
            s = s + ((Line)e2.content()).getblock();
        }
        new ClipboardCopy(this, this, s);
    }

    public void showFirst() {
        this.TopLine = this.L.first();
    }

    public void lostOwnership(Clipboard clip, Transferable cont) {
    }

    TextPosition lastpos() {
        ListElement e2 = this.L.last();
        if (e2 == null) {
            return null;
        }
        Line l = (Line)e2.content();
        return new TextPosition(e2, this.LineCount, l.length());
    }

    public void setTabWidth(int t) {
        this.TabWidth = t;
    }

    public boolean hasFocus() {
        return this.V.hasFocus();
    }

    public void setBackground(Color c2) {
        this.Background = c2;
        super.setBackground(c2);
    }

    public void componentHidden(ComponentEvent e2) {
    }

    public void componentMoved(ComponentEvent e2) {
    }

    public void componentResized(ComponentEvent e2) {
        this.V.resized();
    }

    public void componentShown(ComponentEvent e2) {
    }
}

