/*
 * Decompiled with CFR 0.152.
 */
package rene.viewer;

import java.awt.Color;
import java.awt.Graphics;
import rene.viewer.TextDisplay;

public class Line {
    TextDisplay TD;
    boolean Chosen;
    int Pos;
    int Posend;
    int Block;
    static final int NONE = 0;
    static final int START = 1;
    static final int END = 2;
    static final int FULL = 4;
    Color C;
    Color IC;
    char[] a;

    public Line(String s, TextDisplay td) {
        this(s, td, Color.black);
    }

    public Line(String s, TextDisplay td, Color c2) {
        this.TD = td;
        this.C = c2;
        this.IC = new Color(this.C.getRed() / 4 + 192, this.C.getGreen() / 4 + 192, this.C.getBlue() / 4 + 192);
        this.Block = 0;
        this.a = s.toCharArray();
    }

    public void expandTabs(int tabwidth) {
        int pos = 0;
        for (int i = 0; i < this.a.length; ++i) {
            ++pos;
            if (this.a[i] != '\t') continue;
            pos = (pos / tabwidth + 1) * tabwidth;
        }
        char[] b2 = new char[pos];
        pos = 0;
        for (int i = 0; i < this.a.length; ++i) {
            if (this.a[i] == '\t') {
                int newpos = ((pos + 1) / tabwidth + 1) * tabwidth;
                for (int k = pos; k < newpos; ++k) {
                    b2[k] = 32;
                }
                pos = newpos;
                continue;
            }
            b2[pos++] = this.a[i];
        }
        this.a = b2;
    }

    int length() {
        return this.a.length;
    }

    int getpos(int x, int offset) {
        int i;
        int[] l = this.TD.getwidth(this.a);
        int h = offset - this.TD.Offset * this.TD.FM.charWidth(' ');
        if (x < h) {
            return 0;
        }
        for (i = 0; x > h && i < this.a.length; h += l[i], ++i) {
        }
        return i;
    }

    public void draw(Graphics g, int x, int y) {
        boolean i1 = false;
        boolean p = false;
        x -= this.TD.Offset * this.TD.FM.charWidth(' ');
        if (this.Chosen) {
            if (this.TD.hasFocus()) {
                g.setColor(Color.darkGray);
            } else {
                g.setColor(Color.gray);
            }
            g.fillRect(0, y - this.TD.Ascent, this.TD.getSize().width, this.TD.Height);
            g.setColor(this.IC);
            this.TD.antialias(false);
            g.drawChars(this.a, 0, this.a.length, x, y);
            this.TD.antialias(true);
        } else if ((this.Block & 4) != 0) {
            g.setColor(Color.darkGray);
            g.fillRect(x, y - this.TD.Ascent, this.TD.FM.charsWidth(this.a, 0, this.a.length), this.TD.Height);
            g.setColor(Color.white);
            this.TD.antialias(false);
            g.drawChars(this.a, 0, this.a.length, x, y);
            this.TD.antialias(true);
        } else if ((this.Block & 1) != 0) {
            if (this.Pos > 0) {
                g.setColor(this.C);
                g.drawChars(this.a, 0, this.Pos, x, y);
                x += this.TD.FM.charsWidth(this.a, 0, this.Pos);
            }
            if ((this.Block & 2) != 0) {
                if (this.Posend > this.Pos) {
                    int h = this.TD.FM.charsWidth(this.a, this.Pos, this.Posend - this.Pos);
                    g.setColor(Color.darkGray);
                    g.fillRect(x, y - this.TD.Ascent, h, this.TD.Height);
                    g.setColor(Color.white);
                    this.TD.antialias(false);
                    g.drawChars(this.a, this.Pos, this.Posend - this.Pos, x, y);
                    this.TD.antialias(true);
                    g.setColor(this.C);
                    x += h;
                    if (this.a.length > this.Posend) {
                        g.drawChars(this.a, this.Posend, this.a.length - this.Posend, x, y);
                    }
                } else {
                    g.drawChars(this.a, this.Pos, this.a.length - this.Pos, x, y);
                }
            } else {
                int h = this.TD.FM.charsWidth(this.a, this.Pos, this.a.length - this.Pos);
                g.setColor(Color.darkGray);
                g.fillRect(x, y - this.TD.Ascent, h, this.TD.Height);
                g.setColor(Color.white);
                this.TD.antialias(false);
                g.drawChars(this.a, this.Pos, this.a.length - this.Pos, x, y);
                this.TD.antialias(true);
            }
        } else if ((this.Block & 2) != 0) {
            int h = this.TD.FM.charsWidth(this.a, 0, this.Posend);
            g.setColor(Color.darkGray);
            g.fillRect(x, y - this.TD.Ascent, h, this.TD.Height);
            g.setColor(Color.white);
            this.TD.antialias(false);
            g.drawChars(this.a, 0, this.Posend, x, y);
            this.TD.antialias(true);
            g.setColor(this.C);
            x += h;
            if (this.a.length > this.Posend) {
                g.drawChars(this.a, this.Posend, this.a.length - this.Posend, x, y);
            }
        } else {
            g.setColor(this.C);
            g.drawChars(this.a, 0, this.a.length, x, y);
        }
    }

    void append(String s) {
        this.a = (new String(this.a) + s).toCharArray();
    }

    void chosen(boolean f2) {
        this.Chosen = f2;
    }

    public boolean chosen() {
        return this.Chosen;
    }

    void block(int pos, int mode) {
        switch (mode) {
            case 0: {
                this.Block = 0;
                break;
            }
            case 4: {
                this.Block = 4;
                break;
            }
            case 1: {
                this.Block |= 1;
                this.Pos = pos;
                break;
            }
            case 2: {
                this.Block |= 2;
                this.Posend = pos;
            }
        }
    }

    String getblock() {
        if (this.Block == 4) {
            return new String(this.a, 0, this.a.length);
        }
        if ((this.Block & 1) != 0) {
            if ((this.Block & 2) != 0) {
                return new String(this.a, this.Pos, this.Posend - this.Pos);
            }
            return new String(this.a, this.Pos, this.a.length - this.Pos);
        }
        if ((this.Block & 2) != 0) {
            return new String(this.a, 0, this.Posend);
        }
        return "";
    }
}

