/*
 * Decompiled with CFR 0.152.
 */
package rene.util;

import java.util.Enumeration;

public class MyVector
implements Enumeration {
    Object[] O;
    int OSize;
    int ON;
    int OLast;
    int Gap;
    int EN = 0;

    public MyVector(int initsize) {
        this.O = new Object[initsize];
        this.OSize = initsize;
        this.ON = 0;
        this.OLast = 0;
        this.Gap = -1;
    }

    public MyVector() {
        this(8);
    }

    public void addElement(Object o) {
        if (this.OLast >= this.OSize) {
            this.extend();
        }
        this.O[this.OLast++] = o;
        ++this.ON;
    }

    public void extend() {
        if (this.ON < this.OLast / 2) {
            this.compress();
            return;
        }
        Object[] o = new Object[2 * this.OSize];
        System.arraycopy(this.O, 0, o, 0, this.OLast);
        this.OSize *= 2;
        this.O = o;
    }

    public void compress() {
        int i;
        if (this.Gap < 0) {
            return;
        }
        int k = this.Gap;
        for (i = this.Gap; i < this.OLast; ++i) {
            if (this.O[i] == null) continue;
            this.O[k++] = this.O[i];
        }
        this.ON = k;
        for (i = k; i < this.OLast; ++i) {
            this.O[i] = null;
        }
        this.Gap = -1;
        this.OLast = this.ON;
    }

    public Enumeration elements() {
        this.compress();
        this.EN = 0;
        return this;
    }

    public boolean hasMoreElements() {
        while (this.EN < this.OLast && this.O[this.EN] == null) {
            ++this.EN;
        }
        return this.EN < this.OLast;
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new ArrayIndexOutOfBoundsException(this.OLast);
        }
        return this.O[this.EN++];
    }

    public void removeAllElements() {
        for (int i = 0; i < this.OLast; ++i) {
            this.O[i] = null;
        }
        this.OLast = 0;
        this.ON = 0;
        this.Gap = -1;
    }

    public void removeElement(Object o) {
        int i = this.indexOf(o);
        if (i < 0) {
            return;
        }
        this.O[i] = null;
        --this.ON;
        if (this.Gap < 0 || this.Gap > i) {
            this.Gap = i;
        }
        if (i == this.OLast - 1) {
            --this.OLast;
        }
        while (this.OLast > 0 && this.O[this.OLast - 1] == null) {
            --this.OLast;
        }
        if (this.Gap >= this.OLast) {
            this.Gap = -1;
        }
    }

    public int indexOf(Object o) {
        int i;
        if (this.EN > 0 && this.EN <= this.OLast && this.O[this.EN - 1].equals(o)) {
            return this.EN - 1;
        }
        if (this.Gap < 0) {
            for (int i2 = 0; i2 < this.OLast; ++i2) {
                if (!this.O[i2].equals(o)) continue;
                return i2;
            }
            return -1;
        }
        for (int i3 = 0; i3 < this.Gap; ++i3) {
            if (!this.O[i3].equals(o)) continue;
            return i3;
        }
        int k = this.Gap;
        for (i = this.Gap; i < this.OLast; ++i) {
            if (this.O[i] == null) continue;
            if (this.O[i].equals(o)) {
                this.Gap = k;
                return i;
            }
            this.O[k++] = this.O[i];
            this.O[i] = null;
        }
        this.ON = k;
        for (i = k; i < this.OLast; ++i) {
            this.O[i] = null;
        }
        this.Gap = -1;
        this.OLast = this.ON;
        return -1;
    }

    public int size() {
        return this.ON;
    }

    public Object elementAt(int n) {
        if (n < 0 || n >= this.ON) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (this.Gap < 0 || n < this.Gap) {
            return this.O[n];
        }
        int k = this.Gap;
        for (int i = this.Gap; i < this.OLast; ++i) {
            if (this.O[i] == null) continue;
            this.O[k] = this.O[i];
            this.O[i] = null;
            if (k == n) {
                Object ret = this.O[k];
                this.Gap = ++k;
                if (this.Gap >= this.ON) {
                    for (int j = this.Gap; j < this.OLast; ++j) {
                        this.O[j] = null;
                    }
                    this.OLast = this.ON;
                    this.Gap = -1;
                }
                return ret;
            }
            ++k;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public Object[] getArray() {
        this.compress();
        return this.O;
    }

    public void copyInto(Object[] o) {
        this.compress();
        System.arraycopy(this.O, 0, o, 0, this.ON);
    }

    public boolean equals(MyVector V) {
        if (V.ON != this.ON) {
            return false;
        }
        V.compress();
        this.compress();
        for (int i = 0; i < this.ON; ++i) {
            if (V.O[i].equals(this.O[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentical(MyVector V) {
        if (V.ON != this.ON) {
            return false;
        }
        V.compress();
        this.compress();
        for (int i = 0; i < this.ON; ++i) {
            if (V.O[i] == this.O[i]) continue;
            return false;
        }
        return true;
    }

    public void truncate(int n) {
        if (n >= this.ON) {
            return;
        }
        this.compress();
        for (int i = n; i < this.OLast; ++i) {
            this.O[i] = null;
        }
        this.OLast = this.ON = n;
    }

    public static void main(String[] args) {
        int i;
        MyVector V = new MyVector();
        for (i = 1; i <= 10; ++i) {
            V.addElement("Element " + i);
        }
        for (i = 4; i <= 9; ++i) {
            V.removeElement("Element " + i);
        }
        System.out.println("--> " + V.elementAt(3));
        System.out.println(V.ON + " elements, " + V.OLast + " used, " + V.Gap + " gap.");
        System.out.println("--> " + V.elementAt(3));
        System.out.println(V.ON + " elements, " + V.OLast + " used, " + V.Gap + " gap.");
        for (i = 11; i <= 20; ++i) {
            V.addElement("Element " + i);
        }
        System.out.println(V.ON + " elements, " + V.OLast + " used ," + V.Gap + " gap.");
        Enumeration E = V.elements();
        while (E.hasMoreElements()) {
            System.out.println((String)E.nextElement());
        }
        System.out.println(V.ON + " elements, " + V.OLast + " used, " + V.Gap + " gap.");
    }
}

