/*
 * Decompiled with CFR 0.152.
 */
package rene.gui;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Vector;
import rene.dialogs.ItemEditor;
import rene.dialogs.ItemEditorElement;
import rene.dialogs.ItemPanel;
import rene.gui.ButtonAction;
import rene.gui.Global;
import rene.gui.KeyDictionary;
import rene.gui.KeyboardItem;
import rene.gui.MyTextField;

public class KeyboardPanel
extends ItemPanel
implements KeyListener {
    TextField MenuString;
    TextField ActionName;
    TextField CharKey;
    Checkbox Shift;
    Checkbox Control;
    Checkbox Alt;
    String Name = "";
    Choice C;
    ItemEditor E;

    public KeyboardPanel() {
        this.setLayout(new BorderLayout());
        Panel center = new Panel();
        center.setLayout(new GridLayout(0, 1));
        this.MenuString = new MyTextField("", 30);
        center.add(this.MenuString);
        this.MenuString.setEditable(false);
        this.ActionName = new MyTextField();
        center.add(this.ActionName);
        this.ActionName.setEditable(false);
        this.CharKey = new MyTextField();
        center.add(this.CharKey);
        this.CharKey.setEditable(false);
        this.CharKey.addKeyListener(this);
        this.Shift = new Checkbox(Global.name("keyeditor.shift"));
        center.add(this.Shift);
        this.Control = new Checkbox(Global.name("keyeditor.control"));
        center.add(this.Control);
        this.Alt = new Checkbox(Global.name("keyeditor.alt"));
        center.add(this.Alt);
        this.add("Center", center);
        Panel south = new Panel();
        south.setLayout(new BorderLayout());
        Panel c2 = new Panel();
        this.C = new Choice();
        if (Global.NormalFont != null) {
            this.C.setFont(Global.NormalFont);
        }
        c2.add(this.C);
        this.C.add("-------------");
        south.add("Center", c2);
        Panel buttons = new Panel();
        buttons.add(new ButtonAction(this, Global.name("keyeditor.default"), "Default"));
        buttons.add(new ButtonAction(this, Global.name("keyeditor.none"), "None"));
        south.add("South", buttons);
        this.add("South", south);
    }

    public void setItemEditor(ItemEditor e2) {
        this.E = e2;
    }

    public void makeCommandChoice() {
        this.C.removeAll();
        this.C.add("");
        for (int i = 1; i <= 5; ++i) {
            String s = this.commandShortcut(i);
            this.C.add(i + ": " + s);
        }
        this.C.select(0);
    }

    public String commandShortcut(int i) {
        String s = "command." + i;
        Enumeration e2 = this.E.getElements().elements();
        while (e2.hasMoreElements()) {
            KeyboardItem k = (KeyboardItem)e2.nextElement();
            if (!k.getMenuString().equals(s)) continue;
            return k.shortcut();
        }
        return "";
    }

    public void keyPressed(KeyEvent e2) {
        this.Shift.setState(e2.isShiftDown());
        this.Control.setState(e2.isControlDown());
        this.Alt.setState(e2.isAltDown());
        this.CharKey.setText(KeyDictionary.translate(e2.getKeyCode()).toLowerCase());
        this.C.select(0);
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
    }

    public void display(ItemEditorElement e2) {
        KeyboardItem k = (KeyboardItem)e2;
        this.Name = k.getName();
        this.MenuString.setText(k.getMenuString());
        this.ActionName.setText(k.getActionName());
        this.CharKey.setText(k.getCharKey());
        this.MenuString.setText(k.getMenuString());
        this.Shift.setState(k.isShift());
        this.Control.setState(k.isControl());
        this.Alt.setState(k.isAlt());
        this.C.select(k.getCommandType());
    }

    public ItemEditorElement getElement() {
        int type = this.C.getSelectedIndex();
        return new KeyboardItem(this.CharKey.getText(), this.MenuString.getText(), this.ActionName.getText(), this.Shift.getState(), this.Control.getState(), this.Alt.getState(), type);
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String s) {
        this.Name = s;
        this.MenuString.setText(s);
    }

    public void notifyChange(Vector v, int item) {
        KeyboardItem changed = (KeyboardItem)v.elementAt(item);
        String descr = changed.keyDescription();
        for (int i = 0; i < v.size(); ++i) {
            KeyboardItem k;
            if (i == item || !(k = (KeyboardItem)v.elementAt(i)).keyDescription().equals(descr)) continue;
            v.setElementAt(new KeyboardItem(k.getMenuString(), "none"), i);
        }
        if (changed.getMenuString().startsWith("command.")) {
            this.makeCommandChoice();
        }
    }

    public void doAction(String o) {
        if (o.equals("Default")) {
            String s = this.MenuString.getText();
            KeyboardItem k = new KeyboardItem(s, Global.name("key." + s));
            this.CharKey.setText(k.getCharKey());
            this.Shift.setState(k.isShift());
            this.Control.setState(k.isControl());
            this.Alt.setState(k.isAlt());
        } else if (o.equals("None")) {
            this.CharKey.setText("none");
            this.Shift.setState(false);
            this.Control.setState(false);
            this.Alt.setState(false);
        } else {
            super.doAction(o);
        }
    }

    public boolean extra(Vector v) {
        v.removeAllElements();
        return true;
    }
}

