/*
 * Decompiled with CFR 0.152.
 */
package rene.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SystemColor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import rene.dialogs.Warning;
import rene.util.FileName;
import rene.util.parser.StringParser;

public class Global {
    public static Font NormalFont = null;
    public static Font FixedFont = null;
    public static Font BoldFont = null;
    public static Color Background;
    public static Color ControlBackground;
    protected static ResourceBundle B;
    public static Properties P;
    static String ConfigName;
    static Frame F;
    public static String AppletClipboard;
    public static boolean IsApplet;
    public static Object ExitBlock;

    public static void makeFonts() {
        NormalFont = Global.createfont("normalfont", "SansSerif", 12, false);
        FixedFont = Global.createfont("fixedfont", "Monospaced", 12, false);
        BoldFont = Global.createfont("fixedfont", "Monospaced", 12, true);
    }

    public static Font createfont(String name, String def, int defsize, boolean bold) {
        String fontname = Global.getParameter(name + ".name", def);
        String mode = Global.getParameter(name + ".mode", "plain");
        if (bold || mode.equals("bold")) {
            return new Font(fontname, 1, Global.getParameter(name + ".size", defsize));
        }
        if (mode.equals("italic")) {
            return new Font(fontname, 2, Global.getParameter(name + ".size", defsize));
        }
        return new Font(fontname, 0, Global.getParameter(name + ".size", defsize));
    }

    public static void makeColors() {
        Background = Global.haveParameter("color.background") ? Global.getParameter("color.background", Color.gray.brighter()) : SystemColor.window;
        ControlBackground = Global.haveParameter("color.control") ? Global.getParameter("color.control", Color.gray.brighter()) : SystemColor.control;
    }

    public static Enumeration names() {
        if (B != null) {
            return B.getKeys();
        }
        return null;
    }

    public static String name(String tag, String def) {
        String s;
        if (B == null) {
            return def;
        }
        try {
            s = B.getString(tag);
        }
        catch (Exception e2) {
            s = def;
        }
        return s;
    }

    public static String name(String tag) {
        return Global.name(tag, tag.substring(tag.lastIndexOf(".") + 1));
    }

    public static void initBundle(String file, boolean language) {
        try {
            B = ResourceBundle.getBundle(file);
            String lang = Global.getParameter("language", "");
            if (language && !lang.equals("") && !lang.equals("default")) {
                String langsec = "";
                if (lang.length() > 3 && lang.charAt(2) == '_') {
                    langsec = lang.substring(3);
                    lang = lang.substring(0, 2);
                }
                Locale.setDefault(new Locale(lang, langsec));
                Global.initBundle(file, false);
            }
        }
        catch (RuntimeException e2) {
            B = null;
        }
    }

    public static void initBundle(String file) {
        Global.initBundle(file, false);
    }

    public static synchronized Enumeration properties() {
        return P.keys();
    }

    public static synchronized void loadProperties(InputStream in) {
        try {
            P = new Properties();
            P.load(in);
            in.close();
        }
        catch (Exception e2) {
            P = new Properties();
        }
    }

    public static synchronized boolean loadPropertiesFromResource(String filename) {
        try {
            Object G = new Object();
            InputStream in = G.getClass().getResourceAsStream(filename);
            P = new Properties();
            P.load(in);
            in.close();
        }
        catch (Exception e2) {
            P = new Properties();
            return false;
        }
        ConfigName = filename;
        return true;
    }

    public static synchronized boolean loadProperties(String filename) {
        ConfigName = filename;
        try {
            FileInputStream in = new FileInputStream(filename);
            P = new Properties();
            P.load(in);
            in.close();
        }
        catch (Exception e2) {
            P = new Properties();
            return false;
        }
        return true;
    }

    public static synchronized void loadProperties(String dir, String filename) {
        try {
            Properties p = System.getProperties();
            ConfigName = dir + p.getProperty("file.separator") + filename;
            Global.loadProperties(ConfigName);
        }
        catch (Exception e2) {
            P = new Properties();
        }
    }

    public static synchronized void loadPropertiesInHome(String filename) {
        try {
            Properties p = System.getProperties();
            Global.loadProperties(p.getProperty("user.home"), filename);
        }
        catch (Exception e2) {
            P = new Properties();
        }
    }

    public static synchronized void clearProperties() {
        P = new Properties();
    }

    public static synchronized void saveProperties(String text) {
        try {
            FileOutputStream out = new FileOutputStream(ConfigName);
            P.store(out, text);
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveProperties(String text, String filename) {
        ConfigName = filename;
        Global.saveProperties(text);
    }

    public static synchronized void setParameter(String key, boolean value) {
        if (P == null) {
            return;
        }
        if (value) {
            P.put(key, "true");
        } else {
            P.put(key, "false");
        }
    }

    public static synchronized boolean getParameter(String key, boolean def) {
        try {
            String s = P.getProperty(key);
            if (s.equals("true")) {
                return true;
            }
            if (s.equals("false")) {
                return false;
            }
            return def;
        }
        catch (Exception e2) {
            return def;
        }
    }

    public static synchronized String getParameter(String key, String def) {
        String res = def;
        try {
            res = P.getProperty(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (res != null) {
            if (res.startsWith("$")) {
                res = res.substring(1);
            }
            return res;
        }
        return def;
    }

    public static synchronized void setParameter(String key, String value) {
        if (P == null) {
            return;
        }
        if (value.length() > 0 && Character.isSpaceChar(value.charAt(0))) {
            value = "$" + value;
        }
        P.put(key, value);
    }

    public static synchronized int getParameter(String key, int def) {
        try {
            return Integer.parseInt(Global.getParameter(key, ""));
        }
        catch (Exception e2) {
            try {
                double x = new Double(Global.getParameter(key, ""));
                return (int)x;
            }
            catch (Exception exception) {
                return def;
            }
        }
    }

    public static synchronized void setParameter(String key, int value) {
        Global.setParameter(key, "" + value);
    }

    public static synchronized double getParameter(String key, double def) {
        try {
            return new Double(Global.getParameter(key, ""));
        }
        catch (Exception e2) {
            return def;
        }
    }

    public static synchronized void setParameter(String key, double value) {
        Global.setParameter(key, "" + value);
    }

    public static synchronized Color getParameter(String key, Color c2) {
        String s = Global.getParameter(key, "");
        if (s.equals("")) {
            return c2;
        }
        StringParser p = new StringParser(s);
        p.replace(',', ' ');
        int red = p.parseint();
        int green = p.parseint();
        int blue = p.parseint();
        try {
            return new Color(red, green, blue);
        }
        catch (RuntimeException e2) {
            return c2;
        }
    }

    public static synchronized Color getParameter(String key, int red, int green, int blue) {
        String s = Global.getParameter(key, "");
        if (s.equals("")) {
            return new Color(red, green, blue);
        }
        StringParser p = new StringParser(s);
        p.replace(',', ' ');
        red = p.parseint();
        green = p.parseint();
        blue = p.parseint();
        try {
            return new Color(red, green, blue);
        }
        catch (RuntimeException e2) {
            return Color.black;
        }
    }

    public static synchronized void setParameter(String key, Color c2) {
        Global.setParameter(key, "" + c2.getRed() + "," + c2.getGreen() + "," + c2.getBlue());
    }

    public static synchronized void removeParameter(String key) {
        P.remove(key);
    }

    public static synchronized void removeAllParameters(String start) {
        Enumeration<Object> e2 = P.keys();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            if (!key.startsWith(start)) continue;
            P.remove(key);
        }
    }

    public static synchronized void resetDefaults(String defaults) {
        Enumeration<Object> e2 = P.keys();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            if (!key.startsWith(defaults)) continue;
            Global.setParameter(key.substring(defaults.length()), Global.getParameter(key, ""));
        }
    }

    public static void resetDefaults() {
        Global.resetDefaults("default.");
    }

    public static synchronized boolean haveParameter(String key) {
        try {
            String res = P.getProperty(key);
            if (res == null) {
                return false;
            }
        }
        catch (Exception e2) {
            return false;
        }
        return true;
    }

    public static void warning(String s) {
        if (F == null) {
            F = new Frame();
        }
        Warning W = new Warning(F, s, Global.name("warning"), false);
        W.center();
        W.setVisible(true);
    }

    public static void setApplet(boolean flag) {
        IsApplet = flag;
    }

    public static boolean isApplet() {
        return IsApplet;
    }

    public static double getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version == null) {
            return 0.0;
        }
        double v = 0.0;
        StringTokenizer t = new StringTokenizer(version, ".");
        if (!t.hasMoreTokens()) {
            return v;
        }
        v = Global.convert(t.nextToken());
        if (t.hasMoreTokens()) {
            v += Global.convert(t.nextToken()) / 10.0;
        } else {
            return v;
        }
        if (t.hasMoreTokens()) {
            v += Global.convert(t.nextToken()) / 100.0;
        }
        return v;
    }

    public static double convert(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e2) {
            return 0.0;
        }
    }

    public static synchronized String getUserDir() {
        String dir = System.getProperty("user.dir");
        return FileName.canonical(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void exit(int i) {
        Object object = ExitBlock;
        synchronized (object) {
            System.exit(i);
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println(new Color(4, 5, 600));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    static {
        Global.makeFonts();
        Background = null;
        ControlBackground = null;
        Global.makeColors();
        P = new Properties();
        F = null;
        AppletClipboard = null;
        IsApplet = false;
        ExitBlock = new Object();
    }
}

