/*
 * Decompiled with CFR 0.152.
 */
package rene.dialogs;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.Enumeration;
import rene.dialogs.FileListFinder;
import rene.dialogs.SearchFileThread;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.CloseDialog;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.HistoryTextField;
import rene.gui.MyLabel;
import rene.gui.MyList;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.util.FileList;

public class SearchFileDialog
extends CloseDialog
implements Runnable,
Enumeration {
    HistoryTextField Dir;
    HistoryTextField Pattern;
    MyList L;
    public static int ListNumber = Global.getParameter("searchfile.number", 10);
    String Result = null;
    Button ActionButton;
    Button CloseButton;
    Button SearchButton;
    Button SearchrekButton;
    public FileList F = null;
    public boolean Abort = true;
    Checkbox Mod;
    Thread Run;
    String[] S;
    int Sn;

    public SearchFileDialog(Frame f2, String action, String modify, boolean modifystate) {
        super(f2, Global.name("searchfile.title"), true);
        this.setLayout(new BorderLayout());
        MyPanel north = new MyPanel();
        north.setLayout(new BorderLayout());
        MyPanel northa = new MyPanel();
        northa.setLayout(new BorderLayout());
        MyPanel north1 = new MyPanel();
        north1.setLayout(new GridLayout(0, 2));
        north1.add(new MyLabel(Global.name("searchfile.directory")));
        this.Dir = new HistoryTextField((DoActionListener)this, "Dir", 20);
        north1.add(this.Dir);
        this.Dir.setText(".");
        north1.add(new MyLabel(Global.name("searchfile.pattern")));
        this.Pattern = new HistoryTextField((DoActionListener)this, "TextAction", 20);
        north1.add(this.Pattern);
        northa.add("Center", north1);
        MyPanel north2 = new MyPanel();
        this.SearchButton = new ButtonAction(this, Global.name("searchfile.search"), "Search");
        north2.add(this.SearchButton);
        this.SearchrekButton = new ButtonAction(this, Global.name("searchfile.searchrek"), "SearchRek");
        north2.add(this.SearchrekButton);
        northa.add("South", north2);
        north.add("North", northa);
        this.add("North", new Panel3D(north));
        this.L = new MyList(ListNumber);
        this.add("Center", new Panel3D(this.L));
        this.L.addActionListener(this);
        this.L.setMultipleMode(true);
        MyPanel south = new MyPanel();
        south.setLayout(new FlowLayout(2));
        if (!modify.equals("")) {
            this.Mod = new CheckboxAction(this, modify, "");
            south.add(this.Mod);
            this.Mod.setState(modifystate);
        }
        this.ActionButton = new ButtonAction(this, action, "Action");
        south.add(this.ActionButton);
        this.CloseButton = new ButtonAction(this, Global.name("abort"), "Close");
        south.add(this.CloseButton);
        this.add("South", new Panel3D(south));
        this.pack();
        this.Dir.loadHistory("searchfile.dir");
        this.Pattern.loadHistory("searchfile.pattern");
        this.setSize("searchfiledialog");
        this.addKeyListener(this);
        this.Dir.addKeyListener(this);
        this.Pattern.addKeyListener(this);
    }

    public SearchFileDialog(Frame f2, String action) {
        this(f2, action, "", false);
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.L) {
            this.action();
        } else {
            super.actionPerformed(e2);
        }
    }

    public void doAction(String o) {
        this.Result = null;
        if (o.equals("SearchRek")) {
            this.search(true);
        } else if (o.equals("Search")) {
            this.search(false);
        } else if (o.equals("TextAction")) {
            this.L.removeAll();
            this.action();
        } else if (o.equals("Action")) {
            this.action();
        } else if (o.equals("Help")) {
            this.help();
        } else if (o.equals("Close")) {
            this.Abort = true;
            this.doclose();
        }
    }

    public void help() {
    }

    public void search(boolean recurse) {
        this.saveHistory();
        if (this.Run != null && this.Run.isAlive()) {
            return;
        }
        this.Run = new SearchFileThread(this, this.L, this.Dir.getText(), this.Pattern.getText(), recurse);
        this.Run.start();
    }

    public void action() {
        this.saveHistory();
        if (this.Run != null && this.Run.isAlive()) {
            return;
        }
        this.Run = new Thread(this);
        this.Run.start();
    }

    public void enableButtons(boolean f2) {
        this.Pattern.setEnabled(f2);
        this.SearchButton.setEnabled(f2);
        this.SearchrekButton.setEnabled(f2);
        this.ActionButton.setEnabled(f2);
    }

    public void run() {
        this.Result = null;
        this.enableButtons(false);
        if (this.L.getItemCount() > 0) {
            int i = this.L.getSelectedIndex();
            this.Result = i > 0 ? this.L.getItem(i) : this.L.getItem(0);
        } else {
            FileListFinder f2 = new FileListFinder(this.Dir.getText(), this.Pattern.getText(), true);
            this.F = f2;
            f2.search();
            this.Result = f2.getResult();
        }
        this.enableButtons(true);
        this.Abort = false;
        this.doclose();
    }

    public String getResult() {
        return this.Result;
    }

    public void focusGained(FocusEvent e2) {
        this.Pattern.requestFocus();
    }

    public void setVisible(boolean flag) {
        if (flag) {
            this.enableButtons(true);
        }
        super.setVisible(flag);
    }

    public boolean close() {
        this.Abort = true;
        return true;
    }

    public void doclose() {
        if (this.F != null) {
            this.F.stopIt();
        }
        this.Dir.saveHistory("searchfile.dir");
        this.Pattern.saveHistory("searchfile.pattern");
        this.noteSize("searchfiledialog");
        super.doclose();
    }

    public void saveHistory() {
        this.Dir.remember();
        this.Pattern.remember();
    }

    public void setPattern(String s) {
        this.Pattern.setText(s);
    }

    public Enumeration getFiles() {
        this.S = this.L.getSelectedItems();
        this.Sn = 0;
        return this;
    }

    public boolean hasMoreElements() {
        return this.Sn < this.S.length;
    }

    public Object nextElement() {
        if (this.Sn >= this.S.length) {
            return null;
        }
        String s = this.S[this.Sn];
        ++this.Sn;
        return s;
    }

    public boolean isAborted() {
        return this.Abort;
    }

    public void deselectAll() {
        for (int i = this.L.getItemCount() - 1; i >= 0; --i) {
            this.L.deselect(i);
        }
    }

    public boolean isModified() {
        return this.Mod.getState();
    }
}

