/*
 * Decompiled with CFR 0.152.
 */
package rene.dialogs;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import rene.dialogs.ItemEditorElement;
import rene.dialogs.ItemPanel;
import rene.gui.ButtonAction;
import rene.gui.CloseDialog;
import rene.gui.Global;
import rene.gui.MyLabel;
import rene.gui.MyList;
import rene.gui.MyPanel;
import rene.gui.Panel3D;

public class ItemEditor
extends CloseDialog
implements ItemListener {
    Frame F;
    MyList L;
    boolean Aborted = true;
    Vector V;
    ItemPanel P;
    String Name;
    int Displayed = -1;
    public static final int NONE = 0;
    public static final int SAVE = 1;
    public static final int LOAD = 2;
    int Action = 0;

    public ItemEditor(Frame f2, ItemPanel p, Vector v, String name, String prompt) {
        this(f2, p, v, name, prompt, true, true, false, "");
    }

    public ItemEditor(Frame f2, ItemPanel p, Vector v, String name, String prompt, boolean allowChanges, boolean allowReorder, boolean allowSave, String extraButton) {
        super(f2, Global.name(name + ".title"), true);
        this.Name = name;
        this.F = f2;
        this.P = p;
        this.setLayout(new BorderLayout());
        MyPanel title = new MyPanel();
        title.add(new MyLabel(prompt));
        this.add("North", title);
        MyPanel center = new MyPanel();
        center.setLayout(new BorderLayout(5, 5));
        this.L = new MyList(10);
        center.add("West", this.L);
        this.L.addItemListener(this);
        MyPanel cp = new MyPanel();
        cp.setLayout(new BorderLayout());
        cp.add("North", this.P);
        cp.add("Center", new MyPanel());
        center.add("Center", cp);
        this.add("Center", new Panel3D(center));
        MyPanel buttons = new MyPanel();
        buttons.setLayout(new GridLayout(0, 1));
        if (allowChanges) {
            MyPanel buttons1 = new MyPanel();
            buttons1.add(new ButtonAction(this, Global.name("itemeditor.insert"), "Insert"));
            buttons1.add(new ButtonAction(this, Global.name("itemeditor.new"), "New"));
            buttons1.add(new ButtonAction(this, Global.name("itemeditor.delete"), "Delete"));
            buttons.add(buttons1);
        }
        if (allowReorder) {
            MyPanel buttons2 = new MyPanel();
            buttons2.add(new ButtonAction(this, Global.name("itemeditor.down"), "Down"));
            buttons2.add(new ButtonAction(this, Global.name("itemeditor.up"), "Up"));
            buttons.add(buttons2);
        }
        MyPanel buttons3 = new MyPanel();
        buttons3.setLayout(new FlowLayout(2));
        buttons3.add(new ButtonAction(this, Global.name("OK"), "OK"));
        buttons3.add(new ButtonAction(this, Global.name("abort"), "Close"));
        buttons.add(buttons3);
        if (allowSave) {
            MyPanel buttons4 = new MyPanel();
            buttons4.setLayout(new FlowLayout(2));
            buttons4.add(new ButtonAction(this, Global.name("save"), "Save"));
            buttons4.add(new ButtonAction(this, Global.name("load"), "Load"));
            if (!extraButton.equals("")) {
                buttons4.add(new ButtonAction(this, extraButton, "Extra"));
            }
            buttons.add(buttons4);
        }
        this.add("South", new Panel3D(buttons));
        this.V = new Vector();
        for (int i = 0; i < v.size(); ++i) {
            this.V.addElement(v.elementAt(i));
        }
        this.init();
        this.pack();
    }

    public void init() {
        for (int i = 0; i < this.V.size(); ++i) {
            ItemEditorElement e2 = (ItemEditorElement)this.V.elementAt(i);
            this.L.add(e2.getName());
        }
        if (this.V.size() > 0) {
            this.L.select(0);
            this.select();
        }
    }

    public void itemStateChanged(ItemEvent e2) {
        if (e2.getSource() == this.L) {
            if (this.Displayed >= 0) {
                this.define(this.Displayed);
            }
            this.select();
        }
    }

    public void select() {
        int i = this.L.getSelectedIndex();
        if (i < 0) {
            return;
        }
        this.P.display((ItemEditorElement)this.V.elementAt(i));
        this.Displayed = i;
    }

    public void doAction(String o) {
        if (o.equals("Delete")) {
            this.delete();
        } else if (o.equals("Insert")) {
            this.insert();
        } else if (o.equals("New")) {
            this.P.newElement();
        } else if (o.equals("Up")) {
            this.up();
        } else if (o.equals("Down")) {
            this.down();
        } else if (o.equals("OK")) {
            this.noteSize(this.Name);
            this.define();
            this.Aborted = false;
            this.doclose();
        } else if (o.equals("Help")) {
            this.P.help();
        } else if (o.equals("Save")) {
            this.define();
            this.Action = 1;
            this.Aborted = false;
            this.doclose();
        } else if (o.equals("Load")) {
            this.define();
            this.Action = 2;
            this.Aborted = false;
            this.doclose();
        } else if (o.equals("Extra")) {
            if (this.P.extra(this.V)) {
                this.Aborted = false;
                this.doclose();
            }
        } else {
            super.doAction(o);
        }
    }

    void insert() {
        String name = this.P.getName();
        int Selected = this.L.getSelectedIndex();
        if (Selected < 0) {
            Selected = 0;
        }
        while (this.find(name)) {
            name = name + "*";
        }
        this.P.setName(name);
        ItemEditorElement e2 = this.P.getElement();
        this.L.add(e2.getName(), Selected);
        this.L.select(Selected);
        this.V.insertElementAt(e2, Selected);
    }

    void define(int Selected) {
        String name = this.P.getName();
        if (name.equals("")) {
            return;
        }
        if (!this.L.getItem(Selected).equals(name)) {
            this.L.replaceItem(name, Selected);
        }
        this.V.setElementAt(this.P.getElement(), Selected);
        this.P.notifyChange(this.V, Selected);
    }

    void define() {
        int Selected = this.L.getSelectedIndex();
        if (Selected < 0) {
            return;
        }
        this.define(Selected);
        this.L.select(Selected);
    }

    boolean find(String name) {
        for (int i = 0; i < this.V.size(); ++i) {
            ItemEditorElement t = (ItemEditorElement)this.V.elementAt(i);
            if (!t.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    void delete() {
        int Selected = this.L.getSelectedIndex();
        if (Selected < 0) {
            return;
        }
        this.V.removeElementAt(Selected);
        this.L.remove(Selected);
        if (this.L.getItemCount() == 0) {
            return;
        }
        if (Selected >= this.L.getItemCount()) {
            --Selected;
        }
        this.L.select(Selected);
        this.select();
    }

    void down() {
        this.define();
        int Selected = this.L.getSelectedIndex();
        if (Selected < 0 || Selected + 1 >= this.V.size()) {
            return;
        }
        ItemEditorElement now = (ItemEditorElement)this.V.elementAt(Selected);
        ItemEditorElement next = (ItemEditorElement)this.V.elementAt(Selected + 1);
        this.V.setElementAt(next, Selected);
        this.V.setElementAt(now, Selected + 1);
        this.L.replaceItem(next.getName(), Selected);
        this.L.replaceItem(now.getName(), Selected + 1);
        this.L.select(++Selected);
        this.select();
    }

    void up() {
        this.define();
        int Selected = this.L.getSelectedIndex();
        if (Selected <= 0) {
            return;
        }
        ItemEditorElement now = (ItemEditorElement)this.V.elementAt(Selected);
        ItemEditorElement prev = (ItemEditorElement)this.V.elementAt(Selected - 1);
        this.V.setElementAt(prev, Selected);
        this.V.setElementAt(now, Selected - 1);
        this.L.replaceItem(prev.getName(), Selected);
        this.L.replaceItem(now.getName(), Selected - 1);
        this.L.select(--Selected);
        this.select();
    }

    public boolean isAborted() {
        return this.Aborted;
    }

    public Vector getElements() {
        return this.V;
    }

    public int getAction() {
        return this.Action;
    }
}

