/*
 * Decompiled with CFR 0.152.
 */
package rene.dialogs;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.TextField;
import rene.dialogs.ExampleCanvas;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.ChoiceAction;
import rene.gui.CloseDialog;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.IntField;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;

public class FontEditor
extends CloseDialog {
    String FontTag;
    TextField FontName;
    IntField FontSize;
    IntField FontSpacing;
    Choice Fonts;
    Choice Mode;
    Canvas Example;
    String E = Global.name("fonteditor.sample");
    Checkbox Smooth;

    public FontEditor(Frame f2, String fonttag, String fontdef, int sizedef) {
        super(f2, Global.name("fonteditor.title"), true);
        this.FontTag = fonttag;
        this.setLayout(new BorderLayout());
        MyPanel p = new MyPanel();
        p.setLayout(new GridLayout(0, 2));
        p.add(new MyLabel(Global.name("fonteditor.name")));
        this.FontName = new TextFieldAction(this, "FontName");
        p.add(this.FontName);
        this.FontName.setText(Global.getParameter(fonttag + ".name", fontdef));
        p.add(new MyLabel(Global.name("fonteditor.available")));
        this.Fonts = new ChoiceAction(this, "Fonts");
        p.add(this.Fonts);
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (fonts != null) {
            for (int i = 0; i < fonts.length; ++i) {
                this.Fonts.add(fonts[i]);
            }
        } else {
            this.Fonts.add("Dialog");
            this.Fonts.add("SansSerif");
            this.Fonts.add("Serif");
            this.Fonts.add("Monospaced");
            this.Fonts.add("DialogInput");
        }
        this.Fonts.add("Courier");
        this.Fonts.add("TimesRoman");
        this.Fonts.add("Helvetica");
        this.Fonts.select(this.FontName.getText());
        p.add(new MyLabel(Global.name("fonteditor.mode")));
        this.Mode = new ChoiceAction(this, "Mode");
        p.add(this.Mode);
        this.Mode.add(Global.name("fonteditor.plain"));
        this.Mode.add(Global.name("fonteditor.bold"));
        this.Mode.add(Global.name("fonteditor.italic"));
        String name = Global.getParameter(fonttag + ".mode", "plain");
        if (name.startsWith("bold")) {
            this.Mode.select(1);
        } else if (name.startsWith("italic")) {
            this.Mode.select(2);
        } else {
            this.Mode.select(0);
        }
        p.add(new MyLabel(Global.name("fonteditor.size")));
        this.FontSize = new IntField((DoActionListener)this, "FontSize", Global.getParameter(fonttag + ".size", sizedef));
        p.add(this.FontSize);
        p.add(new MyLabel(Global.name("fonteditor.spacing")));
        this.FontSpacing = new IntField((DoActionListener)this, "FontSpacing", Global.getParameter(fonttag + ".spacing", 0));
        p.add(this.FontSpacing);
        p.add(new MyLabel(Global.name("fonteditor.antialias")));
        this.Smooth = new CheckboxAction(this, "", "Smooth");
        p.add(this.Smooth);
        this.Smooth.setState(Global.getParameter("font.smooth", true));
        this.add("North", new Panel3D(p));
        this.Example = new ExampleCanvas(this);
        this.add("Center", new Panel3D(this.Example));
        MyPanel bp = new MyPanel();
        bp.add(new ButtonAction(this, Global.name("OK"), "OK"));
        bp.add(new ButtonAction(this, Global.name("close"), "Close"));
        this.add("South", new Panel3D(bp));
        this.pack();
    }

    public void doAction(String o) {
        if ("OK".equals(o)) {
            Global.setParameter(this.FontTag + ".name", this.FontName.getText());
            String s = "plain";
            if (this.mode() == 1) {
                s = "bold";
            } else if (this.mode() == 2) {
                s = "Italic";
            }
            Global.setParameter(this.FontTag + ".mode", s);
            Global.setParameter(this.FontTag + ".size", this.FontSize.value(3, 50));
            Global.setParameter(this.FontTag + ".spacing", this.FontSpacing.value(-10, 10));
            Global.setParameter("font.smooth", this.Smooth.getState());
            this.doclose();
        } else {
            super.doAction(o);
        }
        this.Example.repaint();
    }

    public void itemAction(String s, boolean flag) {
        this.FontName.setText(this.Fonts.getSelectedItem());
        this.Example.repaint();
    }

    int mode() {
        if (this.Mode.getSelectedItem().equals(Global.name("fonteditor.bold"))) {
            return 1;
        }
        if (this.Mode.getSelectedItem().equals(Global.name("fonteditor.italic"))) {
            return 2;
        }
        return 0;
    }

    public void example(Graphics g, int w, int h) {
        Font f2 = new Font(this.FontName.getText(), this.mode(), this.FontSize.value(3, 50));
        g.setFont(f2);
        FontMetrics fm = g.getFontMetrics();
        int d2 = this.FontSpacing.value(-10, 10);
        for (int i = 1; i <= 4; ++i) {
            g.drawString(this.E, 5, 5 + d2 + i * d2 + fm.getLeading() + fm.getAscent() + i * fm.getHeight());
        }
    }
}

