/*
 * Decompiled with CFR 0.152.
 */
package rene.dialogs;

import eric.ImageFilter;
import eric.JGlobals;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileSystemView;

public class ExportPictureDlg
extends JDialog {
    private boolean finalResult = false;
    private String fileName;
    private int pictureHeight;
    private int pictureWidth;
    private int pictureScaledHeight;
    private int pictureScaledWidth;
    private int percentScale;
    private JFileChooser jFileChooser1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanelOption;
    private JSlider jSliderScale;
    private JSpinner jSpinnerScale;
    private JTextField jTextFieldOriginalHeight;
    private JTextField jTextFieldOriginalWidth;
    private JTextField jTextFieldScaledHeight;
    private JTextField jTextFieldScaledWidth;

    public ExportPictureDlg(Frame parent) {
        super(parent, true);
        this.initComponents();
        TitledBorder tb = (TitledBorder)this.jPanelOption.getBorder();
        tb.setTitle(JGlobals.Loc("pngdialog.options"));
        this.jLabel2.setText(JGlobals.Loc("pngdialog.scale"));
        this.jLabel3.setText(JGlobals.Loc("pngdialog.originsize"));
        this.jLabel4.setText(JGlobals.Loc("pngdialog.scaledsize"));
        this.setPercentScale(100);
        this.pictureHeight = 0;
        this.pictureScaledWidth = 0;
        FileSystemView vueSysteme = FileSystemView.getFileSystemView();
        File def = vueSysteme.getHomeDirectory();
        File desk = vueSysteme.getChild(def, "Desktop");
        File choice = desk == null ? def : desk;
        this.jFileChooser1.setCurrentDirectory(choice);
        this.jFileChooser1.setAcceptAllFileFilterUsed(false);
        this.jFileChooser1.addChoosableFileFilter(new ImageFilter());
        this.jFileChooser1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getActionCommand().equals("CancelSelection")) {
                    ExportPictureDlg.this.cancel();
                } else if (evt.getActionCommand().equals("ApproveSelection")) {
                    ExportPictureDlg.this.ok();
                }
            }
        });
        this.setLocationRelativeTo(parent);
    }

    public boolean select() {
        this.setVisible(true);
        return this.finalResult;
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.jPanelOption = new JPanel();
        this.jLabel2 = new JLabel();
        this.jSliderScale = new JSlider();
        this.jSpinnerScale = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldOriginalWidth = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextFieldOriginalHeight = new JTextField();
        this.jTextFieldScaledWidth = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextFieldScaledHeight = new JTextField();
        this.jLabel7 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.jFileChooser1.setDialogType(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.5;
        this.getContentPane().add((Component)this.jFileChooser1, gridBagConstraints);
        this.jPanelOption.setBorder(BorderFactory.createTitledBorder("Export options"));
        this.jPanelOption.setLayout(new GridBagLayout());
        this.jLabel2.setText("Scale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanelOption.add((Component)this.jLabel2, gridBagConstraints);
        this.jSliderScale.setMaximum(300);
        this.jSliderScale.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ExportPictureDlg.this.jSliderScaleStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.jPanelOption.add((Component)this.jSliderScale, gridBagConstraints);
        this.jSpinnerScale.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ExportPictureDlg.this.jSpinnerScaleStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 18;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.jPanelOption.add((Component)this.jSpinnerScale, gridBagConstraints);
        this.jLabel3.setText("Originale size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.jPanelOption.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Scaled size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.jPanelOption.add((Component)this.jLabel4, gridBagConstraints);
        this.jTextFieldOriginalWidth.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.jPanelOption.add((Component)this.jTextFieldOriginalWidth, gridBagConstraints);
        this.jLabel5.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.jPanelOption.add((Component)this.jLabel5, gridBagConstraints);
        this.jTextFieldOriginalHeight.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.jPanelOption.add((Component)this.jTextFieldOriginalHeight, gridBagConstraints);
        this.jTextFieldScaledWidth.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.jPanelOption.add((Component)this.jTextFieldScaledWidth, gridBagConstraints);
        this.jLabel6.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.jPanelOption.add((Component)this.jLabel6, gridBagConstraints);
        this.jTextFieldScaledHeight.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.jPanelOption.add((Component)this.jTextFieldScaledHeight, gridBagConstraints);
        this.jLabel7.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 4, 5, 0);
        this.jPanelOption.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanelOption, gridBagConstraints);
        this.pack();
    }

    private void jSpinnerScaleStateChanged(ChangeEvent evt) {
        int value = (Integer)this.jSpinnerScale.getValue();
        this.setPercentScale(value);
    }

    private void jSliderScaleStateChanged(ChangeEvent evt) {
        int value = this.jSliderScale.getValue();
        this.setPercentScale(value);
    }

    public void ok() {
        this.finalResult = true;
        this.setVisible(false);
    }

    public void cancel() {
        this.setVisible(false);
    }

    public int getPercentScale() {
        return this.percentScale;
    }

    public void setPercentScale(int percentScale) {
        int oldValue = this.percentScale;
        this.percentScale = percentScale;
        this.jSpinnerScale.setValue(new Integer(percentScale));
        this.jSliderScale.setValue(percentScale);
        double scale = (double)percentScale / 100.0;
        this.setPictureScaledWidth((int)((double)this.pictureWidth * scale));
        this.setPictureScaledHeight((int)((double)this.pictureHeight * scale));
        this.firePropertyChange("percentScale", oldValue, percentScale);
    }

    public int getPictureHeight() {
        return this.pictureHeight;
    }

    public void setPictureHeight(int pictureHeight) {
        int oldValue = this.pictureHeight;
        this.pictureHeight = pictureHeight;
        this.jTextFieldOriginalHeight.setText(new Integer(this.getPictureHeight()).toString());
        this.firePropertyChange("pictureHeight", oldValue, pictureHeight);
    }

    public int getPictureWidth() {
        return this.pictureWidth;
    }

    public int getPictureScaledHeight() {
        return this.pictureScaledHeight;
    }

    public int getPictureScaledWidth() {
        return this.pictureScaledWidth;
    }

    public void setPictureScaledWidth(int pictureScaledWidth) {
        int oldValue = this.pictureScaledWidth;
        this.pictureScaledWidth = pictureScaledWidth;
        this.jTextFieldScaledWidth.setText(new Integer(this.getPictureScaledWidth()).toString());
        this.firePropertyChange("pictureScaledWidth", oldValue, pictureScaledWidth);
    }

    public void setPictureWidth(int pictureWidth) {
        int oldValue = this.pictureWidth;
        this.pictureWidth = pictureWidth;
        this.jTextFieldOriginalWidth.setText(new Integer(this.getPictureWidth()).toString());
        this.firePropertyChange("pictureWidth", oldValue, pictureWidth);
    }

    public void setPictureScaledHeight(int pictureScaledHeight) {
        int oldValue = this.pictureScaledHeight;
        this.pictureScaledHeight = pictureScaledHeight;
        this.jTextFieldScaledHeight.setText(new Integer(this.getPictureScaledHeight()).toString());
        this.firePropertyChange("pictureScaledHeight", oldValue, pictureScaledHeight);
    }

    public String getFileName() {
        String result = "";
        try {
            File outputfile = this.jFileChooser1.getSelectedFile();
            String strFilename = outputfile.getAbsolutePath();
            String ext = outputfile.getAbsolutePath().endsWith(".png") ? "" : ".png";
            result = strFilename + ext;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

