/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import java.awt.Color;

abstract class NamedColor
extends Color
implements Comparable {
    protected NamedColor(String name, int r, int g, int b2) {
        super(r, g, b2);
    }

    public abstract String getDisplayName();

    public abstract String getName();

    public String getInstantiationCode() {
        return this.toString();
    }

    static NamedColor create(Color c2, String name) {
        return new DefaultNamedColor(c2, name);
    }

    private static final class DefaultNamedColor
    extends NamedColor {
        private String name;

        public DefaultNamedColor(Color c2, String name) {
            super(name, c2.getRed(), c2.getGreen(), c2.getBlue());
            this.name = name;
        }

        public String getDisplayName() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public int compareTo(Object o) {
            if (o instanceof NamedColor) {
                NamedColor nc = (NamedColor)o;
                String nm = nc.getDisplayName();
                if (nm == null && this.getDisplayName() == null) {
                    return 0;
                }
                return nm != null && this.getDisplayName() != null ? this.getDisplayName().compareTo(nm) : -1;
            }
            return -1;
        }
    }
}

