/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import net.java.dev.colorchooser.CCBorder;
import net.java.dev.colorchooser.ColorChooser;
import net.java.dev.colorchooser.ColorChooserUI;

final class DefaultColorChooserUI
extends ColorChooserUI {
    private static DefaultColorChooserUI INSTANCE = null;

    DefaultColorChooserUI() {
    }

    public static ComponentUI createUI(JComponent jc) {
        return DefaultColorChooserUI.getDefault();
    }

    static DefaultColorChooserUI getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultColorChooserUI();
        }
        return INSTANCE;
    }

    protected void init(ColorChooser c2) {
        c2.setToolTipText(DefaultColorChooserUI.getDefaultTooltip());
        c2.setBorder(new CCBorder());
    }

    protected void uninit(ColorChooser c2) {
        if (c2.getBorder() instanceof CCBorder) {
            c2.setBorder(null);
        }
        if (DefaultColorChooserUI.getDefaultTooltip().equals(c2.getToolTipText())) {
            c2.setToolTipText(null);
        }
    }

    private static String getDefaultTooltip() {
        return MAC ? ColorChooser.getString("tip.mac") : ColorChooser.getString("tip");
    }

    public void paint(Graphics g, JComponent c2) {
        ColorChooser chooser = (ColorChooser)c2;
        Color col = chooser.transientColor() != null ? chooser.transientColor() : chooser.getColor();
        g.setColor(col);
        g.fillRect(0, 0, chooser.getWidth() - 1, chooser.getHeight() - 1);
        if (chooser.hasFocus()) {
            g.setColor(DefaultColorChooserUI.invertColor(col));
            g.drawRect(4, 4, chooser.getWidth() - 8, chooser.getHeight() - 8);
        }
    }

    private static final Color invertColor(Color c2) {
        int r = DefaultColorChooserUI.checkRange(255 - c2.getRed());
        int g = DefaultColorChooserUI.checkRange(255 - c2.getGreen());
        int b2 = DefaultColorChooserUI.checkRange(255 - c2.getBlue());
        return new Color(r, g, b2);
    }

    private static final int checkRange(int i) {
        int result = i;
        if (Math.abs(128 - i) < 24) {
            result = Math.abs(128 - i);
        }
        return result;
    }
}

