/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import net.java.dev.colorchooser.ColorChooser;
import net.java.dev.colorchooser.Palette;

final class ContinuousPalette
extends Palette {
    public static final int SMALL_SPEC_WIDTH = 128;
    public static final int SMALL_SPEC_HEIGHT = 64;
    public static final int LARGE_SPEC_WIDTH = 200;
    public static final int LARGE_SPEC_HEIGHT = 100;
    public static final int SPEC_IMAGE_COUNT = 8;
    private BufferedImage img = null;
    private boolean initialized = false;
    private float saturation = 1.0f;
    private boolean verticalHue = true;
    private float grayStripSize = 0.05f;
    private String name;
    private static Palette[] defaultPalettes = null;

    private ContinuousPalette() {
        this.img = new BufferedImage(128, 60, 2);
    }

    private ContinuousPalette(String name, int width, int height) {
        this.img = new BufferedImage(width, height, 2);
        this.name = name;
    }

    ContinuousPalette(String name, int width, int height, float saturation) {
        this.img = new BufferedImage(width, height, 2);
        this.setSaturation(saturation);
        this.name = name;
    }

    private ContinuousPalette(String name, int width, int height, float saturation, boolean vHue) {
        this.img = new BufferedImage(width, height, 2);
        this.setSaturation(saturation);
        this.verticalHue = vHue;
        this.name = name;
    }

    protected void initImage() {
        for (int x = 0; x < this.img.getWidth(); ++x) {
            for (int y = 0; y < this.img.getHeight(); ++y) {
                int currColor = this.getColorAt(x, y).getRGB();
                this.img.setRGB(x, y, currColor);
            }
        }
    }

    public final void initializeImage() {
        if (!this.initialized) {
            this.initImage();
        }
    }

    public void paintTo(Graphics g) {
        if (g != null) {
            this.initializeImage();
            ((Graphics2D)g).drawRenderedImage(this.img, AffineTransform.getTranslateInstance(0.0, 0.0));
            this.initialized = true;
        }
    }

    public Color getColorAt(int x, int y) {
        float workingSaturation;
        float brightness;
        float hue;
        boolean inGrayStrip;
        boolean bl = inGrayStrip = (float)y / (float)this.img.getHeight() > 1.0f - this.grayStripSize;
        if (this.verticalHue) {
            hue = (float)y / (float)this.img.getHeight();
            brightness = (float)x / (float)this.img.getWidth();
        } else {
            if (inGrayStrip) {
                return this.grayValueFromX(x);
            }
            hue = 1.0f - (float)x / (float)this.img.getWidth();
            brightness = 1.0f - (float)y / (float)this.img.getHeight();
        }
        brightness *= 2.0f;
        if (brightness > 1.0f) {
            workingSaturation = this.saturation - (brightness - 1.0f) * this.saturation;
            brightness = 1.0f;
        } else {
            workingSaturation = this.saturation;
        }
        Color newColor = Color.getHSBColor(hue, workingSaturation, brightness);
        return newColor;
    }

    public Color colorFromPoint(Point p) {
        int x = new Double(p.getX()).intValue();
        int y = new Double(p.getY()).intValue();
        return this.getColorAt(x, y);
    }

    protected Color grayValueFromX(int x) {
        Color newColor = Color.getHSBColor(0.0f, 0.0f, (float)x / (float)this.img.getWidth());
        return newColor;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float saturation) {
        if (this.saturation != saturation) {
            this.saturation = saturation;
            this.doChange();
        }
    }

    public boolean isVerticalHue() {
        return this.verticalHue;
    }

    public void setVerticalHue(boolean verticalHue) {
        if (this.verticalHue != verticalHue) {
            this.verticalHue = verticalHue;
            this.doChange();
        }
    }

    protected void doChange() {
        this.initialized = false;
    }

    public void setGrayStripSize(float grayStripSize) {
        float workingGrayStripSize = grayStripSize;
        if (workingGrayStripSize > 1.0f) {
            workingGrayStripSize = 1.0f;
        }
        if (workingGrayStripSize != grayStripSize) {
            this.grayStripSize = grayStripSize;
            this.doChange();
        }
    }

    public float getGrayStripSize() {
        return this.grayStripSize;
    }

    public Dimension getSize() {
        return new Dimension(this.img.getWidth(), this.img.getHeight());
    }

    public String getNameAt(int x, int y) {
        Color c2 = this.getColorAt(x, y);
        StringBuffer sb = new StringBuffer();
        sb.append(c2.getRed());
        sb.append(',');
        sb.append(c2.getGreen());
        sb.append(',');
        sb.append(c2.getBlue());
        return sb.toString();
    }

    public static Palette[] createDefaultPalettes() {
        if (defaultPalettes == null) {
            defaultPalettes = new Palette[]{new ContinuousPalette("satLarge", 200, 100, 1.0f, false), new ContinuousPalette("unsatLarge", 200, 100, 0.4f, false), new ContinuousPalette("satLargeHoriz", 200, 100, 1.0f, true), new ContinuousPalette("unsatLargeHoriz", 200, 100, 0.4f, true)};
        }
        return defaultPalettes;
    }

    public String getDisplayName() {
        return ColorChooser.getString(this.name);
    }
}

