/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import net.java.dev.colorchooser.ColorChooser;
import net.java.dev.colorchooser.Palette;
import net.java.dev.colorchooser.PalettePopup;
import net.java.dev.colorchooser.RecentColors;

public abstract class ColorChooserUI
extends ComponentUI {
    static final boolean MAC = System.getProperty("mrj.version") != null;
    private JColorChooser jchooser = null;

    protected ColorChooserUI() {
    }

    public final void installUI(JComponent jc) {
        this.installListeners((ColorChooser)jc);
        this.init((ColorChooser)jc);
    }

    public final void uninstallUI(JComponent jc) {
        this.uninstallListeners((ColorChooser)jc);
        this.uninit((ColorChooser)jc);
    }

    protected void init(ColorChooser c2) {
    }

    protected void uninit(ColorChooser c2) {
    }

    protected void installListeners(ColorChooser c2) {
        L l = new L();
        c2.addMouseListener(l);
        c2.addFocusListener(l);
        c2.addKeyListener(l);
        c2.putClientProperty("uiListener", l);
    }

    protected void uninstallListeners(ColorChooser c2) {
        Object o = c2.getClientProperty("uiListener");
        if (o instanceof L) {
            L l = (L)o;
            c2.removeMouseListener(l);
            c2.removeFocusListener(l);
            c2.removeKeyListener(l);
        }
    }

    protected int paletteIndexFromKeyCode(KeyEvent ke) {
        int result;
        int keyCode = ke.getKeyCode();
        int n = result = keyCode == 16 ? 1 : 0;
        result = MAC ? (result += keyCode == 157 ? 2 : 0) : (result += keyCode == 17 ? 2 : 0);
        return result += keyCode == 18 ? 4 : 0;
    }

    protected int paletteIndexFromModifiers(InputEvent me) {
        int mods = me.getModifiersEx();
        int result = (mods & 0x40) != 0 ? 1 : 0;
        result += (mods & 0x80) != 0 ? 2 : 0;
        return result += (mods & 0x200) != 0 ? 4 : 0;
    }

    protected void keyboardInvoke(ColorChooser colorChooser) {
        if (!colorChooser.isEnabled()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (this.jchooser != null) {
            return;
        }
        this.jchooser = new JColorChooser();
        this.jchooser.setColor(colorChooser.getColor());
        Color nue = JColorChooser.showDialog(colorChooser, ColorChooser.getString("chooseColor"), colorChooser.getColor());
        if (nue != null) {
            colorChooser.setColor(nue);
            this.fireColorChanged(colorChooser);
        }
        this.jchooser = null;
    }

    protected void fireColorChanged(ColorChooser chooser) {
        chooser.fireActionPerformed(new ActionEvent(chooser, 1001, "color"));
    }

    public Dimension getMaximumSize(JComponent c2) {
        if (!c2.isMaximumSizeSet()) {
            return this.getPreferredSize(c2);
        }
        return super.getMaximumSize(c2);
    }

    public Dimension getMinimumSize(JComponent c2) {
        if (!c2.isMinimumSizeSet()) {
            return this.getPreferredSize(c2);
        }
        return super.getMinimumSize(c2);
    }

    public Dimension getPreferredSize(JComponent c2) {
        if (!c2.isPreferredSizeSet()) {
            return new Dimension(24, 24);
        }
        return super.getPreferredSize(c2);
    }

    private class L
    extends MouseAdapter
    implements FocusListener,
    KeyListener {
        private int paletteIndex = 0;
        private transient Point nextFocusPopupLocation = null;

        private L() {
        }

        int getPaletteIndex() {
            return this.paletteIndex;
        }

        void initPaletteIndex(ColorChooser c2, MouseEvent me) {
            this.paletteIndex = ColorChooserUI.this.paletteIndexFromModifiers(me);
            this.checkRange(c2);
        }

        private void checkRange(ColorChooser chooser) {
            Palette[] p = chooser.getPalettes();
            if (this.paletteIndex >= p.length) {
                this.paletteIndex = p.length - 1;
            }
        }

        private void updatePaletteIndex(ColorChooser chooser, int value, boolean pressed) {
            int oldIndex = this.paletteIndex;
            int result = this.paletteIndex;
            result = pressed ? (result |= value) : (result ^= value);
            if (oldIndex != result && PalettePopup.getDefault().isPopupVisible(chooser)) {
                this.paletteIndex = result;
                this.checkRange(chooser);
                PalettePopup.getDefault().setPalette(chooser.getPalettes()[this.paletteIndex]);
            }
        }

        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                return;
            }
            ColorChooser chooser = (ColorChooser)me.getSource();
            if (!chooser.isEnabled()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            Point p = me.getPoint();
            SwingUtilities.convertPointToScreen(p, chooser);
            this.initPaletteIndex(chooser, me);
            PalettePopup.getDefault().setPalette(chooser.getPalettes()[this.getPaletteIndex()]);
            if (!chooser.hasFocus()) {
                this.nextFocusPopupLocation = p;
                chooser.requestFocus();
                return;
            }
            PalettePopup.getDefault().showPopup(chooser, p);
            me.consume();
            this.nextFocusPopupLocation = null;
        }

        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                return;
            }
            ColorChooser chooser = (ColorChooser)me.getSource();
            if (!chooser.isEnabled()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            this.nextFocusPopupLocation = null;
            if (PalettePopup.getDefault().isPopupVisible(chooser)) {
                PalettePopup.getDefault().hidePopup(chooser);
                Color transientColor = chooser.transientColor();
                if (transientColor != null) {
                    RecentColors.getDefault().add(transientColor);
                    Color old = new Color(transientColor.getRed(), transientColor.getGreen(), transientColor.getBlue());
                    chooser.setTransientColor(null);
                    chooser.setColor(old);
                    ColorChooserUI.this.fireColorChanged(chooser);
                    me.consume();
                }
            }
        }

        public void focusGained(FocusEvent e2) {
            ColorChooser chooser = (ColorChooser)e2.getSource();
            if (this.nextFocusPopupLocation != null && chooser.isEnabled()) {
                PalettePopup.getDefault().showPopup(chooser, this.nextFocusPopupLocation);
            }
            this.nextFocusPopupLocation = null;
            chooser.repaint();
        }

        public void focusLost(FocusEvent e2) {
            ColorChooser chooser = (ColorChooser)e2.getSource();
            chooser.repaint();
        }

        public void keyTyped(KeyEvent e2) {
        }

        public void keyPressed(KeyEvent e2) {
            this.processKeyEvent(e2, true);
        }

        public void keyReleased(KeyEvent e2) {
            this.processKeyEvent(e2, false);
        }

        protected void processKeyEvent(KeyEvent ke, boolean pressed) {
            block6: {
                ColorChooser chooser;
                block7: {
                    block5: {
                        block4: {
                            chooser = (ColorChooser)ke.getSource();
                            this.updatePaletteIndex(chooser, ColorChooserUI.this.paletteIndexFromKeyCode(ke), pressed);
                            if (ke.getKeyCode() == 18) break block4;
                            if (ke.getKeyCode() == 17) break block4;
                            if (ke.getKeyCode() != 16) break block5;
                        }
                        ke.consume();
                        break block6;
                    }
                    if (ke.getKeyCode() == 32) break block7;
                    if (ke.getKeyCode() != 10) break block6;
                }
                if (ke.getID() == 402) {
                    ColorChooserUI.this.keyboardInvoke(chooser);
                }
            }
        }
    }
}

