/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.java.dev.colorchooser.ColorChooser;

class CCBorder
implements Border {
    CCBorder() {
    }

    public Insets getBorderInsets(Component c2) {
        Insets result = UIManager.getLookAndFeel() instanceof MetalLookAndFeel ? new Insets(2, 2, 1, 1) : new Insets(1, 1, 1, 1);
        return result;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c2, Graphics g, int x, int y, int w, int h) {
        Color col;
        ColorChooser cc = (ColorChooser)c2;
        if (!cc.isEnabled()) {
            g.setColor(cc.getColor());
            g.fillRect(x, y, w, h);
            return;
        }
        Color color = col = cc.transientColor() == null ? cc.getColor() : cc.transientColor();
        if (cc == null && (col = c2.getBackground()) == null) {
            col = Color.BLACK;
        }
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            g.setColor(CCBorder.darken(col));
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y, x, y + h - 1);
            g.drawLine(x + w - 1, y + h - 1, x, y + h - 1);
            g.drawLine(x + w - 1, y + h - 1, x + w - 1, y);
            g.setColor(CCBorder.brighten(col));
            g.drawLine(x + w - 2, y + h - 2, x + 1, y + h - 2);
            g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + 1);
        } else {
            g.setColor(CCBorder.darken(col));
            g.drawLine(x + w - 1, y + h - 1, x, y + h - 1);
            g.drawLine(x + w - 1, y + h - 1, x + w - 1, y);
            g.setColor(CCBorder.brighten(col));
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y, x, y + h - 1);
        }
    }

    private static final Color darken(Color c2) {
        int amount = 30;
        int r = CCBorder.normalizeToByte(c2.getRed() - amount);
        int g = CCBorder.normalizeToByte(c2.getGreen() - amount);
        int b2 = CCBorder.normalizeToByte(c2.getGreen() - amount);
        return new Color(r, g, b2);
    }

    private static final Color brighten(Color c2) {
        int amount = 30;
        int r = CCBorder.normalizeToByte(c2.getRed() + amount);
        int g = CCBorder.normalizeToByte(c2.getGreen() + amount);
        int b2 = CCBorder.normalizeToByte(c2.getGreen() + amount);
        return new Color(r, g, b2);
    }

    private static final int normalizeToByte(int i) {
        return Math.min(255, Math.max(0, i));
    }
}

