/*
 * Decompiled with CFR 0.152.
 */
package eric.controls;

import eric.JGlobals;
import eric.JMacrosTools;
import eric.JPaletteManager;
import eric.controls.JCanvasCheckBox;
import eric.controls.JCanvasPanel;
import eric.controls.JCanvasPopup;
import eric.controls.JCanvasSlider;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.util.ArrayList;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.TextObject;

public class JControlsManager {
    static Color bordercolor1 = new Color(80, 80, 80);
    static Color bordercolor2 = new Color(180, 180, 250);
    static int MAGNET = 10;
    ZirkelCanvas ZC;
    ArrayList CPs = new ArrayList();
    Rectangle r = new Rectangle();
    Rectangle r2 = new Rectangle();
    ArrayList XmlTags = new ArrayList();

    public JControlsManager(ZirkelCanvas zc) {
        this.ZC = zc;
    }

    public void paintControls() {
        Graphics2D g2D = null;
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp = (JCanvasPanel)this.CPs.get(i);
            BufferedImage sprite = null;
            if (!jp.isHidden() || this.ZC.getShowHidden()) {
                sprite = new BufferedImage(jp.getSize().width, jp.getSize().height, 2);
                g2D = sprite.createGraphics();
                jp.paintChildren(g2D);
                jp.paintComponent(g2D);
            }
            if (jp.isHidden() && this.ZC.getShowHidden()) {
                GrayFilter filter = new GrayFilter(true, 60);
                Image disImage = jp.createImage(new FilteredImageSource(sprite.getSource(), filter));
                ImageIcon myicn = new ImageIcon(disImage);
                g2D.drawImage(myicn.getImage(), 0, 0, jp.getSize().width, jp.getSize().height, jp);
            }
            if (sprite == null) continue;
            this.ZC.I.getGraphics().drawImage(sprite, jp.getLocation().x, jp.getLocation().y, jp);
        }
    }

    public void addControl(JCanvasPanel jcp, boolean editme, int x, int y, int w, int h) {
        jcp.setDims(x, y, w, h);
        this.CPs.add(jcp);
        this.showHandles(jcp);
        this.ZC.revalidate();
        if (editme) {
            JGlobals.EditObject(jcp);
        }
    }

    public JCanvasCheckBox addChkBox(ExpressionObject o, int x, int y, int w, int h) {
        JCanvasCheckBox jcb = new JCanvasCheckBox(this.ZC, o);
        this.addControl(jcb, o == null, x, y, w, h);
        return jcb;
    }

    public JCanvasSlider addSlider(ExpressionObject o, int x, int y, int w, int h) {
        JCanvasSlider jcs = new JCanvasSlider(this.ZC, o, -5.0, 5.0, -2.0);
        this.addControl(jcs, o == null, x, y, w, h);
        return jcs;
    }

    public JCanvasPopup addPopup(ExpressionObject o, int x, int y, int w, int h) {
        JCanvasPopup jcp = new JCanvasPopup(this.ZC, o);
        this.addControl(jcp, o == null, x, y, w, h);
        return jcp;
    }

    public void analyseResize(JCanvasPanel jp) {
        this.r = jp.getBounds(this.r);
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp2 = (JCanvasPanel)this.CPs.get(i);
            if (jp2.equals(jp)) continue;
            this.r2 = jp2.getBounds(this.r2);
            if (Math.abs(this.r2.x + this.r2.width - this.r.x - this.r.width) >= MAGNET) continue;
            jp.grow(this.r2.x + this.r2.width - this.r.x - this.r.width, 0);
            this.showBordersRight(jp);
            return;
        }
        this.showBordersRight(jp);
    }

    public void analyseXY(JCanvasPanel jp) {
        this.r = jp.getBounds(this.r);
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp2 = (JCanvasPanel)this.CPs.get(i);
            if (jp2.equals(jp)) continue;
            this.r2 = jp2.getBounds(this.r2);
            if (Math.abs(this.r2.x - this.r.x) < MAGNET) {
                jp.setLocation(this.r2.x, this.r.y);
                this.r = jp.getBounds(this.r);
            }
            if (Math.abs(this.r2.x + this.r2.width - this.r.x - this.r.width) < MAGNET) {
                jp.setLocation(this.r2.x + this.r2.width - this.r.width, this.r.y);
                this.r = jp.getBounds(this.r);
            }
            if (Math.abs(this.r2.y + this.r2.height / 2 - this.r.y - this.r.height / 2) >= MAGNET) continue;
            jp.setLocation(this.r.x, this.r2.y + this.r2.height / 2 - this.r.height / 2);
            this.r = jp.getBounds(this.r);
        }
        this.showBorders(jp);
    }

    public void showBordersRight(JCanvasPanel jp) {
        this.r = jp.getBounds(this.r);
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp2 = (JCanvasPanel)this.CPs.get(i);
            if (jp2.equals(jp)) continue;
            this.r2 = jp2.getBounds(this.r2);
            jp2.hideBorder();
            if (this.r2.x + this.r2.width - this.r.x - this.r.width != 0) continue;
            jp2.showBorder();
        }
    }

    public void showBorders(JCanvasPanel jp) {
        this.r = jp.getBounds(this.r);
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp2 = (JCanvasPanel)this.CPs.get(i);
            if (jp2.equals(jp)) continue;
            this.r2 = jp2.getBounds(this.r2);
            jp2.hideBorder();
            if (this.r2.x == this.r.x) {
                jp2.showBorder();
            }
            if (this.r2.x + this.r2.width - this.r.x - this.r.width == 0) {
                jp2.showBorder();
            }
            if (this.r2.y + this.r2.height / 2 - this.r.y - this.r.height / 2 != 0) continue;
            jp2.showBorder();
        }
    }

    public void updateDigits() {
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp2 = (JCanvasPanel)this.CPs.get(i);
            jp2.setVal(jp2.getVal());
        }
    }

    public void hideBorders(JCanvasPanel jp) {
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp2 = (JCanvasPanel)this.CPs.get(i);
            if (jp2.equals(jp)) continue;
            jp2.hideBorder();
        }
    }

    public void hideHandles(JCanvasPanel jp) {
        for (int i = 0; i < this.CPs.size(); ++i) {
            JCanvasPanel jp2 = (JCanvasPanel)this.CPs.get(i);
            if (jp2.equals(jp)) continue;
            jp2.hideHandle();
        }
    }

    public void showHandles(JCanvasPanel jp) {
        this.hideHandles(jp);
        jp.showHandle();
    }

    public static boolean createControl(ZirkelCanvas zc, MouseEvent e2) {
        if (Zirkel.IsApplet) {
            return false;
        }
        if (JMacrosTools.CurrentJZF == null) {
            return false;
        }
        if (JMacrosTools.CurrentJZF.restrictedSession) {
            return false;
        }
        if (e2.isPopupTrigger()) {
            return false;
        }
        int x = e2.getX();
        int y = e2.getY();
        JPaletteManager myJPM = JMacrosTools.CurrentJZF.JPM;
        JControlsManager myJCM = zc.JCM;
        if (myJPM.ctrlJSlider.isSelected()) {
            myJCM.addSlider(null, x, y, 200, 29);
            return true;
        }
        if (myJPM.ctrlJPopup.isSelected()) {
            myJCM.addPopup(null, x, y, 120, 22);
            return true;
        }
        if (myJPM.ctrlJCheckBox.isSelected()) {
            myJCM.addChkBox(null, x, y, 30, 22);
            return true;
        }
        return false;
    }

    public void deleteControls(JCanvasPanel jp) {
        this.CPs.remove(jp);
        this.ZC.delete(jp.O);
        this.ZC.remove(jp);
        this.ZC.revalidate();
    }

    public static void PrintXmlTags(ZirkelCanvas zc, XmlWriter xml) {
        if (JMacrosTools.CurrentJZF == null) {
            return;
        }
        for (int i = 0; i < zc.JCM.CPs.size(); ++i) {
            ((JCanvasPanel)zc.JCM.CPs.get(i)).PrintXmlTags(xml);
        }
    }

    public void addSlider(XmlTag tag) {
        ExpressionObject o = (ExpressionObject)this.ZC.getConstruction().find(tag.getValue("Ename"));
        JCanvasSlider jcs = this.addSlider(o, Integer.parseInt(tag.getValue("x")), Integer.parseInt(tag.getValue("y")), Integer.parseInt(tag.getValue("w")), Integer.parseInt(tag.getValue("h")));
        jcs.hidden = Boolean.valueOf(tag.getValue("hidden"));
        jcs.showcom = Boolean.valueOf(tag.getValue("showC"));
        jcs.showunit = Boolean.valueOf(tag.getValue("showU"));
        jcs.showval = Boolean.valueOf(tag.getValue("showV"));
        jcs.lbl_com = tag.getValue("C");
        jcs.lbl_unit = tag.getValue("U");
        jcs.xTICKS = Double.valueOf(tag.getValue("T"));
        jcs.xMIN = Double.valueOf(tag.getValue("min"));
        jcs.xMAX = Double.valueOf(tag.getValue("max"));
        jcs.setVal(Double.valueOf(tag.getValue("V")));
        jcs.setTicks(jcs.xTICKS);
        jcs.JCS.setSnapToTicks(Boolean.valueOf(tag.getValue("fixT")));
        jcs.JCS.setPaintTicks(Boolean.valueOf(tag.getValue("showT")));
        jcs.setGoodKnobPos(Double.valueOf(tag.getValue("V")));
    }

    public void addChkBox(XmlTag tag) {
        ExpressionObject o = (ExpressionObject)this.ZC.getConstruction().find(tag.getValue("Ename"));
        JCanvasCheckBox jcs = this.addChkBox(o, Integer.parseInt(tag.getValue("x")), Integer.parseInt(tag.getValue("y")), Integer.parseInt(tag.getValue("w")), Integer.parseInt(tag.getValue("h")));
        jcs.hidden = Boolean.valueOf(tag.getValue("hidden"));
        jcs.showcom = Boolean.valueOf(tag.getValue("showC"));
        jcs.showunit = Boolean.valueOf(tag.getValue("showU"));
        jcs.showval = Boolean.valueOf(tag.getValue("showV"));
        jcs.lbl_com = tag.getValue("C");
        jcs.lbl_unit = tag.getValue("U");
        double chked = Double.valueOf(tag.getValue("V"));
        jcs.setVal(chked);
        jcs.JCB.setSelected(chked == 1.0);
    }

    public void addPopup(XmlTag tag) {
        ExpressionObject o = (ExpressionObject)this.ZC.getConstruction().find(tag.getValue("Ename"));
        JCanvasPopup jcs = this.addPopup(o, Integer.parseInt(tag.getValue("x")), Integer.parseInt(tag.getValue("y")), Integer.parseInt(tag.getValue("w")), Integer.parseInt(tag.getValue("h")));
        jcs.hidden = Boolean.valueOf(tag.getValue("hidden"));
        jcs.showcom = Boolean.valueOf(tag.getValue("showC"));
        jcs.showunit = Boolean.valueOf(tag.getValue("showU"));
        jcs.showval = Boolean.valueOf(tag.getValue("showV"));
        jcs.lbl_com = tag.getValue("C");
        jcs.lbl_unit = tag.getValue("U");
        jcs.setItems(tag.getValue("Items").replace("@@@", "\n"));
        double v = Double.valueOf(tag.getValue("V"));
        jcs.setVal(Math.round(v));
        jcs.JCB.setSelectedIndex((int)Math.round(v - 1.0));
    }

    public void fix3Dcomments() {
        if (this.CPs.size() > 1) {
            JCanvasPanel jp = (JCanvasPanel)this.CPs.get(0);
            jp.setComment(JGlobals.Loc("canvas.3D.floor"));
            jp = (JCanvasPanel)this.CPs.get(1);
            jp.setComment(JGlobals.Loc("canvas.3D.system"));
            TextObject t = (TextObject)this.ZC.getConstruction().find("Text2");
            if (t != null) {
                t.setLines(JGlobals.Loc("canvas.3D.rightclic"));
            }
        }
    }

    public void collectXmlTag(XmlTag tag) {
        this.XmlTags.add(tag);
    }

    public void readXmlTags() {
        for (int i = 0; i < this.XmlTags.size(); ++i) {
            XmlTag tag = (XmlTag)this.XmlTags.get(i);
            if (tag.name().equals("CTRLslider")) {
                this.addSlider(tag);
            }
            if (tag.name().equals("CTRLcheckbox")) {
                this.addChkBox(tag);
            }
            if (!tag.name().equals("CTRLpopup")) continue;
            this.addPopup(tag);
        }
        if (this.XmlTags.size() > 0) {
            this.XmlTags.clear();
            this.hideHandles(null);
        }
    }
}

