/*
 * Decompiled with CFR 0.152.
 */
package eric.controls;

import eric.JGlobals;
import eric.controls.JCanvasPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalComboBoxUI;
import rene.util.xml.XmlWriter;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.objects.ExpressionObject;

public class JCanvasPopup
extends JCanvasPanel
implements ActionListener {
    MyJComboBox JCB;

    public JCanvasPopup(ZirkelCanvas zc, ExpressionObject o) {
        super(zc, o);
        this.JSL = new MyJComboBox();
        this.JCB = (MyJComboBox)this.JSL;
        this.JCB.setUI((ComboBoxUI)MyComboBoxUI.createUI(this.JCB));
        this.JCB.addMouseListener(this);
        this.JCB.addMouseMotionListener(this);
        this.JCB.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                if (JCanvasPopup.this.isEditMode()) {
                    JCanvasPopup.this.JCB.hidePopup();
                }
            }
        });
        this.addMouseEvents();
        this.JCB.addActionListener(this);
        this.showval = false;
        this.showunit = false;
        this.showcom = true;
        this.setComment(JGlobals.Loc("props.expl") + " ");
        this.setVal(1.0);
        this.add(this.JCPlabel);
        this.add(this.JCB);
        this.add(this.JCPresize);
        zc.add(this);
    }

    public void addMouseEvents() {
        for (int i = 0; i < this.JCB.getComponentCount(); ++i) {
            this.JCB.getComponent(i).addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e2) {
                    if (JCanvasPopup.this.isEditMode()) {
                        JCanvasPopup.this.JCB.hidePopup();
                    }
                }
            });
            this.JCB.getComponent(i).addMouseListener(this);
            this.JCB.getComponent(i).addMouseMotionListener(this);
        }
    }

    public String getItems() {
        String s = "";
        for (int i = 0; i < this.JCB.getItemCount() - 1; ++i) {
            s = s + this.JCB.getItemAt(i) + "\n";
        }
        s = s + this.JCB.getItemAt(this.JCB.getItemCount() - 1);
        return s;
    }

    public void setItems(String s) {
        this.JCB.removeAllItems();
        String[] itms = s.split("\n");
        for (int i = 0; i < itms.length; ++i) {
            this.JCB.addItem(itms[i]);
        }
        this.setDims();
    }

    public double getVal() {
        return this.JCB.getSelectedIndex() + 1;
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.JCB) {
            int selectedIndex = this.JCB.getSelectedIndex() + 1;
            try {
                this.setVal(selectedIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void PrintXmlTags(XmlWriter xml) {
        xml.startTagStart("CTRLpopup");
        super.PrintXmlTags(xml);
        String s = this.getItems().replace("\n", "@@@");
        xml.printArg("Items", "" + s);
        xml.finishTagNewLine();
    }

    class MyJComboBox
    extends JComboBox {
        MyJComboBox() {
            this.setFocusable(false);
            this.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3"}));
        }
    }

    static class MyComboBoxUI
    extends MetalComboBoxUI {
        MyComboBoxUI() {
        }

        public static ComponentUI createUI(JComponent c2) {
            return new MyComboBoxUI();
        }
    }
}

