/*
 * Decompiled with CFR 0.152.
 */
package eric.controls;

import eric.JGlobals;
import eric.JMacrosTools;
import eric.JPointName;
import eric.controls.JControlsManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rene.gui.Global;
import rene.util.xml.XmlWriter;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.objects.ExpressionObject;

public class JCanvasPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ChangeListener {
    ImageIcon ctrlresizeicon = new ImageIcon(this.getClass().getResource("/eric/icons/palette/ctrl_resize.png"));
    static int COMFONTSIZE = 14;
    static int COMSIZE = 50;
    static Color COMCOLOR = new Color(80, 80, 80);
    JComponent JSL;
    String lbl_com = "";
    String lbl_val = "";
    String lbl_unit = "\u00b0";
    boolean showcom = true;
    boolean showval = true;
    boolean showunit = false;
    JLabel JCPlabel = new JLabel();
    JButton JCPresize = new JButton();
    ZirkelCanvas ZC;
    public ExpressionObject O;
    boolean hidden = false;
    private boolean showborder1 = false;
    private boolean showborder2 = false;
    private boolean showhandle = false;
    private MouseEvent pressed;
    private Point location;
    private DecimalFormat decFormat;

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d2 = this.getSize();
        if (this.showhandle) {
            Graphics2D g2d = (Graphics2D)g;
            Rectangle2D.Double rectangle = new Rectangle2D.Double(0.0, 0.0, d2.width - 8, d2.height - 1);
            g2d.setColor(new Color(119, 136, 153));
            g2d.setStroke(new BasicStroke(1.0f, 2, 2, 1.0f, new float[]{2.0f}, 0.0f));
            g2d.draw(rectangle);
            g.drawImage(this.ctrlresizeicon.getImage(), d2.width - 12, d2.height / 2 - 4, this);
        } else if (this.showborder1) {
            g.setColor(JControlsManager.bordercolor1);
            g.drawRect(0, 0, d2.width - 8, d2.height - 1);
        } else if (this.showborder2) {
            g.setColor(JControlsManager.bordercolor2);
            g.drawRect(0, 0, d2.width - 8, d2.height - 1);
        }
    }

    public void paintChildren(Graphics g) {
        super.paintChildren(g);
    }

    public JCanvasPanel(ZirkelCanvas zc, ExpressionObject o) {
        this.ZC = zc;
        this.O = o == null ? this.createExpression() : o;
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.JCPlabel.setHorizontalAlignment(2);
        this.JCPlabel.setFont(new Font(JGlobals.GlobalFont, 0, COMFONTSIZE));
        this.JCPlabel.setForeground(COMCOLOR);
        this.JCPresize.setOpaque(false);
        this.JCPresize.setContentAreaFilled(false);
        this.JCPresize.setBorder(BorderFactory.createEmptyBorder());
        this.JCPresize.setCursor(new Cursor(11));
        this.JCPresize.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent me) {
                JCanvasPanel.this.pressed = me;
            }

            public void mouseReleased(MouseEvent me) {
                JCanvasPanel.this.ZC.JCM.hideBorders((JCanvasPanel)((JComponent)me.getSource()).getParent());
            }
        });
        this.JCPresize.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent me) {
                int w = JCanvasPanel.this.JSL.getSize().width + me.getX();
                JCanvasPanel.this.setDims(w - JCanvasPanel.this.pressed.getX(), JCanvasPanel.this.getSize().height);
                JCanvasPanel.this.ZC.JCM.analyseResize((JCanvasPanel)((JComponent)me.getSource()).getParent());
            }
        });
        this.decFormat = new DecimalFormat();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.decFormat.setDecimalFormatSymbols(dfs);
    }

    private ExpressionObject createExpression() {
        ExpressionObject o = new ExpressionObject(this.ZC.getConstruction(), 0.0, 0.0);
        o.setDefaults();
        o.setSuperHidden(true);
        this.ZC.getConstruction().add(o);
        if (JMacrosTools.CurrentJZF != null) {
            int i = JMacrosTools.CurrentJZF.PointLabel.getCurrentLetterSetCode();
            boolean b2 = Global.getParameter("options.point.shownames", false);
            Global.setParameter("options.point.shownames", true);
            String s = JMacrosTools.CurrentJZF.PointLabel.setLetterSet(JPointName.minLettersSetCode);
            System.out.println(s);
            Global.setParameter("options.point.shownames", b2);
            JMacrosTools.CurrentJZF.PointLabel.setLetterSet(i);
            o.setName(s);
        }
        return o;
    }

    public int StringwWidth(String s) {
        FontMetrics fm = this.getFontMetrics(new Font(JGlobals.GlobalFont, 0, COMFONTSIZE));
        return fm.stringWidth(s);
    }

    public double getVal() {
        return 0.0;
    }

    public void setVal(double x) {
        this.decFormat.setMaximumFractionDigits(Global.getParameter("digits.edit", 5));
        this.lbl_val = String.valueOf(this.decFormat.format(x));
        this.setVal(String.valueOf(x));
    }

    public void setVal(String s) {
        this.JCPlabel.setText(this.goodLabel());
        try {
            this.O.setExpression(s, this.ZC.getConstruction());
            this.ZC.recompute();
            this.setDims();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDims(int x, int y, int w, int h) {
        int W = w + this.StringwWidth(this.JCPlabel.getText()) + 15;
        JCanvasPanel.fixsize(this.JCPlabel, this.StringwWidth(this.JCPlabel.getText()), h);
        JCanvasPanel.fixsize(this.JCPresize, 15, h);
        JCanvasPanel.fixsize(this.JSL, w, h);
        this.revalidate();
        this.setBounds(x, y, W, h);
        this.ZC.validate();
        this.ZC.repaint();
    }

    public void setDims(int w, int h) {
        int x = this.getLocation().x;
        int y = this.getLocation().y;
        this.setDims(x, y, w, h);
    }

    public void setDims() {
        this.setDims(this.JSL.getSize().width, this.JSL.getSize().height);
    }

    public void grow(int w, int h) {
        this.setDims(this.JSL.getSize().width + w, this.JSL.getSize().height + h);
    }

    public String getComment() {
        return this.lbl_com;
    }

    public void setComment(String s) {
        this.lbl_com = s;
        this.JCPlabel.setText(this.goodLabel());
        this.setDims();
    }

    public String getUnit() {
        return this.lbl_unit;
    }

    public void setUnit(String s) {
        this.lbl_unit = s;
        this.JCPlabel.setText(this.goodLabel());
        this.setDims();
    }

    public void setShowComment(boolean b2) {
        this.showcom = b2;
        this.JCPlabel.setText(this.goodLabel());
        this.setDims();
    }

    public void setShowVal(boolean b2) {
        this.showval = b2;
        this.JCPlabel.setText(this.goodLabel());
        this.setDims();
    }

    public void setShowUnit(boolean b2) {
        this.showunit = b2;
        this.JCPlabel.setText(this.goodLabel());
        this.setDims();
    }

    public boolean getShowComment() {
        return this.showcom;
    }

    public boolean getShowVal() {
        return this.showval;
    }

    public boolean getShowUnit() {
        return this.showunit;
    }

    public String goodLabel() {
        String lbl = "";
        if (this.showcom) {
            lbl = lbl + this.lbl_com;
        }
        if (this.showval) {
            lbl = lbl + this.lbl_val;
        }
        if (this.showunit) {
            lbl = lbl + this.lbl_unit;
        }
        return lbl;
    }

    public static void fixsize(JComponent cp, int w, int h) {
        Dimension d2 = new Dimension(w, h);
        cp.setMaximumSize(d2);
        cp.setMinimumSize(d2);
        cp.setPreferredSize(d2);
        cp.setSize(d2);
    }

    public boolean isEditMode() {
        if (JMacrosTools.CurrentJZF == null) {
            return false;
        }
        boolean bool = JMacrosTools.CurrentJZF.JPM.isSelected("edit") || JMacrosTools.CurrentJZF.JPM.isSelected("ctrl_edit");
        bool = bool || JMacrosTools.CurrentJZF.JPM.isSelected("ctrl_slider");
        bool = bool || JMacrosTools.CurrentJZF.JPM.isSelected("ctrl_popup");
        bool = bool || JMacrosTools.CurrentJZF.JPM.isSelected("ctrl_chkbox");
        bool = bool || JMacrosTools.CurrentJZF.JPM.isSelected("delete");
        bool = bool || JMacrosTools.CurrentJZF.JPM.isSelected("hide");
        return bool;
    }

    public boolean isDeleteMode() {
        if (JMacrosTools.CurrentJZF == null) {
            return false;
        }
        return JMacrosTools.CurrentJZF.JPM.isSelected("delete");
    }

    public boolean isHideToolSelected() {
        if (JMacrosTools.CurrentJZF == null) {
            return false;
        }
        return JMacrosTools.CurrentJZF.JPM.isSelected("hide");
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean b2) {
        this.hidden = b2;
    }

    public void showBorder() {
        this.showborder2 = true;
        this.repaint();
    }

    public void hideBorder() {
        this.showborder2 = false;
        this.repaint();
    }

    public void showHandle() {
        this.showhandle = true;
        this.setDims();
    }

    public void hideHandle() {
        this.showhandle = false;
        this.setDims();
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent e2) {
        this.pressed = e2;
        if (e2.isPopupTrigger()) {
            return;
        }
        this.ZC.JCM.hideHandles(null);
    }

    public void mouseReleased(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            return;
        }
        if (!this.ZC.getShowHidden() && this.isHidden()) {
            return;
        }
        if (this.isHideToolSelected()) {
            this.setHidden(!this.isHidden());
            this.setCursor(new Cursor(0));
            this.showborder1 = false;
            this.repaint();
        }
        if (this.isDeleteMode()) {
            this.ZC.JCM.deleteControls(this);
        }
        this.ZC.JCM.hideBorders(this);
        if (this.isEditMode() && !this.isHidden()) {
            this.showHandle();
            JGlobals.EditObject(this);
        }
    }

    public void mouseEntered(MouseEvent arg0) {
        if (this.isHidden()) {
            this.setCursor(new Cursor(0));
            this.showborder1 = false;
            return;
        }
        if (this.isEditMode()) {
            this.setCursor(new Cursor(12));
            this.showborder1 = true;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent arg0) {
        this.setCursor(new Cursor(0));
        this.showborder1 = false;
        this.repaint();
    }

    public void mouseDragged(MouseEvent me) {
        if (!this.isEditMode()) {
            return;
        }
        this.location = this.getLocation(this.location);
        int x = this.location.x - this.pressed.getX() + me.getX();
        int y = this.location.y - this.pressed.getY() + me.getY();
        if (x < 0) {
            x = 0;
        } else if (x + this.getSize().width > this.ZC.getSize().width) {
            x = this.ZC.getSize().width - this.getSize().width;
        }
        if (y < 0) {
            y = 0;
        } else if (y + this.getSize().height > this.ZC.getSize().height) {
            y = this.ZC.getSize().height - this.getSize().height;
        }
        this.setLocation(x, y);
        Toolkit.getDefaultToolkit().sync();
        this.ZC.JCM.analyseXY(this);
    }

    public void mouseMoved(MouseEvent arg0) {
    }

    public void stateChanged(ChangeEvent arg0) {
    }

    public void PrintXmlTags(XmlWriter xml) {
        xml.printArg("Ename", "" + this.O.getName());
        xml.printArg("x", "" + this.getLocation().x);
        xml.printArg("y", "" + this.getLocation().y);
        xml.printArg("w", "" + this.JSL.getSize().width);
        xml.printArg("h", "" + this.JSL.getSize().height);
        xml.printArg("showC", "" + this.showcom);
        xml.printArg("showU", "" + this.showunit);
        xml.printArg("showV", "" + this.showval);
        xml.printArg("hidden", "" + this.hidden);
        xml.printArg("C", "" + this.lbl_com);
        xml.printArg("U", "" + this.lbl_unit);
        xml.printArg("V", "" + this.lbl_val);
    }
}

