/*
 * Decompiled with CFR 0.152.
 */
package eric.bar;

import eric.JGlobals;
import eric.JMacrosTools;
import eric.JZirkelFrame;
import eric.bar.JControlProperties;
import eric.controls.JCanvasPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import rene.gui.Global;
import rene.zirkel.objects.ConstructionObject;

public class JPropertiesBar
extends JFrame
implements MouseListener,
MouseMotionListener {
    static int HAUT = 0;
    static int BAS = 1;
    static int TOP = 2;
    static int BOTTOM = 3;
    static int Bx = 0;
    static int By = 0;
    static int Docky = HAUT;
    static int Bwidth = 1000;
    static int Bheight = 60;
    CPane CP;
    TitleBar titlebar;
    JControlProperties Content;
    private MouseEvent pressed;
    private Point location;

    public JPropertiesBar() {
        Bx = Global.getParameter("props.paletteX", 0);
        Docky = Global.getParameter("props.dockY", HAUT);
        if (JGlobals.SCREEN.x > Bx) {
            Bx = JGlobals.SCREEN.x;
        }
        By = Docky == HAUT ? JGlobals.SCREEN.y : JGlobals.SCREEN.y + JGlobals.SCREEN.height - Bheight;
        this.CP = new CPane();
        this.setContentPane(this.CP);
        this.titlebar = new TitleBar(this, 18);
        this.Content = new JControlProperties(Bwidth - this.titlebar.getSize().width, Bheight);
        this.Content.addPanel(JGlobals.Loc("props.aspecttab"));
        this.Content.addPanel(JGlobals.Loc("props.numerictab"));
        this.Content.addPanel(JGlobals.Loc("props.conditionaltab"));
        this.Content.selectTab(Global.getParameter("props.selectedtab", 0));
        this.CP.add(this.titlebar);
        this.CP.add(this.Content);
        this.setSize(Bwidth + 2, Bheight + 2);
        this.setLocation(Bx, By);
        this.setUndecorated(true);
        this.setFocusable(true);
    }

    public void clearme() {
        this.Content.clearme();
    }

    public void showme(boolean vis) {
        if (vis) {
            this.setVisible(true);
            this.fixWindowsPosition();
        } else {
            this.setVisible(false);
        }
    }

    public void fixWindowsPosition() {
        if (!this.isVisible()) {
            return;
        }
        ArrayList wins = JMacrosTools.AllJZFs;
        for (int i = 0; i < wins.size(); ++i) {
            JZirkelFrame jzf = (JZirkelFrame)wins.get(i);
            if (jzf.getSize().height > JGlobals.SCREEN.height - Bheight - 2) {
                jzf.ResizeAll(jzf.getSize().width, JGlobals.SCREEN.height - Bheight - 2);
            }
            if (Docky == HAUT) {
                if (jzf.getLocation().y >= By + Bheight + 2) continue;
                jzf.setLocation(jzf.getLocation().x, By + Bheight + 2);
                continue;
            }
            if (jzf.getLocation().y + jzf.getSize().height <= By) continue;
            jzf.setLocation(jzf.getLocation().x, By - jzf.getSize().height - 1);
        }
        this.toFront();
        JMacrosTools.CurrentJZF.toFront();
        JMacrosTools.CurrentJZF.JPM.MainPalette.FollowWindow();
    }

    public void setObject(ConstructionObject O, boolean forcevisible, boolean forcefocus) {
        if (forcevisible) {
            this.showme(true);
        }
        if (!this.isVisible() && !forcefocus) {
            return;
        }
        this.Content.setObject(O, forcevisible, forcefocus);
    }

    public void setObject(JCanvasPanel jcp) {
        this.showme(true);
        this.Content.setObject(jcp);
    }

    private static void fixsize(JComponent cp, int w, int h) {
        Dimension d2 = new Dimension(w, h);
        cp.setMaximumSize(d2);
        cp.setMinimumSize(d2);
        cp.setPreferredSize(d2);
        cp.setSize(d2);
    }

    public void mouseDragged(MouseEvent me) {
        this.location = this.getLocation(this.location);
        int x = this.location.x - this.pressed.getX() + me.getX();
        int y = this.location.y - this.pressed.getY() + me.getY();
        if (y < JGlobals.SCREEN.height / 2) {
            Docky = HAUT;
            y = JGlobals.SCREEN.y;
        } else {
            Docky = BAS;
            y = JGlobals.SCREEN.y + JGlobals.SCREEN.height - Bheight;
        }
        if (x < JGlobals.SCREEN.x + 20) {
            x = JGlobals.SCREEN.x;
        }
        if (x + Bwidth > JGlobals.SCREEN.x + JGlobals.SCREEN.width - 20) {
            x = JGlobals.SCREEN.x + JGlobals.SCREEN.width - Bwidth;
        }
        this.setLocation(x, y);
        Toolkit.getDefaultToolkit().sync();
    }

    public void mousePressed(MouseEvent me) {
        this.pressed = me;
    }

    public void mouseMoved(MouseEvent e2) {
    }

    public void mouseReleased(MouseEvent e2) {
        this.location = this.getLocation();
        int oldDocky = Docky;
        if (this.location.y < JGlobals.SCREEN.height / 2) {
            Docky = HAUT;
            this.setLocation(this.location.x, JGlobals.SCREEN.y);
        } else {
            Docky = BAS;
            this.setLocation(this.location.x, JGlobals.SCREEN.y + JGlobals.SCREEN.height - Bheight);
        }
        Global.setParameter("props.paletteX", this.getLocation().x);
        Global.setParameter("props.dockY", Docky);
        Bx = this.getLocation().x;
        By = this.getLocation().y;
        this.fixWindowsPosition();
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    private class CPane
    extends JPanel {
        public CPane() {
            this.setLayout(new BoxLayout(this, 0));
            this.setOpaque(false);
            this.setBorder(BorderFactory.createLineBorder(new Color(80, 80, 80), 1));
        }
    }

    private class TitleBar
    extends JPanel {
        ImageIcon closeimg = new ImageIcon(this.getClass().getResource("gui/Pclose.png"));
        ImageIcon closeoverimg = new ImageIcon(this.getClass().getResource("gui/Pcloseover.png"));
        ImageIcon myicon = new ImageIcon(this.getClass().getResource("gui/titlebar.png"));
        JButton closebtn;
        JPropertiesBar Mother;

        public void paintComponent(Graphics g) {
            Dimension d2 = this.getSize();
            g.drawImage(this.myicon.getImage(), 0, 0, d2.width, d2.height, this);
            super.paintComponent(g);
        }

        public TitleBar(JPropertiesBar parent, int width) {
            this.Mother = parent;
            this.setLayout(new BoxLayout(this, 1));
            this.setOpaque(false);
            JPropertiesBar.fixsize(this, width, Bheight);
            this.addMouseListener(parent);
            this.addMouseMotionListener(parent);
            this.closebtn = new JButton(this.closeimg);
            this.closebtn.setRolloverIcon(this.closeoverimg);
            this.closebtn.setBorder(BorderFactory.createEmptyBorder());
            this.closebtn.setOpaque(false);
            this.closebtn.setContentAreaFilled(false);
            this.closebtn.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e2) {
                    TitleBar.this.Mother.setVisible(false);
                }
            });
            this.add(this.closebtn);
        }
    }
}

