/*
 * Decompiled with CFR 0.152.
 */
package eric;

import eric.JGlobals;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.ZirkelFrame;

public class ZirkelCanvasFileChooserPreview
extends JPanel
implements PropertyChangeListener {
    static String previewString = JGlobals.Loc("opendialog.preview");
    File file = null;
    ZirkelCanvas CurrentZC = null;
    int w = 250;
    int h = 250;
    Image img = null;

    public void paint(Graphics g) {
        super.paint(g);
        if (this.img != null) {
            g.drawImage(this.img, 20, 25, this.w - 40, this.h - 40, this);
            g.drawRect(20, 25, this.w - 40, this.h - 40);
        }
    }

    public ZirkelCanvasFileChooserPreview(JFileChooser fc) {
        ZirkelCanvasFileChooserPreview.fixsize(this, this.w, this.h);
        fc.addPropertyChangeListener(this);
        this.setBorder(BorderFactory.createTitledBorder(previewString));
    }

    private static void fixsize(JComponent cp, int w, int h) {
        Dimension d2 = new Dimension(w, h);
        cp.setMaximumSize(d2);
        cp.setMinimumSize(d2);
        cp.setPreferredSize(d2);
        cp.setSize(d2);
    }

    public void loadConstruction() {
        ZirkelCanvas zc;
        this.CurrentZC = zc = new ZirkelCanvas(true, false, false);
        zc.setVisible(false);
        this.add(zc);
        try {
            InputStream o = new FileInputStream(this.file);
            if (ZirkelFrame.isCompressed(this.file.getPath())) {
                o = new GZIPInputStream(o);
            }
            zc.load(o);
            ((InputStream)o).close();
            if (!this.isShowing()) {
                return;
            }
            if (!this.CurrentZC.equals(zc)) {
                return;
            }
            int zcW = zc.getPreferredSize().width;
            int zcH = zc.getPreferredSize().height;
            if (zcW == 0) {
                zcW = 1;
            }
            if (zcH == 0) {
                zcH = 1;
            }
            ZirkelCanvasFileChooserPreview.fixsize(zc, zcH, zcW);
            this.img = new BufferedImage(zcW, zcH, 1);
            Graphics g2 = this.img.getGraphics();
            zc.paint(g2);
            this.img = this.img.getScaledInstance(this.w - 40, this.h - 40, 4);
        }
        catch (Exception e2) {
            this.img = null;
        }
        this.repaint();
    }

    public void propertyChange(PropertyChangeEvent e2) {
        boolean update = false;
        String prop = e2.getPropertyName();
        this.img = null;
        this.removeAll();
        this.revalidate();
        this.paintImmediately(0, 0, this.w, this.h);
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = false;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e2.getNewValue();
            if (this.file != null) {
                update = !this.file.isDirectory();
            }
        }
        if (update && this.isShowing()) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    ZirkelCanvasFileChooserPreview.this.loadConstruction();
                }
            });
            thread.start();
        }
    }
}

