/*
 * Decompiled with CFR 0.152.
 */
package eric;

import eric.ImageFilter;
import eric.JBrowserLauncher;
import eric.JGeneralMenuBar;
import eric.JGlobals;
import eric.JLocalPreferences;
import eric.JMacrosTools;
import eric.JPaletteManager;
import eric.JPointName;
import eric.JStatusBar;
import eric.JZirkelChanges;
import eric.JZirkelFrameContent;
import eric.JZirkelTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import rene.dialogs.ExportPictureDlg;
import rene.gui.Global;
import rene.util.ImageSelection;
import rene.util.PngEncoder;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.graphics.MyGraphicsEPS;
import rene.zirkel.graphics.MyGraphicsSvg;
import rene.zirkel.macro.Macro;
import rene.zirkel.macro.MacroItem;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.TextObject;

public class JZirkelFrame
extends JFrame
implements KeyListener,
WindowListener,
MouseListener,
MouseMotionListener {
    public ZirkelFrame ZF = new ZirkelFrame(false);
    public boolean is3D = false;
    JZirkelFrame MW;
    JZirkelTheme JZT = new JZirkelTheme();
    JLocalPreferences JPR;
    JPanel Content;
    JTitleBar TitleBar;
    JStatusBar StatusBar;
    JGeneralMenuBar GeneralMenuBar;
    JZirkelFrameContent ZContent;
    public JPaletteManager JPM;
    boolean restricted = false;
    public boolean restrictedSession = false;
    boolean EditRestricted = false;
    ResourceBundle Strs;
    Runnable doactualisemacrostree;
    JZirkelChanges ZChanges;
    int Wwidth = 800;
    int Pwidth = 194;
    int Wheight = 600;
    public boolean busy = false;
    private int changeX;
    private int changeY;
    private MouseEvent pressed;
    private Point location;
    public JPointName PointLabel;

    public JZirkelFrame(boolean with3D) {
        this.MW = this;
        this.is3D = with3D;
        this.Pwidth = this.IconSize() * 6;
        this.PointLabel = new JPointName(this);
        PointObject.setPointLabel(this.PointLabel);
        this.addWindowListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.ZF.ZC.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (Global.getParameter("smartboard", false)) {
                    return;
                }
                String s = JZirkelFrame.this.PointLabel.getBetterName(null, true);
            }

            public void mouseReleased(MouseEvent evt) {
                if (!Global.getParameter("smartboard", false)) {
                    return;
                }
                String s = JZirkelFrame.this.PointLabel.getBetterName(null, true);
            }
        });
        this.ZF.ZC.getConstruction();
        this.JPR = new JLocalPreferences(this);
        this.doactualisemacrostree = new Runnable(){

            public void run() {
                if (!JZirkelFrame.this.ZF.isEnabled() || JZirkelFrame.this.busy) {
                    SwingUtilities.invokeLater(JZirkelFrame.this.doactualisemacrostree);
                } else {
                    JZirkelFrame.this.SetTitle(JZirkelFrame.this.ZF.getTitle());
                    JZirkelFrame.this.ZContent.macros.myJML.initMacrosTree();
                    JZirkelFrame.this.JPM.setSelected("grid", JZirkelFrame.this.ZF.ZC.showGrid());
                    JZirkelFrame.this.JPM.setSelected("hidden", false);
                    Global.setParameter("grid.colorindex", JZirkelFrame.this.ZF.ZC.GridColor);
                    Global.setParameter("grid.thickness", JZirkelFrame.this.ZF.ZC.GridThickness);
                    Global.setParameter("grid.labels", JZirkelFrame.this.ZF.ZC.GridLabels);
                    Global.setParameter("grid.axesonly", JZirkelFrame.this.ZF.ZC.AxesOnly);
                    JZirkelFrame.this.JPM.setSelected("acolor" + Global.getParameter("grid.colorindex", 0), true);
                    JZirkelFrame.this.JPM.setSelected("athickness" + Global.getParameter("grid.thickness", 0), true);
                    JZirkelFrame.this.JPM.setSelected("numgrid", Global.getParameter("grid.labels", false));
                    JZirkelFrame.this.JPM.setSelected("dottedgrid", Global.getParameter("grid.axesonly", false));
                    JZirkelFrame.this.JPM.setSelected("partial", false);
                    JZirkelFrame.this.JPM.setSelected("plines", false);
                    JZirkelFrame.this.JPM.setSelected("showvalue", false);
                    if (JZirkelFrame.this.ZF.ZC.getConstruction().BackgroundFile == null) {
                        JZirkelFrame.this.JPM.setSelected("background", false);
                    } else {
                        JZirkelFrame.this.JPM.setSelectedWithoutClic("background", true);
                    }
                    JZirkelFrame.this.ZChanges.CLength = 0;
                    JZirkelFrame.this.JPM.MainPalette.FollowWindow();
                }
            }
        };
        String lang = Global.getParameter("language", "");
        String country = Global.getParameter("country", "");
        if (!lang.equals("")) {
            try {
                JGlobals.changeGlobalFont(lang);
                Locale.setDefault(new Locale(lang, country));
            }
            catch (Exception ex) {
                Locale.setDefault(new Locale("en", ""));
                Global.setParameter("language", "en");
                Global.setParameter("country", "");
            }
        }
        this.Strs = ResourceBundle.getBundle("eric/docs/JZirkelProperties");
        this.JZT.setTheme(Global.getParameter("LookAndFeel", "gray"));
        this.setDefaultCloseOperation(0);
        this.setTitle("CaR");
        this.setBackground(new Color(240, 240, 240));
        this.setUndecorated(true);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle dim = ge.getMaximumWindowBounds();
        int w = dim.width - this.Pwidth - 10;
        int h = dim.height - 4;
        this.Wwidth = this.Wwidth > w ? w : this.Wwidth;
        this.Wheight = this.Wheight > h ? h : this.Wheight;
        this.setLocation((dim.width - this.Wwidth - this.Pwidth) / 2, (dim.height - this.Wheight) / 2);
        this.ZF.setLocation((dim.width - this.Wwidth - this.Pwidth) / 2, (dim.height - this.Wheight) / 2);
        this.Content = new JPaletteContainer();
        this.setContentPane(this.Content);
        this.TitleBar = new JTitleBar();
        this.Content.add(this.TitleBar);
        this.StatusBar = new JStatusBar(this.ZF, this);
        this.GeneralMenuBar = new JGeneralMenuBar(this.ZF, this);
        this.Content.add(this.GeneralMenuBar);
        this.ZContent = new JZirkelFrameContent(this.ZF, this);
        this.Content.add(this.ZContent);
        this.Content.add(this.StatusBar);
        this.ResizeAll();
        this.setVisible(false);
        this.pack();
        JGlobals.setRestrictedIcons(Global.getParameter("restrictedicons", JGlobals.DefaultIcons));
        this.JPM = new JPaletteManager(this.ZF, this, this.IconSize());
        this.GeneralMenuBar.InitObjectsMenu();
        this.ZF.ZC.addKeyListener(this);
        this.ZF.ZC.CDP.setVisible(false);
        this.ZChanges = new JZirkelChanges(this.ZF, this);
    }

    public String ToolTip(String s) {
        String ToolTipText = "";
        String purename = s.startsWith("bi_") ? s.substring(3) : s;
        try {
            ToolTipText = this.Strs.getString("palette.info." + purename);
        }
        catch (Exception e1) {
            try {
                ToolTipText = this.Strs.getString("palette.info." + s);
            }
            catch (Exception e2) {
                ToolTipText = Zirkel.name("iconhelp." + purename);
            }
        }
        return ToolTipText;
    }

    public String FilteredStatus(String status) {
        String newstatus = status;
        int index = status.indexOf("@builtin@/syma");
        if (index > 0) {
            newstatus = newstatus.substring(index);
            newstatus = newstatus.replaceAll("\\Q@builtin@/syma\\E", this.Loc("palette.info.bi_syma"));
        } else {
            index = status.indexOf("@builtin@/symc");
            if (index > 0) {
                newstatus = newstatus.substring(index);
                newstatus = newstatus.replaceAll("\\Q@builtin@/symc\\E", this.Loc("palette.info.bi_symc"));
            } else {
                index = status.indexOf("@builtin@/trans");
                if (index > 0) {
                    newstatus = newstatus.substring(index);
                    newstatus = newstatus.replaceAll("\\Q@builtin@/trans\\E", this.Loc("palette.info.bi_trans"));
                } else {
                    index = status.indexOf("@builtin@/med");
                    if (index > 0) {
                        newstatus = newstatus.substring(index);
                        newstatus = newstatus.replaceAll("\\Q@builtin@/med\\E", this.Loc("palette.info.bi_med"));
                    } else {
                        index = status.indexOf("@builtin@/biss");
                        if (index > 0) {
                            newstatus = newstatus.substring(index);
                            newstatus = newstatus.replaceAll("\\Q@builtin@/biss\\E", this.Loc("palette.info.bi_biss"));
                        } else {
                            index = status.indexOf("@builtin@/circ");
                            if (index > 0) {
                                newstatus = newstatus.substring(index);
                                newstatus = newstatus.replaceAll("\\Q@builtin@/circ\\E", this.Loc("palette.info.bi_circ"));
                            } else {
                                index = status.indexOf("@builtin@/arc");
                                if (index > 0) {
                                    newstatus = newstatus.substring(index);
                                    newstatus = newstatus.replaceAll("\\Q@builtin@/arc\\E", this.Loc("palette.info.bi_arc"));
                                } else {
                                    index = status.indexOf("@builtin@/function_u");
                                    if (index > 0) {
                                        newstatus = newstatus.substring(index);
                                        newstatus = newstatus.replaceAll("\\Q@builtin@/function_u\\E", this.ToolTip("bi_function_u"));
                                    } else {
                                        index = status.indexOf("@builtin@/t_align");
                                        if (index > 0) {
                                            newstatus = newstatus.substring(index);
                                            newstatus = newstatus.replaceAll("\\Q@builtin@/t_align\\E", this.Loc("palette.info.bi_t_align"));
                                        } else {
                                            index = status.indexOf("@builtin@/t_para");
                                            if (index > 0) {
                                                newstatus = newstatus.substring(index);
                                                newstatus = newstatus.replaceAll("\\Q@builtin@/t_para\\E", this.Loc("palette.info.bi_t_para"));
                                            } else {
                                                index = status.indexOf("@builtin@/t_perp");
                                                if (index > 0) {
                                                    newstatus = newstatus.substring(index);
                                                    newstatus = newstatus.replaceAll("\\Q@builtin@/t_perp\\E", this.Loc("palette.info.bi_t_perp"));
                                                } else {
                                                    index = status.indexOf("@builtin@/t_equi");
                                                    if (index > 0) {
                                                        newstatus = newstatus.substring(index);
                                                        newstatus = newstatus.replaceAll("\\Q@builtin@/t_equi\\E", this.Loc("palette.info.bi_t_equi"));
                                                    } else {
                                                        index = status.indexOf("@builtin@/t_app");
                                                        if (index > 0) {
                                                            newstatus = newstatus.substring(index);
                                                            newstatus = newstatus.replaceAll("\\Q@builtin@/t_app\\E", this.Loc("palette.info.bi_t_app"));
                                                        } else {
                                                            index = status.indexOf("@builtin@/t_conf");
                                                            if (index > 0) {
                                                                newstatus = newstatus.substring(index);
                                                                newstatus = newstatus.replaceAll("\\Q@builtin@/t_conf\\E", this.Loc("palette.info.bi_t_conf"));
                                                            } else {
                                                                index = status.indexOf("@builtin@/3Dcoords");
                                                                if (index > 0) {
                                                                    newstatus = newstatus.substring(index);
                                                                    newstatus = newstatus.replaceAll("\\Q@builtin@/3Dcoords\\E", this.Loc("palette.info.bi_3Dcoords"));
                                                                } else {
                                                                    index = status.indexOf("@builtin@/3Dcube");
                                                                    if (index > 0) {
                                                                        newstatus = newstatus.substring(index);
                                                                        newstatus = newstatus.replaceAll("\\Q@builtin@/3Dcube\\E", this.Loc("palette.info.bi_3Dcube"));
                                                                    } else {
                                                                        index = status.indexOf("@builtin@/3Darete");
                                                                        if (index > 0) {
                                                                            newstatus = newstatus.substring(index);
                                                                            newstatus = newstatus.replaceAll("\\Q@builtin@/3Darete\\E", this.Loc("palette.info.bi_3Darete"));
                                                                        } else {
                                                                            index = status.indexOf("@builtin@/3Dtetra");
                                                                            if (index > 0) {
                                                                                newstatus = newstatus.substring(index);
                                                                                newstatus = newstatus.replaceAll("\\Q@builtin@/3Dtetra\\E", this.Loc("palette.info.bi_3Dtetra"));
                                                                            } else {
                                                                                index = status.indexOf("@builtin@/3Ddode");
                                                                                if (index > 0) {
                                                                                    newstatus = newstatus.substring(index);
                                                                                    newstatus = newstatus.replaceAll("\\Q@builtin@/3Ddode\\E", this.Loc("palette.info.bi_3Ddode"));
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return newstatus;
    }

    public int IconSize() {
        int icsize = 32;
        switch (Global.getParameter("options.iconsize", 1)) {
            case 0: {
                icsize = 32;
                break;
            }
            case 1: {
                icsize = 28;
                break;
            }
            case 2: {
                icsize = 24;
            }
        }
        return icsize;
    }

    private void fixsize(JComponent cp, Dimension d2) {
        cp.setMaximumSize(d2);
        cp.setMinimumSize(d2);
        cp.setPreferredSize(d2);
        cp.setSize(d2);
    }

    public void ResizeAll() {
        this.ResizeAll(this.Wwidth, this.Wheight);
    }

    public void ResizeAll(int w, int h) {
        if (h > 180 && w > 100) {
            this.Wwidth = w;
            this.Wheight = h;
            int LeftPanelWidth = this.ZContent.leftpanel == null ? 0 : this.ZContent.leftpanelwidth;
            int ZContentHeight = h - this.JZT.TitleBarHeight - this.JZT.MenuBarHeight - this.JZT.StatusHeight;
            int ZContentWidth = w - 2 * this.JZT.VertBorderWidth;
            int ZContentCenterWidth = ZContentWidth - LeftPanelWidth;
            double ZCCH = (double)ZContentCenterWidth / (double)ZContentWidth * (double)ZContentHeight;
            int ZContentCenterHeight = (int)Math.round(ZCCH);
            int ZContentCenterBorderHeight = (ZContentHeight - ZContentCenterHeight) / 2;
            int MacroPanelHeight = this.ZContent.macros.myJML.createmacropanel.visible ? 66 : 0;
            ZContentCenterHeight = ZContentHeight - 2 * ZContentCenterBorderHeight;
            this.fixsize(this.TitleBar, new Dimension(w, this.JZT.TitleBarHeight));
            this.fixsize(this.TitleBar.buttons, new Dimension(60, this.JZT.TitleBarTextHeight));
            int t = this.TitleBar.titlepixelwidth();
            int spacerw = 0;
            if (System.getProperty("mrj.version") != null && this.JZT.AllowMacLook()) {
                spacerw = Math.max(0, (w - t - 132) / 2);
                this.fixsize(this.TitleBar.macosspacer, new Dimension(6, this.JZT.TitleBarHeight));
                this.fixsize(this.TitleBar.titlespacer, new Dimension(spacerw, this.JZT.TitleBarHeight));
            } else {
                spacerw = t + 66 > w ? 0 : Math.min(w - t - 66, (w - t) / 2);
                this.fixsize(this.TitleBar.titlespacer, new Dimension(spacerw, this.JZT.TitleBarHeight));
            }
            this.fixsize(this.TitleBar.windowtitle, new Dimension(w - spacerw - 66, this.JZT.TitleBarTextHeight));
            this.fixsize(this.StatusBar, new Dimension(w, this.JZT.StatusHeight));
            this.fixsize(this.StatusBar.status, new Dimension(w - 50, this.JZT.StatusHeight - 4));
            this.fixsize(this.GeneralMenuBar, new Dimension(w, this.JZT.MenuBarHeight));
            this.fixsize(this.ZContent, new Dimension(w, ZContentHeight));
            this.fixsize(this.ZContent.left, new Dimension(this.JZT.VertBorderWidth, ZContentHeight));
            this.ZContent.history.setVisible(false);
            this.ZContent.macros.setVisible(false);
            this.ZContent.help.setVisible(false);
            if (this.ZContent.leftpanel != null) {
                if (!this.ZContent.leftpanel.isVisible()) {
                    this.ZContent.leftpanel.setVisible(true);
                }
                this.fixsize(this.ZContent.leftpanel, new Dimension(LeftPanelWidth, ZContentHeight));
                this.fixsize(this.ZContent.leftpanel.vertseparator, new Dimension(this.JZT.VertSeparatorWidth, ZContentHeight));
                this.fixsize(this.ZContent.leftpanel.title, new Dimension(LeftPanelWidth - this.JZT.VertSeparatorWidth, this.JZT.LeftPanelTitleHeight));
                this.fixsize(this.ZContent.leftpanel.wholecontent, new Dimension(LeftPanelWidth - this.JZT.VertSeparatorWidth, ZContentHeight));
                this.fixsize(this.ZContent.leftpanel.content, new Dimension(LeftPanelWidth - this.JZT.VertSeparatorWidth, ZContentHeight - this.JZT.LeftPanelTitleHeight));
                if (this.ZContent.history.isVisible()) {
                    this.ZF.ZC.CDP.setSize(new Dimension(LeftPanelWidth - this.JZT.VertSeparatorWidth, ZContentHeight));
                    this.ZF.ZC.CDP.validate();
                }
                if (this.ZContent.help.isVisible()) {
                    this.fixsize((JComponent)this.ZContent.help.content.getComponent(0), new Dimension(LeftPanelWidth - this.JZT.VertSeparatorWidth, ZContentHeight - this.JZT.LeftPanelTitleHeight - 7));
                }
                if (this.ZContent.macros.isVisible()) {
                    this.fixsize(this.ZContent.macros.myJML.controls, new Dimension(LeftPanelWidth - this.JZT.VertSeparatorWidth, 22));
                    this.fixsize(this.ZContent.macros.myJML.createmacropanel, new Dimension(LeftPanelWidth - this.JZT.VertSeparatorWidth, MacroPanelHeight));
                }
            }
            this.fixsize(this.ZContent.right, new Dimension(this.JZT.VertBorderWidth, ZContentHeight));
            this.fixsize(this.ZContent.center, new Dimension(ZContentCenterWidth, ZContentHeight));
            Dimension dzcenterfigure = new Dimension(ZContentCenterWidth, ZContentCenterHeight);
            this.fixsize(this.ZContent.center.figure, dzcenterfigure);
            this.fixsize(this.ZF.ZC, dzcenterfigure);
            this.ZF.ZC.UseSize = dzcenterfigure;
            Dimension dzcenterborder = new Dimension(ZContentCenterWidth, ZContentCenterBorderHeight);
            this.fixsize(this.ZContent.center.b1, dzcenterborder);
            this.fixsize(this.ZContent.center.b2, dzcenterborder);
            this.setSize(w, h);
        }
    }

    public void SetTitle(String newtitle) {
        FontMetrics fm = this.getFontMetrics(new Font(JGlobals.GlobalFont, 0, JGlobals.MenuTextSize));
        int t = fm.stringWidth(newtitle);
        int w = this.getSize().width;
        int spacerw = 0;
        if (System.getProperty("mrj.version") != null) {
            spacerw = Math.max(0, (w - t - 132) / 2);
            this.fixsize(this.TitleBar.macosspacer, new Dimension(6, this.JZT.TitleBarHeight));
            this.fixsize(this.TitleBar.titlespacer, new Dimension(spacerw, this.JZT.TitleBarHeight));
        } else {
            spacerw = t + 66 > w ? 0 : Math.min(w - t - 66, (w - t) / 2);
            this.fixsize(this.TitleBar.titlespacer, new Dimension(spacerw, this.JZT.TitleBarHeight));
        }
        this.fixsize(this.TitleBar.windowtitle, new Dimension(w - spacerw - 66, this.JZT.TitleBarTextHeight));
        this.TitleBar.windowtitle.setText(newtitle);
        this.TitleBar.validate();
        this.TitleBar.repaint();
        this.setTitle(newtitle);
    }

    private String Loc(String s) {
        return this.Strs.getString(s);
    }

    public void runmacro(String macroname) {
        Vector mc = this.ZF.ZC.getMacros();
        for (int i = 0; i < mc.size(); ++i) {
            TextObject t;
            Macro m = ((MacroItem)mc.elementAt((int)i)).M;
            if (!m.getName().equals(macroname)) continue;
            if (m.getName().equals("@builtin@/syma")) {
                m.Prompts[0] = this.Loc("macro.bi_syma.0");
                m.Prompts[1] = this.Loc("macro.bi_syma.1");
            } else if (m.getName().equals("@builtin@/symc")) {
                m.Prompts[0] = this.Loc("macro.bi_symc.0");
                m.Prompts[1] = this.Loc("macro.bi_symc.1");
            } else if (m.getName().equals("@builtin@/trans")) {
                m.Prompts[0] = this.Loc("macro.bi_trans.0");
                m.Prompts[1] = this.Loc("macro.bi_trans.1");
                m.Prompts[2] = this.Loc("macro.bi_trans.2");
            } else if (m.getName().equals("@builtin@/med")) {
                m.Prompts[0] = this.Loc("macro.bi_med.0");
                m.Prompts[1] = this.Loc("macro.bi_med.1");
            } else if (m.getName().equals("@builtin@/biss")) {
                m.Prompts[0] = this.Loc("macro.bi_biss.0");
                m.Prompts[1] = this.Loc("macro.bi_biss.1");
                m.Prompts[2] = this.Loc("macro.bi_biss.2");
            } else if (m.getName().equals("@builtin@/circ")) {
                m.Prompts[0] = this.Loc("macro.bi_circ.0");
                m.Prompts[1] = this.Loc("macro.bi_circ.1");
                m.Prompts[2] = this.Loc("macro.bi_circ.2");
            } else if (m.getName().equals("@builtin@/arc")) {
                m.Prompts[0] = this.Loc("macro.bi_circ.0");
                m.Prompts[1] = this.Loc("macro.bi_circ.1");
                m.Prompts[2] = this.Loc("macro.bi_circ.2");
            } else if (m.getName().equals("@builtin@/function_u")) {
                m.Prompts[0] = this.Loc("macro.bi_expression.0");
            } else if (m.getName().equals("@builtin@/t_align")) {
                m.Prompts[0] = this.Loc("macro.bi_circ.0");
                m.Prompts[1] = this.Loc("macro.bi_circ.1");
                m.Prompts[2] = this.Loc("macro.bi_circ.2");
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 1);
                t.setLines(this.Loc("macro.bi_t_align.text1"));
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 2);
                t.setLines(this.Loc("macro.bi_t_align.text0"));
            } else if (m.getName().equals("@builtin@/t_para")) {
                m.Prompts[0] = this.Loc("macro.bi_t_para.0");
                m.Prompts[1] = this.Loc("macro.bi_t_para.1");
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 1);
                t.setLines(this.Loc("macro.bi_t_para.text0"));
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 2);
                t.setLines(this.Loc("macro.bi_t_para.text1"));
            } else if (m.getName().equals("@builtin@/t_perp")) {
                m.Prompts[0] = this.Loc("macro.bi_t_para.0");
                m.Prompts[1] = this.Loc("macro.bi_t_para.1");
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 1);
                t.setLines(this.Loc("macro.bi_t_perp.text1"));
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 2);
                t.setLines(this.Loc("macro.bi_t_perp.text0"));
            } else if (m.getName().equals("@builtin@/t_equi")) {
                m.Prompts[0] = this.Loc("macro.bi_t_equi.0");
                m.Prompts[1] = this.Loc("macro.bi_t_equi.1");
                m.Prompts[2] = this.Loc("macro.bi_t_equi.2");
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 1);
                t.setLines(this.Loc("macro.bi_t_equi.text0"));
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 2);
                t.setLines(this.Loc("macro.bi_t_equi.text1"));
            } else if (m.getName().equals("@builtin@/t_app")) {
                m.Prompts[0] = this.Loc("macro.bi_t_app.0");
                m.Prompts[1] = this.Loc("macro.bi_t_app.1");
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 1);
                t.setLines(this.Loc("macro.bi_t_app.text1"));
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 2);
                t.setLines(this.Loc("macro.bi_t_app.text0"));
            } else if (m.getName().equals("@builtin@/t_conf")) {
                m.Prompts[0] = this.Loc("macro.bi_t_conf.0");
                m.Prompts[1] = this.Loc("macro.bi_t_conf.1");
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 1);
                t.setLines(this.Loc("macro.bi_t_conf.text1"));
                t = (TextObject)m.getTargets().get(m.getTargets().size() - 2);
                t.setLines(this.Loc("macro.bi_t_conf.text0"));
            } else if (m.getName().equals("@builtin@/3Dcoords")) {
                m.Prompts[4] = this.Loc("macro.bi_3Dcoords.0");
            } else if (m.getName().equals("@builtin@/3Dcube")) {
                m.Prompts[4] = this.Loc("macro.bi_3Dcube.0");
            } else if (m.getName().equals("@builtin@/3Darete")) {
                m.Prompts[0] = this.Loc("macro.bi_3Darete.0");
                m.Prompts[1] = this.Loc("macro.bi_3Darete.1");
                m.Prompts[2] = this.Loc("macro.bi_3Darete.2");
                m.Prompts[3] = this.Loc("macro.bi_3Darete.3");
            } else if (m.getName().equals("@builtin@/3Dtetra")) {
                m.Prompts[4] = this.Loc("macro.bi_3Dtetra.0");
            } else if (m.getName().equals("@builtin@/3Ddode")) {
                m.Prompts[4] = this.Loc("macro.bi_3Ddode.0");
            }
            this.ZF.runMacro(m);
        }
    }

    public void SaveJarAndLaunchBrowser(String targetpath, String targetfile) {
        String sep = System.getProperty("file.separator");
        String mypath = JGlobals.AppPath();
        if (new File(mypath + "CaRMetal.jar").exists()) {
            try {
                int len;
                FileInputStream in = new FileInputStream(mypath + "CaRMetal.jar");
                FileOutputStream out = new FileOutputStream(targetpath + sep + "CaRMetal.jar");
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                    out.flush();
                }
                ((OutputStream)out).close();
                ((InputStream)in).close();
                JBrowserLauncher.openURL(targetpath + sep + targetfile);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void SaveSlideShow() {
        this.ZContent.macros.myJML.MacrosTree.nodepopup.MakeSlideShow();
    }

    public void savefile() {
        this.ZContent.macros.myJML.MacrosTree.nodepopup.savefile();
    }

    public void savefileas() {
        if (!this.restrictedSession && this.restricted) {
            this.setRestrictedView(false);
        }
        this.ZContent.macros.myJML.MacrosTree.nodepopup.savefileas();
    }

    public void setRestrictedView(boolean on) {
        this.restricted = on;
        if (!on) {
            this.GeneralMenuBar.editpaletteitem.setSelected(false);
            this.EditRestricted = false;
        }
        this.GeneralMenuBar.restrictpaletteitem.setSelected(on);
        this.GeneralMenuBar.editpaletteitem.setEnabled(on);
        JGlobals.setRestrictedIcons(Global.getParameter("restrictedicons", JGlobals.DefaultIcons));
        this.JPM.dispose();
        this.JPM = null;
        this.JPM = new JPaletteManager(this.ZF, this, this.IconSize());
        this.JPM.MainPalette.setVisible(true);
    }

    public void saveSVG() {
        int Scale = 1;
        int w = this.ZF.ZC.getSize().width * Scale;
        int h = this.ZF.ZC.getSize().height * Scale;
        this.ZF.ZC.PointSize = Global.getParameter("minpointsize", 3) * Scale;
        this.ZF.ZC.FontSize = Global.getParameter("minfontsize", 12) * Scale;
        this.ZF.ZC.IW = w;
        this.ZF.ZC.IH = h;
        this.ZF.ZC.recompute();
        FileSystemView vueSysteme = FileSystemView.getFileSystemView();
        File def = vueSysteme.getHomeDirectory();
        File desk = vueSysteme.getChild(def, "Desktop");
        File choice = desk == null ? def : desk;
        JFileChooser jfc = new JFileChooser(choice);
        jfc.setDialogType(1);
        jfc.setApproveButtonText("Export to SVG");
        jfc.setAcceptAllFileFilterUsed(false);
        jfc.addChoosableFileFilter(new ImageFilter());
        int rep = jfc.showSaveDialog(null);
        if (rep == 0) {
            File outputfile = jfc.getSelectedFile();
            String filename = outputfile.getAbsolutePath();
            String ext = outputfile.getAbsolutePath().endsWith(".svg") ? "" : ".svg";
            try {
                OutputStream o = new FileOutputStream(filename + ext);
                if (ZirkelFrame.isCompressed(filename)) {
                    o = new GZIPOutputStream(o);
                }
                PrintWriter out = new PrintWriter(new OutputStreamWriter(o, "UTF8"));
                MyGraphicsSvg svg = new MyGraphicsSvg(out, w, h);
                svg.setSize(w, h);
                svg.setDefaultFont((int)this.ZF.ZC.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
                this.ZF.ZC.dopaint(svg);
                svg.close();
                out.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    public void saveeps() {
        int Scale = 1;
        int w = this.ZF.ZC.getSize().width * Scale;
        int h = this.ZF.ZC.getSize().height * Scale;
        this.ZF.ZC.PointSize = Global.getParameter("minpointsize", 3) * Scale;
        this.ZF.ZC.FontSize = Global.getParameter("minfontsize", 12) * Scale;
        this.ZF.ZC.IW = w;
        this.ZF.ZC.IH = h;
        this.ZF.ZC.recompute();
        FileSystemView vueSysteme = FileSystemView.getFileSystemView();
        File def = vueSysteme.getHomeDirectory();
        File desk = vueSysteme.getChild(def, "Desktop");
        File choice = desk == null ? def : desk;
        JFileChooser jfc = new JFileChooser(choice);
        jfc.setDialogType(1);
        jfc.setApproveButtonText("Export to EPS");
        jfc.setAcceptAllFileFilterUsed(false);
        jfc.addChoosableFileFilter(new ImageFilter());
        int rep = jfc.showSaveDialog(null);
        if (rep == 0) {
            File outputfile = jfc.getSelectedFile();
            String filename = outputfile.getAbsolutePath();
            String ext = outputfile.getAbsolutePath().endsWith(".eps") ? "" : ".eps";
            FileOutputStream o = null;
            try {
                o = new FileOutputStream(filename + ext);
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            try {
                MyGraphicsEPS eps = new MyGraphicsEPS(o, w, h);
                eps.setSize(w, h);
                eps.setLineWidth(Global.getParameter("minlinesize", 1));
                eps.setDefaultFont((int)this.ZF.ZC.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
                this.ZF.ZC.dopaint(eps);
                eps.close();
                ((OutputStream)o).close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void savepng(boolean issave) {
        if (issave) {
            ExportPictureDlg dlg = new ExportPictureDlg(this);
            dlg.setPictureWidth(this.ZF.ZC.getSize().width);
            dlg.setPictureHeight(this.ZF.ZC.getSize().height);
            dlg.setPercentScale(100);
            if (dlg.select()) {
                this.ZF.ZC.startWaiting();
                double Scale = (double)dlg.getPercentScale() / 100.0;
                int w = (int)((double)this.ZF.ZC.getSize().width * Scale);
                int h = (int)((double)this.ZF.ZC.getSize().height * Scale);
                this.ZF.ZC.PointSize = (int)((double)Global.getParameter("minpointsize", 3) * Scale);
                this.ZF.ZC.FontSize = (int)((double)Global.getParameter("minfontsize", 12) * Scale);
                this.ZF.ZC.IW = w;
                this.ZF.ZC.IH = h;
                Image I = this.createImage(w, h);
                MyGraphics13 IG = new MyGraphics13(I.getGraphics(), Scale, this.ZF.ZC, null);
                IG.setSize(w, h);
                IG.setDefaultFont((int)this.ZF.ZC.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
                this.ZF.ZC.recompute();
                IG.clearRect(0, 0, w, h, Color.white);
                this.ZF.ZC.dopaint(IG);
                this.ZF.ZC.endWaiting();
                int dpi = 300;
                try {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dlg.getFileName()));
                    PngEncoder png = new PngEncoder(I, false, 0, 9);
                    png.setDPI(dpi);
                    out.write(png.pngEncode());
                    out.close();
                }
                catch (Exception e2) {}
            }
        } else {
            this.ZF.ZC.startWaiting();
            int Scale = 3;
            int w = this.ZF.ZC.getSize().width * Scale;
            int h = this.ZF.ZC.getSize().height * Scale;
            this.ZF.ZC.PointSize = Global.getParameter("minpointsize", 3) * Scale;
            this.ZF.ZC.FontSize = Global.getParameter("minfontsize", 12) * Scale;
            this.ZF.ZC.IW = w;
            this.ZF.ZC.IH = h;
            Image I = this.createImage(w, h);
            MyGraphics13 IG = new MyGraphics13(I.getGraphics(), Scale, this.ZF.ZC, null);
            IG.setSize(w, h);
            IG.setDefaultFont((int)this.ZF.ZC.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            this.ZF.ZC.recompute();
            IG.clearRect(0, 0, w, h, Color.white);
            this.ZF.ZC.dopaint(IG);
            this.ZF.ZC.endWaiting();
            try {
                Clipboard clipboard = this.getToolkit().getSystemClipboard();
                ImageSelection is = new ImageSelection(I);
                clipboard.setContents(is, null);
            }
            catch (Exception e3) {
                Scale = 1;
                I = null;
                this.repaint();
                JOptionPane.showMessageDialog(null, "Sorry : error occured while copying...");
            }
        }
    }

    public void setLanguage(String lang, String country) {
        block2: {
            try {
                JGlobals.changeGlobalFont(lang);
                Global.setParameter("language", lang);
                Global.setParameter("country", country);
                Locale myloc = new Locale(lang, country);
                Locale.setDefault(myloc);
                this.Strs = ResourceBundle.getBundle("eric/docs/JZirkelProperties");
                Global.initBundle("rene/zirkel/docs/ZirkelProperties", true);
                JGlobals.CreatePopertiesBar();
                this.Content.remove(this.GeneralMenuBar);
                this.GeneralMenuBar = new JGeneralMenuBar(this.ZF, this);
                this.Content.add((Component)this.GeneralMenuBar, 1);
                this.ZContent.refreshlanguage();
                this.JPM.dispose();
                this.JPM = null;
                this.JPM = new JPaletteManager(this.ZF, this, this.IconSize());
                this.GeneralMenuBar.InitObjectsMenu();
                this.Content.revalidate();
                this.Content.repaint();
                this.ResizeAll();
                this.ZContent.macros.myJML.initMacrosTree();
                this.JPM.MainPalette.setVisible(true);
            }
            catch (Exception ex) {
                int rep = JOptionPane.showConfirmDialog(null, "Sorry, but the requested font is not installed for this language.\nThis language will not be selected.\n\nDo you want to download the necessary font ?", "Font not installed", 0);
                if (rep != 0) break block2;
                JBrowserLauncher.openURL(JGlobals.FontURL);
            }
        }
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void keyPressed(KeyEvent e2) {
        if (e2.getKeyCode() == 27) {
            this.JPM.setSelected("move", true);
        }
    }

    public void keyReleased(KeyEvent e2) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.JPM.MainPalette.setVisible(false);
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.toFront();
        if (!this.JPM.MainPalette.isVisible()) {
            this.JPM.MainPalette.setVisible(true);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (JMacrosTools.AllowWindowActivatedEvent) {
            JMacrosTools.setCurrentJZF(this);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void mouseDragged(MouseEvent me) {
        this.location = this.getLocation(this.location);
        int x = this.location.x - this.pressed.getX() + me.getX();
        int y = this.location.y - this.pressed.getY() + me.getY();
        this.setLocation(x, y);
        Toolkit.getDefaultToolkit().sync();
        this.JPM.MainPalette.FollowWindow();
    }

    public void mousePressed(MouseEvent me) {
        this.pressed = me;
    }

    public void mouseMoved(MouseEvent e2) {
    }

    public void mouseReleased(MouseEvent e2) {
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private class JPaletteContainer
    extends JPanel {
        public JPaletteContainer() {
            this.setLayout(new BoxLayout(this, 1));
        }
    }

    public class JTitleBar
    extends JPanel {
        JLabel windowtitle;
        JPanel titlespacer;
        JPanel macosspacer;
        JPanel buttons;
        Point origin = new Point();
        private int xw = -1;
        private int yw = -1;
        private JButton reducebtn;
        private JButton growbtn;
        private JButton closebtn;

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension d2 = this.getSize();
            g.drawImage(JZirkelFrame.this.JZT.getImage("titlebar.gif"), 0, 0, d2.width, d2.height, this);
            if (!JZirkelFrame.this.MW.equals(JMacrosTools.CurrentJZF)) {
                JZirkelFrame.this.JZT.setDisable(g, d2);
            }
        }

        public int titlepixelwidth() {
            FontMetrics fm = this.getFontMetrics(new Font(JGlobals.GlobalFont, 0, JGlobals.MenuTextSize));
            return fm.stringWidth(this.windowtitle.getText());
        }

        private void growboxtouched() {
            int w = JGlobals.SCREEN.width - JZirkelFrame.this.Pwidth - 5;
            int h = JGlobals.SCREEN.height - 4;
            if (JZirkelFrame.this.MW.getSize().width == w && JZirkelFrame.this.MW.getSize().height == h) {
                JZirkelFrame.this.MW.setLocation(this.xw, this.yw);
                JZirkelFrame.this.MW.ResizeAll(800, 600);
            } else {
                this.xw = JZirkelFrame.this.MW.getLocation().x;
                this.yw = JZirkelFrame.this.MW.getLocation().y;
                JZirkelFrame.this.MW.setLocation(JGlobals.SCREEN.x + 2, JGlobals.SCREEN.y + 2);
                JZirkelFrame.this.MW.ResizeAll(w, h);
            }
            JGlobals.JPB.fixWindowsPosition();
            JZirkelFrame.this.MW.pack();
            JZirkelFrame.this.MW.ZF.ZC.recompute();
            JZirkelFrame.this.MW.ZF.ZC.validate();
            JZirkelFrame.this.MW.ZF.ZC.repaint();
            JZirkelFrame.this.JPM.MainPalette.FollowWindow();
        }

        public void init() {
            this.removeAll();
            this.titlespacer = new JPanel();
            this.titlespacer.setOpaque(false);
            this.macosspacer = new JPanel();
            this.macosspacer.setOpaque(false);
            this.buttons = new JPanel();
            this.buttons.setLayout(new BoxLayout(this.buttons, 0));
            this.buttons.setOpaque(false);
            this.windowtitle = new JLabel(JZirkelFrame.this.ZF.getTitle());
            this.windowtitle.setFont(new Font(JGlobals.GlobalFont, 0, 12));
            this.windowtitle.setForeground(new Color(80, 80, 80));
            this.windowtitle.setHorizontalAlignment(2);
            this.reducebtn = new JButton();
            this.reducebtn.setBorder(BorderFactory.createEmptyBorder());
            this.reducebtn.setOpaque(false);
            this.reducebtn.setContentAreaFilled(false);
            this.reducebtn.setFocusable(false);
            this.reducebtn.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e2) {
                    ((JTitleBar)JTitleBar.this).JZirkelFrame.this.MW.setState(1);
                }
            });
            this.growbtn = new JButton();
            this.growbtn.setBorder(BorderFactory.createEmptyBorder());
            this.growbtn.setOpaque(false);
            this.growbtn.setContentAreaFilled(false);
            this.growbtn.setFocusable(false);
            this.growbtn.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e2) {
                    JTitleBar.this.growboxtouched();
                }
            });
            this.closebtn = new JButton();
            this.closebtn.setBorder(BorderFactory.createEmptyBorder());
            this.closebtn.setOpaque(false);
            this.closebtn.setContentAreaFilled(false);
            this.closebtn.setFocusable(false);
            this.closebtn.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e2) {
                    JMacrosTools.disposeCurrentJZF();
                }
            });
            this.reducebtn.setIcon(JZirkelFrame.this.JZT.getIcon("zreducebutton.png"));
            this.reducebtn.setRolloverIcon(JZirkelFrame.this.JZT.getIcon("zreducebuttonover.png"));
            this.growbtn.setIcon(JZirkelFrame.this.JZT.getIcon("zgrowbutton.png"));
            this.growbtn.setRolloverIcon(JZirkelFrame.this.JZT.getIcon("zgrowbuttonover.png"));
            this.closebtn.setIcon(JZirkelFrame.this.JZT.getIcon("zclosebutton.png"));
            this.closebtn.setRolloverIcon(JZirkelFrame.this.JZT.getIcon("zclosebuttonover.png"));
            if (System.getProperty("mrj.version") != null && JZirkelFrame.this.JZT.AllowMacLook()) {
                this.add(this.macosspacer);
                this.buttons.add(this.closebtn);
                this.buttons.add(this.reducebtn);
                this.buttons.add(this.growbtn);
                this.add(this.buttons);
                this.add(this.titlespacer);
                this.add(this.windowtitle);
            } else {
                this.add(this.titlespacer);
                this.add(this.windowtitle);
                this.buttons.add(this.reducebtn);
                this.buttons.add(this.growbtn);
                this.buttons.add(this.closebtn);
                this.add(this.buttons);
            }
            this.titlespacer.setAlignmentY(0.0f);
            this.macosspacer.setAlignmentY(0.0f);
            this.windowtitle.setAlignmentY(0.0f);
            this.buttons.setAlignmentY(0.0f);
            this.reducebtn.setAlignmentY(0.5f);
            this.growbtn.setAlignmentY(0.5f);
            this.closebtn.setAlignmentY(0.5f);
            this.revalidate();
        }

        public JTitleBar() {
            this.setLayout(new BoxLayout(this, 0));
            this.init();
        }
    }
}

