/*
 * Decompiled with CFR 0.152.
 */
package eric;

import eric.CTree;
import eric.JDefaultMutableTreeNode;
import eric.JFileFilter;
import eric.JFileSaveDialog;
import eric.JGlobals;
import eric.JMacrosInspector;
import eric.JMacrosTools;
import eric.JSlideshowSaveDialog;
import eric.JZirkelFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.plaf.SeparatorUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import rene.dialogs.Warning;
import rene.gui.Global;
import rene.util.FileName;
import rene.util.xml.XmlTag;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.macro.Macro;
import rene.zirkel.macro.MacroItem;

public class JNodePopup
extends JPopupMenu {
    CTree macrostree;
    JZirkelFrame JZF;
    ZirkelFrame ZF;
    JDefaultMutableTreeNode SelectedNode;
    TreePath[] SelectedPath;
    JMenuItem runitem;
    JMenuItem renitem;
    JMenuItem delitem;
    JMenuItem tolibitem;
    JMenuItem delfromlibitem;
    JMenuItem tofileitem;
    JMenuItem totempitem;
    JMenuItem saveitem;
    JMenuItem updtitem;
    JMenuItem propitem;
    JMenuItem dupitem;
    JMacrosInspector MInspector;

    public JNodePopup(CTree mytree) {
        this.macrostree = mytree;
        this.JZF = this.macrostree.JML.JZF;
        this.ZF = this.JZF.ZF;
        this.MInspector = new JMacrosInspector(this.ZF, this.JZF);
        this.dupitem = new JMenuItem(this.JZF.Strs.getString("macros.popup.duplicate"));
        this.dupitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JNodePopup.this.duplicatenodes();
            }
        });
        this.propitem = new JMenuItem(this.JZF.Strs.getString("macros.popup.properties"));
        this.propitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JNodePopup.this.showproperties();
            }
        });
        this.runitem = new JMenuItem(this.JZF.Strs.getString("macros.popup.run"));
        this.runitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JNodePopup.this.runmacro();
            }
        });
        this.renitem = new JMenuItem(this.JZF.Strs.getString("macros.popup.rename"));
        this.renitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JNodePopup.this.renamenode();
            }
        });
        this.delitem = new JMenuItem(this.JZF.Strs.getString("macros.popup.delete"));
        this.delitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JNodePopup.this.deletenodes();
            }
        });
        this.tolibitem = new JMenuItem(this.JZF.Strs.getString("macros.popup.addtolibrary"));
        this.tolibitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JNodePopup.this.changemacroselectiontype(0);
            }
        });
        this.delfromlibitem = new JMenuItem(this.JZF.Strs.getString("macros.popup.removefromlibrary"));
        this.delfromlibitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JNodePopup.this.removefromlibrary();
            }
        });
        this.tofileitem = new JMenuItem(this.JZF.Strs.getString("macros.popup.publish"));
        this.tofileitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JNodePopup.this.changemacroselectiontype(2);
            }
        });
        this.totempitem = new JMenuItem(this.JZF.Strs.getString("macros.popup.notpublish"));
        this.totempitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JNodePopup.this.changemacroselectiontype(3);
            }
        });
        this.saveitem = new JMenuItem(this.JZF.Strs.getString("macros.popup.saveas"));
        this.saveitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JNodePopup.this.savemacros();
            }
        });
    }

    public void handleMouseClick(MouseEvent e2) {
        TreePath path = this.macrostree.getPathForLocation(e2.getX(), e2.getY());
        if (path != null) {
            this.SelectedNode = (JDefaultMutableTreeNode)path.getLastPathComponent();
            this.SelectedPath = this.macrostree.getSelectionPaths();
            if (this.SelectedPath.length == 1 && this.SelectedNode.isLeaf()) {
                this.runmacro();
            }
        }
    }

    public void handlePopup(MouseEvent e2) {
        TreePath path;
        if (e2.isPopupTrigger() && (path = this.macrostree.getPathForLocation(e2.getX(), e2.getY())) != null) {
            this.macrostree.addSelectionPath(path);
            this.SelectedNode = (JDefaultMutableTreeNode)path.getLastPathComponent();
            this.SelectedPath = this.macrostree.getSelectionPaths();
            this.removeAll();
            if (this.SelectedPath.length > 1) {
                this.add(this.delitem);
                this.add(JNodePopup.createSeparator());
                this.add(this.tofileitem);
                this.add(this.totempitem);
                if (!this.JZF.restrictedSession) {
                    this.add(JNodePopup.createSeparator());
                }
                if (!this.JZF.restrictedSession) {
                    this.add(this.tolibitem);
                }
                if (!this.JZF.restrictedSession) {
                    this.add(this.delfromlibitem);
                }
                if (!this.JZF.restrictedSession) {
                    this.add(JNodePopup.createSeparator());
                }
                if (!this.JZF.restrictedSession) {
                    this.add(this.saveitem);
                }
            } else if (this.SelectedNode.isLeaf()) {
                this.add(this.renitem);
                if (!this.JZF.restrictedSession) {
                    this.add(this.delitem);
                }
                if (!this.JZF.restrictedSession) {
                    this.add(this.dupitem);
                }
                this.add(JNodePopup.createSeparator());
                this.add(this.tofileitem);
                this.add(this.totempitem);
                this.add(JNodePopup.createSeparator());
                if (!this.JZF.restrictedSession) {
                    this.add(this.tolibitem);
                }
                if (!this.JZF.restrictedSession) {
                    this.add(this.delfromlibitem);
                }
                if (!this.JZF.restrictedSession) {
                    this.add(JNodePopup.createSeparator());
                }
                if (!this.JZF.restrictedSession) {
                    this.add(this.saveitem);
                }
                if (!this.JZF.restrictedSession) {
                    this.add(JNodePopup.createSeparator());
                }
                this.add(this.runitem);
                this.add(JNodePopup.createSeparator());
                this.add(this.propitem);
            } else {
                this.add(this.renitem);
                this.add(this.delitem);
                this.add(JNodePopup.createSeparator());
                this.add(this.tofileitem);
                this.add(this.totempitem);
                this.add(JNodePopup.createSeparator());
                if (!this.JZF.restrictedSession) {
                    this.add(this.tolibitem);
                }
                if (!this.JZF.restrictedSession) {
                    this.add(this.delfromlibitem);
                }
                if (!this.JZF.restrictedSession) {
                    this.add(JNodePopup.createSeparator());
                }
                if (!this.JZF.restrictedSession) {
                    this.add(this.saveitem);
                }
            }
            this.show(e2.getComponent(), e2.getX(), e2.getY());
        }
    }

    private void removefromlibrary() {
        for (int i = 0; i < this.SelectedPath.length; ++i) {
            this.SelectedNode = (JDefaultMutableTreeNode)this.SelectedPath[i].getLastPathComponent();
            this.parseremove(this.SelectedNode);
        }
        this.macrostree.repaint();
    }

    private void parseremove(JDefaultMutableTreeNode node) {
        if (node.isLeaf()) {
            node.removefromlib();
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.parseremove((JDefaultMutableTreeNode)node.getChildAt(i));
            }
        }
    }

    private void changemacroselectiontype(int newtype) {
        for (int i = 0; i < this.SelectedPath.length; ++i) {
            this.SelectedNode = (JDefaultMutableTreeNode)this.SelectedPath[i].getLastPathComponent();
            this.parse(this.SelectedNode, newtype);
        }
        this.macrostree.repaint();
    }

    private void parse(JDefaultMutableTreeNode node, int newtype) {
        if (node.isLeaf()) {
            node.setType(newtype);
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.parse((JDefaultMutableTreeNode)node.getChildAt(i), newtype);
            }
        }
    }

    private boolean ICanSave(String Fname, boolean ask) {
        if (!ask) {
            return true;
        }
        if (!new File(Fname).exists()) {
            return true;
        }
        return JOptionPane.showConfirmDialog(null, this.JZF.Strs.getString("filedialog.savemessage1") + Fname + this.JZF.Strs.getString("filedialog.savemessage2"), "", 0) == 0;
    }

    public void dosave(String Filename, boolean restrict, String ext, boolean ask) {
        if (!Filename.endsWith(".zirz") && !Filename.endsWith(".zir")) {
            Filename = Filename + ext;
        }
        if (this.ICanSave(Filename, ask)) {
            this.SetMacrosProtectionForSaveProcess(this.macrostree.JML.MacroTreeTopNode);
            this.ZF.RestrictIcons.setState(restrict);
            this.ZF.setinfo("save");
            try {
                this.ZF.ZC.getConstruction().BackgroundFile = this.ZF.Background;
                this.ZF.ZC.getConstruction().ResizeBackground = Global.getParameter("background.usesize", false);
                if (this.ZF.RestrictIcons.getState()) {
                    String icons = Global.getParameter("restrictedicons", JGlobals.DefaultIcons);
                    String rFileName = JGlobals.RestrictFileName(Filename);
                    if (!this.JZF.restrictedSession) {
                        OutputStream o2 = new FileOutputStream(rFileName);
                        if (ZirkelFrame.isCompressed(rFileName)) {
                            o2 = new GZIPOutputStream(o2, 10000);
                        }
                        this.ZF.ZC.save(o2, true, true, false, this.ZF.ZC.getMacros(), icons);
                        o2.close();
                        OutputStream o = new FileOutputStream(Filename);
                        if (ZirkelFrame.isCompressed(Filename)) {
                            o = new GZIPOutputStream(o, 10000);
                        }
                        this.ZF.ZC.save(o, true, true, false, this.ZF.ZC.getMacros(), "");
                        o.close();
                    } else {
                        Filename = rFileName;
                    }
                } else {
                    OutputStream o = new FileOutputStream(Filename);
                    if (ZirkelFrame.isCompressed(Filename)) {
                        o = new GZIPOutputStream(o, 10000);
                    }
                    this.ZF.ZC.save(o, true, true, false, this.ZF.ZC.getMacros(), "");
                    o.close();
                }
                this.ZF.Filename = Filename;
                this.ZF.setTitle(Zirkel.name("program.name") + " : " + FileName.chop(Filename));
                this.JZF.SetTitle(this.ZF.getTitle());
            }
            catch (Exception e2) {
                Warning w = new Warning((Frame)this.JZF, Zirkel.name("warning.save"), FileName.chop(32, e2.toString(), 64), Zirkel.name("warning"), true);
                w.center(this.JZF);
                w.setVisible(true);
            }
            this.ResetMacrosProtection(this.macrostree.JML.MacroTreeTopNode);
        }
    }

    public void savefile() {
        this.ZF.testjob(false);
        if (!this.ZF.haveFile()) {
            this.savefileas();
        } else {
            this.SetMacrosProtectionForSaveProcess(this.macrostree.JML.MacroTreeTopNode);
            this.ZF.RestrictIcons.setState(this.JZF.restricted);
            this.ZF.setinfo("save");
            this.dosave(this.ZF.Filename, this.JZF.restricted, ".zir", false);
            this.JZF.SetTitle(this.ZF.getTitle());
            this.ResetMacrosProtection(this.macrostree.JML.MacroTreeTopNode);
        }
    }

    public void savefileas() {
        JFileSaveDialog jfc = new JFileSaveDialog(this.JZF, this.ZF, this);
        jfc.setVisible(true);
    }

    public String MakeSlideShow() {
        String name = "";
        String Tools = "";
        String Options = "";
        JSlideshowSaveDialog d2 = new JSlideshowSaveDialog(this.JZF);
        if (d2.OK) {
            name = d2.DIR.getAbsolutePath();
            String[] files = d2.DIR.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".zir") || name.endsWith(".zirz");
                }
            });
            int w = Integer.parseInt(d2.SIZE.w.getText());
            int h = Integer.parseInt(d2.SIZE.h.getText());
            boolean t = d2.JCBK.isSelected();
            boolean as = d2.SIZE.isActualSize();
            if (files.length == 0) {
                return "";
            }
            String myfiles = "'" + files[0] + "'";
            String AssignmentComment = "'" + this.ReadAssignmentComment(name + System.getProperty("file.separator") + files[0]) + "'";
            String AppletSize = "'" + this.ReadAppletSize(name + System.getProperty("file.separator") + files[0], w, h, t, as) + "'";
            for (int i = 1; i < files.length; ++i) {
                myfiles = myfiles + ",'" + files[i] + "'";
                AppletSize = AppletSize + ",'" + this.ReadAppletSize(name + System.getProperty("file.separator") + files[i], w, h, t, as) + "'";
                AssignmentComment = AssignmentComment + ",'" + this.ReadAssignmentComment(name + System.getProperty("file.separator") + files[i]) + "'";
            }
            String myapplettag = "<APPLET ARCHIVE='CaRMetal.jar' CODE='rene.zirkel.ZirkelApplet.class' ";
            myapplettag = myapplettag + "WIDTH='\"+dims[0]+\"' ";
            myapplettag = myapplettag + "HEIGHT='\"+dims[1]+\"' ";
            myapplettag = myapplettag + "ALIGN='CENTER'>";
            myapplettag = myapplettag + "<PARAM NAME='job' VALUE='\"+zirfiles[i]+\"'>";
            myapplettag = myapplettag + "<PARAM NAME='color' VALUE='255,255,255'>";
            if (d2.JCBK.isSelected()) {
                String[] b2 = this.ReadToolsAndOptions();
                Tools = b2[0];
                Options = b2[1];
                myapplettag = myapplettag + "<PARAM NAME='style' VALUE='\"+styl+\"'>";
                myapplettag = myapplettag + "\"+tools+options+\"";
            } else {
                myapplettag = myapplettag + "<PARAM NAME='style' VALUE='plain'>";
            }
            myapplettag = myapplettag + "<PARAM NAME='movefixname' VALUE='true'>";
            myapplettag = myapplettag + "<PARAM NAME='nomousezoom' VALUE='false'>";
            myapplettag = myapplettag + "<PARAM NAME='editdigits' VALUE='" + Global.getParameter("digits.edit", 5) + "'>";
            myapplettag = myapplettag + "<PARAM NAME='displaydigits' VALUE='" + Global.getParameter("digits.lengths", 5) + "'>";
            myapplettag = myapplettag + "<PARAM NAME='angledigits' VALUE='" + Global.getParameter("digits.angles", 1) + "'>";
            myapplettag = myapplettag + "<PARAM NAME='minpointsize' VALUE='" + Global.getParameter("minpointsize", 3) + "'>";
            myapplettag = myapplettag + "<PARAM NAME='minlinesize' VALUE='" + Global.getParameter("minlinesize", 1.0) + "'>";
            myapplettag = myapplettag + "<PARAM NAME='minfontsize' VALUE='" + Global.getParameter("minfontsize", 12) + "'>";
            myapplettag = myapplettag + "<PARAM NAME='arrowsize' VALUE='16'>";
            myapplettag = myapplettag + "</APPLET>";
            Vector lines = this.ReadAllTemplateLines();
            try {
                PrintWriter out = new PrintWriter(name + System.getProperty("file.separator") + "index.html");
                String myline = "";
                String sdownload = this.LocHTML("slideshow.download");
                String snext = this.LocHTML("slideshow.next");
                String sprevious = this.LocHTML("slideshow.previous");
                String ssignature = this.LocHTML("slideshow.signature");
                for (int i = 0; i < lines.size(); ++i) {
                    int k;
                    myline = (String)lines.get(i);
                    if (myline.startsWith("var zirfiles")) {
                        myline = "var zirfiles=[" + myfiles + "];";
                    } else if (myline.startsWith("var appletdims")) {
                        myline = "var appletdims=[" + AppletSize + "];";
                    } else if (myline.startsWith("var appletcomments")) {
                        myline = "var appletcomments=[" + AssignmentComment + "];";
                    } else if (myline.startsWith("myapplettag=")) {
                        myline = "myapplettag=\"" + myapplettag + "\";";
                    } else if (myline.startsWith("var names")) {
                        myline = "var names=[" + myfiles + "];";
                    } else if (myline.startsWith("var next")) {
                        myline = "var next='" + snext + "';";
                    } else if (myline.startsWith("var previous")) {
                        myline = "var previous='" + sprevious + "';";
                    } else if (myline.startsWith("var download")) {
                        myline = "var download='" + sdownload + "';";
                    } else if (myline.startsWith("var signature")) {
                        myline = "var signature='" + ssignature + "';";
                    } else if (myline.startsWith("var applettools")) {
                        out.println("var applettools=[];");
                        if (d2.JCBK.isSelected()) {
                            for (k = 0; k < files.length; ++k) {
                                out.println("applettools[" + k + "]='" + Tools + "';");
                            }
                        }
                        myline = "";
                    } else if (myline.startsWith("var appletoptions")) {
                        out.println("var appletoptions=[];");
                        if (d2.JCBK.isSelected()) {
                            for (k = 0; k < files.length; ++k) {
                                out.println("appletoptions[" + k + "]='" + Options + "';");
                            }
                        }
                        myline = "";
                    }
                    out.println(myline);
                    out.flush();
                }
                out.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.JZF.SaveJarAndLaunchBrowser(name, "index.html");
        }
        d2.doclose();
        return name;
    }

    private String LocHTML(String code) {
        String lochtml = null;
        try {
            byte[] c2 = this.JZF.Strs.getString(code).getBytes("UTF-8");
            String encoding = System.getProperty("mrj.version") != null ? "MacRoman" : "ISO-8859-1";
            lochtml = new String(c2, encoding);
        }
        catch (Exception ex) {
            lochtml = this.JZF.Strs.getString(code);
        }
        return lochtml;
    }

    private String[] ReadToolsAndOptions() {
        int i;
        String tls = " move point boundedpoint intersection line ray segment fixedsegment circle circle3 fixedcircle parallel plumb midpoint angle fixedangle tracker objecttracker locus animate expression area quadric text hide bi_symc bi_syma bi_trans bi_med bi_biss bi_circ bi_arc bi_t_align bi_t_para bi_t_perp bi_t_equi bi_t_app bi_t_conf bi_function_u ";
        String[] tools = tls.split(" ");
        String opts = "back delete undo showname showvalue hidden obtuse solid grid partial plines rename function";
        String[] options = opts.split(" ");
        String[] b2 = new String[]{" ", " "};
        for (i = 0; i < tools.length; ++i) {
            if (!this.JZF.JPM.isRestrictedIcon(tools[i])) continue;
            b2[0] = b2[0] + tools[i] + " ";
        }
        for (i = 0; i < options.length; ++i) {
            if (!this.JZF.JPM.isRestrictedIcon(options[i])) continue;
            b2[1] = b2[1] + options[i] + " ";
        }
        if (this.JZF.JPM.isRestrictedIcon("color0")) {
            b2[1] = b2[1] + "color ";
        }
        if (this.JZF.JPM.isRestrictedIcon("thickness0")) {
            b2[1] = b2[1] + "thickness ";
        }
        if (this.JZF.JPM.isRestrictedIcon("type0")) {
            b2[1] = b2[1] + "type ";
        }
        return b2;
    }

    private String ReadAppletSize(String file, int w, int h, boolean t, boolean as) {
        String str = "";
        if (t) {
            h += 45;
        }
        String params = w + "," + h;
        if (!as) {
            return params;
        }
        try {
            FileInputStream input = new FileInputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            while ((str = in.readLine()) != null) {
                if (!str.startsWith("<Windowdim")) continue;
                str = str.replace("<", "");
                XmlTag tag = new XmlTag(str = str.replace("/>", ""));
                if (!tag.hasParam("w") || !tag.hasParam("h")) break;
                int zcw = Integer.parseInt(tag.getValue("w")) - (this.JZF.getSize().width - this.JZF.ZF.ZC.getSize().width);
                int zch = Integer.parseInt(tag.getValue("h")) - (this.JZF.getSize().height - this.JZF.ZF.ZC.getSize().height);
                int myH = t ? 45 + zch : zch;
                params = zcw + "," + myH;
                break;
            }
            in.close();
        }
        catch (Exception e2) {
            // empty catch block
        }
        return params;
    }

    private String ReadAssignmentComment(String file) {
        String str = "";
        try {
            FileInputStream input = new FileInputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            while ((str = in.readLine()) != null) {
                if (!str.startsWith("<Assignment>")) continue;
                String myCom = "";
                while (true) {
                    str = in.readLine();
                    str = str.replace("<P>", "");
                    if ((str = str.replace("</P>", "<br>")).startsWith("</Assignment>")) break;
                    myCom = myCom + str + " ";
                }
                in.close();
                return myCom;
            }
            in.close();
        }
        catch (Exception e2) {
            // empty catch block
        }
        return "";
    }

    private Vector ReadAllTemplateLines() {
        Vector<String> lines = new Vector<String>();
        try {
            String str;
            InputStream input = this.getClass().getResourceAsStream("/eric/docs/index.html");
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            while ((str = in.readLine()) != null) {
                lines.add(str);
            }
            in.close();
        }
        catch (Exception e2) {
            // empty catch block
        }
        return lines;
    }

    void SetMacrosProtectionForSaveProcess(JDefaultMutableTreeNode mynode) {
        if (!mynode.isLeaf()) {
            for (int i = 0; i < mynode.getChildCount(); ++i) {
                this.SetMacrosProtectionForSaveProcess((JDefaultMutableTreeNode)mynode.getChildAt(i));
            }
        } else {
            String myname = (String)mynode.getUserObject();
            if (!myname.startsWith("-- ")) {
                if (mynode.macrotype == 1 || mynode.macrotype == 2) {
                    if (mynode.m != null) {
                        mynode.m.setProtected(false);
                    }
                } else if (mynode.m != null) {
                    mynode.m.setProtected(true);
                }
            }
        }
    }

    void ResetMacrosProtection(JDefaultMutableTreeNode mynode) {
        if (!mynode.isLeaf()) {
            for (int i = 0; i < mynode.getChildCount(); ++i) {
                this.ResetMacrosProtection((JDefaultMutableTreeNode)mynode.getChildAt(i));
            }
        } else {
            String myname = (String)mynode.getUserObject();
            if (!myname.startsWith("-- ")) {
                if (mynode.macrotype < 2) {
                    if (mynode.m != null) {
                        mynode.m.setProtected(true);
                    }
                } else if (mynode.m != null) {
                    mynode.m.setProtected(false);
                }
            }
        }
    }

    private void savemacros() {
        Vector ZFMacros = new Vector();
        for (int i = 0; i < this.SelectedPath.length; ++i) {
            this.SelectedNode = (JDefaultMutableTreeNode)this.SelectedPath[i].getLastPathComponent();
            this.parsesave(this.SelectedNode, ZFMacros);
        }
        JFileChooser jfc = new JFileChooser(JGlobals.getLastFilePath());
        jfc.setDialogType(1);
        jfc.setApproveButtonText(this.JZF.Strs.getString("macros.savedlog.buttonok"));
        jfc.setAcceptAllFileFilterUsed(false);
        JFileFilter ffilter = new JFileFilter(this.JZF.Strs.getString("filedialog.macrofilefilter"), ".mcr");
        jfc.addChoosableFileFilter(ffilter);
        jfc.setFileFilter(ffilter);
        int rep = jfc.showSaveDialog(null);
        if (rep == 0) {
            File outputfile = jfc.getSelectedFile();
            JGlobals.setLastFilePath(outputfile.getAbsolutePath());
            String ext = outputfile.getAbsolutePath().endsWith(".mcr") ? "" : ".mcr";
            this.ZF.dosave(outputfile.getAbsolutePath() + ext, false, true, true, ZFMacros);
        }
    }

    private void parsesave(JDefaultMutableTreeNode node, Vector ZFMacros) {
        if (node.isLeaf()) {
            MacroItem mi = new MacroItem(node.m, null);
            ZFMacros.add(mi);
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.parsesave((JDefaultMutableTreeNode)node.getChildAt(i), ZFMacros);
            }
        }
    }

    public void updatelibrary() {
        if (!this.JZF.restricted) {
            Vector ZFMacros = new Vector();
            this.parseupdate(this.macrostree.JML.MacroTreeTopNode, ZFMacros);
            String mypath = JGlobals.AppPath();
            String Filename = "library.mcr";
            if (new File(mypath + Zirkel.name("language", "") + "library.mcr").exists()) {
                Filename = Zirkel.name("language", "") + "library.mcr";
            }
            this.ZF.dosave(mypath + Filename, false, true, true, ZFMacros);
        }
    }

    private void parseupdate(JDefaultMutableTreeNode node, Vector ZFMacros) {
        if (node.isLeaf()) {
            String myname = (String)node.getUserObject();
            if (!myname.startsWith("-- ") && node.m.isProtected()) {
                MacroItem mi = new MacroItem(node.m, null);
                ZFMacros.add(mi);
            }
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.parseupdate((JDefaultMutableTreeNode)node.getChildAt(i), ZFMacros);
            }
        }
    }

    private void runmacro() {
        this.JZF.JPM.deselectgeomgroup();
        this.SelectedNode.runZmacro();
    }

    public void actualiseproperties() {
        if (this.MInspector.freeJP.isVisible()) {
            boolean nomacrofound = true;
            this.SelectedPath = this.macrostree.getSelectionPaths();
            if (this.SelectedPath != null) {
                for (int i = 0; i < this.SelectedPath.length; ++i) {
                    this.SelectedNode = (JDefaultMutableTreeNode)this.SelectedPath[i].getLastPathComponent();
                    if (!this.SelectedNode.isLeaf() || ((String)this.SelectedNode.getUserObject()).startsWith("--")) continue;
                    this.MInspector.setMacro(this.SelectedNode);
                    nomacrofound = false;
                    break;
                }
            }
            if (nomacrofound) {
                this.MInspector.clearPalette();
            }
        }
    }

    private void showproperties() {
        if (this.SelectedNode != null) {
            this.MInspector.setMacro(this.SelectedNode);
        }
        this.MInspector.setStandardLocation();
        this.MInspector.setVisible(true);
    }

    public void duplicatenodes() {
        Macro mymacro = (Macro)this.SelectedNode.m.clone();
        String[] mytab = mymacro.getName().split("/");
        mymacro.setName(mytab[mytab.length - 1]);
        Vector<MacroItem> ZFMacros = new Vector<MacroItem>();
        ZFMacros.add(new MacroItem(mymacro, null));
        String mypath = JGlobals.AppPath();
        this.ZF.dosave(mypath + "buffer.mcr", false, true, true, ZFMacros);
        JMacrosTools.OpenMacro(mypath + "buffer.mcr");
    }

    public void deletenodes() {
        TreePath[] paths = this.macrostree.getSelectionPaths();
        if (paths != null) {
            Object[] options = new Object[]{"Ok", "Cancel"};
            int rep = JOptionPane.showOptionDialog(null, this.JZF.Strs.getString("macros.question.delete"), "Warning", -1, 2, null, options, options[0]);
            if (rep == 0) {
                for (int i = 0; i < paths.length; ++i) {
                    JDefaultMutableTreeNode node = (JDefaultMutableTreeNode)paths[i].getLastPathComponent();
                    JDefaultMutableTreeNode father = (JDefaultMutableTreeNode)node.getParent();
                    ((DefaultTreeModel)this.macrostree.getModel()).removeNodeFromParent(node);
                    while (father.getChildCount() == 0) {
                        JDefaultMutableTreeNode grandfather = (JDefaultMutableTreeNode)father.getParent();
                        ((DefaultTreeModel)this.macrostree.getModel()).removeNodeFromParent(father);
                        father = grandfather;
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JNodePopup.this.ActualiseLibraryMacros();
                }
            });
        }
    }

    public void ActualiseLibraryMacros() {
        Vector macs = this.ZF.ZC.getMacros();
        macs.removeAllElements();
        this.parsedeletemacro(this.macrostree.JML.MacroTreeTopNode, macs);
        JMacrosTools.getDefaultMacros();
    }

    private void parsedeletemacro(JDefaultMutableTreeNode Ndfrom, Vector ZFMacros) {
        block2: {
            block1: {
                if (!Ndfrom.isLeaf()) break block1;
                String myname = (String)Ndfrom.getUserObject();
                if (myname.startsWith("-- ")) break block2;
                MacroItem mi = new MacroItem(Ndfrom.m, null);
                ZFMacros.add(mi);
                if (!Ndfrom.m.isProtected()) break block2;
                JMacrosTools.librarymacros.add(mi);
                break block2;
            }
            for (int i = 0; i < Ndfrom.getChildCount(); ++i) {
                this.parsedeletemacro((JDefaultMutableTreeNode)Ndfrom.getChildAt(i), ZFMacros);
            }
        }
    }

    public void addfolder() {
        JDefaultMutableTreeNode node = new JDefaultMutableTreeNode(this.JZF.Strs.getString("macros.untitledfolder"));
        node.add(new JDefaultMutableTreeNode(this.JZF.Strs.getString("macros.emptynode")));
        TreePath[] paths = this.macrostree.getSelectionPaths();
        if (paths != null) {
            JDefaultMutableTreeNode root = (JDefaultMutableTreeNode)paths[0].getLastPathComponent();
            if (root.isLeaf()) {
                DefaultMutableTreeNode father = (DefaultMutableTreeNode)root.getParent();
                int i = father.getIndex(root) + 1;
                ((DefaultTreeModel)this.macrostree.getModel()).insertNodeInto(node, father, i);
            } else {
                ((DefaultTreeModel)this.macrostree.getModel()).insertNodeInto(node, root, root.getChildCount());
            }
        } else {
            ((DefaultTreeModel)this.macrostree.getModel()).insertNodeInto(node, this.macrostree.JML.MacroTreeTopNode, this.macrostree.JML.MacroTreeTopNode.getChildCount());
        }
        TreePath tp = new TreePath(node.getPath());
        this.macrostree.setEditable(true);
        this.macrostree.startEditingAtPath(tp);
    }

    public void renamenode() {
        TreePath[] paths = this.macrostree.getSelectionPaths();
        if (paths != null) {
            this.macrostree.setEditable(true);
            this.macrostree.startEditingAtPath(paths[0]);
        }
    }

    private static final JSeparator createSeparator() {
        JSeparator jsep = new JSeparator(0);
        Dimension d2 = new Dimension(200, 12);
        jsep.setMaximumSize(d2);
        jsep.setMinimumSize(d2);
        jsep.setPreferredSize(d2);
        jsep.setSize(d2);
        jsep.setUI(new MiddleSeparatorUI());
        return jsep;
    }

    private static final class MiddleSeparatorUI
    extends SeparatorUI {
        private MiddleSeparatorUI() {
        }

        public void paint(Graphics g, JComponent c2) {
            Dimension s = c2.getSize();
            int middleHeight = (s.height - 1) / 2;
            g.setColor(Color.lightGray);
            g.drawLine(0, middleHeight, s.width, middleHeight);
            g.setColor(Color.white);
            g.drawLine(0, middleHeight + 1, s.width, middleHeight + 1);
        }
    }
}

