/*
 * Decompiled with CFR 0.152.
 */
package eric;

import eric.JDefaultMutableTreeNode;
import eric.JFileFilter;
import eric.JGlobalPreferences;
import eric.JGlobals;
import eric.JZirkelFrame;
import eric.ZirkelCanvasFileChooserPreview;
import eric.controls.SliderSnap;
import java.awt.Color;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import rene.gui.Global;
import rene.util.xml.XmlReader;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTagPI;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.help.Help;
import rene.zirkel.macro.Macro;
import rene.zirkel.macro.MacroItem;
import rene.zirkel.objects.PointObject;

public class JMacrosTools {
    public static Vector librarymacros = new Vector();
    public static Vector builtinmacros = new Vector();
    public static String MacrosLibraryFileName = "";
    public static String MacrosBackupLibraryFileName = "";
    public static JZirkelFrame CurrentJZF = null;
    public static ArrayList AllJZFs = new ArrayList();
    public static ArrayList StartupFiles = new ArrayList();
    public static boolean AllowWindowActivatedEvent = true;
    public static boolean isStartup = true;
    public static boolean isNewVersion = false;

    public static boolean isJZFnumTooBig() {
        if (AllJZFs.size() > 10) {
            JOptionPane.showMessageDialog(null, JGlobals.Loc("alert.toomuchwins"));
            return true;
        }
        return false;
    }

    public static void newJZirkelWindow(boolean with3D) {
        JZirkelFrame oldframe = CurrentJZF;
        if (oldframe != null) {
            JMacrosTools.updateLibraryFromTree();
        }
        JMacrosTools.initProperties();
        JGlobalPreferences.setLocalPreferences();
        Count.resetAll();
        CurrentJZF = new JZirkelFrame(with3D);
        if (AllJZFs.size() == 0) {
            JMacrosTools.LoadDefaultMacrosAtStartup();
        }
        AllJZFs.add(CurrentJZF);
        JMacrosTools.CurrentJZF.ZContent.macros.myJML.initMacrosTree();
        if (oldframe != null) {
            Point pt = oldframe.getLocation();
            CurrentJZF.setLocation(pt.x + 20, pt.y + 20);
            JMacrosTools.CurrentJZF.JPM.MainPalette.FollowWindow();
        }
    }

    public static void RefreshDisplay() {
        for (int i = 0; i < AllJZFs.size(); ++i) {
            JZirkelFrame jzf = (JZirkelFrame)AllJZFs.get(i);
            if (jzf.equals(CurrentJZF)) continue;
            jzf.JPM.MainPalette.setVisible(false);
            jzf.ResizeAll();
            if (!jzf.isVisible()) {
                jzf.setVisible(true);
            }
            jzf.ZF.ZC.removeMouseMotionListener(jzf.ZF.ZC);
            jzf.ZF.ZC.setFrozen(false);
            jzf.JPR.setLocalPreferences();
            jzf.ZF.ZC.setFrozen(true);
            jzf.repaint();
        }
        CurrentJZF.ResizeAll();
        JMacrosTools.CurrentJZF.JPM.MainPalette.FollowWindow();
        JMacrosTools.CurrentJZF.JPM.MainPalette.setVisible(true);
        if (!CurrentJZF.isVisible()) {
            CurrentJZF.setVisible(true);
        }
        JMacrosTools.CurrentJZF.ZF.ZC.addMouseMotionListener(JMacrosTools.CurrentJZF.ZF.ZC);
        JMacrosTools.CurrentJZF.ZF.ZC.setFrozen(false);
        JMacrosTools.CurrentJZF.JPR.setLocalPreferences();
        JMacrosTools.CurrentJZF.JPM.setGoodProperties(JMacrosTools.CurrentJZF.JPM.geomSelectedIcon());
        CurrentJZF.repaint();
        if (JGlobals.JPB != null) {
            JGlobals.JPB.clearme();
        }
    }

    public static void FirstRun() {
        if (StartupFiles.size() > 0) {
            JMacrosTools.OpenStartupFiles();
        } else {
            JMacrosTools.NewWindow();
        }
        isStartup = false;
    }

    public static void NewWindow() {
        if (JMacrosTools.isJZFnumTooBig()) {
            return;
        }
        JMacrosTools.AllowActivateEvent(false);
        JMacrosTools.newJZirkelWindow(false);
        JMacrosTools.RefreshDisplay();
        JMacrosTools.AllowActivateEvent(true);
    }

    public static void AllowActivateEvent(boolean allow) {
        if (allow) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                        AllowWindowActivatedEvent = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            thread.setPriority(1);
            thread.start();
        } else {
            AllowWindowActivatedEvent = false;
        }
    }

    public static void OpenStartupFiles() {
        JMacrosTools.AllowActivateEvent(false);
        for (int i = 0; i < StartupFiles.size(); ++i) {
            String filename = (String)StartupFiles.get(i);
            if (filename.endsWith(".mcr")) {
                JMacrosTools.OpenMacro(filename);
                continue;
            }
            JMacrosTools.OpenFile(filename, null, false);
        }
        JMacrosTools.RefreshDisplay();
        StartupFiles.clear();
        JMacrosTools.AllowActivateEvent(true);
    }

    public static void New3DWindow() {
        if (JMacrosTools.isJZFnumTooBig()) {
            return;
        }
        JMacrosTools.AllowActivateEvent(false);
        InputStream o = JMacrosTools.class.getResourceAsStream("/base3D.zir");
        String Filename = "base3D.zir";
        JMacrosTools.OpenFile(Filename, o, true);
        JMacrosTools.CurrentJZF.ZF.setTitle(Zirkel.name("program.name"));
        JMacrosTools.CurrentJZF.ZF.Filename = "";
        JMacrosTools.RefreshDisplay();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JMacrosTools.CurrentJZF.ZF.ZC.JCM.fix3Dcomments();
            }
        });
        JMacrosTools.AllowActivateEvent(true);
    }

    public static void OpenFile() {
        if (JMacrosTools.isJZFnumTooBig()) {
            return;
        }
        JMacrosTools.AllowActivateEvent(false);
        String filename = JMacrosTools.getOpenFile();
        if (!filename.equals("")) {
            JMacrosTools.OpenFile(filename, null, false);
            JMacrosTools.RefreshDisplay();
        }
        JMacrosTools.AllowActivateEvent(true);
    }

    public static void OpenFile(String filename, InputStream in, boolean with3D) {
        if (JMacrosTools.isJZFnumTooBig()) {
            return;
        }
        if (filename.equals("")) {
            return;
        }
        if (filename.endsWith(".zir") || filename.endsWith(".zirz")) {
            JMacrosTools.newJZirkelWindow(with3D);
            JMacrosTools.CurrentJZF.busy = true;
            JMacrosTools.CurrentJZF.ZF.setinfo("save");
            JMacrosTools.CurrentJZF.ZF.ZC.getConstruction().BackgroundFile = null;
            JMacrosTools.CurrentJZF.ZF.Background = "";
            JMacrosTools.CurrentJZF.ZF.dograb(false);
            JMacrosTools.CurrentJZF.ZF.doload(filename, in);
            if (!filename.endsWith("base3D.zir")) {
                JMacrosTools.CurrentJZF.JPM.fix3Dpalette();
            }
            JMacrosTools.CurrentJZF.JPR.getLocalPreferences();
            Count.resetAll();
            SwingUtilities.invokeLater(JMacrosTools.CurrentJZF.doactualisemacrostree);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JMacrosTools.CurrentJZF.ZF.ZC.JCM.readXmlTags();
                }
            });
        }
    }

    public static void OpenMacro(String name) {
        if (AllJZFs.size() == 0) {
            JMacrosTools.newJZirkelWindow(false);
        }
        JMacrosTools.CurrentJZF.ZF.setinfo("macro");
        if (name.equals("")) {
            JMacrosTools.CurrentJZF.ZF.loadMacros();
        } else {
            try {
                InputStream o = new FileInputStream(name);
                ZirkelFrame cfr_ignored_0 = JMacrosTools.CurrentJZF.ZF;
                if (ZirkelFrame.isCompressed(name)) {
                    o = new GZIPInputStream(o);
                }
                JMacrosTools.CurrentJZF.ZF.ZC.load(o, false, true);
                o.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        SwingUtilities.invokeLater(JMacrosTools.CurrentJZF.doactualisemacrostree);
    }

    public static void setCurrentJZF(JZirkelFrame jzf) {
        if (!CurrentJZF.equals(jzf)) {
            JMacrosTools.updateLibraryFromTree();
            CurrentJZF = jzf;
            JMacrosTools.RefreshDisplay();
            Count.resetAll();
            PointObject.setPointLabel(JMacrosTools.CurrentJZF.PointLabel);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JMacrosTools.CurrentJZF.ZContent.macros.myJML.initMacrosTree();
                }
            });
        }
    }

    public static void setAnotherCurrentJZF() {
        for (int i = 0; i < AllJZFs.size(); ++i) {
            JZirkelFrame jzf = (JZirkelFrame)AllJZFs.get(i);
            if (jzf.equals(CurrentJZF)) continue;
            jzf.toFront();
            return;
        }
    }

    public static void setDefaultMacros() {
        if (CurrentJZF != null) {
            int i = 0;
            Vector F = new Vector();
            Vector V = JMacrosTools.CurrentJZF.ZF.ZC.getMacros();
            for (i = 0; i < V.size(); ++i) {
                MacroItem mi = (MacroItem)V.get(i);
                if (mi.M.isProtected()) continue;
                F.add(V.get(i));
            }
            V.clear();
            for (i = 0; i < builtinmacros.size(); ++i) {
                V.add(builtinmacros.get(i));
            }
            for (i = 0; i < librarymacros.size(); ++i) {
                V.add(librarymacros.get(i));
            }
            for (i = 0; i < F.size(); ++i) {
                V.add(F.get(i));
            }
        }
    }

    public static void getDefaultMacros() {
        if (CurrentJZF != null) {
            librarymacros.clear();
            Vector V = JMacrosTools.CurrentJZF.ZF.ZC.getMacros();
            for (int i = 0; i < V.size(); ++i) {
                MacroItem mi = (MacroItem)V.get(i);
                if (!mi.M.isProtected() || mi.M.Name.startsWith("@builtin@")) continue;
                librarymacros.add(V.get(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean disposeCurrentJZF() {
        if (AllJZFs.size() == 1) {
            if (!JMacrosTools.CurrentJZF.restricted) {
                JMacrosTools.updateLibraryFromTree();
                JMacrosTools.saveLibraryToDisk();
                JGlobalPreferences.savePreferences();
            }
            if (!JMacrosTools.CurrentJZF.ZF.close()) return false;
            Global.saveProperties("CaR Properties");
            Global.exit(0);
        } else {
            if (!JMacrosTools.CurrentJZF.ZF.close()) return false;
            ZirkelFrame curZF = JMacrosTools.CurrentJZF.ZF;
            CurrentJZF.dispose();
            curZF.dispose();
        }
        AllJZFs.remove(CurrentJZF);
        return true;
    }

    public static void disposeAllJZFs() {
        JMacrosTools.AllowActivateEvent(false);
        while (AllJZFs.size() > 0) {
            CurrentJZF = (JZirkelFrame)AllJZFs.get(AllJZFs.size() - 1);
            CurrentJZF.toFront();
            JMacrosTools.RefreshDisplay();
            if (JMacrosTools.disposeCurrentJZF()) continue;
        }
        JMacrosTools.AllowActivateEvent(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String inFile, String outFile) {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            in = new FileInputStream(inFile).getChannel();
            out = new FileOutputStream(outFile).getChannel();
            in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
        }
        catch (Exception e2) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e3) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e4) {}
            }
        }
    }

    public static String getHomeDirectory() {
        String name = "carmetal_config";
        String SP = System.getProperty("file.separator");
        return FileSystemView.getFileSystemView().getDefaultDirectory() + SP + name + SP;
    }

    public static void createLocalDirectory() {
        String mypath = JGlobals.AppPath();
        String Filename = "library.mcr";
        if (new File(mypath + Zirkel.name("language", "") + "library.mcr").exists()) {
            Filename = Zirkel.name("language", "") + "library.mcr";
        } else if (new File(JMacrosTools.getHomeDirectory() + Zirkel.name("language", "") + "library.mcr").exists()) {
            Filename = Zirkel.name("language", "") + "library.mcr";
        }
        MacrosLibraryFileName = JMacrosTools.getHomeDirectory() + Filename;
        if (new File(MacrosLibraryFileName).exists()) {
            if (isNewVersion) {
                MacrosBackupLibraryFileName = JMacrosTools.getHomeDirectory() + "library_backup.mcr";
                JMacrosTools.copyFile(MacrosLibraryFileName, MacrosBackupLibraryFileName);
                JMacrosTools.copyFile(mypath + Filename, MacrosLibraryFileName);
            }
        } else {
            new File(JMacrosTools.getHomeDirectory()).mkdirs();
            JMacrosTools.copyFile(mypath + Filename, MacrosLibraryFileName);
        }
    }

    public static void LoadDefaultMacrosAtStartup() {
        InputStream o;
        try {
            o = JMacrosTools.class.getResourceAsStream("/builtin.mcr");
            JMacrosTools.LoadMacros(o, builtinmacros);
            o.close();
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (new File(MacrosLibraryFileName).exists()) {
            try {
                o = new FileInputStream(MacrosLibraryFileName);
                JMacrosTools.LoadMacros(o, librarymacros);
                o.close();
                if (!MacrosBackupLibraryFileName.equals("")) {
                    FileInputStream o2 = new FileInputStream(MacrosBackupLibraryFileName);
                    JMacrosTools.LoadMacros(o2, librarymacros);
                    ((InputStream)o2).close();
                    File f2 = new File(MacrosBackupLibraryFileName);
                    f2.delete();
                }
                return;
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        try {
            o = JMacrosTools.class.getResourceAsStream("/default.mcr");
            JMacrosTools.LoadMacros(o, librarymacros);
            o.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void saveLibraryToDisk() {
        if (!JMacrosTools.CurrentJZF.restricted) {
            JMacrosTools.CurrentJZF.ZF.dosave(MacrosLibraryFileName, false, true, true, librarymacros);
        }
    }

    public static void updateLibraryFromTree() {
        if (!JMacrosTools.CurrentJZF.restricted) {
            librarymacros.removeAllElements();
            JMacrosTools.parseupdate(JMacrosTools.CurrentJZF.ZContent.macros.myJML.MacroTreeTopNode, librarymacros);
        }
    }

    private static void parseupdate(JDefaultMutableTreeNode node, Vector V) {
        if (node.isLeaf()) {
            String myname = (String)node.getUserObject();
            if (!myname.startsWith("-- ") && node.m.isProtected()) {
                MacroItem mi = new MacroItem(node.m, null);
                V.add(mi);
            }
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                JMacrosTools.parseupdate((JDefaultMutableTreeNode)node.getChildAt(i), V);
            }
        }
    }

    private static void LoadMacros(InputStream in, Vector Macros) throws Exception {
        XmlReader xml = new XmlReader();
        xml.init(in);
        XmlTree tree = xml.scan();
        if (tree == null) {
            throw new ConstructionException("XML file not recognized");
        }
        Enumeration e2 = tree.getContent();
        while (e2.hasMoreElements()) {
            tree = (XmlTree)e2.nextElement();
            if (tree.getTag() instanceof XmlTagPI) continue;
            if (tree.getTag().name().equals("CaR")) break;
            throw new ConstructionException("CaR tag not found");
        }
        e2 = tree.getContent();
        boolean all = false;
        while (e2.hasMoreElements()) {
            tree = (XmlTree)e2.nextElement();
            XmlTag tag = tree.getTag();
            if (tag.name().equals("Macro")) {
                try {
                    Count.setAllAlternate(true);
                    Macro m = new Macro(null, tree);
                    int i = 0;
                    for (i = 0; i < Macros.size() && !((MacroItem)Macros.elementAt((int)i)).M.getName().equals(m.getName()); ++i) {
                    }
                    if (i >= Macros.size()) {
                        m.setProtected(true);
                        MacroItem mi = new MacroItem(m, null);
                        Macros.addElement(mi);
                    }
                }
                catch (ConstructionException ex) {
                    Count.setAllAlternate(false);
                    throw ex;
                }
                Count.setAllAlternate(false);
                continue;
            }
            throw new ConstructionException("Construction not found");
        }
    }

    public static void initObjectsProperties() {
        Global.setParameter("options.segment.color", Global.getParameter("options.segment.color", 1));
        Global.setParameter("options.segment.colortype", Global.getParameter("options.segment.colortype", 0));
        Global.setParameter("options.segment.shownames", Global.getParameter("options.segment.shownames", false));
        Global.setParameter("options.segment.showvalues", Global.getParameter("options.segment.showvalues", false));
        Global.setParameter("options.segment.large", Global.getParameter("options.segment.large", false));
        Global.setParameter("options.segment.bold", Global.getParameter("options.segment.bold", false));
        Global.setParameter("options.line.color", Global.getParameter("options.line.color", 3));
        Global.setParameter("options.line.colortype", Global.getParameter("options.line.colortype", 0));
        Global.setParameter("options.line.shownames", Global.getParameter("options.line.shownames", false));
        Global.setParameter("options.line.showvalues", false);
        Global.setParameter("options.line.large", Global.getParameter("options.line.large", false));
        Global.setParameter("options.line.bold", Global.getParameter("options.line.bold", false));
        Global.setParameter("options.point.color", Global.getParameter("options.point.color", 2));
        Global.setParameter("options.point.colortype", Global.getParameter("options.point.colortype", 0));
        Global.setParameter("options.point.shownames", Global.getParameter("options.point.shownames", false));
        Global.setParameter("options.point.large", Global.getParameter("options.point.large", false));
        Global.setParameter("options.point.bold", Global.getParameter("options.point.bold", false));
        Global.setParameter("options.point.showvalues", Global.getParameter("options.point.showvalues", false));
        Global.setParameter("options.circle.color", Global.getParameter("options.circle.color", 4));
        Global.setParameter("options.circle.colortype", Global.getParameter("options.circle.colortype", 0));
        Global.setParameter("options.circle.shownames", Global.getParameter("options.circle.shownames", false));
        Global.setParameter("options.circle.showvalues", Global.getParameter("options.circle.showvalues", false));
        Global.setParameter("options.circle.filled", Global.getParameter("options.circle.filled", false));
        Global.setParameter("options.circle.large", Global.getParameter("options.circle.large", false));
        Global.setParameter("options.circle.bold", Global.getParameter("options.circle.bold", false));
        Global.setParameter("options.angle.color", Global.getParameter("options.angle.color", 1));
        Global.setParameter("options.angle.colortype", Global.getParameter("options.angle.colortype", 0));
        Global.setParameter("options.angle.shownames", Global.getParameter("options.angle.shownames", false));
        Global.setParameter("options.angle.showvalues", Global.getParameter("options.angle.showvalues", true));
        Global.setParameter("options.angle.filled", Global.getParameter("options.angle.filled", true));
        Global.setParameter("options.angle.large", Global.getParameter("options.angle.large", false));
        Global.setParameter("options.angle.bold", Global.getParameter("options.angle.bold", false));
        Global.setParameter("options.angle.obtuse", Global.getParameter("options.angle.obtuse", false));
        Global.setParameter("options.area.color", Global.getParameter("options.area.color", 1));
        Global.setParameter("options.area.colortype", Global.getParameter("options.area.colortype", 2));
        Global.setParameter("options.area.shownames", Global.getParameter("options.area.shownames", false));
        Global.setParameter("options.area.showvalues", Global.getParameter("options.area.showvalues", false));
        Global.setParameter("options.text.color", Global.getParameter("options.text.color", 1));
        Global.setParameter("options.text.colortype", Global.getParameter("options.text.colortype", 1));
        Global.setParameter("options.text.shownames", Global.getParameter("options.text.shownames", true));
        Global.setParameter("options.text.showvalues", Global.getParameter("options.text.showvalues", true));
        Global.setParameter("options.locus.color", Global.getParameter("options.locus.color", 1));
        Global.setParameter("options.locus.colortype", Global.getParameter("options.locus.colortype", 0));
        Global.setParameter("options.locus.shownames", Global.getParameter("options.locus.shownames", false));
        Global.setParameter("options.locus.showvalues", Global.getParameter("options.locus.showvalues", false));
    }

    public static void initProperties() {
        if (!Global.getParameter("program.version", "").equals(Zirkel.name("program.version"))) {
            Global.setParameter("program.newversion", true);
            Global.setParameter("program.version", Zirkel.name("program.version"));
            Global.setParameter("icons", " new load save back undo delete color type thickness hidden showcolor macro grid comment replay point line segment ray circle fixedcircle parallel plumb circle3 midpoint angle fixedangle move tracker objecttracker hide expression area text quadric runmacro edit animate  info zoom draw function rename ");
            isNewVersion = true;
        }
        Global.setParameter("iconpath", "/rene/zirkel/newicons/");
        Global.setParameter("icontype", "png");
        if (Global.getParameter("options.smallicons", false)) {
            Global.setParameter("iconsize", 24);
        } else {
            Global.setParameter("iconsize", 32);
        }
        Help.CodePage = Global.name("codepage.help", "");
        Global.setParameter("save.includemacros", true);
        Global.setParameter("load.clearmacros", false);
        Global.setParameter("options.backups", false);
        Global.setParameter("options.visual", true);
        Global.setParameter("options.filedialog", false);
        Global.setParameter("options.restricted", true);
        Global.setParameter("options.smallicons", false);
        Global.setParameter("options.indicate", true);
        Global.setParameter("restricted", false);
        Global.setParameter("showgrid", false);
        Global.setParameter("simplegraphics", false);
        Global.setParameter("quality", true);
        Global.setParameter("export.jar", "CaRMetal.jar");
        Global.setParameter("iconpath", "/eric/icons/palette/");
        Global.Background = Global.getParameter("colorbackground", new Color(231, 238, 255));
        Global.setParameter("background.tile", Global.getParameter("background.tile", false));
        if (!Global.haveParameter("options.germanpoints") && Locale.getDefault().getLanguage().equals("de")) {
            Global.setParameter("options.germanpoints", true);
        }
        SliderSnap.init();
        JMacrosTools.initObjectsProperties();
    }

    public static String getOpenFile() {
        String name = "";
        JFileChooser jfc = new JFileChooser(JGlobals.getLastFilePath());
        jfc.setDialogType(0);
        jfc.setApproveButtonText("Ouvrir la figure");
        jfc.setAcceptAllFileFilterUsed(false);
        JFileFilter ffilter = new JFileFilter(JMacrosTools.CurrentJZF.Strs.getString("filedialog.filefilter"), ".zir");
        jfc.addChoosableFileFilter(ffilter);
        JFileFilter fcfilter = new JFileFilter(JMacrosTools.CurrentJZF.Strs.getString("filedialog.compressedfilefilter"), ".zirz");
        jfc.addChoosableFileFilter(fcfilter);
        jfc.setFileFilter(ffilter);
        jfc.setAccessory(new ZirkelCanvasFileChooserPreview(jfc));
        int rep = jfc.showOpenDialog(null);
        if (rep == 0) {
            name = jfc.getSelectedFile().getAbsolutePath();
            JGlobals.setLastFilePath(name);
        } else {
            name = "";
        }
        return name;
    }
}

