/*
 * Decompiled with CFR 0.152.
 */
package eric;

import java.util.Enumeration;
import java.util.Vector;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.PolygonDrawer;
import rene.zirkel.objects.AreaObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.QuadricObject;
import rene.zirkel.objects.RayObject;
import rene.zirkel.objects.SegmentObject;
import rene.zirkel.objects.TrackObject;
import rene.zirkel.structures.Coordinates;

public class JLocusTrackObject
extends TrackObject {
    Coordinates C;
    PolygonDrawer pd;
    double c0;
    double r0;
    double c;
    double r;
    ExpressionObject EO;
    Vector RefreshList = new Vector();
    long time = 0L;
    private static double a = 5.0;
    private static double b = 6.0;
    private static double xmin = -b + 1.0E-4;

    public JLocusTrackObject(Construction c2, ConstructionObject p, ConstructionObject[] po, int pn, ConstructionObject o, PointObject pm) {
        super(c2);
        this.P = p;
        this.PN = pn;
        for (int i = 0; i < this.PN; ++i) {
            this.PO[i] = po[i];
        }
        this.O = o;
        this.PM = pm;
        this.validate();
        this.updateText();
        if (o instanceof SegmentObject) {
            this.validate(c2, p, pm);
        } else if (o instanceof ExpressionObject) {
            this.validate(c2, p, null);
        } else if (o instanceof RayObject) {
            this.validate(c2, p, pm);
        } else if (o instanceof PrimitiveLineObject) {
            this.validate(c2, p, pm);
        } else if (o instanceof PrimitiveCircleObject) {
            this.validate(c2, p, pm);
        } else if (o instanceof QuadricObject) {
            this.validate(c2, p, pm);
        } else if (o instanceof TrackObject) {
            this.validate(c2, p, pm);
        } else if (o instanceof AreaObject) {
            this.validate(c2, p, pm);
        }
    }

    public void validate(Construction c2, ConstructionObject o, ConstructionObject avoid) {
        if (o.RekValidating) {
            return;
        }
        o.RekValidating = true;
        Enumeration e2 = c2.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).setRekFlag(false);
        }
        this.recursiveValidate(o, avoid);
        e2 = c2.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject oc = (ConstructionObject)e2.nextElement();
            if (!oc.isRekFlag()) continue;
            this.RefreshList.addElement(oc);
        }
        o.RekValidating = false;
    }

    public void recursiveValidate(ConstructionObject o, ConstructionObject avoid) {
        if (o.isRekFlag() || o == avoid) {
            return;
        }
        o.setRekFlag(true);
        ConstructionObject[] d2 = o.getDepArray();
        for (int i = 0; i < d2.length; ++i) {
            this.recursiveValidate(d2[i], avoid);
        }
    }

    public synchronized void refresh() {
        Enumeration e2 = this.RefreshList.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject oc = (ConstructionObject)e2.nextElement();
            oc.validate();
        }
    }

    private static void setConstants(ZirkelCanvas zc) {
        double r;
        a = r = Math.sqrt(zc.DX * zc.DX + zc.DY * zc.DY);
        b = 1.5 * a;
        xmin = -b + (b - a) / 1000.0;
    }

    public static double fline(double x) {
        if (Math.abs(x) < a) {
            return x;
        }
        double s = Math.signum(x);
        return s * (2.0 * a - b) + (b - a) * (b - a) / (s * b - x);
    }

    public synchronized void docomputeCircle(ZirkelCanvas zc) {
        PrimitiveCircleObject c2 = (PrimitiveCircleObject)this.O;
        double x = c2.getX();
        double y = c2.getY();
        double r = c2.getR();
        double dt = Math.PI * 2 * this.DMin;
        int nbsteps = (int)Math.round(1.0 / this.DMin) + 1;
        for (int i = 0; i < nbsteps; ++i) {
            this.PM.move(x + r * Math.cos((double)i * dt), y + r * Math.sin((double)i * dt));
            this.refresh();
            if (!this.P.valid()) continue;
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeLine(ZirkelCanvas zc) {
        zc.getConstruction().shouldSwitch(false);
        PrimitiveLineObject l = (PrimitiveLineObject)this.O;
        JLocusTrackObject.setConstants(zc);
        double da = -2.0 * xmin * this.DMin;
        double lx = l.getX();
        double ly = l.getY();
        double ldx = l.getDX();
        double ldy = l.getDY();
        int nbsteps = (int)Math.round(1.0 / this.DMin) + 1;
        for (int i = 0; i < nbsteps; ++i) {
            double delta = JLocusTrackObject.fline(xmin + (double)i * da);
            this.PM.move(lx + ldx * delta, ly + ldy * delta);
            this.refresh();
            if (!this.P.valid()) continue;
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeRay(ZirkelCanvas zc) {
        zc.getConstruction().shouldSwitch(false);
        PrimitiveLineObject l = (PrimitiveLineObject)this.O;
        JLocusTrackObject.setConstants(zc);
        double da = -xmin * this.DMin;
        double lx = l.getX();
        double ly = l.getY();
        double ldx = l.getDX();
        double ldy = l.getDY();
        int nbsteps = (int)Math.round(1.0 / this.DMin) + 1;
        for (int i = 0; i < nbsteps; ++i) {
            double delta = JLocusTrackObject.fline((double)i * da);
            this.PM.move(lx + ldx * delta, ly + ldy * delta);
            this.refresh();
            if (!this.P.valid()) continue;
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeSegments(ZirkelCanvas zc) {
        zc.getConstruction().shouldSwitch(false);
        PrimitiveLineObject l = (PrimitiveLineObject)this.O;
        double r = ((SegmentObject)l).getLength();
        double lx = l.getX();
        double ly = l.getY();
        double ldx = r * l.getDX() * this.DMin;
        double ldy = r * l.getDY() * this.DMin;
        int nbsteps = (int)Math.round(1.0 / this.DMin) + 1;
        for (int i = 0; i < nbsteps; ++i) {
            this.PM.move(lx + ldx * (double)i, ly + ldy * (double)i);
            this.refresh();
            if (!this.P.valid()) continue;
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeQuadric(ZirkelCanvas zc) {
        zc.getConstruction().shouldSwitch(false);
        QuadricObject q = (QuadricObject)this.O;
        double A = q.X[0];
        double B = q.X[1];
        double C = q.X[2];
        double D = q.X[3];
        double E = q.X[4];
        double F = q.X[5];
        double dt = Math.PI * this.DMin;
        double X1 = q.P[0].getX();
        double Y1 = q.P[0].getY();
        double M = 0.0;
        double N2 = 0.0;
        double P1 = 0.0;
        int nbsteps = (int)Math.round(1.0 / this.DMin) + 1;
        for (int i = 0; i < nbsteps; ++i) {
            M = -Math.sin((double)i * dt + 0.01);
            N2 = Math.cos((double)i * dt + 0.01);
            P1 = -(M * X1 + N2 * Y1);
            double x1 = 0.0;
            double x2 = 0.0;
            double y1 = 0.0;
            double y2 = 0.0;
            double part1 = -2.0 * B * M * P1 - C * N2 * N2 + D * M * N2 + E * N2 * P1;
            double part2 = Math.abs(N2) * Math.sqrt(-2.0 * M * D * N2 * C + 4.0 * P1 * D * A * N2 + 4.0 * P1 * M * B * C + 4.0 * E * M * N2 * F - 2.0 * E * P1 * N2 * C - 2.0 * E * P1 * M * D - 4.0 * M * M * B * F - 4.0 * P1 * P1 * A * B - 4.0 * A * N2 * N2 * F + N2 * N2 * C * C + M * M * D * D + E * E * P1 * P1);
            double part3 = 2.0 * A * N2 * N2 + 2.0 * B * M * M + -2.0 * E * M * N2;
            x1 = (part1 + part2) / part3;
            y1 = (-M * x1 - P1) / N2;
            x2 = (part1 - part2) / part3;
            y2 = (-M * x2 - P1) / N2;
            if ((x2 - x1) / N2 < 0.0) {
                double c1 = x1;
                double r1 = y1;
                x1 = x2;
                y1 = y2;
                x2 = c1;
                y2 = r1;
            }
            if (Math.abs(X1 - x1) < 1.0E-10 && Math.abs(X1 - x1) < 1.0E-10) {
                this.PM.move(x2, y2);
            } else {
                this.PM.move(x1, y1);
            }
            this.refresh();
            if (!this.P.valid()) continue;
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeExpression(ZirkelCanvas zc) {
        zc.getConstruction().shouldSwitch(false);
        this.EO = (ExpressionObject)this.O;
        if (!this.EO.isSlider()) {
            return;
        }
        int nbsteps = (int)Math.round(1.0 / this.DMin) + 1;
        for (int i = 0; i < nbsteps; ++i) {
            this.EO.setSliderPosition(this.DMin * (double)i);
            this.refresh();
            if (!this.P.valid()) continue;
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeTrack(ZirkelCanvas zc) {
        zc.getConstruction().shouldSwitch(false);
        JLocusTrackObject TR = (JLocusTrackObject)this.O;
        Enumeration e2 = TR.V.elements();
        while (e2.hasMoreElements()) {
            this.C = (Coordinates)e2.nextElement();
            this.PM.move(this.C.X, this.C.Y);
            this.refresh();
            if (!this.P.valid()) continue;
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void docomputeArea(ZirkelCanvas zc) {
        double yB;
        double xB;
        double yA;
        double xA;
        PointObject ORIGIN;
        zc.getConstruction().shouldSwitch(false);
        AreaObject poly = (AreaObject)this.O;
        int NVertex = poly.V.size();
        int nbsteps = (int)Math.round(1.0 / (this.DMin * (double)NVertex));
        if (nbsteps < 2) {
            nbsteps = 2;
        }
        PointObject A = ORIGIN = (PointObject)poly.V.get(0);
        PointObject B = null;
        for (int n = 1; n < NVertex; ++n) {
            B = (PointObject)poly.V.get(n);
            xA = A.getX();
            yA = A.getY();
            xB = B.getX();
            yB = B.getY();
            for (int i = 0; i <= nbsteps; ++i) {
                this.PM.move(xA + (double)i * (xB - xA) / (double)nbsteps, yA + (double)i * (yB - yA) / (double)nbsteps);
                this.refresh();
                if (!this.P.valid()) continue;
                this.addCoordinates(this.V, this.P);
            }
            A = B;
        }
        xA = A.getX();
        yA = A.getY();
        xB = ORIGIN.getX();
        yB = ORIGIN.getY();
        for (int i = 0; i <= nbsteps; ++i) {
            this.PM.move(xA + (double)i * (xB - xA) / (double)nbsteps, yA + (double)i * (yB - yA) / (double)nbsteps);
            this.refresh();
            if (!this.P.valid()) continue;
            this.addCoordinates(this.V, this.P);
        }
    }

    public synchronized void compute(ZirkelCanvas zc) {
        if (this.Fixed && !this.StartFix) {
            return;
        }
        this.V = new Vector();
        this.StartFix = false;
        double x = 0.0;
        double y = 0.0;
        if (this.PM != null) {
            x = this.PM.getX();
            y = this.PM.getY();
        }
        zc.getConstruction().clearSwitches();
        zc.getConstruction().shouldSwitch(true);
        this.DontProject = true;
        if (this.O instanceof SegmentObject) {
            this.docomputeSegments(zc);
        } else if (this.O instanceof QuadricObject) {
            this.docomputeQuadric(zc);
        } else if (this.O instanceof JLocusTrackObject) {
            this.docomputeTrack(zc);
        } else if (this.O instanceof AreaObject) {
            this.docomputeArea(zc);
        } else if (this.O instanceof ExpressionObject) {
            this.docomputeExpression(zc);
        } else if (this.O instanceof RayObject) {
            this.docomputeRay(zc);
        } else if (this.O instanceof PrimitiveCircleObject) {
            this.docomputeCircle(zc);
        } else if (this.O instanceof PrimitiveLineObject) {
            this.docomputeLine(zc);
        }
        this.DontProject = false;
        zc.getConstruction().shouldSwitch(false);
        zc.getConstruction().clearSwitches();
        if (this.PM != null) {
            this.PM.move(x, y);
            this.refresh();
        }
        zc.dovalidate();
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        Coordinates C;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        Enumeration e2 = this.V.elements();
        if (this.indicated()) {
            boolean sel = this.P.indicated();
            this.P.setIndicated(true);
            g.setColor(this.P);
            this.P.setIndicated(sel);
        } else {
            g.setColor(this);
        }
        PolygonDrawer pd = new PolygonDrawer(g, this);
        if (e2.hasMoreElements()) {
            C = (Coordinates)e2.nextElement();
            this.c0 = zc.col(C.X);
            this.r0 = zc.row(C.Y);
            pd.startPolygon(this.c0, this.r0);
        }
        while (e2.hasMoreElements()) {
            C = (Coordinates)e2.nextElement();
            double c2 = zc.col(C.X);
            double r = zc.row(C.Y);
            if (Math.abs(pd.c() - c2) < 1000.0 && Math.abs(pd.r() - r) < 1000.0) {
                pd.drawTo(c2, r);
                continue;
            }
            pd.finishPolygon();
            pd.startPolygon(c2, r);
        }
        pd.finishPolygon();
    }
}

