/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import com.hartmath.expression.HDouble;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HObject;
import com.hartmath.lib.C;
import com.hartmath.lib.Scanner;
import com.hartmath.lib.SessionData;
import geonext.Coordinates;
import geonext.Element;
import geonext.ElementSet;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.PathPoint;
import geonext.Point;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Vector;

public class ParameterCurve
extends Element {
    String sx;
    String sy;
    String sRangeMin;
    String sRangeMax;
    HObject hx;
    HObject hy;
    HObject hRangeMin;
    HObject hRangeMax;
    HObject hxvalue;
    HObject hyvalue;
    Vector path;
    boolean firstRun = true;
    double[] bounds = new double[2];
    public String internalname;

    public ParameterCurve() {
        this.initParameterCurve();
    }

    public ParameterCurve(String string, int n, String string2, String string3, String string4, String string5, int n2, int n3) {
        super(string, n, n3);
        this.initParameterCurve();
        this.sx = string2;
        this.sy = string3;
        this.sRangeMin = string4;
        this.sRangeMax = string5;
        this.internalname = "ipp" + n2;
        this.declareFunction();
        this.setFirstRun(true);
    }

    public double[] calculate(double d) {
        double[] dArray = new double[]{this.subandeval(this.hxvalue, d), this.subandeval(this.hyvalue, d)};
        return dArray;
    }

    public void declareFunction() {
        Scanner scanner = new Scanner(this.internalname + "x(t)=" + this.sx, true);
        SessionData sessionData = SessionData.currentSessionData();
        sessionData.currentElement = this;
        this.hx = scanner.start();
        C.GEV(this.hx);
        scanner = new Scanner(this.internalname + "y(t)=" + this.sy, true);
        sessionData = SessionData.currentSessionData();
        this.hy = scanner.start();
        C.GEV(this.hy);
        this.hxvalue = new Scanner(this.internalname + "x(t)").start();
        this.hyvalue = new Scanner(this.internalname + "y(t)").start();
        scanner = new Scanner(this.sRangeMin, true);
        this.hRangeMin = scanner.start();
        scanner = new Scanner(this.sRangeMax, true);
        this.hRangeMax = scanner.start();
        sessionData.currentElement = null;
    }

    public String description() {
        return this.generateDesc(Geonext.language.getString("parametercurve_description"));
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        if (this.exists() && this.isVisible()) {
            graphics2D.setStroke(jBoardPane.setStroke(this.getStrokeWidth(), this.getDash()));
            if (!this.isDraft()) {
                if (this.isMode() && jBoardPane.getModus() != 210260) {
                    graphics2D.setColor(this.getLighting());
                } else {
                    graphics2D.setColor(this.getStroke());
                }
            } else {
                graphics2D.setColor(this.getDraftColor());
            }
            boolean bl = false;
            Color color = Color.green;
            Color color2 = Color.red;
            if (!bl) {
                color = graphics2D.getColor();
                color2 = graphics2D.getColor();
            }
            if (this.getPath().size() > 1) {
                PathPoint pathPoint = (PathPoint)this.getPath().get(0);
                graphics2D.setColor(color);
                for (int i = 0; i < this.getPath().size(); ++i) {
                    PathPoint pathPoint2 = (PathPoint)this.getPath().get(i);
                    if (pathPoint.isDrawtonext() && (pathPoint.getScreen().getWidth() >= 0.0 && pathPoint.getScreen().getWidth() <= (double)jBoardPane.getWidth() && pathPoint.getScreen().getHeight() >= 0.0 && pathPoint.getScreen().getHeight() <= (double)jBoardPane.getHeight() || pathPoint2.getScreen().getWidth() >= 0.0 && pathPoint2.getScreen().getWidth() <= (double)jBoardPane.getWidth() && pathPoint2.getScreen().getHeight() >= 0.0 && pathPoint2.getScreen().getHeight() <= (double)jBoardPane.getHeight())) {
                        double d;
                        double d2;
                        double d3;
                        double d4;
                        double d5 = pathPoint.getScreen().getWidth();
                        double d6 = pathPoint.getScreen().getHeight();
                        double d7 = pathPoint2.getScreen().getWidth();
                        double d8 = pathPoint2.getScreen().getHeight();
                        if (d5 < 0.0 || d5 > (double)jBoardPane.getWidth() || d6 < 0.0 || d6 > (double)jBoardPane.getHeight() || d7 < 0.0 || d7 > (double)jBoardPane.getWidth() || d8 < 0.0 || d8 > (double)jBoardPane.getHeight()) {
                            Coordinates[] coordinatesArray = new Coordinates[]{new Coordinates(d5, d6), new Coordinates(d7, d8)};
                            Coordinates[] coordinatesArray2 = jBoardPane.getLineToDraw(coordinatesArray, 10);
                            d4 = coordinatesArray2[0].getWidth();
                            d3 = coordinatesArray2[0].getHeight();
                            d2 = coordinatesArray2[1].getWidth();
                            d = coordinatesArray2[1].getHeight();
                        } else {
                            d4 = d5;
                            d3 = d6;
                            d2 = d7;
                            d = d8;
                        }
                        graphics2D.drawLine((int)d4, (int)d3, (int)d2, (int)d);
                        if (bl && graphics2D.getColor() == color) {
                            graphics2D.setColor(color2);
                        } else {
                            graphics2D.setColor(color);
                        }
                    }
                    pathPoint = pathPoint2;
                }
            }
        }
    }

    public boolean exists() {
        for (int i = 0; i < this.data().size(); ++i) {
            if (((Element)this.data().get(i)).exists()) continue;
            return false;
        }
        return true;
    }

    public void generateName(ElementSet elementSet) {
        boolean bl = false;
        String string = "";
        int n = elementSet.nameCounterParameterCurve++;
        String string2 = Geonext.language.getString("parametercurve_auto_name");
        while (!bl) {
            if (elementSet.searchName(string2 + "" + n) == null) {
                bl = true;
                continue;
            }
            string = "";
            ++elementSet.nameCounterParameterCurve;
        }
        this.setName(string2 + "" + n);
    }

    public double[] getBounds() {
        this.bounds[0] = new Double(C.NEV(this.hRangeMin).toString());
        this.bounds[1] = new Double(C.NEV(this.hRangeMax).toString());
        return this.bounds;
    }

    public String getMax() {
        return this.getSRangeMax();
    }

    public String getMin() {
        return this.getSRangeMin();
    }

    public Vector getPath() {
        return this.path;
    }

    public String getSRangeMax() {
        return this.hRangeMax.toString();
    }

    public String getSRangeMin() {
        return this.hRangeMin.toString();
    }

    public String getSx() {
        return this.hx.toString().substring(this.hx.toString().indexOf("=") + 1, this.hx.toString().length());
    }

    public String getSy() {
        return this.hy.toString().substring(this.hy.toString().indexOf("=") + 1, this.hy.toString().length());
    }

    public void initParameterCurve() {
        this.dataVector = new Vector();
        this.stroke = new Color(0, 128, 192);
        this.fill = new Color(0, 0, 255, 100);
        this.lighting = Color.cyan;
        this.label = new Color(0, 0, 0, 0);
        this.strokeWidth = 1;
        this.typeString = "parametercurve";
        this.setElementName(Geonext.language.getString("parametercurve_element_name"));
    }

    public boolean parse(JBoardPane jBoardPane, String string) {
        try {
            String string2 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string3 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            String string4 = this.tag(string3, "functionx")[1];
            String string5 = this.tag(string3, "functiony")[1];
            String string6 = this.tag(string3, "min")[1];
            String string7 = this.tag(string3, "max")[1];
            if (string4.equals("") || string5.equals("") || string6.equals("") || string7.equals("")) {
                return false;
            }
            int n = jBoardPane.element.parameterCurveCounter;
            jBoardPane.createParameterCurve(string4, string5, string6, string7, string2, false);
            if (n == jBoardPane.element.parameterCurveCounter) {
                return false;
            }
            ParameterCurve parameterCurve = (ParameterCurve)jBoardPane.element.parameterCurve.lastElement();
            string = parameterCurve.parseProperties(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setBounds(double[] dArray) {
        this.bounds = dArray;
    }

    public void setFirstRun(boolean bl) {
        this.firstRun = bl;
    }

    public void setMax(String string) {
        this.sRangeMax = string;
        this.declareFunction();
    }

    public void setMin(String string) {
        this.sRangeMin = string;
        this.declareFunction();
    }

    public String writeData(String string) {
        String string2 = "";
        string2 = string2 + string + "<functionx>" + this.getSx() + "</functionx>\n ";
        string2 = string2 + string + "<functiony>" + this.getSy() + "</functiony>\n ";
        string2 = string2 + string + "<min>" + this.getMin() + "</min>\n ";
        string2 = string2 + string + "<max>" + this.getMax() + "</max>\n ";
        return string2;
    }

    public Vector data() {
        return this.dataVector;
    }

    public String shortInfo() {
        return this.generateShort(Geonext.language.getString("parametercurve_short"));
    }

    public double subandeval(HObject hObject, double d) {
        ((HFunction)hObject).getA()[0] = new HDouble(d);
        HObject hObject2 = C.NEV(hObject);
        try {
            return new Double(hObject2.toString());
        }
        catch (Exception exception) {
            return new Double(C.NEV(hObject2).toString());
        }
    }

    public void calculate(JBoardPane jBoardPane, boolean bl) {
        this.calculateChanged(bl);
        if (this.isChanged()) {
            if (this.dataVector.size() > 0) {
                this.redeclareFunction();
            }
            C.boardName = jBoardPane.internalName;
            this.path = new Vector();
            int n = 0;
            this.getBounds();
            double d = (this.bounds[1] - this.bounds[0]) / (30.0 * jBoardPane.zoom.width);
            double d2 = this.bounds[0] - d;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = d / 10.0;
            double d6 = d5 * 20.0;
            boolean bl2 = false;
            boolean bl3 = false;
            PathPoint pathPoint = null;
            PathPoint pathPoint2 = null;
            Point point = new Point();
            double d7 = Math.log(jBoardPane.zoom.getWidth()) / Math.log(1500.0);
            while (!bl2) {
                ++n;
                if (d2 > this.bounds[1] - d) {
                    d2 = this.bounds[1] - d;
                    bl2 = true;
                }
                double[] dArray = this.calculate(d2 += d);
                point = new Point();
                point.setUser(dArray);
                jBoardPane.user2screen(point);
                try {
                    if (pathPoint != null && pathPoint2 != null) {
                        double d8 = 0.0;
                        double d9 = 0.0;
                        double d10 = 0.0;
                        double d11 = 0.0;
                        try {
                            d3 = Math.sqrt(Math.pow(pathPoint.getUser().getWidth() - point.getUser().getWidth(), 2.0) + Math.pow(pathPoint.getUser().getHeight() - point.getUser().getHeight(), 2.0));
                            d8 = (pathPoint2.getScreen().getHeight() - pathPoint.getScreen().getHeight()) / (pathPoint2.getScreen().getWidth() - pathPoint.getScreen().getWidth());
                            d9 = (pathPoint.getScreen().getHeight() - point.getScreen().getHeight()) / (pathPoint.getScreen().getWidth() - point.getScreen().getWidth());
                            d10 = d9 / d8;
                            d11 = Math.abs(d9 - d8);
                        }
                        catch (Exception exception) {
                            d10 = pathPoint2.getScreenY() - pathPoint.getScreenY() < 2 ? 0.5 : 0.1;
                        }
                        if (d11 == 0.0 | d8 == 0.0 | (d <= d5 | (Math.abs(d11 * (pathPoint.getUser().getWidth() - point.getUser().getWidth())) <= 5.0 && d10 >= 0.65 * (d7 + 1.0) && d10 * (d7 + 1.0) <= 1.6) | pathPoint.equals(point))) {
                            bl3 = false;
                            pathPoint2 = pathPoint;
                            if (d3 - d4 > 50.0 * jBoardPane.zoom.getWidth() && d3 / d4 > 0.99 || d <= d5 && d3 > 300.0 * jBoardPane.zoom.getWidth()) {
                                try {
                                    ((PathPoint)this.path.get(this.path.size() - 1)).setDrawtonext(false);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            pathPoint = new PathPoint(point.getUser(), point.getScreen(), d2, true);
                            this.path.addElement(pathPoint);
                            if (Math.abs(d11 * (pathPoint.getUser().getWidth() - point.getUser().getWidth())) <= 2.5 && (d11 == 0.0 || d10 >= 0.8 * (d7 + 1.0) && d10 <= 1.3 * (d7 + 1.0)) && (d += d / 20.0) > d6) {
                                d = d6;
                            }
                            d4 = d3;
                            continue;
                        }
                        bl3 = true;
                        bl2 = false;
                        d2 -= d;
                        if (!((d -= d / 10.0) < d5)) continue;
                        d = d5;
                        continue;
                    }
                    pathPoint2 = pathPoint;
                    pathPoint = new PathPoint(point.getUser(), point.getScreen(), d2, true);
                    this.path.addElement(pathPoint);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void redeclareFunction() {
        Scanner scanner = new Scanner(this.internalname + "xn(t)=N(" + this.internalname + "x(t))", true);
        SessionData sessionData = SessionData.currentSessionData();
        sessionData.currentElement = this;
        C.GEV(scanner.start());
        scanner = new Scanner(this.internalname + "yn(t)=N(" + this.internalname + "y(t))", true);
        sessionData = SessionData.currentSessionData();
        C.GEV(scanner.start());
        this.hxvalue = new Scanner(this.internalname + "xn(t)").start();
        this.hyvalue = new Scanner(this.internalname + "yn(t)").start();
        sessionData.currentElement = null;
    }
}

