/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import com.hartmath.expression.HObject;
import com.hartmath.lib.C;
import com.hartmath.lib.Scanner;
import com.hartmath.lib.SessionData;
import geonext.Coordinates;
import geonext.Element;
import geonext.ElementSet;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.Line;
import geonext.Point;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import util.Base64;
import util.IO;

public class Circle
extends Element
implements MouseListener,
MouseMotionListener {
    public Point P;
    public Point R;
    public Point M;
    HObject hradius;
    public int rx;
    public Line l;
    public Circle c;
    public Line k;
    public String radius;
    public double radiusValue;

    public Circle() {
        this.initCircle();
        this.M = new Point();
        this.M.setChanged(false);
        this.P = new Point();
        this.P.setChanged(false);
        this.k = null;
        this.l = null;
        this.c = null;
        this.R = null;
        this.radius = null;
    }

    public void drawImage(Graphics2D graphics2D, JBoardPane jBoardPane) {
        if (this.getImage() != null) {
            try {
                double d = 2.0 * this.getM().getScreen().distance(this.getP().getScreen());
                double d2 = this.getImage().getWidth(null);
                double d3 = this.getImage().getHeight(null);
                Image image = this.getImage();
                image = image.getScaledInstance((int)d, (int)(d * d3 / d2), 2);
                MediaTracker mediaTracker = new MediaTracker(jBoardPane);
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForID(0);
                d2 = image.getWidth(null);
                d3 = image.getHeight(null);
                graphics2D.drawImage(image, (int)(this.getM().getScreenX() - this.distance(this.getM(), this.getP())), (int)(this.getM().getScreenY() - d3 / 2.0), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Circle(String string, int n, Point point, Circle circle, int n2) {
        super(string, n, n2);
        this.initCircle();
        this.M = point;
        this.P = new Point();
        this.P.setChanged(false);
        this.k = null;
        this.l = null;
        this.c = circle;
        this.R = null;
        this.radius = null;
        this.P.setUser(this.M.getUserX() + this.distance(this.c.getM(), this.c.getP()), this.M.getUserY());
    }

    public Circle(String string, int n, Point point, Line line, int n2) {
        super(string, n, n2);
        this.initCircle();
        this.M = point;
        this.P = new Point();
        this.P.setChanged(false);
        this.k = null;
        this.l = line;
        this.c = null;
        this.R = null;
        this.radius = null;
        this.P.setUser(this.M.getUserX() + this.distance(this.l.getA(), this.l.getB()), this.M.getUserY());
    }

    public Circle(String string, int n, Point point, Line line, Line line2, int n2) {
        super(string, n, n2);
        this.initCircle();
        this.M = point;
        this.P = new Point();
        this.P.setChanged(false);
        this.k = line2;
        this.l = line;
        this.c = null;
        this.R = null;
        this.radius = null;
        this.P.setUser(this.M.getUserX() + this.distance(this.l.getA(), this.l.getB()) + this.distance(this.k.getA(), this.k.getB()), this.M.getUserY());
    }

    public Circle(String string, int n, Point point, Point point2, int n2) {
        super(string, n, n2);
        this.initCircle();
        this.M = point;
        this.P = point2;
        this.k = null;
        this.l = null;
        this.c = null;
        this.R = null;
        this.radius = null;
    }

    public Circle(String string, int n, Point point, String string2, int n2) {
        super(string, n, n2);
        this.initCircle();
        this.M = point;
        this.P = null;
        this.k = null;
        this.l = null;
        this.c = null;
        this.R = new Point();
        this.R.setChanged(false);
        this.radius = string2;
        SessionData sessionData = SessionData.currentSessionData();
        sessionData.currentElement = this;
        Scanner scanner = new Scanner(this.radius);
        this.hradius = scanner.start();
    }

    public void calculate(boolean bl) {
        this.calculateChanged(bl);
        if (this.isChanged()) {
            this.getP();
        }
    }

    public void calculate(JBoardPane jBoardPane, boolean bl) {
        this.calculateChanged(bl);
        if (this.isChanged()) {
            if (this.radius != null) {
                try {
                    C.boardName = jBoardPane.internalName;
                    SessionData sessionData = SessionData.currentSessionData();
                    sessionData.currentElement = this;
                    HObject hObject = C.NEV(this.hradius);
                    try {
                        this.radiusValue = new Double(hObject.toString());
                    }
                    catch (Exception exception) {
                        this.radiusValue = new Double(C.NEV(hObject).toString());
                    }
                    sessionData.currentElement = null;
                    this.setActive(true);
                    this.getR().setUser(this.getM().getUserX() + this.radiusValue, this.getM().getUserY());
                    jBoardPane.user2screen(this.getR());
                }
                catch (Exception exception) {
                    this.setActive(false);
                }
            }
            this.getP();
        }
    }

    public Vector data() {
        Vector vector = new Vector();
        for (int i = 0; i < this.dataVector.size(); ++i) {
            vector.addElement(this.dataVector.get(i));
        }
        vector.addElement(this.getM());
        vector.addElement(this.getP());
        vector.addElement(this.getK());
        vector.addElement(this.getL());
        vector.addElement(this.getC());
        while (vector.contains(null)) {
            vector.remove(null);
        }
        return vector;
    }

    public String description() {
        if (this.getL() != null) {
            return this.generateDesc(Geonext.language.getString("circle_description_a"));
        }
        if (this.getC() != null) {
            return this.generateDesc(Geonext.language.getString("circle_description_b"));
        }
        if (this.getR() != null) {
            return this.generateDesc(Geonext.language.getString("circle_description_c"));
        }
        return this.generateDesc(Geonext.language.getString("circle_description_d"));
    }

    public double distance(Point point, Point point2) {
        return Math.sqrt((point.getScreenX() - point2.getScreenX()) * (point.getScreenX() - point2.getScreenX()) + (point.getScreenY() - point2.getScreenY()) * (point.getScreenY() - point2.getScreenY()));
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        if (this.exists() && this.isVisible()) {
            this.drawImage(graphics2D, jBoardPane);
            graphics2D.setStroke(jBoardPane.setStroke(this.getStrokeWidth(), this.getDash()));
            double d = jBoardPane.user2screenX(this.getM().userDistance(this.getP())) - jBoardPane.origin.getWidth();
            double d2 = -jBoardPane.user2screenY(this.getM().userDistance(this.getP())) + jBoardPane.origin.getHeight();
            if (!this.isDraft()) {
                graphics2D.setColor(this.getFill());
                graphics2D.fillOval(jBoardPane.round(jBoardPane.user2screenX(this.getM().getUserX()) - d), jBoardPane.round(jBoardPane.user2screenY(this.getM().getUserY()) - d2), jBoardPane.round(2.0 * d), jBoardPane.round(2.0 * d2));
                if (this.isMode() && jBoardPane.getModus() != 210260) {
                    graphics2D.setColor(this.getLighting());
                } else {
                    graphics2D.setColor(this.getStroke());
                }
            } else {
                graphics2D.setColor(this.getDraftColor());
            }
            graphics2D.drawOval(jBoardPane.round(jBoardPane.user2screenX(this.getM().getUserX()) - d), jBoardPane.round(jBoardPane.user2screenY(this.getM().getUserY()) - d2), jBoardPane.round(2.0 * d), jBoardPane.round(2.0 * d2));
            if (this.isNameDrawed()) {
                double d3 = this.getP().getScreenX() - this.getM().getScreenX();
                double d4 = this.getP().getScreenY() - this.getM().getScreenY();
                if (!this.isDraft()) {
                    graphics2D.setColor(this.getLabel());
                } else {
                    graphics2D.setColor(this.getDraftColor());
                }
                if (this.isTextName() && this.getNameText() != null) {
                    jBoardPane.drawName(graphics2D, this.getNameText(), jBoardPane.round(this.getM().getScreenX() - d3 * 0.9), jBoardPane.round(this.getM().getScreenY() - d4 * 0.9), graphics2D.getColor(), 0, 12);
                } else {
                    jBoardPane.drawName(graphics2D, this.getName(), jBoardPane.round(this.getM().getScreenX() - d3 * 0.9), jBoardPane.round(this.getM().getScreenY() - d4 * 0.9), graphics2D.getColor(), 0, 12);
                }
            }
        }
    }

    public boolean exists() {
        if (this.isActive()) {
            if (this.R == null) {
                if (this.c == null) {
                    if (this.l == null) {
                        return this.M.exists() && this.P.exists();
                    }
                    if (this.k == null) {
                        return this.M.exists() && this.l.exists();
                    }
                    return this.M.exists() && this.l.exists() | this.k.exists();
                }
                return this.M.exists() && this.c.exists();
            }
            for (int i = 0; i < this.data().size(); ++i) {
                if (((Element)this.data().get(i)).exists()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void generateName(ElementSet elementSet) {
        boolean bl = false;
        String string = "";
        int n = elementSet.nameCounterCircle++;
        String string2 = Geonext.language.getString("circle_auto_name");
        while (!bl) {
            while (n > -1) {
                string = "" + (char)(97 + n % 26) + string;
                n = (n - n % 26) / 26 - 1;
            }
            if (elementSet.searchName(string2 + "_" + string) == null) {
                bl = true;
                continue;
            }
            string = "";
            ++elementSet.nameCounterCircle;
        }
        this.setName(string2 + "_" + string);
    }

    public Circle getC() {
        return this.c;
    }

    public Line getK() {
        return this.k;
    }

    public Line getL() {
        return this.l;
    }

    public Point getM() {
        return this.M;
    }

    public Point getP() {
        if (this.radius == null) {
            if (this.c == null) {
                if (this.l == null) {
                    return this.P;
                }
                if (this.k == null) {
                    this.P.setScreen(this.M.getScreenX() + this.distance(this.l.getA(), this.l.getB()), this.M.getScreenY());
                    this.P.setUser(this.M.getUserX() + this.userDistance(this.l.getA(), this.l.getB()), this.M.getUserY());
                    return this.P;
                }
                double d = 0.0;
                double d2 = 0.0;
                if (this.l.exists()) {
                    d = this.distance(this.l.getA(), this.l.getB());
                }
                if (this.k.exists()) {
                    d2 = this.distance(this.k.getA(), this.k.getB());
                }
                this.P.setScreen(this.M.getScreenX() + d + d2, this.M.getScreenY());
                double d3 = 0.0;
                double d4 = 0.0;
                if (this.l.exists()) {
                    d3 = this.userDistance(this.l.getA(), this.l.getB());
                }
                if (this.k.exists()) {
                    d4 = this.userDistance(this.k.getA(), this.k.getB());
                }
                this.P.setUser(this.M.getUserX() + d3 + d4, this.M.getUserY());
                return this.P;
            }
            this.P.setScreen(this.M.getScreenX() + this.distance(this.c.getM(), this.c.getP()), this.M.getScreenY());
            this.P.setUser(this.M.getUserX() + this.userDistance(this.c.getM(), this.c.getP()), this.M.getUserY());
            return this.P;
        }
        return this.R;
    }

    public Point getR() {
        return this.R;
    }

    public String getRadius() {
        return this.radius;
    }

    public double getRadiusValue() {
        return this.radiusValue;
    }

    public Coordinates getTextAnchor() {
        return this.getM().user;
    }

    public void initCircle() {
        this.area = 3;
        this.stroke = Color.blue;
        this.fill = new Color(0, 255, 0, 0);
        this.lighting = Color.cyan;
        this.label = new Color(0, 0, 0, 0);
        this.typeString = "circle";
        this.setElementName(Geonext.language.getString("circle_element_name"));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        double d;
        double d2 = Math.sqrt((this.getM().getScreenX() - this.getP().getScreenX()) * (this.getM().getScreenX() - this.getP().getScreenX()) + (this.getM().getScreenY() - this.getP().getScreenY()) * (this.getM().getScreenY() - this.getP().getScreenY()));
        if (d2 - (d = Math.sqrt((this.getM().getScreenX() - (double)mouseEvent.getX()) * (this.getM().getScreenX() - (double)mouseEvent.getX()) + (this.getM().getScreenY() - (double)mouseEvent.getY()) * (this.getM().getScreenY() - (double)mouseEvent.getY()))) < (double)this.area & d - d2 < (double)this.area && this.isVisible()) {
            this.setMode(true);
        } else {
            this.setMode(false);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parse(JBoardPane jBoardPane, String string) {
        try {
            String string2 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string3 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            Point point = (Point)jBoardPane.element.searchLoadID(this.tag(string3, "midpoint")[1]);
            Element element = jBoardPane.element.searchLoadID(this.tag(string3, "radius")[1]);
            String string4 = this.tag(string3, "radiusvalue")[1];
            if (point == null || element == null || point.equals(element) || !(element instanceof Point) && !(element instanceof Line) && !(element instanceof Circle)) {
                if (string4.equals("")) return false;
                jBoardPane.createCircle(point, string4, string2, false);
            } else if (element instanceof Point) {
                jBoardPane.createCircle(point, (Point)element, string2, false);
            } else if (element instanceof Line) {
                jBoardPane.createCircle(point, (Line)element, string2, false);
            } else {
                jBoardPane.createCircle(point, (Circle)element, string2, false);
            }
            Circle circle = (Circle)jBoardPane.element.circle.lastElement();
            string = circle.parseProperties(jBoardPane, string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String parseProperties(JBoardPane jBoardPane, String string) {
        super.parseProperties(string);
        if (this.tag(string, "image")[1].length() > 0) {
            Object object;
            Image image = null;
            try {
                image = jBoardPane.getToolkit().createImage(Base64.decode(this.tag(string, "image")[1]));
                string = this.tag(string, "image")[0];
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (image != null) {
                object = new MediaTracker(jBoardPane);
                ((MediaTracker)object).addImage(image, 1);
                try {
                    ((MediaTracker)object).waitForAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.image = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                object = this.image.createGraphics();
                ((Graphics)object).drawImage(image, 0, 0, null);
            }
            catch (Exception exception) {
                this.image = null;
            }
        }
        return string;
    }

    public String writeProperties(String string) {
        String string2 = "";
        string2 = string2 + super.writeProperties(string);
        string2 = string2 + string + "<image>";
        if (this.getImage() != null) {
            string2 = string2 + Base64.encodeBytes(IO.image2byteArray(this.getImage()));
        }
        string2 = string2 + "</image>\n";
        return string2;
    }

    public Coordinates screen2circle(Coordinates coordinates) {
        Point point = new Point();
        point.setScreen(coordinates.getWidth(), coordinates.getHeight());
        double d = this.screenDistance(this.getM(), point);
        if (Math.abs(d) < 1.0E-5) {
            d = 1.0E-5;
        }
        double d2 = this.screenDistance(this.getM(), this.getP()) / d;
        return new Coordinates(this.getM().getScreenX() - d2 * (this.getM().getScreenX() - point.getScreenX()), this.getM().getScreenY() - d2 * (this.getM().getScreenY() - point.getScreenY()));
    }

    public double screenDistance(Point point, Point point2) {
        return Math.sqrt((point.getScreenX() - point2.getScreenX()) * (point.getScreenX() - point2.getScreenX()) + (point.getScreenY() - point2.getScreenY()) * (point.getScreenY() - point2.getScreenY()));
    }

    public void setC(Circle circle) {
        this.c = circle;
    }

    public void setK(Line line) {
        this.k = line;
    }

    public void setL(Line line) {
        this.l = line;
    }

    public void setM(Point point) {
        this.M = point;
    }

    public void setP(Point point) {
        this.P = point;
    }

    public void setR(Point point) {
        this.R = point;
    }

    public void setRadius(String string) {
        this.radius = string;
    }

    public void setRadiusValue(double d) {
        this.radiusValue = d;
    }

    public String svg() {
        String string = new String();
        if (this.exists() && this.isVisible()) {
            int n = (int)Math.round(this.getM().getScreenX());
            int n2 = (int)Math.round(this.getM().getScreenY());
            int n3 = (int)Math.round(this.getP().getScreenX());
            int n4 = (int)Math.round(this.getP().getScreenY());
            if (!this.isDraft()) {
                string = string + "<circle cx=\"" + n + "\" cy=\"" + n2 + "\" r=\"" + (int)Math.round(this.distance(this.getM(), this.getP())) + "\" style=\"stroke-width:1; stroke:" + this.rgb2svgrgb(this.getStroke()) + "; fill:" + this.rgb2svgrgb(this.getFill()) + "; stroke-opacity:" + (double)this.getStroke().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getFill().getAlpha() / 255.0 + "\" />\n";
                string = string + "<text x=\"" + (this.getM().getScreenX() - (this.getP().getScreenX() - this.getM().getScreenX()) * 0.9) + "\" y=\"" + (this.getM().getScreenY() - (this.getP().getScreenY() - this.getM().getScreenY()) * 0.9) + "\" style=\"font-family: Arial; font-size: 12 pt; fill:";
                string = string + this.rgb2svgrgb(this.getLabel());
                string = string + "; fill-opacity:" + (double)this.getLabel().getAlpha() / 255.0;
                string = string + "\">" + this.generateSVGName(this.getName(), 12) + "</text>\n";
                return string;
            }
            string = string + "<line x1=\"" + (n - 3) + "\" y1=\"" + (n2 - 3) + "\" x2=\"" + (n + 3) + "\" y2=\"" + (n2 + 3) + "\" style=\"stroke-width:2; stroke:" + this.rgb2svgrgb(this.getDraftColor()) + "; fill:" + this.rgb2svgrgb(this.getDraftColor()) + "; stroke-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "\" />\n";
            string = string + "<line x1=\"" + (n - 3) + "\" y1=\"" + (n2 + 3) + "\" x2=\"" + (n + 3) + "\" y2=\"" + (n2 - 3) + "\" style=\"stroke-width:2; stroke:" + this.rgb2svgrgb(this.getDraftColor()) + "; fill:" + this.rgb2svgrgb(this.getDraftColor()) + "; stroke-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "\" />\n";
            string = string + "<text x=\"" + n + "\" y=\"" + (n2 - 10) + "\" style=\"font-family: Arial; font-size: 12 pt; fill:";
            string = string + this.rgb2svgrgb(this.getDraftColor());
            string = string + "; fill-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0;
            string = string + "\">" + this.generateSVGName(this.getName(), 12) + "</text>\n";
            return string;
        }
        return string;
    }

    public Coordinates user2circle(Coordinates coordinates) {
        Point point = new Point();
        point.setUserX(coordinates.getWidth());
        point.setUserY(coordinates.getHeight());
        double d = this.userDistance(this.getM(), point);
        if (Math.abs(d) < 1.0E-5) {
            d = 1.0E-5;
        }
        double d2 = this.userDistance(this.getM(), this.getP()) / d;
        return new Coordinates(this.getM().getUserX() - d2 * (this.getM().getUserX() - point.getUserX()), this.getM().getUserY() - d2 * (this.getM().getUserY() - point.getUserY()));
    }

    public double userDistance(Point point, Point point2) {
        return Math.sqrt((point.getUserX() - point2.getUserX()) * (point.getUserX() - point2.getUserX()) + (point.getUserY() - point2.getUserY()) * (point.getUserY() - point2.getUserY()));
    }

    public String writeData(String string) {
        String string2 = "";
        string2 = string2 + string + "<midpoint>" + this.getM().getId() + "</midpoint>\n ";
        if (this.getL() != null) {
            string2 = string2 + string + "<radius>" + this.getL().getId() + "</radius>\n ";
        } else if (this.getC() != null) {
            string2 = string2 + string + "<radius>" + this.getC().getId() + "</radius>\n ";
        } else if (this.getR() != null) {
            string2 = string2 + string + "<radiusvalue>" + this.hradius.toString() + "</radiusvalue>\n ";
            string2 = string2 + string + "<radiusnum>" + this.getM().userDistance(this.getP()) + "</radiusnum>\n ";
        } else {
            string2 = string2 + string + "<radius>" + this.getP().getId() + "</radius>\n ";
        }
        return string2;
    }

    public String shortInfo() {
        if (this.getParent() != null) {
            return this.getParent().shortInfo();
        }
        if (this.getL() != null) {
            return this.generateShort(Geonext.language.getString("circle_short_a"));
        }
        if (this.getC() != null) {
            return this.generateShort(Geonext.language.getString("circle_short_b"));
        }
        if (this.getR() != null) {
            return this.generateShort(Geonext.language.getString("circle_short_c"));
        }
        return this.generateShort(Geonext.language.getString("circle_short_d"));
    }
}

