/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.expression;

import com.hartmath.expression.HDouble;
import com.hartmath.expression.HFraction;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HRational;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import com.hartmath.lib.SessionData;
import java.math.BigInteger;
import java.util.Random;
import java.util.Vector;

public class HInteger
implements HObject,
HRational {
    protected BigInteger biggi;
    public static final byte[] I0 = new byte[]{0};
    public static final byte[] I1 = new byte[]{1};
    public static final byte[] I2 = new byte[]{2};
    public static final byte[] I3 = new byte[]{3};
    public static final byte[] I4 = new byte[]{4};
    public static final byte[] I5 = new byte[]{5};
    public static final byte[] I6 = new byte[]{6};
    public static final byte[] I7 = new byte[]{7};
    public static final byte[] I8 = new byte[]{8};
    public static final byte[] I9 = new byte[]{9};
    public static final byte[] I10 = new byte[]{10};
    public static final byte[] I100 = new byte[]{100};
    public static final byte[] IN1 = new byte[]{-1};
    public static final byte[] IN2 = new byte[]{-2};
    public static final byte[] IN3 = new byte[]{-3};
    public static final byte[] IN4 = new byte[]{-4};
    public static final byte[] IN5 = new byte[]{-5};
    public static final byte[] IN6 = new byte[]{-6};
    public static final byte[] IN7 = new byte[]{-7};
    public static final byte[] IN8 = new byte[]{-8};
    public static final byte[] IN9 = new byte[]{-9};
    public static final byte[] IN10 = new byte[]{-10};
    public static final BigInteger BN3 = new BigInteger(IN3);
    public static final BigInteger BN2 = new BigInteger(IN2);
    public static final BigInteger BN1 = new BigInteger(IN1);
    public static final BigInteger B0 = new BigInteger(I0);
    public static final BigInteger B1 = new BigInteger(I1);
    public static final BigInteger B2 = new BigInteger(I2);
    public static final BigInteger B3 = new BigInteger(I3);
    public static final BigInteger B10 = new BigInteger(I10);
    public Vector geonextElements = new Vector();

    public HInteger(byte[] byArray) {
        this.biggi = new BigInteger(byArray);
    }

    public HInteger(int n, byte[] byArray) {
        this.biggi = new BigInteger(n, byArray);
    }

    public HInteger(int n, int n2, Random random) {
        this.biggi = new BigInteger(n, n2, random);
    }

    public HInteger(int n, Random random) {
        this.biggi = new BigInteger(n, random);
    }

    public HInteger(String string) {
        this.biggi = new BigInteger(string);
    }

    public HInteger(int n) {
        this.biggi = new BigInteger(n + "");
    }

    public HInteger(String string, int n) {
        this.biggi = new BigInteger(string, n);
    }

    public HInteger(BigInteger bigInteger) {
        this.biggi = bigInteger;
    }

    public HObject abs() {
        return new HInteger(this.biggi.abs());
    }

    public HInteger add(HInteger hInteger) throws ArithmeticException {
        return new HInteger(this.biggi.add(hInteger.biggi));
    }

    public HInteger and(HInteger hInteger) {
        return new HInteger(this.biggi.and(hInteger.biggi));
    }

    public HInteger andNot(HInteger hInteger) {
        return new HInteger(this.biggi.andNot(hInteger.biggi));
    }

    public HObject apply(HObject hObject) {
        if (hObject instanceof HSymbol) {
            return C.EV(new HFunction((HSymbol)hObject, this));
        }
        if (hObject instanceof HFunction && ((HFunction)hObject).isPureFunction()) {
            HFunction hFunction = (HFunction)((HFunction)hObject).clone();
            hFunction.add(this);
            return C.EV(hFunction);
        }
        throw new HThrowException(C.HeadFormatError, C.Lambda, hObject);
    }

    public BigInteger bigIntegerValue() {
        return this.biggi;
    }

    public HObject ceil() {
        return this;
    }

    public boolean checkRange(long l, long l2) {
        return this.biggi.compareTo(BigInteger.valueOf(l)) >= 0 && this.biggi.compareTo(BigInteger.valueOf(l2)) <= 0;
    }

    public HInteger clearBit(int n) throws ArithmeticException {
        return new HInteger(this.biggi.clearBit(n));
    }

    public int compSignum() {
        return this.signum();
    }

    public HObject conjugate() {
        return this;
    }

    public HInteger denom() {
        return C.C1;
    }

    public HInteger divide(HInteger hInteger) throws ArithmeticException {
        return new HInteger(this.biggi.divide(hInteger.biggi));
    }

    public HInteger[] divideAndRemainder(HInteger hInteger) throws ArithmeticException {
        BigInteger[] bigIntegerArray = this.biggi.divideAndRemainder(hInteger.biggi);
        HInteger[] hIntegerArray = new HInteger[]{new HInteger(bigIntegerArray[0]), new HInteger(bigIntegerArray[1])};
        return hIntegerArray;
    }

    public double doubleValue() {
        return this.biggi.doubleValue();
    }

    public boolean equals(Object object) {
        if (object instanceof HInteger) {
            return this.biggi.equals(((HInteger)object).biggi);
        }
        return false;
    }

    public HObject evaluate() {
        if (SessionData.getCurrentNumericFlag()) {
            return new HDouble(this.doubleValue());
        }
        return null;
    }

    public HInteger flipBit(int n) throws ArithmeticException {
        return new HInteger(this.biggi.flipBit(n));
    }

    public float floatValue() {
        return this.biggi.floatValue();
    }

    public HObject floor() {
        return this;
    }

    public HInteger gcd(HInteger hInteger) {
        return new HInteger(this.biggi.gcd(hInteger.biggi));
    }

    public int getIntValue() {
        if (this.biggi.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) > 0 && this.biggi.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0) {
            return this.biggi.intValue();
        }
        return Integer.MIN_VALUE;
    }

    public int getLowestSetBit() {
        return this.biggi.getLowestSetBit();
    }

    public boolean greater(Object object) {
        if (object instanceof HObject) {
            return ((HObject)object).less(this);
        }
        return false;
    }

    public int hashCode() {
        return this.biggi.hashCode();
    }

    public HSymbol head() {
        return C.Integer;
    }

    public final int hierarchy() {
        return 4;
    }

    public HObject im() {
        return C.C0;
    }

    public int intValue() {
        return this.biggi.intValue();
    }

    public boolean isEqual(HInteger hInteger) {
        return this.biggi.equals(hInteger.biggi);
    }

    public boolean isEven() {
        return this.biggi.mod(B2).equals(B0);
    }

    public boolean isGreater(HInteger hInteger) {
        return hInteger.isLess(this);
    }

    public boolean isGreaterEqual(HInteger hInteger) {
        return hInteger.isLessEqual(this);
    }

    public boolean isHeadMember(HSymbol hSymbol) {
        return C.Integer.equals(hSymbol);
    }

    public boolean isLess(HInteger hInteger) {
        return this.biggi.compareTo(hInteger.biggi) == -1;
    }

    public boolean isLessEqual(HInteger hInteger) {
        return this.biggi.compareTo(hInteger.biggi) <= 0;
    }

    public boolean isList() {
        return false;
    }

    public boolean isMember(HObject hObject) {
        return this.equals(hObject);
    }

    public boolean isNegative() {
        return this.biggi.compareTo(B0) == -1;
    }

    public boolean isNonNegative() {
        return this.biggi.compareTo(B0) >= 0;
    }

    public boolean isNonZero() {
        return this.biggi.compareTo(B0) != 0;
    }

    public boolean isNumber() {
        return true;
    }

    public boolean isOdd() {
        return this.biggi.mod(B2).equals(B1);
    }

    public boolean isPositive() {
        return this.biggi.compareTo(B0) == 1;
    }

    public boolean isProbablePrime(int n) {
        return this.biggi.isProbablePrime(n);
    }

    public boolean isRational() {
        return true;
    }

    public boolean isUnequal(HInteger hInteger) {
        return !this.isEqual(hInteger);
    }

    public boolean isZero() {
        return this.biggi.compareTo(B0) == 0;
    }

    public boolean less(Object object) {
        if (object instanceof HFraction) {
            BigInteger bigInteger = ((HFraction)object).denom.multiply(this.biggi);
            return bigInteger.compareTo(((HFraction)object).numer) == -1;
        }
        if (object instanceof HInteger) {
            return this.biggi.compareTo(((HInteger)object).biggi) == -1;
        }
        if (object instanceof HObject) {
            return this.hierarchy() < ((HObject)object).hierarchy();
        }
        return false;
    }

    public long longValue() {
        return this.biggi.longValue();
    }

    public boolean matches(HObject hObject) {
        return this.equals(hObject);
    }

    public HInteger max(HInteger hInteger) {
        return new HInteger(this.biggi.max(hInteger.biggi));
    }

    public HInteger min(HInteger hInteger) {
        return new HInteger(this.biggi.min(hInteger.biggi));
    }

    public HInteger mod(HInteger hInteger) {
        return new HInteger(this.biggi.mod(hInteger.biggi));
    }

    public HInteger modInverse(HInteger hInteger) throws ArithmeticException {
        return new HInteger(this.biggi.modInverse(hInteger.biggi));
    }

    public HInteger modPow(HInteger hInteger, HInteger hInteger2) {
        return new HInteger(this.biggi.modPow(hInteger.biggi, hInteger2.biggi));
    }

    public HInteger multiply(HInteger hInteger) {
        return new HInteger(this.biggi.multiply(hInteger.biggi));
    }

    public HInteger negate() {
        return new HInteger(this.biggi.negate());
    }

    public HInteger not() {
        return new HInteger(this.biggi.not());
    }

    public HInteger numer() {
        return this;
    }

    public HInteger or(HInteger hInteger) {
        return new HInteger(this.biggi.or(hInteger.biggi));
    }

    public HInteger pow(int n) throws ArithmeticException {
        return new HInteger(this.biggi.pow(n));
    }

    public int precedence() {
        if (this.biggi.compareTo(B0) == -1) {
            return 100;
        }
        return 999999;
    }

    public HObject re() {
        return this;
    }

    public HInteger remainder(HInteger hInteger) throws ArithmeticException {
        return new HInteger(this.biggi.remainder(hInteger.biggi));
    }

    public HInteger root(int n) throws ArithmeticException {
        if (this.isNegative()) {
            throw new ArithmeticException();
        }
        int n2 = n - 1;
        HInteger hInteger = HInteger.valueOf(n2);
        HInteger hInteger2 = HInteger.valueOf(n);
        HInteger hInteger3 = this;
        HInteger hInteger4 = this.add(hInteger).divide(hInteger2);
        while (hInteger4.isLess(hInteger3)) {
            hInteger3 = hInteger4;
            hInteger4 = this.add(hInteger.multiply(hInteger3.pow(n))).divide(hInteger2.multiply(hInteger3.pow(n2)));
        }
        return hInteger3;
    }

    public HObject round(HDouble hDouble) {
        return this;
    }

    public HObject round(HInteger hInteger) {
        return this;
    }

    public HInteger setBit(int n) throws ArithmeticException {
        return new HInteger(this.biggi.setBit(n));
    }

    public HInteger shiftLeft(int n) {
        return new HInteger(this.biggi.shiftLeft(n));
    }

    public HInteger shiftRight(int n) {
        return new HInteger(this.biggi.shiftRight(n));
    }

    public int signum() {
        return this.biggi.signum();
    }

    public HObject substitute(HObject hObject, HObject hObject2) {
        if (this.equals(hObject)) {
            return hObject2;
        }
        return this;
    }

    public HObject substitutePattern() {
        return this;
    }

    public HInteger subtract(HInteger hInteger) {
        return new HInteger(this.biggi.subtract(hInteger.biggi));
    }

    public boolean testBit(int n) throws ArithmeticException {
        return this.biggi.testBit(n);
    }

    public byte[] toByteArray() {
        return this.biggi.toByteArray();
    }

    public String toString() {
        return this.biggi.toString();
    }

    public void toStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(this.biggi.toString());
    }

    public boolean unequals(Object object) {
        return !this.equals(object);
    }

    public static HInteger valueOf(long l) {
        return new HInteger(BigInteger.valueOf(l));
    }

    public HInteger xor(HInteger hInteger) {
        return new HInteger(this.biggi.xor(hInteger.biggi));
    }
}

