/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import rene.gui.Global;
import rene.util.MyVector;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;

public class MoverTool
extends ObjectConstructor {
    ConstructionObject P;
    boolean Selected = false;
    boolean ShowsValue;
    boolean ShowsName;
    boolean Grab;
    boolean WasDrawable;
    boolean ChangedDrawable;
    MyVector V = null;
    double OldX;
    double OldY;
    Graphics ZCG;
    boolean IntersectionBecameInvalid = false;

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        Enumeration en;
        if (!this.Selected && this.V != null) {
            zc.clearSelected();
        }
        if (e2.isControlDown() && this.V == null) {
            this.P = zc.selectObject(e2.getX(), e2.getY());
            this.ChangedDrawable = false;
            if (this.P instanceof FixedCircleObject && ((FixedCircleObject)this.P).fixedByNumber()) {
                this.WasDrawable = ((FixedCircleObject)this.P).isDragable();
                this.ChangedDrawable = true;
                ((FixedCircleObject)this.P).setDragable(true);
            } else if (this.P instanceof FixedAngleObject && ((FixedAngleObject)this.P).fixedByNumber()) {
                this.WasDrawable = ((FixedAngleObject)this.P).isDragable();
                this.ChangedDrawable = true;
                ((FixedAngleObject)this.P).setDragable(true);
            } else {
                this.P = null;
            }
        }
        if (this.P == null) {
            this.P = this.V != null ? zc.selectMoveablePoint(e2.getX(), e2.getY()) : zc.selectMoveableObject(e2.getX(), e2.getY());
        }
        if (this.P != null && this.V != null) {
            en = this.V.elements();
            while (en.hasMoreElements()) {
                if (this.P != en.nextElement()) continue;
                if (e2.isShiftDown()) {
                    this.P = null;
                    break;
                }
                this.V.removeElement(this.P);
                break;
            }
        }
        if (this.P != null) {
            this.P.setSelected(true);
            this.ShowsName = this.P.showName();
            this.ShowsValue = this.P.showValue();
            zc.setCursor(new Cursor(13));
        } else {
            boolean bl = this.Selected = zc.findSelectedObject() != null;
        }
        if (this.V != null) {
            en = this.V.elements();
            while (en.hasMoreElements()) {
                ((PointObject)en.nextElement()).setSelected(true);
            }
        }
        if (this.P != null) {
            if (this.P instanceof PointObject) {
                if (e2.isShiftDown()) {
                    if (this.V == null) {
                        this.V = new MyVector();
                    }
                    if (this.P != null) {
                        this.V.addElement(this.P);
                    }
                    this.P = null;
                } else if (e2.isControlDown()) {
                    zc.grab(true);
                    this.Grab = true;
                } else {
                    this.OldX = ((PointObject)this.P).getX();
                    this.OldY = ((PointObject)this.P).getY();
                }
            } else if (this.P instanceof MoveableObject) {
                ((MoveableObject)((Object)this.P)).startDrag(zc.x(e2.getX()), zc.y(e2.getY()));
                this.V = null;
            }
            if (this.ZCG != null) {
                this.ZCG.dispose();
                this.ZCG = null;
            }
            this.ZCG = zc.getGraphics();
        }
        zc.repaint();
        this.showStatus(zc);
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicateMoveableObjects(e2.getX(), e2.getY(), e2.isControlDown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent e2, ZirkelCanvas zc) {
        if (this.P == null) {
            return;
        }
        zc.getConstruction().haveChanged();
        zc.getConstruction().dontAlternate(false);
        ZirkelCanvas zirkelCanvas = zc;
        synchronized (zirkelCanvas) {
            PointObject Po;
            double oldx = 0.0;
            double oldy = 0.0;
            if ((Global.getParameter("restrictedmove", false) || e2.isShiftDown()) && this.P instanceof PointObject) {
                if (this.IntersectionBecameInvalid) {
                    zc.getConstruction().dontAlternate(true);
                    this.IntersectionBecameInvalid = false;
                }
                oldx = ((PointObject)this.P).getX();
                oldy = ((PointObject)this.P).getY();
            }
            ((MoveableObject)((Object)this.P)).dragTo(zc.x(e2.getX()), zc.y(e2.getY()));
            if (Global.getParameter("options.movename", false) && !this.P.isFixed() || Global.getParameter("options.movefixname", true) && this.P.isFixed()) {
                this.P.setShowValue(true);
                this.P.setShowName(true);
            }
            this.P.updateText();
            if (this.V != null && this.P instanceof PointObject) {
                double dx = ((PointObject)this.P).getX() - this.OldX;
                double dy = ((PointObject)this.P).getY() - this.OldY;
                Enumeration en = this.V.elements();
                while (en.hasMoreElements()) {
                    PointObject p = (PointObject)en.nextElement();
                    p.move(p.getX() + dx, p.getY() + dy);
                    p.updateText();
                }
                this.OldX = ((PointObject)this.P).getX();
                this.OldY = ((PointObject)this.P).getY();
            }
            if (this.P instanceof PointObject && (Po = (PointObject)this.P).dependsOnItselfOnly()) {
                Po.dontUpdate(true);
                zc.dovalidate();
                Po.dontUpdate(false);
            }
            zc.validate();
            if ((Global.getParameter("restrictedmove", false) || e2.isShiftDown()) && this.P instanceof PointObject && zc.getConstruction().intersectionBecameInvalid()) {
                ((PointObject)this.P).dragTo(oldx, oldy);
                this.IntersectionBecameInvalid = true;
                zc.validate();
            }
        }
        if (this.ZCG == null) {
            this.ZCG = zc.getGraphics();
        }
        zc.paint(this.ZCG);
    }

    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc, boolean rightmouse) {
        if (this.P == null) {
            return;
        }
        if (this.ZCG != null) {
            this.ZCG.dispose();
            this.ZCG = null;
        }
        zc.setCursor(Cursor.getDefaultCursor());
        this.P.setSelected(false);
        this.P.setShowValue(this.ShowsValue);
        this.P.setShowName(this.ShowsName);
        if (zc.showGrid() && !rightmouse && Global.getParameter("grid.leftsnap", false)) {
            if (this.P instanceof PointObject && this.V != null) {
                double dx = ((PointObject)this.P).getX();
                double dy = ((PointObject)this.P).getY();
                this.P.snap(zc);
                dx = ((PointObject)this.P).getX() - dx;
                dy = ((PointObject)this.P).getY() - dy;
                this.P.round();
                this.P.updateText();
                Enumeration en = this.V.elements();
                while (en.hasMoreElements()) {
                    PointObject p = (PointObject)en.nextElement();
                    p.move(p.getX() + dx, p.getY() + dy);
                    p.updateText();
                }
            } else {
                this.P.snap(zc);
                this.P.round();
                this.P.updateText();
            }
        }
        zc.validate();
        if (this.Grab) {
            zc.grab(false);
            this.Grab = false;
        }
        if (this.ChangedDrawable) {
            if (this.P instanceof FixedCircleObject) {
                ((FixedCircleObject)this.P).setDragable(this.WasDrawable);
            } else if (this.P instanceof FixedAngleObject) {
                ((FixedAngleObject)this.P).setDragable(this.WasDrawable);
            }
        }
        zc.clearSelected();
        zc.repaint();
        this.P = null;
        this.V = null;
        this.Selected = false;
        this.showStatus(zc);
    }

    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc) {
        this.mouseReleased(e2, zc, false);
    }

    public void reset(ZirkelCanvas zc) {
        this.V = null;
        this.P = null;
        zc.clearSelected();
        zc.repaint();
        this.Selected = false;
    }

    public void resetFirstTime(ZirkelCanvas zc) {
        if (this.V != null) {
            this.V.removeAllElements();
        }
        zc.clearSelected();
        zc.selectAllMoveableVisibleObjects();
        Graphics g = zc.getGraphics();
        if (g != null) {
            zc.paint(g);
            g.dispose();
            try {
                Thread.sleep(400L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            zc.clearSelected();
        }
        zc.repaint();
        this.Selected = false;
        this.P = null;
        this.V = null;
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.P == null && !this.Selected) {
            zc.showStatus(Zirkel.name("message.move.select", "Move: Select a point"));
        } else if (this.Selected) {
            zc.showStatus(Zirkel.name("message.move.move", "Move: Move the point"));
        } else {
            zc.showStatus(String.valueOf(Zirkel.name("message.move.move", "Move: Move the point")) + " (" + this.P.getName() + ")");
        }
    }

    public boolean useSmartBoard() {
        return false;
    }
}

