/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.FontMetrics;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.StringTokenizer;
import rene.dialogs.Warning;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.UserFunctionEditDialog;

public class UserFunctionObject
extends ConstructionObject
implements MoveableObject {
    Expression EY = null;
    double[] X = new double[]{0.0};
    String[] Var = new String[]{"x"};
    protected double Xpos;
    protected double Ypos;
    protected boolean Fixed;
    protected Expression EXpos;
    protected Expression EYpos;
    boolean DrawZeros;
    double C;
    double R;
    double W;
    double H;
    double[] x;
    double[] y;
    double[][] z;
    int xn = 20;
    int yn = 20;
    double[] xv = new double[2];
    public boolean EditAborted;
    double oldx;
    double oldy;
    double startx;
    double starty;

    public UserFunctionObject(Construction c2) {
        super(c2);
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Function";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        this.setText(this.getDisplayValue());
    }

    public void validate() {
        this.Valid = this.EY != null ? this.EY.isValid() : false;
        if (this.Fixed && this.EXpos != null && this.EXpos.isValid()) {
            try {
                this.Xpos = this.EXpos.getValue();
            }
            catch (Exception e2) {
                this.Valid = false;
                return;
            }
        }
        if (this.Fixed && this.EYpos != null && this.EYpos.isValid()) {
            try {
                this.Ypos = this.EYpos.getValue();
            }
            catch (Exception e3) {
                this.Valid = false;
                return;
            }
        }
    }

    public void setExpressions(String t, String ey) {
        StringTokenizer tok = new StringTokenizer(t);
        this.Var = new String[tok.countTokens()];
        this.X = new double[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            this.Var[i++] = tok.nextToken();
        }
        this.EY = new Expression(ey, this.getConstruction(), this, this.Var);
        this.validate();
    }

    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "0";
    }

    public double fix(double x1, double y1, double z1, double x2, double y2, double z2, double l1) {
        this.xv[0] = x1 * l1 + x2 * (1.0 - l1);
        this.xv[1] = y1 * l1 + y2 * (1.0 - l1);
        try {
            double z = this.evaluateF(this.xv);
            if (Math.abs(z) > (Math.abs(z1) + Math.abs(z2)) * 1.0E-5) {
                double mu = 1.0 - l1;
                double mu2 = mu * mu;
                double mu3 = mu2 * mu;
                double mu4 = mu3 * mu;
                double h = Math.sqrt(mu4 * z2 * z2 + ((-2.0 * mu4 + 4.0 * mu3 - 2.0 * mu2) * z1 - 2.0 * mu2 * z) * z2 + (mu4 - 4.0 * mu3 + 6.0 * mu2 - 4.0 * mu + 1.0) * z1 * z1 + (-2.0 * mu2 + 4.0 * mu - 2.0) * z * z1 + z * z);
                double h1 = (mu2 * z2 - mu2 * z1 + z1 - z + h) / (2.0 * (mu * z2 - mu * z1 + z1 - z));
                double h2 = (mu2 * z2 - mu2 * z1 + z1 - z - h) / (2.0 * (mu * z2 - mu * z1 + z1 - z));
                if (h1 >= 0.0 && h1 <= 1.0) {
                    l1 = 1.0 - h1;
                } else if (h2 >= 0.0 && h2 <= 1.0) {
                    l1 = 1.0 - h2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l1;
    }

    public void drawZeros(MyGraphics g, ZirkelCanvas zc, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) {
        if (z1 * z2 < 0.0) {
            double l1 = z2 / (z2 - z1);
            l1 = this.fix(x1, y1, z1, x2, y2, z2, l1);
            double m1 = 1.0 - l1;
            if (z1 * z3 < 0.0) {
                double l2 = z3 / (z3 - z1);
                l2 = this.fix(x1, y1, z1, x3, y3, z3, l2);
                double m2 = 1.0 - l2;
                g.drawLine(zc.col(l1 * x1 + m1 * x2), zc.row(l1 * y1 + m1 * y2), zc.col(l2 * x1 + m2 * x3), zc.row(l2 * y1 + m2 * y3));
            } else {
                double l2 = z3 / (z3 - z2);
                l2 = this.fix(x2, y2, z2, x3, y3, z3, l2);
                double m2 = 1.0 - l2;
                g.drawLine(zc.col(l1 * x1 + m1 * x2), zc.row(l1 * y1 + m1 * y2), zc.col(l2 * x2 + m2 * x3), zc.row(l2 * y2 + m2 * y3));
            }
        } else if (z1 * z3 < 0.0) {
            double l1 = z3 / (z3 - z1);
            l1 = this.fix(x1, y1, z1, x3, y3, z3, l1);
            double m1 = 1.0 - l1;
            double l2 = z3 / (z3 - z2);
            l2 = this.fix(x2, y2, z2, x3, y3, z3, l2);
            double m2 = 1.0 - l2;
            g.drawLine(zc.col(l1 * x1 + m1 * x3), zc.row(l1 * y1 + m1 * y3), zc.col(l2 * x2 + m2 * x3), zc.row(l2 * y2 + m2 * y3));
        }
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        if (this.DrawZeros && this.X.length == 2) {
            int j;
            double xmin = zc.Xmin;
            double xmax = zc.Xmin + 2.0 * zc.DX;
            double ymin = zc.Ymin;
            double ymax = zc.Ymin + 2.0 * zc.DY;
            double dx = (xmax - xmin) / 50.0;
            double dy = dx * Math.sqrt(3.0) / 2.0;
            this.xn = (int)((xmax - xmin) / dx) + 2;
            this.yn = (int)((ymax - ymin) / dy) + 1;
            if (this.x == null || this.x.length != this.xn || this.y.length != this.yn) {
                this.x = new double[this.xn + 1];
                this.y = new double[this.yn + 1];
                this.z = new double[this.xn + 1][this.yn + 1];
            }
            int i = 0;
            while (i <= this.xn) {
                this.x[i] = xmin - dx + (double)i * dx;
                ++i;
            }
            int j2 = 0;
            while (j2 <= this.yn) {
                this.y[j2] = ymin + (double)j2 * dy;
                ++j2;
            }
            i = 0;
            while (i <= this.xn) {
                j = 0;
                while (j <= this.yn) {
                    this.xv[0] = this.x[i];
                    this.xv[1] = this.y[j];
                    if (j % 2 == 0) {
                        this.xv[0] = this.xv[0] + dx / 2.0;
                    }
                    try {
                        this.z[i][j] = this.evaluateF(this.xv);
                    }
                    catch (Exception e2) {
                        this.z[i][j] = 0.0;
                    }
                    ++j;
                }
                ++i;
            }
            g.setColor(this);
            i = 0;
            while (i <= this.xn - 1) {
                j = 0;
                while (j <= this.yn - 1) {
                    if (j % 2 == 0) {
                        this.drawZeros(g, zc, this.x[i] + dx / 2.0, this.y[j], this.z[i][j], this.x[i], this.y[j + 1], this.z[i][j + 1], this.x[i + 1], this.y[j + 1], this.z[i + 1][j + 1]);
                        this.drawZeros(g, zc, this.x[i] + dx / 2.0, this.y[j], this.z[i][j], this.x[i + 1] + dx / 2.0, this.y[j], this.z[i + 1][j], this.x[i + 1], this.y[j + 1], this.z[i + 1][j + 1]);
                    } else {
                        this.drawZeros(g, zc, this.x[i], this.y[j], this.z[i][j], this.x[i + 1], this.y[j], this.z[i + 1][j], this.x[i] + dx / 2.0, this.y[j + 1], this.z[i][j + 1]);
                        this.drawZeros(g, zc, this.x[i + 1], this.y[j], this.z[i + 1][j], this.x[i + 1] - dx / 2.0, this.y[j + 1], this.z[i][j + 1], this.x[i + 1] + dx / 2.0, this.y[j + 1], this.z[i + 1][j + 1]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        FontMetrics fm = g.getFontMetrics();
        this.W = this.H = (double)fm.getHeight();
        this.C = zc.col(this.Xpos);
        this.R = zc.row(this.Ypos);
        g.setColor(this);
        this.setFont(g);
        g.drawString(AngleObject.translateToUnicode(this.getDisplayValue()), this.C, this.R);
        this.R -= this.H;
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.X[0];
    }

    public double getValue(String var) throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        int i = 0;
        while (i < this.Var.length) {
            if (var.equals(this.Var[i])) {
                return this.X[i];
            }
            ++i;
        }
        return this.X[0];
    }

    public String getDisplayValue() {
        String s = "";
        if (this.showName()) {
            if (this.getAlias() != null) {
                s = String.valueOf(this.getAlias()) + " : ";
            }
            s = String.valueOf(s) + this.getName() + "(" + this.Var[0];
            int i = 1;
            while (i < this.Var.length) {
                s = String.valueOf(s) + "," + this.Var[i];
                ++i;
            }
            s = String.valueOf(s) + ")";
            if (this.showValue()) {
                s = String.valueOf(s) + "=";
            }
        }
        if (this.showValue()) {
            s = String.valueOf(s) + (this.EY == null ? "" : this.EY.toString());
        }
        return s;
    }

    public boolean check(double size, double c2, double r, double c1, double r1, double c22, double r2) {
        return Math.abs(r - (r1 + r2) / 2.0) + Math.abs(c2 - (c1 + c22) / 2.0) < 2.0 * size;
    }

    public boolean nearto(ZirkelCanvas zc, int cc, int rr, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) {
        int size = (int)zc.selectionSize();
        if (z1 * z2 < 0.0) {
            double l1 = z2 / (z2 - z1);
            l1 = this.fix(x1, y1, z1, x2, y2, z2, l1);
            double m1 = 1.0 - l1;
            if (z1 * z3 < 0.0) {
                double l2 = z3 / (z3 - z1);
                l2 = this.fix(x1, y1, z1, x3, y3, z3, l2);
                double m2 = 1.0 - l2;
                return this.check(size, cc, rr, zc.col(l1 * x1 + m1 * x2), zc.row(l1 * y1 + m1 * y2), zc.col(l2 * x1 + m2 * x3), zc.row(l2 * y1 + m2 * y3));
            }
            double l2 = z3 / (z3 - z2);
            l2 = this.fix(x2, y2, z2, x3, y3, z3, l2);
            double m2 = 1.0 - l2;
            return this.check(size, cc, rr, zc.col(l1 * x1 + m1 * x2), zc.row(l1 * y1 + m1 * y2), zc.col(l2 * x2 + m2 * x3), zc.row(l2 * y2 + m2 * y3));
        }
        if (z1 * z3 < 0.0) {
            double l1 = z3 / (z3 - z1);
            l1 = this.fix(x1, y1, z1, x3, y3, z3, l1);
            double m1 = 1.0 - l1;
            double l2 = z3 / (z3 - z2);
            l2 = this.fix(x2, y2, z2, x3, y3, z3, l2);
            double m2 = 1.0 - l2;
            return this.check(size, cc, rr, zc.col(l1 * x1 + m1 * x3), zc.row(l1 * y1 + m1 * y3), zc.col(l2 * x2 + m2 * x3), zc.row(l2 * y2 + m2 * y3));
        }
        return false;
    }

    public boolean nearto(int cc, int rr, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        if (this.C <= (double)cc && this.R <= (double)rr && (double)cc <= this.C + this.W && (double)rr <= this.R + this.H) {
            return true;
        }
        if (this.DrawZeros && this.X.length == 2 && this.z != null) {
            double xmin = zc.Xmin;
            double xmax = zc.Xmin + 2.0 * zc.DX;
            double ymin = zc.Ymin;
            double ymax = zc.Ymin + 2.0 * zc.DY;
            double dx = (xmax - xmin) / 50.0;
            double dy = dx * Math.sqrt(3.0) / 2.0;
            int i = 0;
            while (i <= this.xn - 1) {
                int j = 0;
                while (j <= this.yn - 1) {
                    if (j % 2 == 0) {
                        if (this.nearto(zc, cc, rr, this.x[i] + dx / 2.0, this.y[j], this.z[i][j], this.x[i], this.y[j + 1], this.z[i][j + 1], this.x[i + 1], this.y[j + 1], this.z[i + 1][j + 1])) {
                            return true;
                        }
                        if (this.nearto(zc, cc, rr, this.x[i] + dx / 2.0, this.y[j], this.z[i][j], this.x[i + 1] + dx / 2.0, this.y[j], this.z[i + 1][j], this.x[i + 1], this.y[j + 1], this.z[i + 1][j + 1])) {
                            return true;
                        }
                    } else {
                        if (this.nearto(zc, cc, rr, this.x[i], this.y[j], this.z[i][j], this.x[i + 1], this.y[j], this.z[i + 1][j], this.x[i] + dx / 2.0, this.y[j + 1], this.z[i][j + 1])) {
                            return true;
                        }
                        if (this.nearto(zc, cc, rr, this.x[i + 1], this.y[j], this.z[i + 1][j], this.x[i + 1] - dx / 2.0, this.y[j + 1], this.z[i][j + 1], this.x[i + 1] + dx / 2.0, this.y[j + 1], this.z[i + 1][j + 1])) {
                            return true;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    public void edit(ZirkelCanvas zc) {
        UserFunctionEditDialog d2;
        while (true) {
            Warning w;
            Frame F;
            d2 = new UserFunctionEditDialog(zc, this);
            d2.setVisible(true);
            this.EditAborted = false;
            if (d2.isAborted()) {
                this.EditAborted = true;
                break;
            }
            if (!this.EY.isValid()) {
                F = zc.getFrame();
                w = new Warning(F, this.EY.getErrorText(), Zirkel.name("warning"), true);
                w.center(F);
                w.setVisible(true);
            }
            if (this.EXpos != null && !this.EXpos.isValid()) {
                F = zc.getFrame();
                w = new Warning(F, this.EXpos.getErrorText(), Zirkel.name("warning"), true);
                w.center(F);
                w.setVisible(true);
                continue;
            }
            if (this.EYpos == null || this.EYpos.isValid()) break;
            F = zc.getFrame();
            w = new Warning(F, this.EYpos.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        }
        this.validate();
        this.updateText();
        zc.getConstruction().updateCircleDep();
        zc.repaint();
        if (d2.wantsMore()) {
            new EditConditionals(zc.getFrame(), this);
            this.validate();
        }
    }

    public void printArgs(XmlWriter xml) {
        xml.printArg("f", this.EY.toString());
        if (this.DrawZeros) {
            xml.printArg("drawzeros", "true");
        }
        if (this.Fixed && this.EXpos != null && this.EXpos.isValid()) {
            xml.printArg("x", this.EXpos.toString());
        } else {
            xml.printArg("x", "" + this.Xpos);
        }
        if (this.Fixed && this.EYpos != null && this.EYpos.isValid()) {
            xml.printArg("y", this.EYpos.toString());
        } else {
            xml.printArg("y", "" + this.Ypos);
        }
        if (this.Fixed) {
            xml.printArg("fixed", "true");
        }
        xml.printArg("var", this.getVar());
    }

    public void translate() {
        try {
            this.EY = new Expression(this.EY.toString(), this.getConstruction(), this, this.Var);
            ConstructionObject O = this.getTranslation();
            this.setTranslation(this);
            if (this.Fixed) {
                try {
                    this.setFixed(this.EXpos.toString(), this.EYpos.toString());
                    this.EXpos.translate();
                    this.EYpos.translate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.validate();
            this.setTranslation(O);
        }
        catch (Exception e2) {
            System.out.println();
            System.out.println(this.getName());
            System.out.println(e2);
            e2.printStackTrace();
        }
    }

    public void setFixed(boolean flag) {
        this.Fixed = flag;
        if (!this.Fixed) {
            this.EYpos = null;
            this.EXpos = null;
        }
        this.updateText();
    }

    public void setFixed(String x, String y) {
        this.Fixed = true;
        this.EXpos = new Expression(x, this.getConstruction(), this);
        this.EYpos = new Expression(y, this.getConstruction(), this);
        this.updateText();
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public String getEXpos() {
        if (this.EXpos != null) {
            return this.EXpos.toString();
        }
        return "" + this.round(this.Xpos);
    }

    public String getEYpos() {
        if (this.EYpos != null) {
            return this.EYpos.toString();
        }
        return "" + this.round(this.Ypos);
    }

    public boolean onlynearto(int x, int y, ZirkelCanvas zc) {
        return false;
    }

    public boolean equals(ConstructionObject o) {
        return false;
    }

    public Enumeration depending() {
        DL.reset();
        this.addDepending(this.EY);
        if (this.Fixed) {
            this.addDepending(this.EXpos);
            this.addDepending(this.EYpos);
        }
        return DL.elements();
    }

    public void addDepending(Expression E) {
        if (E != null) {
            Enumeration e2 = E.getDepList().elements();
            while (e2.hasMoreElements()) {
                DL.add((ConstructionObject)e2.nextElement());
            }
        }
    }

    public boolean hasUnit() {
        return false;
    }

    public double evaluateF(double[] x) throws ConstructionException {
        int n = x.length;
        if (n > this.X.length) {
            n = this.X.length;
        }
        int i = 0;
        while (i < n) {
            this.X[i] = x[i];
            ++i;
        }
        i = n;
        while (i < this.X.length) {
            this.X[i] = 0.0;
            ++i;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception e2) {
            throw new ConstructionException("");
        }
    }

    public double evaluateF(double x) throws ConstructionException {
        this.X[0] = x;
        int i = 1;
        while (i < this.X.length) {
            this.X[i] = 0.0;
            ++i;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception e2) {
            throw new ConstructionException("");
        }
    }

    public boolean maybeTransparent() {
        return true;
    }

    public boolean canDisplayName() {
        return true;
    }

    public boolean isFilledForSelect() {
        return false;
    }

    public String getVar() {
        String vars = this.Var[0];
        int i = 1;
        while (i < this.Var.length) {
            vars = String.valueOf(vars) + " " + this.Var[i];
            ++i;
        }
        return vars;
    }

    public void dragTo(double x, double y) {
        this.move(this.oldx + (x - this.startx), this.oldy + (y - this.starty));
    }

    public void move(double x, double y) {
        this.Xpos = x;
        this.Ypos = y;
    }

    public boolean moveable() {
        return !this.Fixed;
    }

    public void startDrag(double x, double y) {
        this.oldx = this.Xpos;
        this.oldy = this.Ypos;
        this.startx = x;
        this.starty = y;
    }

    public double getX() {
        return this.Xpos;
    }

    public double getY() {
        return this.Ypos;
    }

    public boolean canFillBackground() {
        return false;
    }

    public boolean isDrawZeros() {
        return this.DrawZeros;
    }

    public void setDrawZeros(boolean drawZeros) {
        this.DrawZeros = drawZeros;
        if (this.X.length != 2 && this.EY != null) {
            this.setExpressions("x y", this.EY.toString());
        }
    }
}

