/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.util.Enumeration;
import rene.util.xml.XmlWriter;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.LineEditDialog;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.structures.Coordinates;

public class PrimitiveLineObject
extends ConstructionObject
implements PointonObject {
    protected double X1;
    protected double Y1;
    protected double DX;
    protected double DY;
    protected PointObject P1;
    PointObject[] Dep;
    int NDep;
    boolean Partial = false;
    double k1;
    double k2;
    boolean k12valid = false;

    public PrimitiveLineObject(Construction c2) {
        super(c2);
        this.setColor(this.ColorIndex);
    }

    public String getTag() {
        return "Line";
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        double xm = (zc.minX() + zc.maxX()) / 2.0;
        double ym = (zc.minY() + zc.maxY()) / 2.0;
        double d2 = (xm - this.X1) * this.DY - (ym - this.Y1) * this.DX;
        double x = xm - d2 * this.DY;
        double y = ym + d2 * this.DX;
        double a2 = Math.max(zc.maxX() - zc.minX(), zc.maxY() - zc.minY());
        if (Math.abs(d2) > a2) {
            return;
        }
        double b2 = (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
        this.k1 = b2 - a2;
        this.k2 = b2 + a2;
        this.k12valid = true;
        if (this.Partial && this.Dep != null && !zc.showHidden()) {
            double dd = (zc.maxX() - zc.minX()) / 20.0;
            double dmin = -dd;
            double dmax = dd;
            if (this.Dep != null) {
                int i = 0;
                while (i < this.NDep) {
                    if (this.Dep[i].valid() && !this.Dep[i].mustHide(zc)) {
                        double s = this.project(this.Dep[i].getX(), this.Dep[i].getY());
                        if (s - dd < dmin) {
                            dmin = s - dd;
                        } else if (s + dd > dmax) {
                            dmax = s + dd;
                        }
                    }
                    ++i;
                }
            }
            if (this.k1 < dmin) {
                this.k1 = dmin;
            }
            if (this.k2 > dmax) {
                this.k2 = dmax;
            }
        }
        double c1 = zc.col(this.X1 + this.k1 * this.DX);
        double c2 = zc.col(this.X1 + this.k2 * this.DX);
        double r1 = zc.row(this.Y1 + this.k1 * this.DY);
        double r2 = zc.row(this.Y1 + this.k2 * this.DY);
        if (this.isStrongSelected() && g instanceof MyGraphics13) {
            ((MyGraphics13)g).drawMarkerLine(c1, r1, c2, r2);
        }
        g.setColor(this);
        g.drawLine(c1, r1, c2, r2, this);
        String s = this.getDisplayText();
        if (!s.equals("")) {
            g.setLabelColor(this);
            this.setFont(g);
            this.DisplaysText = true;
            if (this.KeepClose) {
                double side = this.YcOffset < 0.0 ? 1 : -1;
                this.drawLabel(g, s, zc, this.X1 + this.XcOffset * this.DX, this.Y1 + this.XcOffset * this.DY, side * this.DX, side * this.DY, 0.0, 0.0);
            } else {
                this.drawLabel(g, s, zc, x + a2 / 5.0 * this.DX, y + a2 / 5.0 * this.DY, this.DX, this.DY, this.XcOffset, this.YcOffset);
            }
        }
    }

    public boolean canKeepClose() {
        return true;
    }

    public void setKeepClose(double x, double y) {
        this.KeepClose = true;
        this.XcOffset = (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
        this.YcOffset = (x - this.X1) * this.DY - (y - this.Y1) * this.DX;
    }

    public boolean nearto(int c2, int r, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        double x = zc.x(c2);
        double y = zc.y(r);
        double d2 = (x - this.X1) * this.DY - (y - this.Y1) * this.DX;
        this.Value = Math.abs(zc.col(zc.minX() + d2) - zc.col(zc.minX()));
        return this.Value < zc.selectionSize() * 2.0;
    }

    public boolean onlynearto(int c2, int r, ZirkelCanvas zc) {
        return false;
    }

    public static Coordinates intersect(PrimitiveLineObject l1, PrimitiveLineObject l2) {
        double det = -l1.DX * l2.DY + l1.DY * l2.DX;
        if (Math.abs(det) < 1.0E-10) {
            return null;
        }
        double a2 = (-(l2.X1 - l1.X1) * l2.DY + (l2.Y1 - l1.Y1) * l2.DX) / det;
        return new Coordinates(l1.X1 + a2 * l1.DX, l1.Y1 + a2 * l1.DY);
    }

    public static Coordinates intersect(PrimitiveLineObject l, PrimitiveCircleObject c2) {
        double x = c2.getX();
        double y = c2.getY();
        double r = c2.getR();
        double d2 = (x - l.X1) * l.DY - (y - l.Y1) * l.DX;
        if (Math.abs(d2) > r + 1.0E-10) {
            return null;
        }
        double h = r * r - d2 * d2;
        h = h > 0.0 ? Math.sqrt(h) : 0.0;
        return new Coordinates((x -= d2 * l.DY) + h * l.DX, (y += d2 * l.DX) + h * l.DY, x - h * l.DX, y - h * l.DY);
    }

    public double getDX() {
        return this.DX;
    }

    public double getDY() {
        return this.DY;
    }

    public double getX() {
        return this.X1;
    }

    public double getY() {
        return this.Y1;
    }

    public void edit(ZirkelCanvas zc) {
        LineEditDialog d2 = new LineEditDialog(zc.getFrame(), this);
        d2.setVisible(true);
        zc.getConstruction().updateCircleDep();
        zc.repaint();
        if (d2.wantsMore()) {
            new EditConditionals(zc.getFrame(), this);
            this.validate();
        }
    }

    public String getEquation() {
        double y = this.DX;
        double x = -this.DY;
        double c2 = y * this.Y1 + x * this.X1;
        if (c2 < 0.0) {
            c2 = -c2;
            x = -x;
            y = -y;
        }
        if (Math.abs(x) < 1.0E-10 && y < 0.0) {
            c2 = -c2;
            x = -x;
            y = -y;
        } else if (Math.abs(y) < 1.0E-10 && x < 0.0) {
            c2 = -c2;
            x = -x;
            y = -y;
        }
        String s = this.helpDisplayValue(true, x, "x");
        return String.valueOf(s) + this.helpDisplayValue(s.equals(""), y, "y") + "=" + (Math.abs(c2) < 1.0E-10 ? "0" : this.helpDisplayNumber(true, c2));
    }

    public boolean contains(double x, double y) {
        return true;
    }

    public void printArgs(XmlWriter xml) {
        if (this.Partial) {
            xml.printArg("partial", "true");
        }
    }

    public double project(double x, double y) {
        return (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
    }

    public boolean equals(ConstructionObject o) {
        if (!(o instanceof PrimitiveLineObject) || !o.valid()) {
            return false;
        }
        PrimitiveLineObject l = (PrimitiveLineObject)o;
        return this.equals(this.DX * l.DY - this.DY * l.DX, 0.0) && this.equals((this.X1 - l.X1) * this.DY - (this.Y1 - l.Y1) * this.DX, 0.0);
    }

    public PointObject getP1() {
        return this.P1;
    }

    public Enumeration points() {
        return this.depending();
    }

    public boolean locallyLike(ConstructionObject o) {
        if (!(o instanceof PrimitiveLineObject)) {
            return false;
        }
        return this.equals(this.DX, ((PrimitiveLineObject)o).DX) && this.equals(this.DY, ((PrimitiveLineObject)o).DY) || this.equals(-this.DX, ((PrimitiveLineObject)o).DX) && this.equals(-this.DY, ((PrimitiveLineObject)o).DY);
    }

    public boolean isPartial() {
        return this.Partial;
    }

    public void setPartial(boolean partial) {
        if (this.Partial == partial) {
            return;
        }
        this.Partial = partial;
        if (partial) {
            this.Dep = new PointObject[16];
            this.NDep = 0;
        } else {
            this.Dep = null;
        }
    }

    public void addDep(PointObject p) {
        if (!this.Partial || this.Dep == null || this.NDep >= this.Dep.length) {
            return;
        }
        this.Dep[this.NDep++] = p;
    }

    public void clearCircleDep() {
        this.NDep = 0;
    }

    public void project(PointObject P) {
        double h = this.project(P.getX(), P.getY());
        P.setXY(this.getX() + h * this.getDX(), this.getY() + h * this.getDY());
        P.setA(h);
    }

    public void project(PointObject P, double alpha) {
        P.setXY(this.getX() + alpha * this.getDX(), this.getY() + alpha * this.getDY());
    }

    public boolean canInteresectWith(ConstructionObject o) {
        return true;
    }

    public boolean canFillBackground() {
        return false;
    }

    public boolean canBeReplacedBy(ConstructionObject o) {
        return o instanceof PrimitiveLineObject && !this.getConstruction().dependsOn(o, this);
    }
}

