/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Checkbox;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import rene.gui.ButtonAction;
import rene.gui.IconBar;
import rene.gui.MyLabel;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.objects.FunctionObject;

class FunctionEditDialog
extends ObjectEditDialog {
    TextField VarMin;
    TextField VarMax;
    TextField DVar;
    TextField Var;
    TextField EX;
    TextField EY;
    IconBar IC;
    IconBar TypeIB;
    ZirkelCanvas ZC;
    Checkbox Special;

    public FunctionEditDialog(ZirkelCanvas zc, FunctionObject o) {
        super(zc.getFrame(), Zirkel.name("edit.function.title"), o, "function");
        this.ZC = zc;
    }

    public void addFirst(Panel P) {
        FunctionObject f2 = (FunctionObject)this.O;
        this.VarMin = new TextFieldAction(this, "varmin", "" + f2.VarMin, 30);
        P.add(new MyLabel(Zirkel.name("function.varmin")));
        P.add(this.VarMin);
        this.VarMax = new TextFieldAction(this, "varmax", "" + f2.VarMax, 30);
        P.add(new MyLabel(Zirkel.name("function.varmax")));
        P.add(this.VarMax);
        this.DVar = new TextFieldAction(this, "dvar", "" + f2.DVar, 30);
        P.add(new MyLabel(Zirkel.name("function.dvar")));
        P.add(this.DVar);
        this.Var = new TextFieldAction(this, "var", f2.getVar(), 30);
        P.add(new MyLabel(Zirkel.name("function.var")));
        P.add(this.Var);
        String ex = f2.getEX();
        if (ex.equals(f2.Var)) {
            ex = "";
        }
        this.EX = new TextFieldAction(this, "ex", ex, 30);
        P.add(new MyLabel(Zirkel.name("function.x")));
        P.add(this.EX);
        this.EY = new TextFieldAction(this, "ey", f2.getEY(), 30);
        P.add(new MyLabel(Zirkel.name("function.y")));
        P.add(this.EY);
    }

    public void addSecond(Panel P) {
        FunctionObject Func = (FunctionObject)this.O;
        this.IC = new IconBar(this.F);
        this.IC.setIconBarListener(this);
        this.IC.addOnOffLeft("filled");
        this.IC.setState("filled", Func.isFilled());
        this.IC.setIconBarListener(this);
        P.add(new MyLabel(""));
        P.add(this.IC);
        this.TypeIB = new IconBar(this.F);
        this.TypeIB.addToggleGroupLeft("type", 6);
        this.TypeIB.toggle("type", Func.getType());
        P.add(new MyLabel(""));
        P.add(this.TypeIB);
        P.add(new MyLabel(Zirkel.name("edit.discrete")));
        this.Special = new Checkbox();
        P.add(this.Special);
        this.Special.setState(Func.isSpecial());
    }

    public void addButton(Panel P) {
        FunctionObject f2 = (FunctionObject)this.O;
        if (!f2.Var.equals(f2.EX)) {
            if (f2.Center == null) {
                P.add(new ButtonAction(this, Zirkel.name("edit.function.center"), "SetCenter"));
            } else {
                P.add(new ButtonAction(this, Zirkel.name("edit.function.free"), "SetFree"));
            }
            P.add(new MyLabel(" "));
        }
    }

    public void iconPressed(String o) {
        if (o.equals("filled")) {
            if (this.IC.getState("filled")) {
                this.IB.setState("isback", true);
                this.ThicknessIB.setEnabled("solid", true);
            } else {
                this.IB.setState("isback", false);
                this.ThicknessIB.setState("solid", false);
                this.ThicknessIB.setEnabled("solid", false);
            }
        }
        super.iconPressed(o);
    }

    public void setAction() {
        FunctionObject f2 = (FunctionObject)this.O;
        f2.setExpressions(this.Var.getText(), this.EX.getText(), this.EY.getText());
        f2.setRange(this.VarMin.getText(), this.VarMax.getText(), this.DVar.getText());
        f2.setFilled(this.IC.getState("filled"));
        f2.setType(this.TypeIB.getToggleState("type"));
        f2.setSpecial(this.Special.getState());
    }

    public void doAction(String o) {
        if (o.equals("SetCenter")) {
            this.ZC.setCurveCenter((FunctionObject)this.O);
            super.doAction("OK");
        } else if (o.equals("SetFree")) {
            ((FunctionObject)this.O).Center = null;
            super.doAction("OK");
        } else {
            super.doAction(o);
        }
    }

    public void focusGained(FocusEvent e2) {
        this.VarMin.requestFocus();
    }
}

