/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.gui.Global;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.FixedAngleEditDialog;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.SimulationObject;

public class FixedAngleObject
extends PrimitiveLineObject
implements MoveableObject,
SimulationObject,
InsideObject {
    protected PointObject P2;
    static Count N = new Count();
    double A;
    double A1;
    double A2;
    double AA;
    Expression E;
    boolean Filled = false;
    boolean Inverse = false;
    boolean EditAborted = false;
    boolean Dragable = false;
    boolean Reduced = false;
    public static final int NORMALSIZE = 1;
    public static final int SMALL = 0;
    public static final int LARGER = 2;
    public static final int LARGE = 3;
    public static final int RECT = 4;
    protected int DisplaySize = 1;

    public FixedAngleObject(Construction c2, PointObject p1, PointObject p2, double x, double y) {
        super(c2);
        this.P1 = p1;
        this.P2 = p2;
        this.init(c2, x, y);
        this.Unit = Global.getParameter("unit.angle", "\u00b0");
    }

    public FixedAngleObject(Construction c2) {
        super(c2);
    }

    public void init(Construction c2, double x, double y, boolean invert) {
        double dx = this.P1.getX() - this.P2.getX();
        double dy = this.P1.getY() - this.P2.getY();
        this.A1 = Math.atan2(dy, dx);
        dx = x - this.P2.getX();
        dy = y - this.P2.getY();
        this.A2 = Math.atan2(dy, dx);
        this.A = this.A2 - this.A1;
        if (this.A < 0.0) {
            this.A += Math.PI * 2;
        } else if (this.A > Math.PI * 2) {
            this.A -= Math.PI * 2;
        }
        if (this.Inverse && this.Obtuse) {
            this.A = Math.PI * 2 - this.A;
        }
        if (invert && !this.Obtuse) {
            if (this.A > Math.PI) {
                this.A = Math.PI * 2 - this.A;
                this.Inverse = true;
            } else {
                this.Inverse = false;
            }
        }
        this.E = new Expression("" + this.round(this.A / Math.PI * 180.0, ZirkelCanvas.EditFactor), c2, this);
        this.validate();
        this.setColor(this.ColorIndex);
        this.updateText();
    }

    public void init(Construction c2, double x, double y) {
        this.init(c2, x, y, true);
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        double xm = (zc.minX() + zc.maxX()) / 2.0;
        double ym = (zc.minY() + zc.maxY()) / 2.0;
        double d2 = (xm - this.X1) * this.DY - (ym - this.Y1) * this.DX;
        double x = xm - d2 * this.DY;
        double y = ym + d2 * this.DX;
        double a2 = Math.max(zc.maxX() - zc.minX(), zc.maxY() - zc.minY());
        if (Math.abs(d2) > a2) {
            return;
        }
        double b2 = (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
        double k1 = b2 - a2;
        double k2 = b2 + a2;
        if (k1 < 0.0) {
            k1 = 0.0;
        }
        if (k1 >= k2) {
            return;
        }
        double c1 = zc.col(this.X1 + k1 * this.DX);
        double c2 = zc.col(this.X1 + k2 * this.DX);
        double r1 = zc.row(this.Y1 + k1 * this.DY);
        double r2 = zc.row(this.Y1 + k2 * this.DY);
        g.setColor(this);
        if (!this.Reduced) {
            g.drawLine(c1, r1, c2, r2, this);
        }
        double R = zc.col(this.getDisplaySize(zc)) - zc.col(0.0);
        c1 = zc.col(this.X1) - R;
        r1 = zc.row(this.Y1) - R;
        String s = AngleObject.translateToUnicode(this.getDisplayText());
        double DA = (int)(this.A / Math.PI * 180.0);
        if (DA < 0.0) {
            DA += 360.0;
        } else if (DA >= 360.0) {
            DA -= 360.0;
        }
        if (this.isStrongSelected() && g instanceof MyGraphics13) {
            ((MyGraphics13)g).drawMarkerArc(c1 + R, r1 + R, R, this.A1 / Math.PI * 180.0, DA);
        }
        g.setColor(this);
        if (this.Filled) {
            g.fillArc(c1, r1, 2.0 * R + 1.0, 2.0 * R + 1.0, this.A1 / Math.PI * 180.0, DA, this.Selected || this.getColorType() == 0, this.getColorType() != 1 && !this.isFillBackground(), true, this);
        } else if (this.DisplaySize == 4) {
            double dx1 = Math.cos(this.A1);
            double dy1 = Math.sin(this.A1);
            double dx2 = Math.cos(this.A1 + DA / 180.0 * Math.PI);
            double dy2 = Math.sin(this.A1 + DA / 180.0 * Math.PI);
            g.drawLine(c1 + R + R * dx1, r1 + R - R * dy1, c1 + R + R * (dx1 + dx2), r1 + R - R * (dy1 + dy2));
            g.drawLine(c1 + R + R * (dx1 + dx2), r1 + R - R * (dy1 + dy2), c1 + R + R * dx2, r1 + R - R * dy2);
        } else {
            g.drawCircleArc(c1 + R, r1 + R, R, this.A1 / Math.PI * 180.0, DA, this);
        }
        if (!s.equals("")) {
            double dof;
            g.setLabelColor(this);
            this.setFont(g);
            this.DisplaysText = true;
            double dx = Math.cos(this.A1 + this.A / 2.0);
            double dy = Math.sin(this.A1 + this.A / 2.0);
            if (s.equals("90" + this.getUnit()) || this.Name.startsWith(".")) {
                if (this.KeepClose) {
                    dof = Math.sqrt(this.XcOffset * this.XcOffset + this.YcOffset * this.YcOffset);
                    this.TX1 = zc.col(this.X1 + dof * dx) - 3.0;
                    this.TY1 = zc.row(this.Y1 + dof * dy) - 3.0;
                    this.TX2 = this.TX1 + 9.0;
                    this.TY2 = this.TY1 + 9.0;
                    g.drawRect(zc.col(this.X1 + dof * dx) - 1.0, zc.row(this.Y1 + dof * dy) - 1.0, 3.0, 3.0);
                } else {
                    this.TX1 = zc.col(this.X1 + zc.dx(R * 0.66) * dx + this.XcOffset) - 3.0;
                    this.TY1 = zc.row(this.Y1 + zc.dy(R * 0.66) * dy + this.YcOffset) - 3.0;
                    this.TX2 = this.TX1 + 9.0;
                    this.TY2 = this.TY1 + 9.0;
                    g.drawRect(zc.col(this.X1 + zc.dx(R * 0.66) * dx + this.XcOffset) - 1.0, zc.row(this.Y1 + zc.dy(R * 0.66) * dy + this.YcOffset) - 1.0, 3.0, 3.0);
                }
            } else if (this.KeepClose) {
                dof = Math.sqrt(this.XcOffset * this.XcOffset + this.YcOffset * this.YcOffset);
                this.drawCenteredLabel(g, s, zc, this.X1 + dof * dx, this.Y1 + dof * dy, 0.0, 0.0);
            } else {
                this.drawCenteredLabel(g, s, zc, this.X1 + zc.dx(R * 0.66) * dx, this.Y1 + zc.dy(R * 0.66) * dy, this.XcOffset, this.YcOffset);
            }
        }
    }

    public boolean canKeepClose() {
        return true;
    }

    public void setKeepClose(double x, double y) {
        this.KeepClose = true;
        this.XcOffset = x - this.X1;
        this.YcOffset = y - this.Y1;
    }

    double getDisplaySize(ZirkelCanvas zc) {
        double R = zc.dx((int)zc.angleSize());
        if (this.DisplaySize == 0 || this.DisplaySize == 4) {
            R /= 2.0;
        } else if (this.DisplaySize == 2) {
            R *= 2.0;
        } else if (this.DisplaySize == 3) {
            double dx = this.P1.getX() - this.X1;
            double dy = this.P1.getY() - this.Y1;
            R = Math.sqrt(dx * dx + dy * dy);
        }
        return R;
    }

    public String getTag() {
        return "Angle";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        if (this.E == null || !this.E.isValid()) {
            return;
        }
        this.setText(FixedAngleObject.text3(Zirkel.name("text.fixedangle"), this.P1.getName(), this.P2.getName(), this.E.toString()));
    }

    public String getDisplayValue() {
        if (ZirkelCanvas.AnglesFactor <= 2.0) {
            return "" + (int)(this.A / Math.PI * 180.0 + 0.5);
        }
        return "" + this.round(this.A / Math.PI * 180.0, ZirkelCanvas.AnglesFactor);
    }

    public void validate() {
        double dy;
        if (this.P1 == null) {
            return;
        }
        if (!this.P1.valid() || !this.P2.valid()) {
            this.Valid = false;
            return;
        }
        this.X1 = this.P2.getX();
        this.Y1 = this.P2.getY();
        double dx = this.P1.getX() - this.X1;
        if (Math.sqrt(dx * dx + (dy = this.P1.getY() - this.Y1) * dy) < 1.0E-9) {
            this.Valid = false;
            return;
        }
        this.A1 = Math.atan2(dy, dx);
        boolean Negative = false;
        try {
            if (this.E != null && this.E.isValid()) {
                this.A = this.E.getValue() / 180.0 * Math.PI;
            }
            if (this.Obtuse) {
                if (this.Inverse) {
                    this.A = -this.A;
                }
            } else {
                if (this.Inverse && Math.sin(this.A) > 0.0) {
                    this.A = -this.A;
                }
                if (!this.Inverse && Math.sin(this.A) < 0.0) {
                    this.A = -this.A;
                }
            }
            if (this.A < 0.0) {
                Negative = true;
            }
            while (this.A < 0.0) {
                this.A += Math.PI * 2;
            }
            while (this.A >= Math.PI * 2) {
                this.A -= Math.PI * 2;
            }
            this.A2 = this.A1 + this.A;
            this.DX = Math.cos(this.A2);
            this.DY = Math.sin(this.A2);
            this.AA = this.A;
        }
        catch (Exception e2) {
            this.Valid = false;
            return;
        }
        if (!this.Obtuse && this.A > Math.PI) {
            this.A1 = this.A2;
            this.A = Math.PI * 2 - this.A;
            this.A2 = this.A1 + this.A;
        } else if (this.Obtuse && Negative) {
            this.A1 = this.A2;
            this.A = Math.PI * 2 - this.A;
            this.A2 = this.A1 + this.A;
        }
        this.Valid = true;
    }

    public double getLength() {
        return this.A;
    }

    public void setFixed(String s) {
        this.E = new Expression(s, this.getConstruction(), this);
        this.updateText();
    }

    public void round() {
        try {
            this.setFixed(String.valueOf(this.round(this.E.getValue(), ZirkelCanvas.AnglesFactor)));
            this.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEditFixed(String s) {
        this.E = new Expression(s, this.getConstruction(), this);
        this.updateText();
    }

    public boolean canFix() {
        return true;
    }

    public void printArgs(XmlWriter xml) {
        if (this.P1 != null) {
            xml.printArg("first", this.P1.getName());
        }
        if (this.P2 != null) {
            xml.printArg("root", this.P2.getName());
        }
        xml.printArg("fixedangle", "true");
        if (this.DisplaySize == 0) {
            xml.printArg("display", "small");
        }
        if (this.DisplaySize == 3) {
            xml.printArg("display", "large");
        }
        if (this.DisplaySize == 2) {
            xml.printArg("display", "larger");
        }
        if (this.DisplaySize == 4) {
            xml.printArg("display", "rectangle");
        }
        if (this.Filled) {
            xml.printArg("filled", "true");
        }
        if (this.E != null && this.E.isValid()) {
            xml.printArg("fixed", this.E.toString());
        } else {
            xml.printArg("fixed", "" + this.A / Math.PI * 180.0);
        }
        if (!this.Obtuse) {
            xml.printArg("acute", "true");
        }
        if (this.Inverse) {
            xml.printArg("inverse", "true");
        }
        if (this.Reduced) {
            xml.printArg("reduced", "true");
        }
        if (this.Dragable) {
            xml.printArg("dragable", "true");
        }
        super.printArgs(xml);
    }

    public void edit(ZirkelCanvas zc) {
        FixedAngleEditDialog d2;
        while (true) {
            d2 = new FixedAngleEditDialog(zc.getFrame(), this, zc);
            d2.setVisible(true);
            zc.repaint();
            this.EditAborted = false;
            if (d2.isAborted()) {
                this.EditAborted = true;
                break;
            }
            if (this.E == null || this.E.isValid()) break;
            Frame F = zc.getFrame();
            Warning w = new Warning(F, this.E.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        }
        if (d2.wantsMore()) {
            new EditConditionals(zc.getFrame(), this);
            this.validate();
        }
    }

    public boolean nearto(int c2, int r, ZirkelCanvas zc) {
        double cc;
        boolean near;
        if (!this.Valid && this.P2.valid()) {
            return this.P2.nearto(c2, r, zc);
        }
        if (!this.displays(zc)) {
            return false;
        }
        double x = zc.x(c2);
        double y = zc.y(r);
        double d2 = (x - this.X1) * this.DY - (y - this.Y1) * this.DX;
        double e2 = (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
        this.Value = Math.abs(zc.col(zc.minX() + d2) - zc.col(zc.minX()));
        if (!this.Reduced && this.Value < zc.selectionSize() && e2 > 0.0) {
            return true;
        }
        double dx = zc.x(c2) - this.X1;
        double dy = zc.y(r) - this.Y1;
        double size = zc.dx((int)zc.selectionSize());
        double rd = this.getDisplaySize(zc);
        double rr = Math.sqrt(dx * dx + dy * dy);
        if (this.Filled || this.DisplaySize == 4) {
            near = rr < rd + size;
        } else {
            boolean bl = near = Math.abs(rr - rd) < size;
        }
        if (!near) {
            return false;
        }
        if (rd < size) {
            return near;
        }
        double a2 = Math.atan2(dy, dx);
        if (a2 < 0.0) {
            a2 += Math.PI * 2;
        }
        if (this.A1 - (cc = 0.05) < a2 && this.A2 + cc > a2) {
            return true;
        }
        if (this.A1 - cc < (a2 -= Math.PI * 2) && this.A2 + cc > a2) {
            return true;
        }
        return this.A1 - cc < (a2 += Math.PI * 4) && this.A2 + cc > a2;
    }

    public void setDisplaySize(int i) {
        this.DisplaySize = i;
    }

    public int getDisplaySize() {
        return this.DisplaySize;
    }

    public Enumeration depending() {
        super.depending();
        this.depset(this.P1, this.P2);
        Enumeration e2 = this.E.getDepList().elements();
        while (e2.hasMoreElements()) {
            DL.add((ConstructionObject)e2.nextElement());
        }
        return DL.elements();
    }

    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.P2 = (PointObject)this.P2.getTranslation();
        try {
            this.setFixed(this.E.toString());
            this.E.translate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getE() {
        return this.E.toString();
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.A / Math.PI * 180.0;
    }

    public void setFilled(boolean flag) {
        this.Filled = flag;
    }

    public boolean isFilled() {
        return this.Filled;
    }

    public boolean isFilledForSelect() {
        return false;
    }

    public boolean contains(double x, double y) {
        double a2 = (x - this.X1) * this.DX + (y - this.Y1) * this.DY;
        return !(a2 < 1.0E-9);
    }

    public double project(double x, double y) {
        double h = super.project(x, y);
        if (h < 0.0) {
            return 0.0;
        }
        return h;
    }

    public Enumeration points() {
        super.depending();
        return this.depset(this.P2);
    }

    public void move(double x, double y) {
        this.init(this.getConstruction(), x, y, true);
    }

    public boolean moveable() {
        return this.Dragable;
    }

    public boolean isFixed() {
        return true;
    }

    public boolean getInverse() {
        return this.Inverse;
    }

    public void setInverse(boolean inverse) {
        this.Inverse = inverse;
    }

    public boolean isEditAborted() {
        return this.EditAborted;
    }

    public boolean isDragable() {
        return this.Dragable;
    }

    public void setDragable(boolean f2) {
        this.Dragable = f2;
    }

    public boolean isReduced() {
        return this.Reduced;
    }

    public void setReduced(boolean f2) {
        this.Reduced = f2;
    }

    public boolean fixedByNumber() {
        return this.E != null && this.E.isNumber();
    }

    public void setSimulationValue(double x) {
        this.A = x / 180.0 * Math.PI;
        Expression OldE = this.E;
        this.E = null;
        this.validate();
        this.E = OldE;
    }

    public void resetSimulationValue() {
        this.validate();
    }

    public void startDrag(double x, double y) {
    }

    public void dragTo(double x, double y) {
        this.move(x, y);
    }

    public double containsInside(PointObject P) {
        double dx = P.getX() - this.X1;
        double dy = P.getY() - this.Y1;
        double a2 = Math.atan2(dy, dx);
        if (a2 < this.A1) {
            a2 += Math.PI * 2;
        }
        double c2 = 1.0E-5;
        if (a2 > this.A1 && a2 < this.A1 + this.A) {
            return 1.0;
        }
        if (a2 > this.A1 - c2 && a2 < this.A1 + this.A + c2) {
            return 0.5;
        }
        return 0.0;
    }

    public boolean keepInside(PointObject P) {
        double yh;
        double xh;
        double dist;
        double y2;
        double dy;
        double r;
        if (this.containsInside(P) > 0.0) {
            return true;
        }
        double x = P.getX();
        double y = P.getY();
        double x1 = this.X1;
        double y1 = this.Y1;
        double xmin = x1;
        double ymin = y1;
        double dmin = 1.0E20;
        double x2 = this.X1 + Math.cos(this.A1);
        double dx = x2 - x1;
        double h = dx * (x - x1) / (r = dx * dx + (dy = (y2 = this.Y1 + Math.sin(this.A1)) - y1) * dy) + dy * (y - y1) / r;
        if (h < 0.0) {
            h = 0.0;
        }
        if ((dist = Math.sqrt((x - (xh = x1 + h * dx)) * (x - xh) + (y - (yh = y1 + h * dy)) * (y - yh))) < dmin) {
            dmin = dist;
            xmin = xh;
            ymin = yh;
        }
        if ((h = (dx = (x2 = this.X1 + Math.cos(this.A2)) - x1) * (x - x1) / (r = dx * dx + (dy = (y2 = this.Y1 + Math.sin(this.A2)) - y1) * dy) + dy * (y - y1) / r) < 0.0) {
            h = 0.0;
        }
        if ((dist = Math.sqrt((x - (xh = x1 + h * dx)) * (x - xh) + (y - (yh = y1 + h * dy)) * (y - yh))) < dmin) {
            dmin = dist;
            xmin = xh;
            ymin = yh;
        }
        P.move(xmin, ymin);
        return false;
    }
}

