/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.FontMetrics;
import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionEditDialog;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.SimulationObject;

public class ExpressionObject
extends ConstructionObject
implements MoveableObject,
SimulationObject {
    protected double X;
    protected double Y;
    private static Count N = new Count();
    Expression E;
    protected Expression EX;
    protected Expression EY;
    protected boolean Fixed;
    String Prompt = Zirkel.name("expression.value");
    protected double CurrentValue = 0.0;
    protected boolean CurrentValueValid = true;
    protected boolean Slider = false;
    protected Expression SMin;
    protected Expression SMax;
    public double C;
    public double R;
    public double W;
    public double H;
    public double SC;
    public double SR;
    public double SW;
    public double SH;
    public double SX;
    public double SY;
    public double SD;
    private double OldE;
    double oldx;
    double oldy;
    double startx;
    double starty;
    boolean DragSlider;

    public ExpressionObject(Construction c2, double x, double y) {
        super(c2);
        this.X = x;
        this.Y = y;
        this.setColor(this.ColorIndex);
        this.updateText();
    }

    public String getTag() {
        return "Expression";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        if (this.E != null) {
            this.setText(ExpressionObject.text3(Zirkel.name("text.expression"), this.E.toString(), "" + this.roundDisplay(this.X), "" + this.roundDisplay(this.Y)));
        } else {
            this.setText(ExpressionObject.text3(Zirkel.name("text.expression"), "", "" + this.roundDisplay(this.X), "" + this.roundDisplay(this.Y)));
        }
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        this.DisplaysText = false;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        this.C = zc.col(this.X);
        this.R = zc.row(this.Y);
        this.setFont(g);
        FontMetrics fm = g.getFontMetrics();
        if (this.isStrongSelected() && g instanceof MyGraphics) {
            ((MyGraphics13)g).drawMarkerRect(this.C - 5.0, this.R - 5.0, 10.0, 10.0);
        }
        g.setColor(this);
        String s = "";
        if (this.showName()) {
            s = this.Prompt;
            s = this.showValue() ? (s.endsWith("_") && s.length() > 1 ? s.substring(0, s.length() - 1) : String.valueOf(s) + " = ") : this.Prompt;
        }
        if (this.showValue()) {
            try {
                this.E.getValue();
                double x = this.round(this.CurrentValue);
                if (this.Slider) {
                    x = this.round(this.CurrentValue, 100.0);
                }
                s = Math.abs(x - (double)Math.round(x)) < 1.0E-10 ? String.valueOf(s) + (int)x : String.valueOf(s) + x;
            }
            catch (Exception e2) {
                s = String.valueOf(s) + "???";
            }
        }
        s = String.valueOf(s) + this.Unit;
        s = AngleObject.translateToUnicode(s);
        this.W = fm.stringWidth("---");
        if (s.equals("") && !this.Slider) {
            s = "-";
        }
        if (!s.equals("")) {
            this.setFont(g);
            this.R -= (double)fm.getAscent();
            this.H = g.drawStringExtended(s, this.C, this.R);
        }
        if (this.Slider) {
            int coffset = (int)(4.0 * zc.pointSize());
            this.R += this.H;
            g.drawLine(this.C, this.R + (double)(coffset / 2), this.C + (double)(10 * coffset), this.R + (double)(coffset / 2));
            double d2 = this.getSliderPosition();
            int size = coffset / 4;
            double rslider = this.C + d2 * 10.0 * (double)coffset;
            if (this.getColorType() == 1) {
                g.fillOval(rslider - (double)size, this.R + (double)(coffset / 2) - (double)size, 2 * size, 2 * size, true, false, this);
            } else {
                this.FillBackground = true;
                g.fillOval(rslider - (double)size, this.R + (double)(coffset / 2) - (double)size, 2 * size, 2 * size, false, false, this);
                this.FillBackground = false;
                g.setColor(this);
                g.drawOval(rslider - (double)size, this.R + (double)(coffset / 2) - (double)size, 2 * size, 2 * size);
            }
            this.SC = rslider - (double)size;
            this.SR = this.R + (double)(coffset / 2) - (double)size;
            this.SW = this.SH = (double)(2 * size);
            this.SX = zc.x((int)this.C);
            this.SY = zc.y((int)this.R + coffset / 2 - size);
            this.SD = zc.x((int)this.C + 10 * coffset) - this.SX;
            this.R -= this.H;
        }
    }

    public double getSliderPosition() {
        double x;
        double max;
        double min;
        block5: {
            try {
                min = this.SMin.getValue();
                max = this.SMax.getValue();
                x = this.CurrentValue;
                if (!(min >= max)) break block5;
                this.Valid = false;
                return 0.0;
            }
            catch (Exception e2) {
                this.Valid = false;
                return 0.0;
            }
        }
        if (x < min) {
            x = min;
        }
        if (x > max) {
            x = max;
        }
        return (x - min) / (max - min);
    }

    public void setSliderPosition(double d2) {
        try {
            double min = this.SMin.getValue();
            double max = this.SMax.getValue();
            if (min >= max) {
                this.Valid = false;
                return;
            }
            double value = min + d2 * (max - min);
            if (value < min) {
                value = min;
            }
            if (value > max) {
                value = max;
            }
            this.E.setValue(value);
        }
        catch (Exception e2) {
            this.Valid = false;
        }
    }

    public boolean nearto(int x, int y, ZirkelCanvas zc) {
        this.DragSlider = false;
        if (this.Valid && !this.displays(zc)) {
            return false;
        }
        if (this.C <= (double)x && (double)x <= this.C + this.W && this.R <= (double)y && (double)y <= this.R + this.H) {
            return true;
        }
        if (this.SC <= (double)x && this.SR <= (double)y && this.SC + this.SW >= (double)x && this.SR + this.SH >= (double)y) {
            this.DragSlider = true;
            return true;
        }
        return false;
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public void move(double x, double y) {
        this.X = x;
        this.Y = y;
    }

    public void snap(ZirkelCanvas zc) {
        double d2 = zc.getGridSize() / 2.0;
        this.X = (double)Math.round(this.X / d2) * d2;
        this.Y = (double)Math.round(this.Y / d2) * d2;
    }

    public void round() {
        this.move(this.round(this.X, ZirkelCanvas.LengthsFactor), this.round(this.Y, ZirkelCanvas.LengthsFactor));
    }

    public void edit(ZirkelCanvas zc) {
        Warning w;
        Frame F;
        ExpressionEditDialog d2 = new ExpressionEditDialog(zc.getFrame(), zc, this);
        d2.setVisible(true);
        zc.repaint();
        if (this.E != null && !this.E.isValid()) {
            F = zc.getFrame();
            w = new Warning(F, this.E.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        }
        if (this.EX != null && !this.EX.isValid()) {
            F = zc.getFrame();
            w = new Warning(F, this.EX.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        } else if (this.EY != null && !this.EY.isValid()) {
            F = zc.getFrame();
            w = new Warning(F, this.EY.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        }
        this.validate();
        if (d2.wantsMore()) {
            new EditConditionals(zc.getFrame(), this);
            this.validate();
        }
    }

    public void printArgs(XmlWriter xml) {
        if (this.Fixed && this.EX != null && this.EX.isValid()) {
            xml.printArg("x", this.EX.toString());
        } else {
            xml.printArg("x", "" + this.X);
        }
        if (this.Fixed && this.EY != null && this.EY.isValid()) {
            xml.printArg("y", this.EY.toString());
        } else {
            xml.printArg("y", "" + this.Y);
        }
        if (this.E != null) {
            xml.printArg("value", this.E.toString());
        } else {
            xml.printArg("value", "");
        }
        xml.printArg("prompt", this.Prompt);
        if (this.Fixed) {
            xml.printArg("fixed", "true");
        }
        if (this.Slider) {
            xml.printArg("slider", "true");
            xml.printArg("min", this.SMin.toString());
            xml.printArg("max", this.SMax.toString());
        }
    }

    public boolean equals(ConstructionObject o) {
        return false;
    }

    public void setExpression(String expr, Construction c2) throws ConstructionException {
        this.E = new Expression(expr, c2, this);
        this.updateText();
    }

    public void setFixed(String expr) {
        this.E = new Expression(expr, this.getConstruction(), this);
        this.updateText();
    }

    public String getExpression() {
        if (this.E != null) {
            return this.E.toString();
        }
        return "";
    }

    public Enumeration depending() {
        Enumeration e2;
        DL.reset();
        if (this.E != null) {
            e2 = this.E.getDepList().elements();
            while (e2.hasMoreElements()) {
                DL.add((ConstructionObject)e2.nextElement());
            }
        }
        if (this.Fixed) {
            if (this.EX != null) {
                e2 = this.EX.getDepList().elements();
                while (e2.hasMoreElements()) {
                    DL.add((ConstructionObject)e2.nextElement());
                }
            }
            if (this.EY != null) {
                e2 = this.EY.getDepList().elements();
                while (e2.hasMoreElements()) {
                    DL.add((ConstructionObject)e2.nextElement());
                }
            }
        }
        return DL.elements();
    }

    public double getValue() throws ConstructionException {
        if (!this.CurrentValueValid) {
            throw new InvalidException("");
        }
        return this.CurrentValue;
    }

    public String getPrompt() {
        return this.Prompt;
    }

    public void setPrompt(String prompt) {
        this.Prompt = prompt;
    }

    public void translate() {
        this.E.translate();
        if (this.Fixed) {
            try {
                this.setFixed(this.EX.toString(), this.EY.toString());
                this.EX.translate();
                this.EY.translate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.updateText();
    }

    public void validate() {
        try {
            this.CurrentValue = this.E.getValue();
            this.CurrentValueValid = true;
        }
        catch (Exception e2) {
            this.CurrentValueValid = false;
        }
        this.Valid = true;
        if (this.Fixed && this.EX != null && this.EX.isValid()) {
            try {
                this.X = this.EX.getValue();
            }
            catch (Exception e3) {
                this.Valid = false;
                return;
            }
        }
        if (this.Fixed && this.EY != null && this.EY.isValid()) {
            try {
                this.Y = this.EY.getValue();
            }
            catch (Exception e4) {
                this.Valid = false;
                return;
            }
        }
    }

    public void setFixed(boolean flag) {
        this.Fixed = flag;
        if (!this.Fixed) {
            this.EY = null;
            this.EX = null;
        }
        this.updateText();
    }

    public void setFixed(String x, String y) {
        this.Fixed = true;
        this.EX = new Expression(x, this.getConstruction(), this);
        this.EY = new Expression(y, this.getConstruction(), this);
        this.updateText();
    }

    public ConstructionObject copy() {
        try {
            ExpressionObject o = (ExpressionObject)this.clone();
            this.setTranslation(o);
            o.setExpression(this.E.toString(), this.getConstruction());
            o.translateConditionals();
            o.translate();
            o.setName();
            o.updateText();
            o.setBreak(false);
            o.setTarget(false);
            return o;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public void setDefaults() {
        super.setDefaults();
        this.setShowValue(true);
    }

    public boolean moveable() {
        if (this.Slider) {
            return true;
        }
        return this.EX == null && this.EY == null;
    }

    public void reset() {
        if (this.E != null) {
            this.E.reset();
        }
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public String getEX() {
        if (this.EX != null) {
            return this.EX.toString();
        }
        return "" + this.round(this.X);
    }

    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "" + this.round(this.Y);
    }

    public void setCurrentValue(double x) {
        this.CurrentValue = x;
        this.CurrentValueValid = true;
    }

    public void setSimulationValue(double x) {
        this.OldE = this.CurrentValue;
        this.CurrentValue = x;
    }

    public void resetSimulationValue() {
        this.CurrentValue = this.OldE;
    }

    public void setSlider(String smin, String smax) {
        this.Slider = true;
        this.SMin = new Expression(smin, this.getConstruction(), this);
        this.SMax = new Expression(smax, this.getConstruction(), this);
    }

    public void setSlider(boolean flag) {
        this.Slider = flag;
    }

    public void startDrag(double x, double y) {
        this.oldx = this.X;
        this.oldy = this.Y;
        this.startx = x;
        this.starty = y;
    }

    public void dragTo(double x, double y) {
        if (this.DragSlider) {
            this.setSliderPosition((x - this.SX) / this.SD);
        } else {
            this.move(this.oldx + (x - this.startx), this.oldy + (y - this.starty));
        }
    }

    public boolean isSlider() {
        return this.Slider;
    }

    public String getMin() {
        if (this.Slider) {
            return this.SMin.toString();
        }
        return "-5";
    }

    public String getMax() {
        if (this.Slider) {
            return this.SMax.toString();
        }
        return "5";
    }

    public String getDisplayValue() {
        String s = "";
        try {
            this.E.getValue();
            double x = this.round(this.CurrentValue);
            if (this.Slider) {
                x = this.round(this.CurrentValue, 100.0);
            }
            s = Math.abs(x - (double)Math.round(x)) < 1.0E-10 ? String.valueOf(s) + (int)x : String.valueOf(s) + x;
        }
        catch (Exception e2) {
            s = String.valueOf(s) + "???";
        }
        s = String.valueOf(s) + this.Unit;
        return s;
    }

    public String getEquation() {
        if (this.E == null) {
            return "???";
        }
        return this.E.toString();
    }

    public boolean canFIllBackground() {
        return false;
    }

    public boolean canBeReplacedBy(ConstructionObject o) {
        return o instanceof ExpressionObject && !this.getConstruction().dependsOn(o, this);
    }
}

