/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;

public class CircleObject
extends PrimitiveCircleObject
implements MoveableObject {
    protected PointObject P2;
    boolean Fixed = false;
    Expression E;
    boolean ExpressionFailed;
    boolean Ellipse = false;
    double x1;
    double y1;
    double x2;
    double y2;
    double x3;
    double y3;

    public CircleObject(Construction c2, PointObject p1, PointObject p2) {
        super(c2, p1);
        this.P2 = p2;
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Circle";
    }

    public void updateText() {
        if (this.Fixed) {
            if (this.E == null) {
                this.setText(CircleObject.text3(Zirkel.name("text.circle.fixed"), this.M.getName(), this.P2.getName(), "" + this.round(this.R)));
            } else {
                this.setText(CircleObject.text3(Zirkel.name("text.circle.fixed"), this.M.getName(), this.P2.getName(), "\"" + this.E.toString() + "\""));
            }
        } else {
            this.setText(CircleObject.text2(Zirkel.name("text.circle"), this.M.getName(), this.P2.getName()));
        }
    }

    public void validate() {
        super.validate();
        this.ExpressionFailed = false;
        if (!this.M.valid() || !this.P2.valid()) {
            this.Valid = false;
            return;
        }
        this.Valid = true;
        this.X = this.M.getX();
        this.Y = this.M.getY();
        double X2 = this.P2.getX();
        double Y2 = this.P2.getY();
        double DX = X2 - this.X;
        double DY = Y2 - this.Y;
        this.R = Math.sqrt(DX * DX + DY * DY);
        if (this.Fixed) {
            if (!this.P2.moveableBy(this)) {
                this.Fixed = false;
            } else {
                try {
                    double FixR = this.E.getValue();
                    if (FixR < 0.0) {
                        FixR = 0.0;
                    }
                    if (this.R < 1.0E-10) {
                        this.P2.move(this.X + FixR, this.Y);
                    } else {
                        this.P2.move(this.X + DX * FixR / this.R, this.Y + DY * FixR / this.R);
                    }
                    this.R = FixR;
                    this.P2.movedBy(this);
                }
                catch (Exception e2) {
                    this.R = 0.0;
                    this.P2.move(this.X, this.Y);
                    this.ExpressionFailed = true;
                    this.Valid = false;
                }
            }
        }
    }

    public void printArgs(XmlWriter xml) {
        xml.printArg("through", this.P2.getName());
        if (this.Fixed && this.E != null) {
            xml.printArg("fixed", this.E.toString());
        }
        super.printArgs(xml);
    }

    public boolean canFix() {
        return this.P2.moveableBy(this);
    }

    public boolean fixed() {
        return this.Fixed;
    }

    public void setFixed(boolean flag, String s) throws ConstructionException {
        if (!flag || s.equals("")) {
            this.Fixed = false;
            this.E = null;
        } else {
            this.E = new Expression(s, this.getConstruction(), this);
            if (!this.E.isValid()) {
                throw new ConstructionException(this.E.getErrorText());
            }
            this.Fixed = true;
        }
        this.updateText();
    }

    public boolean nearto(int c2, int r, ZirkelCanvas zc) {
        if (this.ExpressionFailed && this.M.valid()) {
            return this.M.nearto(c2, r, zc);
        }
        return super.nearto(c2, r, zc);
    }

    public void edit(ZirkelCanvas zc) {
        super.edit(zc);
        if (this.E != null && !this.E.isValid()) {
            Frame F = zc.getFrame();
            Warning w = new Warning(F, this.E.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        }
    }

    public boolean isValidFix() {
        return this.E != null && this.E.isValid();
    }

    public void updateCircleDep() {
        this.addDep(this.P2);
    }

    public void translate() {
        super.translate();
        this.P2 = (PointObject)this.P2.getTranslation();
        try {
            this.setFixed(this.Fixed, this.E.toString());
            this.E.translate();
        }
        catch (Exception e2) {
            this.Fixed = false;
        }
    }

    public String getStringLength() {
        if (this.E != null) {
            return this.E.toString();
        }
        return "" + this.roundDisplay(this.R);
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.R;
    }

    public Enumeration depending() {
        super.depending();
        if (!this.Fixed || this.E == null) {
            return this.depset(this.P2);
        }
        this.depset(this.P2);
        Enumeration e2 = this.E.getDepList().elements();
        while (e2.hasMoreElements()) {
            DL.add((ConstructionObject)e2.nextElement());
        }
        return DL.elements();
    }

    public PointObject getP2() {
        return this.P2;
    }

    public boolean contains(PointObject p) {
        return p == this.P2;
    }

    public void dragTo(double x, double y) {
        this.M.move(this.x1 + (x - this.x3), this.y1 + (y - this.y3));
        this.P2.move(this.x2 + (x - this.x3), this.y2 + (y - this.y3));
    }

    public void move(double x, double y) {
    }

    public boolean moveable() {
        return !this.Fixed && this.M.moveable() && this.P2.moveable();
    }

    public void startDrag(double x, double y) {
        this.x1 = this.M.getX();
        this.y1 = this.M.getY();
        this.x2 = this.P2.getX();
        this.y2 = this.P2.getY();
        this.x3 = x;
        this.y3 = y;
    }

    public void snap(ZirkelCanvas zc) {
        if (this.moveable()) {
            this.M.snap(zc);
            this.P2.snap(zc);
        }
    }
}

