/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.macro;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.StringTokenizer;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.DepList;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.macro.Macro;
import rene.zirkel.macro.MacroPrompt;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.AreaObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.LineObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.RayObject;
import rene.zirkel.objects.SegmentObject;
import rene.zirkel.objects.TwoPointLineObject;
import rene.zirkel.objects.UserFunctionObject;

public class MacroRunner
extends ObjectConstructor
implements Selector {
    String[] S;
    int Param;
    Macro M;
    ConstructionObject[] Params;
    boolean[] NewPoint;
    boolean[] Fixed;
    static DepList DL = new DepList();

    public void setMacro(Macro m, ZirkelCanvas zc) {
        this.S = m.getPrompts();
        this.Param = 0;
        this.M = m;
        this.Params = new ConstructionObject[this.S.length];
        this.Fixed = new boolean[this.S.length];
        this.NewPoint = new boolean[this.S.length];
        int i = 0;
        while (i < this.S.length) {
            this.Fixed[i] = false;
            ++i;
        }
    }

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (!zc.Visual) {
            return;
        }
        ConstructionObject o = null;
        ConstructionObject[] p = this.M.getParams();
        o = p[this.Param] instanceof PointObject ? zc.selectCreatePoint(e2.getX(), e2.getY()) : zc.selectWithSelector(e2.getX(), e2.getY(), this);
        if (o == null) {
            return;
        }
        int ip = this.Param;
        if (!this.setNextParameter(o, zc, e2.isShiftDown())) {
            return;
        }
        boolean bl = this.NewPoint[ip] = o instanceof PointObject && zc.isNewPoint();
        if (this.Param >= this.S.length) {
            this.doMacro(zc);
            this.reset(zc);
        } else {
            this.getFixed(zc);
        }
    }

    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        ConstructionObject[] p = this.M.getParams();
        if (p[this.Param] instanceof PointObject) {
            return o instanceof PointObject;
        }
        if (p[this.Param] instanceof FixedAngleObject) {
            return o instanceof FixedAngleObject;
        }
        if (p[this.Param] instanceof SegmentObject) {
            return o instanceof SegmentObject;
        }
        if (p[this.Param] instanceof RayObject) {
            return o instanceof RayObject;
        }
        if (p[this.Param] instanceof TwoPointLineObject) {
            return o instanceof TwoPointLineObject;
        }
        if (p[this.Param] instanceof PrimitiveLineObject) {
            return o instanceof PrimitiveLineObject;
        }
        if (p[this.Param] instanceof PrimitiveCircleObject) {
            return o instanceof PrimitiveCircleObject;
        }
        if (p[this.Param] instanceof FunctionObject) {
            return o instanceof FunctionObject;
        }
        if (p[this.Param] instanceof UserFunctionObject) {
            return o instanceof UserFunctionObject;
        }
        if (p[this.Param] instanceof AngleObject) {
            return o instanceof AngleObject;
        }
        if (p[this.Param] instanceof ExpressionObject) {
            return o instanceof ExpressionObject || o instanceof AngleObject || o instanceof FixedAngleObject || o instanceof AreaObject;
        }
        if (p[this.Param] instanceof AreaObject) {
            return o instanceof AreaObject;
        }
        return false;
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        ConstructionObject[] p = this.M.getParams();
        if (!(p[this.Param] instanceof PointObject) && this.Param == p.length - 1) {
            zc.clearPreview();
            zc.repaint();
            ConstructionObject o = zc.selectWithSelector(e2.getX(), e2.getY(), (Selector)this, false);
            if (o != null) {
                zc.prepareForPreview(e2);
                this.Params[this.Param] = o;
                this.runMacroPreview(zc);
                zc.indicateWithSelector(e2.getX(), e2.getY(), this);
                return;
            }
        }
        if (!simple && this.waitForLastPoint()) {
            if (zc.isPreview()) {
                zc.movePreview(e2);
            } else {
                zc.prepareForPreview(e2);
                this.finishConstruction(e2, zc);
                return;
            }
        }
        if (p[this.Param] instanceof PointObject) {
            zc.indicateCreatePoint(e2.getX(), e2.getY(), true);
        } else {
            zc.indicateWithSelector(e2.getX(), e2.getY(), this);
        }
    }

    public boolean waitForLastPoint() {
        if (this.M.countPrompts() > 0) {
            return false;
        }
        ConstructionObject[] p = this.M.getParams();
        return p[this.Param] instanceof PointObject && this.Param == p.length - 1;
    }

    public void finishConstruction(MouseEvent e2, ZirkelCanvas zc) {
        ConstructionObject[] p = this.M.getParams();
        if (!(p[this.Param] instanceof PointObject)) {
            return;
        }
        PointObject o = zc.selectCreatePoint(e2.getX(), e2.getY());
        this.NewPoint[this.Param] = true;
        this.Params[this.Param] = o;
        this.runMacroPreview(zc);
    }

    public void reset(ZirkelCanvas zc) {
        if (zc.Visual) {
            super.reset(zc);
            this.Param = 0;
            if (this.M != null && this.M.hasFixed()) {
                this.getFixed(zc);
            }
            this.showStatus(zc);
        } else if (this.M != null) {
            StringBuffer b2 = new StringBuffer();
            b2.append('=');
            String name = this.M.getName();
            if (name.indexOf("(") > 0) {
                b2.append("\"" + this.M.getName() + "\"");
            } else {
                b2.append(this.M.getName());
            }
            b2.append('(');
            int i = 0;
            while (i < this.M.getParams().length - 1) {
                b2.append(',');
                ++i;
            }
            b2.append(')');
            zc.setPrompt(b2.toString());
        }
    }

    public void getFixed(ZirkelCanvas zc) {
        if (this.M == null || !zc.Visual) {
            return;
        }
        boolean start = this.Param == 0;
        while ((this.M.isFixed(this.Param) || this.M.getPrompts()[this.Param].startsWith("=")) && this.Param < (start ? this.S.length - 1 : this.S.length)) {
            String name = this.M.isFixed(this.Param) ? this.M.getLast(this.Param) : this.M.getPrompts()[this.Param].substring(1);
            if (name.equals("")) {
                this.M.setFixed(this.Param, false);
                break;
            }
            ConstructionObject o = zc.getConstruction().find(name);
            if (o == null) {
                this.M.setFixed(this.Param, false);
                break;
            }
            if (!this.setNextParameter(o, zc, false)) {
                return;
            }
            if (this.Param < this.S.length) continue;
            this.doMacro(zc);
            this.reset(zc);
            break;
        }
        this.showStatus(zc);
    }

    public void returnPressed(ZirkelCanvas zc) {
        if (this.M == null || !zc.Visual) {
            return;
        }
        String name = this.M.getLast(this.Param);
        if (name.equals("")) {
            return;
        }
        ConstructionObject o = zc.getConstruction().find(name);
        if (!this.setNextParameter(o, zc, false)) {
            return;
        }
        if (this.Param >= this.S.length) {
            this.doMacro(zc);
            this.reset(zc);
        } else {
            this.getFixed(zc);
        }
    }

    public boolean setNextParameter(ConstructionObject o, ZirkelCanvas zc, boolean fix) {
        if (!this.isAdmissible(zc, o)) {
            return false;
        }
        this.Params[this.Param] = o;
        o.setSelected(true);
        if (fix) {
            this.Fixed[this.Param] = true;
        }
        zc.getConstruction().addParameter(o);
        zc.repaint();
        ++this.Param;
        return true;
    }

    public void doMacro(ZirkelCanvas zc) {
        String[] value = new String[]{};
        this.runMacro(zc, value);
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.M != null) {
            ConstructionObject[] p = this.M.getParams();
            String type = "???";
            if (p[this.Param] instanceof PointObject) {
                type = Zirkel.name("name.Point");
            } else if (p[this.Param] instanceof FixedAngleObject) {
                type = Zirkel.name("name.FixedAngle");
            } else if (p[this.Param] instanceof SegmentObject) {
                type = Zirkel.name("name.Segment");
            } else if (p[this.Param] instanceof LineObject) {
                type = Zirkel.name("name.TwoPointLine");
            } else if (p[this.Param] instanceof RayObject) {
                type = Zirkel.name("name.Ray");
            } else if (p[this.Param] instanceof PrimitiveLineObject) {
                type = Zirkel.name("name.Line");
            } else if (p[this.Param] instanceof PrimitiveCircleObject) {
                type = Zirkel.name("name.Circle");
            } else if (p[this.Param] instanceof ExpressionObject) {
                type = Zirkel.name("name.Expression");
            } else if (p[this.Param] instanceof AreaObject) {
                type = Zirkel.name("name.Polygon");
            } else if (p[this.Param] instanceof AngleObject) {
                type = Zirkel.name("name.Angle");
            }
            String s = this.M.getLast(this.Param);
            String prompt = s.equals("") ? ConstructionObject.text4(Zirkel.name("message.runmacro"), this.M.getName(), "" + (this.Param + 1), type, this.S[this.Param]) : String.valueOf(ConstructionObject.text4(Zirkel.name("message.runmacro"), this.M.getName(), "" + (this.Param + 1), type, this.S[this.Param])) + " " + ConstructionObject.text1(Zirkel.name("message.runmacro.return"), this.M.getLast(this.Param));
            zc.showStatus(prompt);
        }
    }

    public void runMacro(ZirkelCanvas zc, Construction c2, String[] value) {
        this.M.setTranslation(c2);
        ConstructionObject LastBefore = c2.last();
        int N = this.Params.length;
        Enumeration e2 = this.M.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.clearParameter();
            o.setTranslation(null);
        }
        this.M.clearTranslations();
        c2.clearTranslators();
        ConstructionObject[] p = this.M.getParams();
        this.M.initLast();
        int i = 0;
        while (i < N) {
            PointObject P;
            this.M.setLast(this.Params[i].getName(), i);
            p[i].setTranslation(this.Params[i]);
            p[i].setMainParameter();
            if (this.NewPoint[i] && p[i].isHidden()) {
                this.Params[i].setHidden(true);
            }
            if (this.Params[i] instanceof PointObject && p[i] instanceof PointObject && this.NewPoint[i]) {
                PointObject pa = (PointObject)this.Params[i];
                PointObject pp = (PointObject)p[i];
                pa.setIncrement(pp.getIncrement());
                if (pp.getBound() != null) {
                    pa.setBound(pp.getBound());
                    pa.setInside(pp.isInside());
                    pa.translate();
                }
            }
            if (this.Params[i] instanceof PointObject && p[i] instanceof PointObject && ((PointObject)p[i]).dependsOnItselfOnly() && !(P = (PointObject)this.Params[i]).depending().hasMoreElements()) {
                P.setConstruction(this.M);
                P.setFixed(((PointObject)p[i]).getEX(), ((PointObject)p[i]).getEY());
                P.translateConditionals();
                P.translate();
                P.setConstruction(c2);
            }
            if (p[i].isMainParameter()) {
                e2 = p[i].secondaryParams();
                DL.reset();
                while (e2.hasMoreElements()) {
                    ConstructionObject o = (ConstructionObject)e2.nextElement();
                    DL.add(o);
                    o.setParameter();
                }
                e2 = DL.elements();
                Enumeration ep = this.Params[i].secondaryParams();
                while (ep.hasMoreElements() && e2.hasMoreElements()) {
                    ConstructionObject o = (ConstructionObject)e2.nextElement();
                    ConstructionObject op = (ConstructionObject)ep.nextElement();
                    if (o.getTranslation() != op && o.getTranslation() != null) {
                        zc.warning(Zirkel.name("macro.usage"));
                        return;
                    }
                    o.setTranslation(op);
                }
            }
            ++i;
        }
        e2 = this.M.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isParameter()) continue;
            ConstructionObject oc = o.copy();
            oc.setKeep(false);
            oc.setTarget(false);
            c2.addNoCheck(oc);
            o.setTranslation(oc);
            oc.validate();
            c2.added(oc);
            if (o.isTarget()) {
                oc.setTargetDefaults();
            }
            if (oc.getColorIndex() == 0) {
                oc.setColor(c2.DefaultColor);
            }
            if (!(oc instanceof FixedCircleObject) && !(oc instanceof FixedAngleObject) && !(oc instanceof ExpressionObject) || !this.M.promptFor(o.getName())) continue;
            c2.updateCircleDep();
            c2.dovalidate();
            zc.repaint();
            int index = this.M.getPromptFor(o.getName());
            String v = "";
            if (index >= value.length || value[index].equals("")) {
                MacroPrompt pr = new MacroPrompt(zc.getFrame(), this.M.getPromptName(o.getName()));
                pr.setVisible(true);
                if (pr.isValid()) {
                    v = pr.getValue();
                }
            } else {
                v = value[index];
            }
            if (!v.equals("")) {
                oc.setFixed(v);
                zc.check();
                continue;
            }
            zc.warning(Zirkel.name("macro.prompt.illegal"));
        }
        e2 = this.M.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isParameter()) continue;
            o.laterTranslate(this.M);
        }
        c2.updateCircleDep();
        c2.runTranslators(this.M);
        c2.dovalidate();
        zc.repaint();
        int fixed = 0;
        int i2 = 0;
        while (i2 < this.Fixed.length) {
            if (this.Fixed[i2]) {
                ++fixed;
            }
            ++i2;
        }
        if (fixed > 0 && fixed < this.Fixed.length && !this.M.hasFixed()) {
            String name = String.valueOf(this.M.getName()) + " -";
            int i3 = 0;
            while (i3 < this.Fixed.length) {
                if (this.Fixed[i3]) {
                    name = String.valueOf(name) + " " + this.M.LastParams[i3];
                }
                ++i3;
            }
            this.M = zc.copyMacro(this.M, name, this.Fixed);
            i3 = 0;
            while (i3 < this.Fixed.length) {
                this.Fixed[i3] = false;
                ++i3;
            }
            this.reset(zc);
        }
        if (LastBefore != null && this.M.hideDuplicates()) {
            zc.hideDuplicates(LastBefore);
        }
    }

    public void runMacro(ZirkelCanvas zc, String[] value) {
        this.runMacro(zc, zc.getConstruction(), value);
    }

    public void runMacroPreview(ZirkelCanvas zc) {
        Construction c2 = zc.getConstruction();
        this.M.setTranslation(c2);
        int N = this.Params.length;
        Enumeration e2 = this.M.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.clearParameter();
            o.setTranslation(null);
        }
        this.M.clearTranslations();
        c2.clearTranslators();
        ConstructionObject[] p = this.M.getParams();
        int i = 0;
        while (i < N) {
            this.M.setLast(this.Params[i].getName(), i);
            p[i].setTranslation(this.Params[i]);
            p[i].setMainParameter();
            if (this.NewPoint[i] && p[i].isHidden()) {
                this.Params[i].setHidden(true);
            }
            if (p[i].isMainParameter()) {
                e2 = p[i].secondaryParams();
                DL.reset();
                while (e2.hasMoreElements()) {
                    ConstructionObject o = (ConstructionObject)e2.nextElement();
                    DL.add(o);
                    o.setParameter();
                }
                e2 = DL.elements();
                Enumeration ep = this.Params[i].secondaryParams();
                while (ep.hasMoreElements() && e2.hasMoreElements()) {
                    ConstructionObject o = (ConstructionObject)e2.nextElement();
                    ConstructionObject op = (ConstructionObject)ep.nextElement();
                    if (o.getTranslation() != op && o.getTranslation() != null) {
                        return;
                    }
                    if (o == null) continue;
                    o.setTranslation(op);
                }
            }
            ++i;
        }
        e2 = this.M.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isParameter()) continue;
            ConstructionObject oc = o.copy();
            oc.setKeep(false);
            oc.setTarget(false);
            oc.setSelectable(false);
            oc.setIndicated(true);
            c2.addNoCheck(oc);
            o.setTranslation(oc);
            oc.validate();
            c2.added(oc);
            if (o.isTarget()) {
                oc.setTargetDefaults();
            }
            if (o.isHidden()) {
                oc.setHidden(true);
            }
            if (oc.getColorIndex() != 0) continue;
            oc.setColor(c2.DefaultColor);
        }
        e2 = this.M.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isParameter()) continue;
            o.laterTranslate(this.M);
        }
        c2.updateCircleDep();
        c2.runTranslators(this.M);
        c2.dovalidate();
        zc.repaint();
    }

    public void run(ZirkelCanvas zc, Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        ConstructionObject[] p = this.M.getParams();
        if (nparams != p.length + this.M.countPrompts()) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        String[] value = new String[this.M.countPrompts()];
        int i = 0;
        while (i < this.M.countPrompts()) {
            value[i] = params[p.length + i];
            ++i;
        }
        i = 0;
        while (i < p.length) {
            ConstructionObject o = c2.find(params[i]);
            if (o == null) {
                throw new ConstructionException(Zirkel.name("exception.notfound"));
            }
            if (p[this.Param] instanceof PointObject) {
                if (!(o instanceof PointObject)) {
                    throw new ConstructionException(Zirkel.name("exception.type"));
                }
                if (p[this.Param] instanceof SegmentObject) {
                    if (!(o instanceof SegmentObject)) {
                        throw new ConstructionException(Zirkel.name("exception.type"));
                    }
                    if (p[this.Param] instanceof LineObject) {
                        if (!(o instanceof LineObject)) {
                            throw new ConstructionException(Zirkel.name("exception.type"));
                        }
                        if (p[this.Param] instanceof RayObject) {
                            if (!(o instanceof RayObject)) {
                                throw new ConstructionException(Zirkel.name("exception.type"));
                            }
                            if (p[this.Param] instanceof PrimitiveLineObject) {
                                if (!(o instanceof PrimitiveLineObject)) {
                                    throw new ConstructionException(Zirkel.name("exception.type"));
                                }
                                if (p[this.Param] instanceof PrimitiveCircleObject) {
                                    if (!(o instanceof PrimitiveCircleObject)) {
                                        throw new ConstructionException(Zirkel.name("exception.type"));
                                    }
                                    throw new ConstructionException(Zirkel.name("exception.type"));
                                }
                            }
                        }
                    }
                }
            }
            this.Params[i] = o;
            ++i;
        }
        this.runMacro(zc, c2, value);
        StringTokenizer t = new StringTokenizer(name, ",");
        Enumeration e2 = this.M.getTargets().elements();
        while (e2.hasMoreElements() && t.hasMoreTokens()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.getTranslation().setName(t.nextToken().trim());
        }
        zc.repaint();
    }
}

