/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.help;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import rene.gui.Global;
import rene.util.MyVector;
import rene.util.sort.SortObject;
import rene.util.sort.Sorter;
import rene.zirkel.help.Keyword;
import rene.zirkel.help.Topic;

public class Translator {
    BufferedReader in;
    PrintWriter out;
    String line;
    Hashtable Headers;
    Hashtable Keywords;
    Hashtable Aliases;
    Hashtable NextTopic;

    public Translator(String source, String language) {
        if (language != null) {
            Locale.setDefault(new Locale(language, ""));
        }
        Global.initBundle("rene/zirkel/docs/ZirkelProperties");
        String codepage = Global.name("codepage.help", "default");
        try {
            this.Headers = new Hashtable();
            this.Aliases = new Hashtable();
            this.NextTopic = new Hashtable();
            this.in = codepage.equals("default") ? new BufferedReader(new InputStreamReader(new FileInputStream(source))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), codepage));
            this.line = this.in.readLine();
            String topic = "";
            while (this.line != null) {
                if (this.line.startsWith(".")) {
                    String thistopic = this.addHeader();
                    if (!topic.equals("") && !thistopic.equals("")) {
                        this.NextTopic.put(topic, thistopic);
                    }
                    if (thistopic.equals("")) continue;
                    topic = thistopic;
                    continue;
                }
                this.line = this.in.readLine();
            }
            this.in.close();
            this.Keywords = new Hashtable();
            this.in = codepage.equals("default") ? new BufferedReader(new InputStreamReader(new FileInputStream(source))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), codepage));
            this.line = this.in.readLine();
            while (this.line != null) {
                if (this.line.startsWith(".")) {
                    this.writeFile();
                    continue;
                }
                this.line = this.in.readLine();
            }
            this.in.close();
            this.writeKeywords();
            this.writeTopics();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public String addHeader() throws IOException {
        String filename = this.line.substring(1);
        int n = filename.indexOf(" ");
        if (n > 0) {
            StringTokenizer t = new StringTokenizer(filename.substring(n + 1));
            filename = filename.substring(0, n);
            while (t.hasMoreTokens()) {
                String alias = t.nextToken();
                this.Aliases.put(alias, filename);
            }
        }
        this.line = this.in.readLine();
        while (this.line != null) {
            if (!this.line.startsWith(".related")) break;
            this.line = this.in.readLine();
        }
        if (this.line == null) {
            return "";
        }
        String header = this.line.replace("__", "");
        this.Headers.put(filename, header);
        while (this.line != null) {
            if (this.line.startsWith(".")) break;
            this.line = this.in.readLine();
        }
        return filename;
    }

    public void writeFile() throws IOException {
        String filename = this.line.substring(1);
        int n = filename.indexOf(" ");
        if (n > 0) {
            filename = filename.substring(0, n);
        }
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(filename) + ".html"), "utf-8"));
        this.writeHeader(this.out);
        this.line = this.in.readLine();
        String related = "";
        while (this.line != null) {
            if (!this.line.startsWith(".related")) break;
            related = String.valueOf(related) + this.line.substring(".related".length());
            this.line = this.in.readLine();
        }
        if (this.line == null) {
            return;
        }
        this.out.println("<h2>" + this.extractKeywords(this.line, filename) + "</h2>");
        this.line = this.in.readLine();
        boolean paragraph = false;
        boolean start = true;
        while (this.line != null) {
            String image;
            if (this.line.startsWith(".")) break;
            if (this.line.trim().equals("")) {
                if (paragraph) {
                    this.out.println("</p>");
                }
                start = true;
                while (this.line != null && (this.line.trim().equals("") || this.line.startsWith("->") || this.line.startsWith("//image "))) {
                    if (this.line.startsWith("//image ")) {
                        image = this.line.substring("//image ".length());
                        this.out.println("<p align=\"center\"><img src=\"" + image + "\"/></p>");
                    }
                    this.line = this.in.readLine();
                }
                this.out.println("<p>");
                paragraph = true;
                continue;
            }
            if (this.line.startsWith(" ") && !start) {
                this.out.println("<br />");
            } else {
                start = false;
            }
            if (this.line.startsWith("//image+ ")) {
                image = this.line.substring("//image+ ".length());
                this.out.println("<img align=\"right\" src=\"" + image + "\"/>");
            } else if (this.line.startsWith("//image- ")) {
                image = this.line.substring("//image+ ".length());
                this.out.println("<img align=\"left\" src=\"" + image + "\"/>");
            } else {
                this.out.println(this.extractKeywords(this.line.trim(), filename));
            }
            this.line = this.in.readLine();
        }
        if (paragraph) {
            this.out.println("</p>");
        }
        this.out.println("<p>");
        this.out.print(String.valueOf(Global.name("help.related", "Related Topics")) + ": ");
        StringTokenizer st = new StringTokenizer(related, " ");
        boolean first = true;
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            String t = "";
            try {
                if (this.Headers.get(s) != null) {
                    t = (String)this.Headers.get(s);
                } else if (this.Headers.get((String)this.Aliases.get(s)) != null) {
                    t = (String)this.Headers.get((String)this.Aliases.get(s));
                }
            }
            catch (Exception e2) {
                System.out.println(String.valueOf(s) + " missing in " + filename);
            }
            if (!first) {
                this.out.println(", ");
            }
            this.out.print("<a href=\"" + s + ".html\">" + t + "</a>");
            first = false;
        }
        this.out.println();
        this.out.println("</p>");
        if (this.NextTopic.get(filename) != null) {
            this.out.println("<p>");
            this.out.print(String.valueOf(Global.name("help.nexttopic", "NextTopic")) + ": ");
            String nexttopic = (String)this.NextTopic.get(filename);
            this.out.println("<a href=\"" + nexttopic + ".html\">" + (String)this.Headers.get(nexttopic) + "</a>");
            this.out.println("</p>");
        }
        this.writeFooter(this.out);
        this.out.close();
    }

    /*
     * Unable to fully structure code
     */
    public String extractKeywords(String s, String topic) {
        s = s.replace('\u00a7', ' ');
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("<", "&lt;");
        t = "";
        n = s.indexOf("__");
        if (n >= 0) ** GOTO lbl16
        return s;
lbl-1000:
        // 1 sources

        {
            t = String.valueOf(t) + s.substring(0, n) + "<b>";
            if ((n = (s = s.substring(n + 2)).indexOf("__")) < 0) {
                return String.valueOf(t) + s + "</b>";
            }
            keyword = s.substring(0, n);
            this.addKeyword(keyword, topic);
            t = String.valueOf(t) + keyword + "</b>";
            s = s.substring(n + 2);
            n = s.indexOf("__");
lbl16:
            // 2 sources

            ** while (n >= 0)
        }
lbl17:
        // 1 sources

        return String.valueOf(t) + s;
    }

    public void addKeyword(String keyword, String topic) {
        if (this.Keywords.get(keyword.toLowerCase()) == null) {
            Keyword k = new Keyword(keyword);
            k.addTopic(topic);
            this.Keywords.put(keyword.toLowerCase(), k);
        } else {
            Keyword k = (Keyword)this.Keywords.get(keyword.toLowerCase());
            k.addTopic(topic);
        }
    }

    public void writeKeywords() throws IOException {
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("keywords.html"), "utf-8"));
        this.writeHeader(out);
        Enumeration e2 = this.Keywords.elements();
        MyVector All = new MyVector();
        while (e2.hasMoreElements()) {
            Keyword key = (Keyword)e2.nextElement();
            All.addElement(key);
        }
        Object[] k = new Keyword[All.size()];
        All.copyInto(k);
        Sorter.sort((SortObject[])k, All.size());
        out.println("<p>");
        char preface = '\u0000';
        int i = 0;
        while (i < k.length) {
            char c2 = Character.toUpperCase(((Keyword)k[i]).K.charAt(0));
            if (c2 != preface) {
                preface = c2;
                out.println("</p>");
                out.println("<p><b>" + preface + "</b></p>");
                out.println("<p>");
            }
            String keyword = ((Keyword)k[i]).K;
            keyword = String.valueOf(Character.toUpperCase(keyword.charAt(0))) + keyword.substring(1);
            out.print(keyword);
            int j = 0;
            while (j < ((Keyword)k[i]).V.size()) {
                String topic = (String)((Keyword)k[i]).V.elementAt(j);
                if (j == 0) {
                    out.print(": ");
                } else {
                    out.print(", ");
                }
                out.print("<a href=\"" + topic + ".html\">" + (String)this.Headers.get(topic) + "</a>");
                ++j;
            }
            out.print("<br />");
            ++i;
        }
        out.println("</p>");
        this.writeFooter(out);
        out.close();
    }

    public void writeTopics() throws IOException {
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("topics.html"), "utf-8"));
        this.writeHeader(out);
        out.println("<p>");
        Enumeration e2 = this.Headers.keys();
        MyVector All = new MyVector();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            if (this.Headers.get(key) == null) continue;
            All.addElement(new Topic(key, (String)this.Headers.get(key)));
        }
        Object[] k = new Topic[All.size()];
        All.copyInto(k);
        Sorter.sort((SortObject[])k, All.size());
        int i = 0;
        while (i < k.length) {
            out.println("<a href=\"" + ((Topic)k[i]).T + ".html\">" + ((Topic)k[i]).D + "</a><br />");
            ++i;
        }
        out.println("</p>");
        this.writeFooter(out);
        out.close();
    }

    public void writeHeader(PrintWriter out) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("header.dat"), "UTF-8"));
        this.copy(in, out);
        in.close();
    }

    public void writeFooter(PrintWriter out) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("footer.dat"), "UTF-8"));
        this.copy(in, out);
        in.close();
    }

    public void copy(BufferedReader in, PrintWriter out) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            out.println(line);
        }
        return;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("usage: java -cp zirkel.jar rene.helptohtmt.Translator source language");
        } else {
            new Translator(args[0], args[1]);
        }
    }
}

