/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import atp.sHotEqn;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import rene.gui.Global;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.graphics.FontStruct;
import rene.zirkel.graphics.LatexOutput;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;

public class MyGraphics13
extends MyGraphics {
    Graphics2D G;
    BasicStroke Thin;
    BasicStroke Normal;
    BasicStroke Thick;
    BasicStroke SuperThick;
    AlphaComposite C;
    AlphaComposite CO;
    Component ZC = null;
    LatexOutput LOut;
    int[] xx = new int[64];
    int[] yy = new int[64];
    FontStruct FS = new FontStruct();
    int fsize;
    boolean flarge;
    boolean fbold;
    int ffactor = Global.getParameter("ffactor", 130);
    int StrH = 0;
    int StrW = 0;
    int StrAsc = 0;
    boolean StrTex = false;
    String Str = null;
    sHotEqn HE = null;

    public MyGraphics13(Graphics g, double factor, Component zc, LatexOutput lout) {
        this.LOut = lout;
        this.G = (Graphics2D)g;
        if (Global.getParameter("quality", true)) {
            this.G.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.G.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.G.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            this.G.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
        float[] dash = new float[]{(float)(factor * 15.0), (float)(factor * 15.0)};
        if (factor < Global.getParameter("minlinesize", 1.5)) {
            factor = Global.getParameter("minlinesize", 1.5);
        }
        this.Thin = new BasicStroke((float)factor, 0, 0, 10.0f, dash, 0.0f);
        this.Normal = new BasicStroke((float)factor);
        this.Thick = new BasicStroke((float)(factor * 2.0), 1, 0);
        this.SuperThick = new BasicStroke((float)(factor * 5.0), 1, 1);
        this.C = AlphaComposite.getInstance(3, 0.5f);
        this.CO = AlphaComposite.getInstance(3, 1.0f);
        this.G.setComposite(this.CO);
        this.ZC = zc;
    }

    public MyGraphics13(Graphics g) {
        this(g, 0.5, null, null);
    }

    public MyGraphics13(Graphics g, Component zc) {
        this(g, 0.5, zc, null);
    }

    public MyGraphics13(Graphics g, double factor) {
        this(g, factor, null, null);
    }

    public void setColor(Color c2) {
        this.G.setColor(c2);
    }

    public void setColor(ConstructionObject o) {
        this.G.setStroke(this.Normal);
        if (o.isJobTarget()) {
            if (o.isNoCheckTarget()) {
                this.setColor(ZirkelFrame.NoCheckTargetColor);
            } else {
                this.setColor(ZirkelFrame.TargetColor);
            }
        } else if (o.indicated()) {
            this.setColor(ZirkelFrame.IndicateColor);
        } else if (o.selected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (o.getColorType() == 2) {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterLightColors[i]);
            } else {
                this.setColor(ZirkelFrame.LightColors[i]);
            }
        } else {
            int i = o.getColorIndex();
            if (o.isHidden()) {
                this.setColor(ZirkelFrame.BrighterColors[i]);
            } else {
                this.setColor(ZirkelFrame.Colors[i]);
            }
        }
        if (o.getColorType() == 2) {
            this.G.setStroke(this.Thin);
        } else if (o.getColorType() == 1) {
            this.G.setStroke(this.Thick);
        } else {
            this.G.setStroke(this.Normal);
        }
    }

    public void clearRect(int x, int y, int w, int h, Color c2) {
        this.G.setColor(c2);
        this.G.fillRect(x, y, w, h);
    }

    public void setFillColor(ConstructionObject o) {
        this.G.setStroke(this.Normal);
        if (o.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (o instanceof PointObject && o.indicated()) {
            this.setColor(ZirkelFrame.IndicateColor);
        } else if (o.getColorType() == 0 && o.isFillBackground() && !o.selected()) {
            this.setColor(this.G.getBackground());
            this.G.setStroke(this.Normal);
        } else {
            if (o.getColorType() != 1) {
                int i = o.getColorIndex();
                if (o.isHidden()) {
                    this.setColor(ZirkelFrame.BrighterLightColors[i]);
                } else {
                    this.setColor(ZirkelFrame.LightColors[i]);
                }
            } else {
                int i = o.getColorIndex();
                if (o.isHidden()) {
                    this.setColor(ZirkelFrame.BrighterColors[i]);
                } else {
                    this.setColor(ZirkelFrame.Colors[i]);
                }
            }
            if (o.getColorType() == 2) {
                this.G.setStroke(this.Thin);
            } else if (o.getColorType() == 1) {
                this.G.setStroke(this.Thick);
            } else {
                this.G.setStroke(this.Normal);
            }
        }
    }

    public void setLabelColor(ConstructionObject o) {
        if (o.labelSelected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (o.isFilled()) {
            int type = o.getColorType();
            o.setColorType(0);
            this.setColor(o);
            o.setColorType(type);
        } else {
            this.setColor(o);
        }
    }

    public void drawRect(double x, double y, double w, double h) {
        if (this.test(x) || this.test(y) || this.test(x + w) || this.test(y + h)) {
            return;
        }
        this.G.setStroke(this.Normal);
        this.G.draw(new Rectangle2D.Double(x, y, w, h));
    }

    public void drawMarkerRect(double x, double y, double w, double h) {
        if (this.test(x) || this.test(y) || this.test(x + w) || this.test(y + h)) {
            return;
        }
        this.G.setColor(ZirkelFrame.IndicateColor);
        this.G.setStroke(this.SuperThick);
        this.G.draw(new Rectangle2D.Double(x, y, w, h));
        this.G.setStroke(this.Normal);
    }

    public void drawLine(double x, double y, double x1, double y1) {
        if (this.test(x) || this.test(y) || this.test(x1) || this.test(y1)) {
            return;
        }
        this.G.setStroke(this.Normal);
        this.G.draw(new Line2D.Double(x, y, x1, y1));
    }

    public void drawThickLine(double x, double y, double x1, double y1) {
        if (this.test(x) || this.test(y) || this.test(x1) || this.test(y1)) {
            return;
        }
        this.G.setStroke(this.Thick);
        this.G.draw(new Line2D.Double(x, y, x1, y1));
        this.G.setStroke(this.Normal);
    }

    public void drawMarkerLine(double x, double y, double x1, double y1) {
        if (this.test(x) || this.test(y) || this.test(x1) || this.test(y1)) {
            return;
        }
        this.G.setColor(ZirkelFrame.IndicateColor);
        this.G.setStroke(this.SuperThick);
        this.G.draw(new Line2D.Double(x, y, x1, y1));
        this.G.setStroke(this.Normal);
    }

    public void drawLine(double x, double y, double x1, double y1, ConstructionObject o) {
        if (this.test(x) || this.test(y) || this.test(x1) || this.test(y1)) {
            return;
        }
        this.G.draw(new Line2D.Double(x, y, x1, y1));
    }

    public boolean test(double x) {
        return Math.abs(x) > 100000.0;
    }

    public void drawArc(double x, double y, double w, double h, double a2, double b2) {
        if (this.test(x) || this.test(y) || this.test(w) || this.test(h)) {
            return;
        }
        this.G.setStroke(this.Normal);
        this.G.draw(new Arc2D.Double(x, y, w, h, a2, b2, 0));
    }

    public void drawArc(double x, double y, double w, double h, double a2, double b2, ConstructionObject o) {
        if (this.test(x) || this.test(y) || this.test(w) || this.test(h)) {
            return;
        }
        this.G.draw(new Arc2D.Double(x, y, w, h, a2, b2, 0));
    }

    public FontMetrics getFontMetrics() {
        return this.G.getFontMetrics();
    }

    public void drawString(String s, double x, double y) {
        if (this.test(x) || this.test(y)) {
            return;
        }
        this.G.drawString(s, (float)x, (float)y);
    }

    public void drawOval(double x, double y, double w, double h) {
        if (this.test(x) || this.test(y) || this.test(w) || this.test(h)) {
            return;
        }
        this.G.setStroke(this.Normal);
        this.G.draw(new Ellipse2D.Double(x, y, w, h));
    }

    public void drawOval(double x, double y, double w, double h, ConstructionObject o) {
        if (this.test(x) || this.test(y) || this.test(w) || this.test(h)) {
            return;
        }
        this.G.draw(new Ellipse2D.Double(x, y, w, h));
    }

    public void drawCircle(double x, double y, double r, ConstructionObject o) {
        if (r > 10.0 * (this.W + this.H)) {
            this.drawLargeCircleArc(x, y, r, 0.0, 360.0);
        } else {
            this.G.draw(new Ellipse2D.Double(x - r, y - r, 2.0 * r, 2.0 * r));
        }
    }

    public void drawMarkerArc(double x, double y, double r, double a2, double b2) {
        if (this.test(x) || this.test(y) || this.test(r)) {
            return;
        }
        this.G.setColor(ZirkelFrame.IndicateColor);
        this.G.setStroke(this.SuperThick);
        this.G.draw(new Arc2D.Double(x - r, y - r, 2.0 * r, 2.0 * r, a2, b2, 0));
    }

    public void drawCircleArc(double x, double y, double r, double a2, double b2, ConstructionObject o) {
        if (r > 10.0 * (this.W + this.H)) {
            this.drawLargeCircleArc(x, y, r, a2, b2);
        } else {
            this.G.draw(new Arc2D.Double(x - r, y - r, 2.0 * r, 2.0 * r, a2, b2, 0));
        }
    }

    void drawLargeCircleArc(double x, double y, double r, double a2, double b2) {
        double dw = Math.sqrt((this.W + this.H) / r / 10.0);
        double w = a2;
        double x0 = x + r * Math.cos(w / 180.0 * Math.PI);
        double y0 = y - r * Math.sin(w / 180.0 * Math.PI);
        w += dw;
        while (w < a2 + b2 + dw) {
            double y1;
            double dy;
            double x1;
            double dx;
            if (w > a2 + b2) {
                w = a2 + b2;
            }
            if (Math.sqrt((dx = (x0 + (x1 = x + r * Math.cos(w / 180.0 * Math.PI))) / 2.0) * dx + (dy = (y0 + (y1 = y - r * Math.sin(w / 180.0 * Math.PI))) / 2.0) * dy) <= 10.0 * (this.W + this.H)) {
                this.G.draw(new Line2D.Double(x0, y0, x1, y1));
            }
            x0 = x1;
            y0 = y1;
            w += dw;
        }
    }

    public void fillRect(double x, double y, double w, double h, boolean outline, boolean transparent, ConstructionObject o) {
        if (this.test(x) || this.test(y) || this.test(w) || this.test(h)) {
            return;
        }
        this.setFillColor(o);
        if (transparent && !o.isSolid()) {
            this.G.setComposite(this.C);
        }
        this.G.fill(new Rectangle2D.Double(x, y, w, h));
        if (transparent && !o.isSolid()) {
            this.G.setComposite(this.CO);
        }
        if (outline) {
            this.setColor(o);
            this.G.draw(new Rectangle2D.Double(x, y, w, h));
        }
    }

    public void fillOval(double x, double y, double w, double h, boolean outline, boolean transparent, ConstructionObject o) {
        if (this.test(x) || this.test(y) || this.test(w) || this.test(h)) {
            return;
        }
        if (o.getColorType() != 3) {
            this.setFillColor(o);
            if (transparent && !o.isSolid()) {
                this.G.setComposite(this.C);
            }
            try {
                this.G.fill(new Ellipse2D.Double(x, y, w, h));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (transparent && !o.isSolid()) {
                this.G.setComposite(this.CO);
            }
        }
        if (outline) {
            this.setColor(o);
            this.drawOval(x, y, w, h);
        }
    }

    public void fillArc(double x, double y, double w, double h, double a2, double b2, boolean outline, boolean transparent, boolean arcb, ConstructionObject o) {
        if (this.test(x) || this.test(y) || this.test(w) || this.test(h)) {
            return;
        }
        this.setFillColor(o);
        if (transparent && !o.isSolid()) {
            this.G.setComposite(this.C);
        }
        Arc2D.Double arc = new Arc2D.Double(x, y, w, h, a2, b2, arcb ? 2 : 1);
        this.G.fill(arc);
        if (transparent && !o.isSolid()) {
            this.G.setComposite(this.CO);
        }
        if (outline) {
            this.setColor(o);
            arc.setArcType(0);
            this.G.setStroke(this.Normal);
            this.G.draw(arc);
        }
    }

    public void fillPolygon(double[] x, double[] y, int n, boolean outline, boolean transparent, ConstructionObject o) {
        if (o.getColorType() != 3) {
            this.setFillColor(o);
            if (transparent && !o.isSolid()) {
                this.G.setComposite(this.C);
            }
        }
        if (n > this.xx.length) {
            this.xx = new int[n];
            this.yy = new int[n];
        }
        int i = 0;
        while (i < n) {
            this.xx[i] = (int)x[i];
            if (this.test(x[i])) {
                return;
            }
            this.yy[i] = (int)y[i];
            if (this.test(y[i])) {
                return;
            }
            ++i;
        }
        if (o.getColorType() != 3) {
            this.G.fillPolygon(this.xx, this.yy, n);
            if (transparent && !o.isSolid()) {
                this.G.setComposite(this.CO);
            }
        }
        if (outline) {
            this.setColor(o);
            this.G.setStroke(this.Normal);
            i = 0;
            while (i < n - 1) {
                this.drawLine(this.xx[i], this.yy[i], this.xx[i + 1], this.yy[i + 1]);
                ++i;
            }
            this.drawLine(this.xx[n - 1], this.yy[n - 1], this.xx[0], this.yy[0]);
        }
    }

    public void drawImage(Image i, int x, int y, ImageObserver o) {
        this.G.drawImage(i, x, y, o);
    }

    public void drawImage(Image i, int x, int y, int w, int h, ImageObserver o) {
        this.G.drawImage(i, x, y, w, h, o);
    }

    public void setFont(int h, boolean bold) {
        Font f2 = this.FS.getFont(h, bold);
        if (f2 != null) {
            this.G.setFont(f2);
        } else {
            f2 = new Font(Global.getParameter("font.name", "dialog"), bold ? 1 : 0, h);
            this.FS.storeFont(h, bold, f2);
            this.G.setFont(f2);
        }
    }

    public void setDefaultFont(int h, boolean large, boolean bold) {
        this.ffactor = Global.getParameter("ffactor", 130);
        this.fsize = h;
        this.flarge = large;
        this.fbold = bold;
        this.setFont(large, bold);
    }

    public void setFont(boolean large, boolean bold) {
        int size = this.fsize;
        if (large) {
            size = size * this.ffactor / 100;
        }
        if (this.flarge) {
            size = size * this.ffactor / 100;
        }
        this.setFont(size, bold || this.fbold);
    }

    public void drawImage(Image i, double x, double y, double x1, double y1, double x2, double y2, ImageObserver o) {
        try {
            int w = i.getWidth(o);
            int h = i.getHeight(o);
            AffineTransform AT = new AffineTransform((x1 - x) / (double)w, (y1 - y) / (double)w, (x2 - x) / (double)h, (y2 - y) / (double)h, x, y);
            this.G.drawImage(i, AT, o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Graphics getGraphics() {
        return this.G;
    }

    public void computeString(String s) {
        if (s.equals(this.Str)) {
            return;
        }
        this.StrAsc = 0;
        this.StrW = 0;
        this.StrH = 0;
        this.StrTex = false;
        this.Str = s;
        while (s != "") {
            int n = s.indexOf(36);
            while (n > 0 && s.charAt(n - 1) == '\\') {
                n = s.indexOf(36, n + 1);
            }
            if (n < 0) {
                this.StrH = Math.max(this.StrH, this.getFontMetrics().getHeight());
                this.StrW += this.getFontMetrics().stringWidth(s);
                this.StrAsc = Math.max(this.StrAsc, this.getFontMetrics().getAscent());
                break;
            }
            this.StrTex = true;
            String ss = s.substring(0, n);
            s = s.substring(n + 1);
            this.StrH = Math.max(this.StrH, this.getFontMetrics().getHeight());
            this.StrW += this.getFontMetrics().stringWidth(ss);
            this.StrAsc = Math.max(this.StrAsc, this.getFontMetrics().getAscent());
            n = s.indexOf(36);
            while (n > 0 && s.charAt(n - 1) == '\\') {
                n = s.indexOf(36, n + 1);
            }
            ss = s;
            if (n >= 0) {
                ss = s.substring(0, n);
                s = s.substring(n + 1);
            } else {
                s = "";
            }
            if (this.HE == null || !this.HE.getEquation().equals(ss)) {
                this.setHotEqn(ss);
            }
            this.StrH = Math.max(this.StrH, this.heightHotEqn(this.G));
            this.StrW += this.widthHotEqn(this.G);
            this.StrAsc = Math.max(this.StrAsc, this.ascentHotEqn(this.G));
        }
    }

    public int stringWidth(String s) {
        this.computeString(s);
        return this.StrW;
    }

    public int stringHeight(String s) {
        this.computeString(s);
        return this.StrH;
    }

    public boolean isTex(String s) {
        this.computeString(s);
        return this.StrTex;
    }

    public int drawStringExtended(String s, double x, double y) {
        if (s.startsWith("$$")) {
            if ((s = s.substring(2)).endsWith("$$")) {
                s = s.substring(0, s.length() - 2);
            }
            if (this.HE == null || !this.HE.getEquation().equals(s)) {
                this.setHotEqn(s);
            }
            if (this.LOut == null || !this.LOut.println("$$" + s + "$$", x, y + (double)this.ascentHotEqn(this.G))) {
                return this.paintHotEqn((int)x, (int)y, this.G);
            }
            return this.heightHotEqn(this.G);
        }
        this.computeString(s);
        if (this.LOut != null) {
            if (this.StrTex && this.LOut.printDollar()) {
                this.LOut.println(s, x, y + (double)this.StrAsc, true);
                return this.StrH;
            }
            if (!this.StrTex && this.LOut.println(s, x, y + (double)this.StrAsc)) {
                return this.StrH;
            }
        }
        int w = 0;
        while (s != "") {
            int n = s.indexOf(36);
            while (n > 0 && s.charAt(n - 1) == '\\') {
                n = s.indexOf(36, n + 1);
            }
            if (n < 0) {
                this.drawString(this.translateDollar(s), x + (double)w, y + (double)this.StrAsc);
                w += this.getFontMetrics().stringWidth(s);
                break;
            }
            String ss = s.substring(0, n);
            s = s.substring(n + 1);
            this.drawString(this.translateDollar(ss), x + (double)w, y + (double)this.StrAsc);
            w += this.getFontMetrics().stringWidth(ss);
            n = s.indexOf(36);
            while (n > 0 && s.charAt(n - 1) == '\\') {
                n = s.indexOf(36, n + 1);
            }
            ss = s;
            if (n >= 0) {
                ss = s.substring(0, n);
                s = s.substring(n + 1);
            } else {
                s = "";
            }
            if (this.HE == null || !this.HE.getEquation().equals(ss)) {
                this.setHotEqn(ss);
            }
            this.paintHotEqn((int)x + w, (int)y + this.StrAsc - this.ascentHotEqn(this.G), this.G);
            w += this.widthHotEqn(this.G);
        }
        return this.StrH;
    }

    public String translateDollar(String s) {
        int n;
        while ((n = s.indexOf("\\$")) >= 0) {
            s = String.valueOf(s.substring(0, n)) + "$" + s.substring(n + 2);
        }
        return s;
    }

    public int stringAscent(String s) {
        return this.getFontMetrics().getAscent();
    }

    public void setHotEqn(String s) {
        if (this.ZC == null) {
            return;
        }
        if (this.HE == null) {
            this.HE = new sHotEqn(this.ZC);
        }
        this.HE.setEquation(s);
    }

    public int paintHotEqn(int c2, int r, Graphics g) {
        if (this.HE == null) {
            return 0;
        }
        return this.HE.paint(c2, r, g);
    }

    public int heightHotEqn(Graphics g) {
        if (this.HE == null) {
            return 0;
        }
        return this.HE.getSizeof((String)this.HE.getEquation(), (Graphics)g).height;
    }

    public int ascentHotEqn(Graphics g) {
        if (this.HE == null) {
            return 0;
        }
        return this.HE.getAscent(this.HE.getEquation(), g);
    }

    public int widthHotEqn(Graphics g) {
        if (this.HE == null) {
            return 0;
        }
        return this.HE.getSizeof((String)this.HE.getEquation(), (Graphics)g).width;
    }
}

