/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.Zirkel;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ExpressionText;

class DoubleExpression
extends BasicExpression {
    double X;

    public DoubleExpression(double x) {
        this.X = x;
    }

    public static BasicExpression scan(ExpressionText t) throws ConstructionException {
        double result = 0.0;
        double Faktor = 1.0;
        boolean Punkt = false;
        boolean Digit = false;
        boolean Negative = false;
        if (t.next() == '+') {
            t.advance();
        } else if (t.next() == '-') {
            Negative = true;
            t.advance();
        }
        while (true) {
            char c2;
            if ((c2 = t.next()) >= '0' && c2 <= '9') {
                result = result * 10.0 + (double)(c2 - 48);
                if (Punkt) {
                    Faktor /= 10.0;
                }
                t.advance();
                Digit = true;
                continue;
            }
            if (c2 != '.') break;
            if (Punkt) {
                throw new ConstructionException(Zirkel.name("exception.dot"));
            }
            Punkt = true;
            t.advance();
        }
        if (!Digit) {
            throw new ConstructionException(Zirkel.name("exception.nodigit"));
        }
        if (Negative) {
            result = -result;
        }
        return new DoubleExpression(Faktor * result);
    }

    public double getValue() throws ConstructionException {
        return this.X;
    }

    public String toString() {
        String s = "" + this.X;
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    public void translate() {
    }

    public boolean isNumber() {
        return true;
    }
}

