/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import rene.gui.ButtonAction;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.IconBarListener;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.MyTextField;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.dialogs.HelpCloseDialog;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointonObject;

public class ObjectEditDialog
extends HelpCloseDialog
implements IconBarListener {
    protected MyTextField Text;
    protected MyTextField Unit;
    protected MyTextField Equation;
    protected TextFieldAction Name;
    protected TextFieldAction Alias;
    protected ConstructionObject O;
    protected IconBar ColorIB;
    protected IconBar ThicknessIB;
    protected IconBar IB;
    protected Frame F;
    protected boolean More;
    protected ButtonAction OK;
    protected boolean SuperHide = false;
    protected boolean HideChanged = false;
    protected boolean HidingBreak = false;
    protected boolean BreakChanged = false;
    protected boolean OKControlDown = false;
    Checkbox Decorative;

    public ObjectEditDialog(Frame f2, String title, ConstructionObject o) {
        this(f2, title, o, "properties");
    }

    public ObjectEditDialog(Frame f2, String title, ConstructionObject o, String subject) {
        super(f2, title, true);
        String eq;
        this.F = f2;
        this.O = o;
        o.getConstruction().changed(true);
        this.setLayout(new BorderLayout());
        MyPanel center = new MyPanel();
        center.setLayout(new BorderLayout());
        MyPanel P = new MyPanel();
        this.Name = new TextFieldAction(this, "Name", o.getName(), 32);
        if (this.O.canDisplayName()) {
            this.Alias = new TextFieldAction(this, "Alias", o.getAlias(), 32);
        }
        this.Text = new MyTextField(o.getText(), 32);
        this.Unit = new MyTextField(o.getUnit(), 32);
        P.setLayout(new GridLayout(0, 2));
        P.add(new MyLabel(Zirkel.name("edit.name")));
        P.add(this.Name);
        if (this.Alias != null) {
            P.add(new MyLabel(Zirkel.name("edit.alias")));
            P.add(this.Alias);
        }
        P.add(new MyLabel(Zirkel.name("edit.text")));
        P.add(this.Text);
        if (o.hasUnit()) {
            P.add(new MyLabel(Zirkel.name("edit.unit")));
            P.add(this.Unit);
        }
        if (!(eq = o.getEquation()).equals("")) {
            P.add(new MyLabel(Zirkel.name("edit.equation")));
            this.Equation = new MyTextField(o.getName(), 32);
            this.Equation.setEditable(false);
            this.Equation.setText(eq);
            P.add(this.Equation);
        }
        if (o instanceof PointonObject) {
            P.add(new MyLabel(Zirkel.name("edit.decorative")));
            this.Decorative = new Checkbox("");
            this.Decorative.setState(o.isDecorative());
            P.add(this.Decorative);
        }
        this.addFirst(P);
        center.add("Center", P);
        MyPanel cs = new MyPanel();
        cs.setLayout(new GridLayout(0, 2));
        this.ColorIB = new IconBar(f2);
        this.ColorIB.addToggleGroupLeft("color", 6);
        this.ColorIB.toggle("color", this.O.getColorIndex(true));
        cs.add(new MyLabel(""));
        cs.add(this.ColorIB);
        this.ThicknessIB = new IconBar(f2);
        this.ThicknessIB.addToggleGroupLeft("thickness", 4);
        int ct = this.O.getColorType(true);
        this.ThicknessIB.toggle("thickness", ct);
        if (this.O.canFillBackground()) {
            this.ThicknessIB.addSeparatorLeft();
            this.ThicknessIB.addToggleLeft("fillbackground");
            this.ThicknessIB.setState("fillbackground", this.O.isFillBackground());
        }
        if (o.maybeTransparent()) {
            this.ThicknessIB.addSeparatorLeft();
            this.ThicknessIB.addOnOffLeft("solid");
            this.ThicknessIB.setState("solid", o.isSolid(true));
            if (!o.isFilled()) {
                this.ThicknessIB.setEnabled("solid", false);
            }
        }
        cs.add(new MyLabel(""));
        cs.add(this.ThicknessIB);
        this.IB = new IconBar(f2);
        this.IB.setIconBarListener(this);
        this.IB.addOnOffLeft("hide");
        this.IB.setState("hide", this.O.isHidden(true));
        this.IB.addSeparatorLeft();
        if (this.O.canDisplayName()) {
            this.IB.addOnOffLeft("showname");
            this.IB.setState("showname", this.O.showName(true));
            if (this.showsValue()) {
                this.IB.addOnOffLeft("showvalue");
                this.IB.setState("showvalue", this.O.showValue(true));
            }
            this.IB.addSeparatorLeft();
            this.IB.addOnOffLeft("bold");
            this.IB.setState("bold", this.O.isBold());
            this.IB.addOnOffLeft("large");
            this.IB.setState("large", this.O.isLarge());
            this.IB.addSeparatorLeft();
        }
        this.IB.addOnOffLeft("isback");
        this.IB.setState("isback", this.O.isBack(true));
        this.IB.addOnOffLeft("setbreak");
        this.IB.setState("setbreak", this.O.isBreak());
        cs.add(new MyLabel(""));
        cs.add(this.IB);
        this.addSecond(cs);
        center.add("South", cs);
        this.add("Center", new Panel3D(center));
        MyPanel p = new MyPanel();
        this.addButton(p);
        if (Global.getParameter("options.more", false)) {
            p.add(new ButtonAction(this, Zirkel.name("edit.more"), "More"));
        }
        this.OK = new ButtonAction(this, Zirkel.name("edit.ok"), "OK");
        p.add(this.OK);
        this.OK.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                ObjectEditDialog.this.OKControlDown = e2.isControlDown();
            }
        });
        this.OKControlDown = false;
        ButtonAction b2 = new ButtonAction(this, Zirkel.name("edit.cancel"), "Close");
        p.add(b2);
        this.addHelp(p, subject);
        this.add("South", new Panel3D(p));
        this.More = false;
        this.pack();
        this.center(f2);
    }

    public void doAction(String o) {
        if (o.equals("OK") || o.equals("Name") || o.equals("Alias") || o.equals("More")) {
            String text;
            this.More = o.equals("More") || this.OKControlDown;
            this.O.setName(this.Name.getText());
            if (this.Alias != null) {
                if (!this.Alias.getText().equals("")) {
                    if (this.O.getAlias() == null || !this.O.getAlias().equals(this.Alias.getText())) {
                        this.O.setShowName(true);
                    }
                    this.O.setAlias(this.Alias.getText());
                } else {
                    this.O.setAlias(null);
                }
            }
            if (o.equals("Name")) {
                this.IB.setState("showname", true);
            }
            if ((text = this.Text.getText()).equals("")) {
                this.O.setText("", true);
                this.O.updateText();
            } else if (!this.O.getText().equals(text)) {
                if (!text.endsWith(" ")) {
                    text = String.valueOf(text) + " ";
                }
                this.O.setText(text, true);
            }
            this.O.setUnit(this.Unit.getText());
            if (this.HideChanged) {
                this.O.setHidden(this.IB.getState("hide"));
                if (this.SuperHide && this.IB.getState("hide")) {
                    this.O.setSuperHidden(true);
                } else {
                    this.O.setSuperHidden(false);
                }
            }
            this.O.setColor(this.ColorIB.getToggleState("color"));
            this.O.setColorType(this.ThicknessIB.getToggleState("thickness"));
            if (this.O.canFillBackground()) {
                this.O.setFillBackground(this.ThicknessIB.getState("fillbackground"));
            }
            this.O.setShowName(o.equals("Name") || o.equals("Alias") || this.IB.getState("showname"));
            this.O.setBold(this.IB.getState("bold"));
            this.O.setLarge(this.IB.getState("large"));
            this.O.setBack(this.IB.getState("isback"));
            if (this.showsValue()) {
                this.O.setShowValue(this.IB.getState("showvalue"));
            }
            if (this.O.maybeTransparent()) {
                this.O.setSolid(this.ThicknessIB.getState("solid"));
            }
            if (this.BreakChanged) {
                if (this.IB.getState("setbreak")) {
                    if (this.HidingBreak) {
                        this.O.setHideBreak(true);
                    } else {
                        this.O.setBreak(true);
                    }
                } else {
                    this.O.setBreak(false);
                }
            }
            if (this.O instanceof PointonObject && this.Decorative != null) {
                this.O.setDecorative(this.Decorative.getState());
            }
            this.doclose();
            this.setAction();
        } else {
            super.doAction(o);
        }
    }

    public void addFirst(Panel P) {
    }

    public void addSecond(Panel P) {
    }

    public void addButton(Panel p) {
    }

    public void setAction() {
    }

    public void iconPressed(String o) {
        if (o.equals("hide")) {
            this.HideChanged = true;
            this.SuperHide = this.IB.isShiftPressed() ? this.IB.getState("hide") : false;
        } else if (o.equals("setbreak")) {
            this.BreakChanged = true;
            this.HidingBreak = this.IB.isShiftPressed() ? this.IB.getState("setbreak") : false;
        }
    }

    public void showValue() {
        if (this.showsValue()) {
            this.IB.setState("showvalue", true);
        }
    }

    public boolean showsValue() {
        return true;
    }

    public boolean wantsMore() {
        return this.More;
    }
}

