/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.QuadricObject;

public class QuadricConstructor
extends ObjectConstructor {
    PointObject[] P;
    int NPoints;

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (!zc.Visual) {
            return;
        }
        PointObject p = zc.selectCreatePoint(e2.getX(), e2.getY());
        if (p != null) {
            this.P[this.NPoints++] = p;
            p.setSelected(true);
            zc.repaint();
        }
        this.showStatus(zc);
        if (this.NPoints == 5) {
            QuadricObject Q = new QuadricObject(zc.getConstruction(), this.P);
            zc.addObject(Q);
            Q.setDefaults();
            zc.clearSelected();
            this.reset(zc);
            zc.repaint();
        }
    }

    public void showStatus(ZirkelCanvas zc) {
        zc.showStatus(String.valueOf(Zirkel.name("message.quadric")) + " " + (this.NPoints + 1));
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        if (zc.Visual) {
            this.P = new PointObject[5];
            this.NPoints = 0;
            this.showStatus(zc);
        } else {
            zc.setPrompt(Zirkel.name("prompt.quadric"));
        }
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Quadric")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        int i = 0;
        while (i < 5) {
            if (!tag.hasParam("point" + (i + 1))) {
                throw new ConstructionException("Quadric points missing!");
            }
            ++i;
        }
        try {
            PointObject[] P = new PointObject[5];
            int i2 = 0;
            while (i2 < 5) {
                P[i2] = (PointObject)c2.find(tag.getValue("point" + (i2 + 1)));
                ++i2;
            }
            QuadricObject p = new QuadricObject(c2, P);
            this.setName(tag, p);
            this.set(tree, p);
            c2.add(p);
            this.setConditionals(tree, c2, p);
        }
        catch (ConstructionException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new ConstructionException("Quadric points illegal!");
        }
        return true;
    }

    public String getPrompt() {
        return Zirkel.name("prompt.quadric");
    }

    public String getTag() {
        return "Quadric";
    }

    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams != 5) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        PointObject[] P = new PointObject[5];
        int i = 0;
        while (i < 5) {
            P[i] = c2.find(params[i]);
            if (P[i] == null) {
                throw new ConstructionException(String.valueOf(Zirkel.name("exception.notfound")) + " " + params[i]);
            }
            if (!(P[i] instanceof PointObject)) {
                throw new ConstructionException(String.valueOf(Zirkel.name("exception.type")) + " " + params[i]);
            }
            ++i;
        }
        QuadricObject s = new QuadricObject(c2, P);
        if (!name.equals("")) {
            s.setNameCheck(name);
        }
        c2.add(s);
        s.setDefaults();
    }
}

