/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ParallelObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class ParallelConstructor
extends ObjectConstructor {
    PointObject P = null;
    PrimitiveLineObject L = null;

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (!zc.Visual) {
            return;
        }
        if (this.L == null) {
            this.L = this.selectline(e2.getX(), e2.getY(), zc);
            if (this.L != null) {
                this.L.setSelected(true);
                zc.repaint();
            }
            this.showStatus(zc);
        } else {
            this.P = this.select(e2.getX(), e2.getY(), zc);
            if (this.P != null) {
                PrimitiveLineObject o = this.create(zc.getConstruction(), this.L, this.P);
                zc.addObject(o);
                o.setDefaults();
                this.P = null;
                this.L = null;
                zc.clearSelected();
                this.showStatus(zc);
            }
        }
    }

    public boolean waitForLastPoint() {
        return this.L != null;
    }

    public void finishConstruction(MouseEvent e2, ZirkelCanvas zc) {
        this.P = this.select(e2.getX(), e2.getY(), zc);
        if (this.P != null) {
            PrimitiveLineObject o = this.create(zc.getConstruction(), this.L, this.P);
            zc.addObject(o);
            o.setDefaults();
            zc.validate();
            zc.repaint();
            this.P = null;
        }
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        if (!simple && this.waitForLastPoint()) {
            if (zc.isPreview()) {
                zc.movePreview(e2);
            } else {
                zc.prepareForPreview(e2);
                this.finishConstruction(e2, zc);
            }
        }
        if (this.L == null) {
            zc.indicateLineObjects(e2.getX(), e2.getY());
        } else if (this.P == null) {
            zc.indicateCreatePoint(e2.getX(), e2.getY(), false);
        }
    }

    public PointObject select(int x, int y, ZirkelCanvas zc) {
        return zc.selectCreatePoint(x, y);
    }

    public PrimitiveLineObject selectline(int x, int y, ZirkelCanvas zc) {
        return zc.selectLine(x, y);
    }

    public PrimitiveLineObject create(Construction c2, PrimitiveLineObject l, PointObject p) {
        return new ParallelObject(c2, l, p);
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        if (zc.Visual) {
            this.P = null;
            this.L = null;
            this.showStatus(zc);
        } else {
            zc.setPrompt(this.getPrompt());
        }
    }

    public String getPrompt() {
        return Zirkel.name("prompt.parallel");
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.L == null) {
            zc.showStatus(Zirkel.name("message.parallel.first", "Parallel: Choose a line!"));
        } else {
            zc.showStatus(Zirkel.name("message.parallel.second", "Parallel: Choose a Point!"));
        }
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Parallel")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("point") || !tag.hasParam("line")) {
            throw new ConstructionException("Parallel parameters missing!");
        }
        try {
            PointObject p1 = (PointObject)c2.find(tag.getValue("point"));
            PrimitiveLineObject p2 = (PrimitiveLineObject)c2.find(tag.getValue("line"));
            ParallelObject o = new ParallelObject(c2, p2, p1);
            this.setName(tag, o);
            this.set(tree, o);
            if (tag.hasParam("partial")) {
                o.setPartial(true);
            }
            c2.add(o);
            this.setConditionals(tree, c2, o);
        }
        catch (ConstructionException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new ConstructionException("Parallel parameters illegal!");
        }
        return true;
    }

    public String getTag() {
        return "Parallel";
    }

    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams != 2) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        ConstructionObject P1 = c2.find(params[0]);
        if (P1 == null) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.notfound")) + " " + params[0]);
        }
        ConstructionObject P2 = c2.find(params[1]);
        if (P2 == null) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.notfound")) + " " + params[1]);
        }
        if (!(P1 instanceof PrimitiveLineObject)) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.type")) + " " + params[0]);
        }
        if (!(P2 instanceof PointObject)) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.type")) + " " + params[1]);
        }
        ParallelObject s = new ParallelObject(c2, (PrimitiveLineObject)P1, (PointObject)P2);
        if (!name.equals("")) {
            s.setNameCheck(name);
        }
        c2.add(s);
        s.setDefaults();
    }
}

