/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTagText;
import rene.util.xml.XmlTree;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;

public class ObjectConstructor {
    protected boolean Dragging = false;

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
    }

    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc) {
    }

    public void mouseDragged(MouseEvent e2, ZirkelCanvas zc) {
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        if (simple && (this.waitForPoint() || this.waitForLastPoint())) {
            zc.indicateCreatePoint(e2.getX(), e2.getY(), false);
            return;
        }
        if (this.waitForPoint()) {
            zc.indicateCreatePoint(e2.getX(), e2.getY(), false);
        }
        if (this.waitForLastPoint()) {
            if (zc.isPreview()) {
                zc.movePreview(e2);
            } else {
                zc.prepareForPreview(e2);
                this.finishConstruction(e2, zc);
                return;
            }
        }
    }

    public void finishConstruction(MouseEvent e2, ZirkelCanvas zc) {
    }

    public boolean waitForLastPoint() {
        return false;
    }

    public boolean waitForPoint() {
        return true;
    }

    public void reset(ZirkelCanvas zc) {
        zc.validate();
        zc.clearSelected();
    }

    public void resetFirstTime(ZirkelCanvas zc) {
        this.reset(zc);
    }

    public void invalidate(ZirkelCanvas zc) {
    }

    public void showStatus(ZirkelCanvas zc) {
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        return false;
    }

    public boolean testTree(XmlTree t, String tag) {
        return t.getTag().name().equals(tag);
    }

    public void setName(XmlTag tag, ConstructionObject o) {
        if (tag.hasParam("name")) {
            o.setName(tag.getValue("name"));
        }
        if (tag.hasParam("alias")) {
            o.setAlias(tag.getValue("alias"));
        }
    }

    public void set(XmlTree tree, ConstructionObject o) throws ConstructionException {
        XmlTag tag = tree.getTag();
        if (tag.hasParam("n")) {
            try {
                o.setNCount(new Integer(tag.getValue("n")));
                o.setGotNCount(true);
            }
            catch (Exception ex) {
                throw new ConstructionException("Illegal count!");
            }
        }
        if (tag.hasParam("hidden")) {
            if (tag.getValue("hidden").equals("super")) {
                o.setSuperHidden(true);
            } else {
                o.setHidden(true);
            }
        }
        if (tag.hasTrueParam("showvalue")) {
            o.setShowValue(true);
        }
        if (tag.hasTrueParam("showname")) {
            o.setShowName(true);
        }
        if (tag.hasTrueParam("background")) {
            o.setBack(true);
        } else {
            o.setBack(false);
        }
        if (tag.hasTrueParam("parameter")) {
            o.setParameter();
        }
        if (tag.hasTrueParam("mainparameter")) {
            o.setMainParameter();
        }
        if (tag.hasTrueParam("target")) {
            o.setTarget(true);
        }
        if (tag.hasTrueParam("break")) {
            o.setBreak(true);
        }
        if (tag.hasTrueParam("hidebreak")) {
            o.setHideBreak(true);
        }
        if (tag.hasTrueParam("solid")) {
            o.setSolid(true);
        }
        if (tag.hasTrueParam("bold")) {
            o.setBold(true);
        }
        if (tag.hasTrueParam("large")) {
            o.setLarge(true);
        }
        if (tag.hasParam("xoffset") || tag.hasParam("yoffset")) {
            int x = 0;
            int y = 0;
            try {
                if (tag.hasParam("xoffset")) {
                    x = Integer.parseInt(tag.getValue("xoffset"));
                }
                if (tag.hasParam("yoffset")) {
                    y = Integer.parseInt(tag.getValue("yoffset"));
                }
                o.setOffset(x, y);
            }
            catch (Exception e2) {
                throw new ConstructionException("Illegal offset value");
            }
        }
        if (tag.hasTrueParam("keepclose")) {
            o.setKeepClose(true);
        }
        if (tag.hasParam("xcoffset") || tag.hasParam("ycoffset")) {
            double x = 0.0;
            double y = 0.0;
            try {
                if (tag.hasParam("xcoffset")) {
                    x = new Double(tag.getValue("xcoffset"));
                }
                if (tag.hasParam("ycoffset")) {
                    y = new Double(tag.getValue("ycoffset"));
                }
                o.setcOffset(x, y);
            }
            catch (Exception e3) {
                throw new ConstructionException("Illegal offset value");
            }
        }
        if (tag.hasParam("color")) {
            try {
                String s = tag.getValue("color");
                int n = -1;
                int i = 0;
                while (i < ZirkelFrame.ColorStrings.length) {
                    if (s.equals(ZirkelFrame.ColorStrings[i])) {
                        o.setColor(i);
                        n = i;
                        break;
                    }
                    ++i;
                }
                if (n < 0) {
                    n = Integer.parseInt(s);
                    if (n < 0 || n >= ZirkelFrame.Colors.length) {
                        throw new Exception("");
                    }
                    o.setColor(n);
                }
            }
            catch (Exception ex) {
                throw new ConstructionException("Illegal color index (1-" + (ZirkelFrame.Colors.length - 1) + ")");
            }
        }
        if (tag.hasParam("type")) {
            String type = tag.getValue("type");
            if (type.equals("thick")) {
                o.setColorType(1);
            }
            if (type.equals("thin")) {
                o.setColorType(2);
            }
            if (type.equals("invisible")) {
                o.setColorType(3);
            }
        }
        if (tag.hasParam("unit")) {
            o.setUnit(tag.getValue("unit"));
        } else {
            o.setUnit("");
        }
        if (o instanceof PointObject) {
            o.setFillBackground(true);
        }
        if (tag.hasParam("fillbackground")) {
            o.setFillBackground(tag.hasTrueParam("fillbackground"));
        }
        o.setDecorative(tag.hasTrueParam("decorative"));
        Enumeration e4 = tree.getContent();
        while (e4.hasMoreElements()) {
            tree = (XmlTree)e4.nextElement();
            if (!(tree.getTag() instanceof XmlTagText)) continue;
            o.setText(((XmlTagText)tree.getTag()).getContent(), true);
        }
    }

    public void setConditionals(XmlTree tree, Construction c2, ConstructionObject o) {
        o.clearConditionals();
        int i = 0;
        XmlTag tag = tree.getTag();
        while (tag.hasParam("ctag" + i) && tag.hasParam("cexpr" + i)) {
            String t = tag.getValue("ctag" + i);
            String e2 = tag.getValue("cexpr" + i);
            Expression ex = new Expression(e2, c2, o);
            o.addConditional(t, ex);
            ++i;
        }
    }

    public String getTag() {
        return "???";
    }

    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        throw new ConstructionException("");
    }

    public void pause(boolean flag) {
    }

    public boolean useSmartBoard() {
        return true;
    }
}

