/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.MyVector;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.constructors.PointConstructor;
import rene.zirkel.objects.CircleIntersectionObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.LineCircleIntersectionObject;
import rene.zirkel.objects.LineIntersectionObject;
import rene.zirkel.objects.PointonObjectIntersectionObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class IntersectionConstructor
extends ObjectConstructor {
    ConstructionObject P1 = null;
    ConstructionObject P2 = null;

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        MyVector v;
        if (!zc.Visual) {
            return;
        }
        boolean immediate = false;
        if (this.P1 == null && (v = zc.selectPointonObjects(e2.getX(), e2.getY())).size() == 2) {
            this.P1 = (ConstructionObject)v.elementAt(0);
            this.P2 = (ConstructionObject)v.elementAt(1);
            if (this.P1.equals(this.P2) || this.P1.isFilled() && this.P2.isFilled()) {
                this.P2 = null;
                this.P1 = null;
            } else {
                immediate = true;
            }
        }
        if (this.P1 == null) {
            this.P1 = this.select(e2.getX(), e2.getY(), zc);
            if (this.P1 != null) {
                this.P1.setSelected(true);
                zc.repaint();
                this.showStatus(zc);
            }
        } else {
            if (this.P2 == null) {
                this.P2 = this.select(e2.getX(), e2.getY(), zc);
            }
            if (this.P2 != null) {
                if (this.P2 == this.P1) {
                    this.P2 = null;
                    return;
                }
                IntersectionObject[] o = IntersectionConstructor.construct(this.P1, this.P2, zc.getConstruction());
                if (o != null) {
                    IntersectionObject oc = null;
                    if (immediate && o.length > 1) {
                        if (o[1].nearto(e2.getX(), e2.getY(), zc)) {
                            o[0] = null;
                            oc = o[1];
                        } else {
                            o[1] = null;
                            oc = o[0];
                        }
                    }
                    int i = 0;
                    while (i < o.length) {
                        if (o[i] != null) {
                            o[i].setDefaults();
                            zc.addObject(o[i]);
                            o[i].validate(zc.x(e2.getX()), zc.y(e2.getY()));
                        }
                        ++i;
                    }
                    if (oc != null) {
                        oc.autoAway();
                    }
                }
                this.P2 = null;
                this.P1 = null;
                zc.clearSelected();
                this.showStatus(zc);
            }
        }
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicateIntersectedObjects(e2.getX(), e2.getY(), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IntersectionObject[] construct(ConstructionObject P1, ConstructionObject P2, Construction c2) {
        IntersectionObject[] o = null;
        if (P1 instanceof PrimitiveLineObject) {
            if (P2 instanceof PrimitiveLineObject) {
                o = new IntersectionObject[]{new LineIntersectionObject(c2, (PrimitiveLineObject)P1, (PrimitiveLineObject)P2)};
                return o;
            } else {
                if (!(P2 instanceof PrimitiveCircleObject)) return IntersectionConstructor.construct(P2, P1, c2);
                o = new IntersectionObject[]{new LineCircleIntersectionObject(c2, (PrimitiveLineObject)P1, (PrimitiveCircleObject)P2, true), new LineCircleIntersectionObject(c2, (PrimitiveLineObject)P1, (PrimitiveCircleObject)P2, false)};
            }
            return o;
        } else if (P1 instanceof PrimitiveCircleObject) {
            if (P2 instanceof PrimitiveCircleObject) {
                o = new IntersectionObject[]{new CircleIntersectionObject(c2, (PrimitiveCircleObject)P1, (PrimitiveCircleObject)P2, true), new CircleIntersectionObject(c2, (PrimitiveCircleObject)P1, (PrimitiveCircleObject)P2, false)};
                return o;
            } else {
                if (!(P2 instanceof PrimitiveLineObject)) return IntersectionConstructor.construct(P2, P1, c2);
                o = new IntersectionObject[]{new LineCircleIntersectionObject(c2, (PrimitiveLineObject)P2, (PrimitiveCircleObject)P1, true), new LineCircleIntersectionObject(c2, (PrimitiveLineObject)P2, (PrimitiveCircleObject)P1, false)};
            }
            return o;
        } else {
            o = new PointonObjectIntersectionObject[]{new PointonObjectIntersectionObject(c2, P1, P2)};
        }
        return o;
    }

    public ConstructionObject select(int x, int y, ZirkelCanvas zc) {
        return zc.selectPointonObject(x, y, false);
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        if (zc.Visual) {
            this.P2 = null;
            this.P1 = null;
            this.showStatus(zc);
        } else {
            zc.setPrompt(Zirkel.name("prompt.intersection"));
        }
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.P1 == null) {
            zc.showStatus(Zirkel.name("message.intersection.first", "Intersection: Select first object!"));
        } else {
            zc.showStatus(Zirkel.name("message.intersection.second", "Intersection: Select second object!"));
        }
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Intersection")) {
            return this.constructOther(tree, c2);
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("first") || !tag.hasParam("second")) {
            throw new ConstructionException("Intersection parameters missing!");
        }
        try {
            ConstructionObject o1 = c2.find(tag.getValue("first"));
            ConstructionObject o2 = c2.find(tag.getValue("second"));
            IntersectionObject[] o = IntersectionConstructor.construct(o1, o2, c2);
            if (o == null) {
                throw new Exception("");
            }
            String name = "";
            String nameOther = "";
            if (tag.hasParam("name")) {
                name = tag.getValue("name");
            }
            if (tag.hasParam("other")) {
                nameOther = tag.getValue("other");
            }
            if (o.length > 1) {
                if (tag.hasParam("which")) {
                    IntersectionObject oo = tag.getValue("which").equals("second") ? o[1] : o[0];
                    if (!name.equals("")) {
                        oo.setName(name);
                    }
                    PointConstructor.setType(tag, oo);
                    this.setName(tag, oo);
                    this.set(tree, oo);
                    c2.add(oo);
                    this.setConditionals(tree, c2, oo);
                    if (tag.hasParam("awayfrom")) {
                        oo.setAway(tag.getValue("awayfrom"), true);
                    } else if (tag.hasParam("closeto")) {
                        oo.setAway(tag.getValue("closeto"), false);
                    }
                    if (tag.hasParam("valid")) {
                        oo.setRestricted(false);
                    }
                    if (tag.hasParam("alternate")) {
                        oo.setAlternate(true);
                    }
                } else if (tag.hasParam("other")) {
                    if (!name.equals("")) {
                        o[0].setName(name);
                    }
                    if (!nameOther.equals("")) {
                        o[1].setName(nameOther);
                    }
                    if (tag.hasParam("awayfrom")) {
                        o[0].setAway(tag.getValue("awayfrom"), true);
                        o[1].setAway(tag.getValue("awayfrom"), false);
                    } else if (tag.hasParam("closeto")) {
                        o[1].setAway(tag.getValue("awayfrom"), true);
                        o[0].setAway(tag.getValue("awayfrom"), false);
                    }
                    int i = 0;
                    while (i < o.length) {
                        if (o[i] != null) {
                            PointConstructor.setType(tag, o[i]);
                            this.set(tree, o[i]);
                            c2.add(o[i]);
                            this.setConditionals(tree, c2, o[i]);
                        }
                        ++i;
                    }
                }
            } else {
                if (!name.equals("")) {
                    o[0].setName(name);
                }
                PointConstructor.setType(tag, o[0]);
                this.setName(tag, o[0]);
                this.set(tree, o[0]);
                c2.add(o[0]);
                this.setConditionals(tree, c2, o[0]);
                if (tag.hasParam("valid")) {
                    o[0].setRestricted(false);
                }
                try {
                    double x = new Double(tag.getValue("x"));
                    double y = new Double(tag.getValue("y"));
                    o[0].setXY(x, y);
                }
                catch (Exception exception) {}
            }
        }
        catch (ConstructionException e2) {
            throw e2;
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new ConstructionException("Intersection parameters illegal!");
        }
        return true;
    }

    public boolean constructOther(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "OtherIntersection")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (tag.hasParam("name")) {
            ConstructionObject o = c2.find(tag.getValue("name"));
            if (o == null || !(o instanceof IntersectionObject)) {
                throw new ConstructionException("OtherIntersection not found!");
            }
            IntersectionObject oo = (IntersectionObject)o;
            PointConstructor.setType(tag, oo);
            o.setDefaults();
            this.set(tree, o);
            ConstructionObject ol = c2.lastButOne();
            if (tag.hasParam("awayfrom")) {
                oo.setAway(tag.getValue("awayfrom"), true);
                if (ol != null && ol instanceof IntersectionObject) {
                    ((IntersectionObject)ol).setAway(tag.getValue("awayfrom"), false);
                }
            } else if (tag.hasParam("closeto")) {
                oo.setAway(tag.getValue("closeto"), false);
                if (ol != null && ol instanceof IntersectionObject) {
                    ((IntersectionObject)ol).setAway(tag.getValue("awayfrom"), true);
                }
            }
            if (tag.hasParam("valid")) {
                oo.setRestricted(false);
            }
        } else {
            throw new ConstructionException("OtherIntersection must have a name!");
        }
        return true;
    }

    public String getTag() {
        return "Intersection";
    }

    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        block12: {
            IntersectionObject[] o;
            block11: {
                if (nparams != 2 && nparams != 3) {
                    throw new ConstructionException(Zirkel.name("exception.nparams"));
                }
                ConstructionObject P1 = c2.find(params[0]);
                if (P1 == null) {
                    throw new ConstructionException(String.valueOf(Zirkel.name("exception.notfound")) + " " + params[0]);
                }
                ConstructionObject P2 = c2.find(params[1]);
                if (P2 == null) {
                    throw new ConstructionException(String.valueOf(Zirkel.name("exception.notfound")) + " " + params[0]);
                }
                o = IntersectionConstructor.construct(P1, P2, c2);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.type"));
                }
                if (o.length != 1) break block11;
                c2.add(o[0]);
                o[0].setDefaults();
                if (name.equals("")) break block12;
                o[0].setName(name);
                break block12;
            }
            if (name.equals("")) {
                int i = 0;
                while (i < o.length) {
                    c2.add(o[i]);
                    o[i].setDefaults();
                    ++i;
                }
            } else {
                String[] names = new String[2];
                int n = name.indexOf(44);
                if (n >= 0) {
                    names[0] = name.substring(n + 1).trim();
                    names[1] = name.substring(0, n).trim();
                } else {
                    names[0] = name;
                    names[1] = "";
                }
                int i = 0;
                while (i < o.length) {
                    if (!names[i].equals("")) {
                        c2.add(o[i]);
                        o[i].setDefaults();
                        o[i].setName(names[i]);
                    }
                    ++i;
                }
            }
        }
    }
}

