/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.gui.Global;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.expression.Expression;
import rene.zirkel.macro.Macro;
import rene.zirkel.objects.Circle3Object;
import rene.zirkel.objects.CircleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.SegmentObject;

public class CircleConstructor
extends ObjectConstructor {
    PointObject P1 = null;
    PointObject P2 = null;
    boolean Fixed = false;
    FixedCircleObject C;
    ConstructionObject O;
    boolean ShowsValue;
    boolean ShowsName;
    int Moved;

    public CircleConstructor(boolean fixed) {
        this.Fixed = fixed;
    }

    public CircleConstructor() {
        this(false);
    }

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (!zc.Visual) {
            return;
        }
        if (this.P1 == null) {
            this.P1 = this.select(e2.getX(), e2.getY(), zc);
            if (this.P1 != null) {
                this.P1.setSelected(true);
                zc.repaint();
            }
            this.showStatus(zc);
        } else if (e2.isShiftDown() || this.Fixed) {
            FixedCircleObject c2 = new FixedCircleObject(zc.getConstruction(), this.P1, zc.x(e2.getX()), zc.y(e2.getY()));
            zc.addObject(c2);
            c2.setDefaults();
            zc.repaint();
            this.C = c2;
            this.O = this.C;
            this.ShowsValue = c2.showValue();
            this.ShowsName = c2.showName();
            if (Global.getParameter("options.movefixname", true)) {
                this.C.setShowValue(true);
                this.C.setShowName(true);
            }
            this.Dragging = true;
            this.Moved = 0;
            this.P2 = null;
        } else {
            this.P2 = this.select(e2.getX(), e2.getY(), zc);
            if (this.P2 != null) {
                if (this.P2 == this.P1) {
                    this.P2 = null;
                    return;
                }
                CircleObject c3 = new CircleObject(zc.getConstruction(), this.P1, this.P2);
                zc.addObject(c3);
                c3.setDefaults();
                c3.validate();
                zc.repaint();
                if (this.P2.moveable() && !this.P2.isPointOn() && zc.isNewPoint()) {
                    this.ShowsValue = c3.showValue();
                    this.ShowsName = c3.showName();
                    if (Global.getParameter("options.movename", false)) {
                        c3.setShowValue(true);
                        c3.setShowName(true);
                    }
                    this.O = c3;
                    this.Dragging = true;
                    this.Moved = 0;
                } else {
                    this.P1.setSelected(false);
                    this.P2 = null;
                    this.P1 = null;
                    this.showStatus(zc);
                }
            }
        }
    }

    public boolean waitForLastPoint() {
        return this.P1 != null && this.P2 == null;
    }

    public void finishConstruction(MouseEvent e2, ZirkelCanvas zc) {
        this.P2 = this.select(e2.getX(), e2.getY(), zc);
        if (this.P2 != null) {
            CircleObject c2 = new CircleObject(zc.getConstruction(), this.P1, this.P2);
            zc.addObject(c2);
            c2.setDefaults();
            c2.validate();
            zc.repaint();
        }
        this.P2 = null;
    }

    public boolean waitForPoint() {
        return this.P1 == null || !this.Fixed;
    }

    public void mouseDragged(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging) {
            return;
        }
        ++this.Moved;
        if (this.P2 == null) {
            this.C.init(zc.getConstruction(), zc.x(e2.getX()), zc.y(e2.getY()));
            if (this.C instanceof FixedCircleObject) {
                this.C.setDragable(this.Moved > 5);
            }
        } else {
            this.P2.move(zc.x(e2.getX()), zc.y(e2.getY()));
            zc.validate();
        }
        zc.repaint();
    }

    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging) {
            return;
        }
        this.Dragging = false;
        this.O.setShowValue(this.ShowsValue);
        this.O.setShowName(this.ShowsName);
        zc.repaint();
        if (this.P2 == null) {
            this.P1.setSelected(false);
            this.P1 = null;
            this.C.round();
            if (this.Moved <= 5) {
                this.C.edit(zc);
                if (this.C instanceof FixedCircleObject && this.C.isEditAborted()) {
                    zc.delete(this.C);
                    zc.repaint();
                    this.reset(zc);
                }
            }
            this.C.validate();
            zc.check();
        } else {
            this.P1.setSelected(false);
            this.P2.updateText();
            this.P2 = null;
            this.P1 = null;
        }
        this.O.updateCircleDep();
        zc.repaint();
        zc.showStatus();
    }

    public PointObject select(int x, int y, ZirkelCanvas zc) {
        return zc.selectCreatePoint(x, y);
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        if (zc.Visual) {
            this.P2 = null;
            this.P1 = null;
            this.showStatus(zc);
        } else {
            zc.setPrompt(Zirkel.name("prompt.circle"));
        }
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.Fixed) {
            if (this.P1 == null) {
                zc.showStatus(Zirkel.name("message.fixedcircle.midpoint"));
            } else {
                zc.showStatus(Zirkel.name("message.fixedcircle.radius"));
            }
        } else if (this.P1 == null) {
            zc.showStatus(Zirkel.name("message.circle.midpoint"));
        } else {
            zc.showStatus(Zirkel.name("message.circle.radius"));
        }
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        block23: {
            if (!this.testTree(tree, "Circle")) {
                return false;
            }
            XmlTag tag = tree.getTag();
            try {
                if (!tag.hasParam("midpoint")) {
                    throw new ConstructionException("Circle parameters missing!");
                }
                if (!tag.hasParam("through")) {
                    if (tag.hasParam("fixed")) {
                        PointObject p1 = (PointObject)c2.find(tag.getValue("midpoint"));
                        FixedCircleObject o = new FixedCircleObject(c2, p1, 0.0, 0.0);
                        c2.add(o);
                        this.setConditionals(tree, c2, o);
                        this.setName(tag, o);
                        this.set(tree, o);
                        if (tag.hasParam("partial")) {
                            o.setPartial(true);
                        }
                        if (tag.hasParam("filled")) {
                            o.setFilled(true);
                        }
                        if (tag.hasTrueParam("dragable")) {
                            o.setDragable(true);
                        }
                        if (tag.hasTrueParam("drawable")) {
                            o.setDragable(true);
                        }
                        o.setFixed(tag.getValue("fixed"));
                        if (tag.hasParam("start") && tag.hasParam("end")) {
                            o.setRange(tag.getValue("start"), tag.getValue("end"));
                        }
                        if (tag.hasParam("acute")) {
                            o.setObtuse(false);
                        }
                        if (tag.hasParam("chord")) {
                            o.setArc(false);
                        }
                    } else {
                        if (!(c2 instanceof Macro)) {
                            throw new ConstructionException("Circle parameters missing!");
                        }
                        PointObject p1 = (PointObject)c2.find(tag.getValue("midpoint"));
                        PrimitiveCircleObject o = new PrimitiveCircleObject(c2, p1);
                        this.setName(tag, o);
                        this.set(tree, o);
                        c2.add(o);
                        this.setConditionals(tree, c2, o);
                    }
                    break block23;
                }
                PointObject p1 = (PointObject)c2.find(tag.getValue("midpoint"));
                PointObject p2 = (PointObject)c2.find(tag.getValue("through"));
                CircleObject o = new CircleObject(c2, p1, p2);
                this.setName(tag, o);
                this.set(tree, o);
                c2.add(o);
                this.setConditionals(tree, c2, o);
                if (tag.hasParam("partial")) {
                    o.setPartial(true);
                }
                if (tag.hasParam("filled")) {
                    o.setFilled(true);
                }
                if (tag.hasParam("start") && tag.hasParam("end")) {
                    o.setRange(tag.getValue("start"), tag.getValue("end"));
                }
                if (tag.hasParam("acute")) {
                    o.setObtuse(false);
                }
                if (tag.hasParam("chord")) {
                    o.setArc(false);
                }
                if (!tag.hasParam("fixed")) break block23;
                try {
                    o.setFixed(true, tag.getValue("fixed"));
                }
                catch (Exception e2) {
                    throw new ConstructionException("Fixed value illegal!");
                }
            }
            catch (ConstructionException e3) {
                throw e3;
            }
            catch (Exception e4) {
                throw new ConstructionException("Circle parameters illegal!");
            }
        }
        return true;
    }

    public String getTag() {
        return "Circle";
    }

    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams > 3 || nparams == 0) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        ConstructionObject P1 = c2.find(params[0]);
        if (P1 == null) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.notfound")) + " " + params[0]);
        }
        if (!(P1 instanceof PointObject)) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.type")) + " " + params[0]);
        }
        if (nparams == 1) {
            PrimitiveCircleObject s = new PrimitiveCircleObject(c2, (PointObject)P1);
            c2.add(s);
            s.setDefaults();
            if (!name.equals("")) {
                s.setNameCheck(name);
            }
            return;
        }
        ConstructionObject P2 = c2.find(params[1]);
        if (P2 == null) {
            Expression ex = new Expression(params[1], c2, null);
            if (!ex.isValid()) {
                throw new ConstructionException(Zirkel.name("exception.expression"));
            }
            FixedCircleObject s = new FixedCircleObject(c2, (PointObject)P1, 0.0, 0.0);
            c2.add(s);
            s.setDefaults();
            s.setFixed(params[1]);
            s.validate();
            if (!name.equals("")) {
                s.setNameCheck(name);
            }
            return;
        }
        if (P2 instanceof SegmentObject) {
            Circle3Object s = new Circle3Object(c2, ((SegmentObject)P2).getP1(), ((SegmentObject)P2).getP2(), (PointObject)P1);
            c2.add(s);
            s.setDefaults();
            if (!name.equals("")) {
                s.setNameCheck(name);
            }
            return;
        }
        if (!(P2 instanceof PointObject)) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.type")) + " " + params[1]);
        }
        if (nparams == 3) {
            ConstructionObject P3 = c2.find(params[2]);
            if (P3 == null || !(P3 instanceof PointObject)) {
                CircleObject s = new CircleObject(c2, (PointObject)P1, (PointObject)P2);
                if (!s.canFix()) {
                    throw new ConstructionException(Zirkel.name("exception.canfix"));
                }
                s.setFixed(true, params[2]);
                if (!s.isValidFix()) {
                    throw new ConstructionException(String.valueOf(Zirkel.name("exception.fix")) + " " + params[2]);
                }
                c2.add(s);
                s.validate();
                if (!name.equals("")) {
                    s.setNameCheck(name);
                }
                s.setDefaults();
                return;
            }
            Circle3Object cr = new Circle3Object(c2, (PointObject)P2, (PointObject)P3, (PointObject)P1);
            c2.add(cr);
            cr.setDefaults();
            if (!name.equals("")) {
                cr.setNameCheck(name);
            }
            return;
        }
        CircleObject s = new CircleObject(c2, (PointObject)P1, (PointObject)P2);
        c2.add(s);
        s.setDefaults();
        if (!name.equals("")) {
            s.setName(name);
        }
    }
}

