/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.Circle3Object;
import rene.zirkel.objects.PointObject;

public class Circle3Constructor
extends ObjectConstructor {
    PointObject P1 = null;
    PointObject P2 = null;
    PointObject P3 = null;

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (!zc.Visual) {
            return;
        }
        if (this.P1 == null) {
            this.P1 = this.select(e2.getX(), e2.getY(), zc);
            if (this.P1 != null) {
                this.P1.setSelected(true);
                zc.repaint();
            }
            this.showStatus(zc);
        } else if (this.P2 == null) {
            this.P2 = this.select(e2.getX(), e2.getY(), zc);
            if (this.P2 != null && this.P2 != this.P1) {
                this.P2.setSelected(true);
                zc.repaint();
            }
            this.showStatus(zc);
        } else {
            this.P3 = this.select(e2.getX(), e2.getY(), zc);
            if (this.P3 != null) {
                Circle3Object c2 = new Circle3Object(zc.getConstruction(), this.P1, this.P2, this.P3);
                zc.addObject(c2);
                c2.setDefaults();
                c2.updateCircleDep();
                this.P3 = null;
                this.P2 = null;
                this.P1 = null;
                zc.clearSelected();
                this.showStatus(zc);
            }
        }
    }

    public boolean waitForLastPoint() {
        return this.P1 != null && this.P2 != null;
    }

    public void finishConstruction(MouseEvent e2, ZirkelCanvas zc) {
        this.P3 = this.select(e2.getX(), e2.getY(), zc);
        if (this.P3 != null) {
            Circle3Object c2 = new Circle3Object(zc.getConstruction(), this.P1, this.P2, this.P3);
            zc.addObject(c2);
            c2.setDefaults();
            zc.validate();
            zc.repaint();
            this.P3 = null;
        }
    }

    public PointObject select(int x, int y, ZirkelCanvas zc) {
        return zc.selectCreatePoint(x, y);
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        if (zc.Visual) {
            this.P3 = null;
            this.P2 = null;
            this.P1 = null;
            this.showStatus(zc);
        } else {
            zc.setPrompt(Zirkel.name("prompt.circle3"));
        }
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.P1 == null) {
            zc.showStatus(Zirkel.name("message.circle3.first", "Circle: Choose the first radius point!"));
        } else if (this.P2 == null) {
            zc.showStatus(Zirkel.name("message.circle3.second", "Circle: Choose the second radius point!"));
        } else {
            zc.showStatus(Zirkel.name("message.circle3.midpoint", "Circle: Choose the midpoint!"));
        }
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Circle3")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!(tag.hasParam("midpoint") && tag.hasParam("from") && tag.hasParam("to"))) {
            throw new ConstructionException("Circle3 parameters missing!");
        }
        try {
            PointObject p1 = (PointObject)c2.find(tag.getValue("midpoint"));
            PointObject p2 = (PointObject)c2.find(tag.getValue("from"));
            PointObject p3 = (PointObject)c2.find(tag.getValue("to"));
            Circle3Object o = new Circle3Object(c2, p2, p3, p1);
            if (tag.hasParam("partial")) {
                o.setPartial(true);
            }
            if (tag.hasParam("start") && tag.hasParam("end")) {
                o.setRange(tag.getValue("start"), tag.getValue("end"));
            }
            this.setName(tag, o);
            this.set(tree, o);
            c2.add(o);
            this.setConditionals(tree, c2, o);
        }
        catch (ConstructionException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new ConstructionException("Circle3 parameters illegal!");
        }
        return true;
    }
}

