/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.construction;

import java.util.Vector;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.AngleConstructor;
import rene.zirkel.constructors.AreaConstructor;
import rene.zirkel.constructors.CircleConstructor;
import rene.zirkel.constructors.ExpressionConstructor;
import rene.zirkel.constructors.FunctionConstructor;
import rene.zirkel.constructors.IntersectionConstructor;
import rene.zirkel.constructors.LineConstructor;
import rene.zirkel.constructors.MidpointConstructor;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.constructors.ParallelConstructor;
import rene.zirkel.constructors.PlumbConstructor;
import rene.zirkel.constructors.PointConstructor;
import rene.zirkel.constructors.QuadricConstructor;
import rene.zirkel.constructors.RayConstructor;
import rene.zirkel.constructors.SegmentConstructor;
import rene.zirkel.macro.Macro;
import rene.zirkel.macro.MacroRunner;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.CircleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.LineObject;
import rene.zirkel.objects.PlumbObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.SegmentObject;
import rene.zirkel.objects.TwoPointLineObject;

public class Interpreter {
    Construction C;
    MacroRunner MR = new MacroRunner();
    static ObjectConstructor[] OCs = new ObjectConstructor[]{new PointConstructor(), new SegmentConstructor(), new LineConstructor(), new RayConstructor(), new CircleConstructor(), new IntersectionConstructor(), new ParallelConstructor(), new PlumbConstructor(), new MidpointConstructor(), new AngleConstructor(), new AreaConstructor(), new QuadricConstructor(), new ExpressionConstructor(), new FunctionConstructor()};
    public static String[] ONs = new String[]{"point", "segment", "line", "ray", "circle", "intersection", "parallel", "plumb", "midpoint", "angle", "area", "quadric", "expression", "function"};

    public Interpreter(Construction c2) {
        this.C = c2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void interpret(ZirkelCanvas zc, String s, String comment) throws ConstructionException {
        boolean fill;
        boolean hidden;
        int i;
        boolean Parameter = false;
        boolean Target = false;
        boolean Prompt = false;
        Vector V = this.C.V;
        int VN = V.size();
        int k = Interpreter.startTest("parameter", s);
        if (k >= 0) {
            Parameter = true;
            s = s.substring(k).trim();
        } else {
            if (s.toLowerCase().equals(Zirkel.name("showall")) || s.toLowerCase().equals("showall")) {
                this.C.ShowAll = true;
                return;
            }
            if (s.toLowerCase().equals(Zirkel.name("invisible")) || s.toLowerCase().equals("invisible")) {
                this.C.SuperHide = true;
                return;
            }
            k = Interpreter.startTest("target", s);
            if (k >= 0) {
                Target = true;
                s = s.substring(k).trim();
                ConstructionObject o = this.C.find(s);
                this.C.determineConstructables();
                if (o != null && o.isFlag()) {
                    o.setTarget(true);
                    this.C.addTarget(o);
                    return;
                }
                Target = true;
            } else {
                k = Interpreter.startTest("prompt", s);
                if (k >= 0) {
                    Prompt = true;
                    if (this.C.find(s = s.substring(k).trim()) != null) {
                        this.C.PromptFor.addElement(s);
                        return;
                    }
                }
            }
        }
        String name = "";
        String function = "";
        String[] params = new String[16];
        int NParams = 0;
        int n = s.indexOf(61);
        if (n >= 0) {
            name = s.substring(0, n).trim();
            s = s.substring(n + 1).trim();
        }
        int bracketn = 0;
        if (s.startsWith("\"")) {
            bracketn = s.indexOf("\"", 1);
        }
        if (bracketn < 0) {
            throw new ConstructionException("exception.brackets");
        }
        n = s.indexOf(40, bracketn);
        if (n >= 0) {
            function = s.substring(0, n).trim();
            if (function.startsWith("\"") && function.endsWith("\"") && function.length() > 1) {
                function = function.substring(1, function.length() - 1);
            }
            if (!(s = s.substring(n + 1).trim()).endsWith(")")) {
                throw new ConstructionException("exception.brackets");
            }
            char[] a2 = s.substring(0, s.length() - 1).toCharArray();
            int ia = 0;
            int BCount = 0;
            while (ia < a2.length && NParams < params.length) {
                int ia0 = ia;
                while (ia < a2.length && (BCount > 0 || a2[ia] != ',')) {
                    if (a2[ia] == '\"') {
                        ++ia;
                        while (ia < a2.length && a2[ia] != '\"') {
                            ++ia;
                        }
                        if (ia >= a2.length) {
                            throw new ConstructionException(Zirkel.name("exception.quotes"));
                        }
                        ++ia;
                        continue;
                    }
                    if (a2[ia] == '(') {
                        ++BCount;
                        ++ia;
                        continue;
                    }
                    if (a2[ia] == ')') {
                        if (BCount <= 0) throw new ConstructionException(Zirkel.name("exception.brackets"));
                        --BCount;
                        ++ia;
                        continue;
                    }
                    ++ia;
                }
                params[NParams++] = new String(a2, ia0, ia - ia0).trim();
                ++ia;
            }
        } else {
            function = s;
        }
        String f2 = function;
        if (NParams == 3 && Interpreter.ptest(f2, "window")) {
            try {
                double x = new Double(params[0]);
                double y = new Double(params[1]);
                double w = new Double(params[2]);
                this.C.setXYW(x, y, w);
                zc.recompute();
                return;
            }
            catch (Exception e2) {
                throw new ConstructionException(Zirkel.name("exception.value"));
            }
        }
        if ((NParams == 1 || NParams == 2) && Interpreter.ptest(f2, "color")) {
            i = 0;
            i = 0;
            while (i < ZirkelFrame.ColorStrings.length) {
                if (Interpreter.test(params[0], "colors", ZirkelFrame.ColorStrings[i])) break;
                ++i;
            }
            if (i >= ZirkelFrame.ColorStrings.length) throw new ConstructionException(Zirkel.name("exception.color"));
            if (NParams == 2) {
                ConstructionObject o = this.C.find(params[1]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setColor(i);
                return;
            } else {
                this.C.DefaultColor = i;
            }
            return;
        }
        if ((NParams == 1 || NParams == 2) && Interpreter.ptest(f2, "thickness")) {
            i = 0;
            i = 0;
            while (i < ZirkelFrame.ColorTypes.length) {
                if (Interpreter.test(params[0], "color.type", ZirkelFrame.ColorTypes[i])) break;
                ++i;
            }
            if (i >= ZirkelFrame.ColorTypes.length) throw new ConstructionException(Zirkel.name("exception.colortype"));
            if (NParams == 2) {
                ConstructionObject o = this.C.find(params[1]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setColorType(i);
                return;
            } else {
                this.C.DefaultColorType = i;
            }
            return;
        }
        if ((NParams == 1 || NParams == 2) && Interpreter.ptest(f2, "type")) {
            i = 0;
            i = 0;
            while (i < ZirkelFrame.PointTypes.length) {
                if (Interpreter.test(params[0], "point.type", ZirkelFrame.PointTypes[i])) break;
                ++i;
            }
            if (i >= ZirkelFrame.PointTypes.length) throw new ConstructionException(Zirkel.name("exception.type"));
            if (NParams == 2) {
                ConstructionObject o = this.C.find(params[1]);
                if (o == null || !(o instanceof PointObject)) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                ((PointObject)o).setType(i);
                return;
            } else {
                this.C.DefaultType = i;
            }
            return;
        }
        if ((NParams == 1 || NParams == 2) && Interpreter.ptest(f2, "partial")) {
            if (NParams == 1 && !Interpreter.truecheck(params[0])) {
                ConstructionObject o = this.C.find(params[0]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                if (o instanceof PrimitiveCircleObject) {
                    ((PrimitiveCircleObject)o).setPartial(true);
                }
                if (!(o instanceof LineObject)) return;
                ((LineObject)o).setPartial(true);
                return;
            }
            boolean partial = Interpreter.truetest(params[0]);
            if (NParams == 2) {
                ConstructionObject o = this.C.find(params[1]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                if (o instanceof PrimitiveCircleObject) {
                    ((PrimitiveCircleObject)o).setPartial(partial);
                }
                if (!(o instanceof LineObject)) return;
                ((LineObject)o).setPartial(partial);
                return;
            } else {
                this.C.Partial = partial;
                this.C.PartialLines = partial;
            }
            return;
        }
        if ((NParams == 1 || NParams == 2) && Interpreter.ptest(f2, "hide")) {
            if (NParams == 1 && !Interpreter.truecheck(params[0])) {
                ConstructionObject o = this.C.find(params[0]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setHidden(true);
                return;
            }
            hidden = Interpreter.truetest(params[0]);
            if (NParams == 2) {
                ConstructionObject o = this.C.find(params[1]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setHidden(hidden);
                return;
            } else {
                this.C.Hidden = hidden;
            }
            return;
        }
        if (NParams == 2 && Interpreter.ptest(f2, "invisible")) {
            if (NParams == 1 && !Interpreter.truecheck(params[0])) {
                ConstructionObject o = this.C.find(params[0]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setSuperHidden(true);
                return;
            }
            hidden = Interpreter.truetest(params[0]);
            if (NParams != 2) throw new ConstructionException(Zirkel.name("exception.notfound"));
            ConstructionObject o = this.C.find(params[1]);
            if (o == null) {
                throw new ConstructionException(Zirkel.name("exception.notfound"));
            }
            o.setSuperHidden(hidden);
            return;
        }
        if (NParams >= 1 && Interpreter.ptest(f2, "back")) {
            if (NParams == 1) {
                ConstructionObject o = this.C.find(params[0]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setBack(true);
                return;
            }
            boolean back = Interpreter.truetest(params[0]);
            ConstructionObject o = this.C.find(params[1]);
            if (o == null) {
                throw new ConstructionException(Zirkel.name("exception.notfound"));
            }
            o.setBack(back);
            return;
        }
        if (NParams >= 1 && Interpreter.ptest(f2, "acute")) {
            if (NParams == 1 && !Interpreter.truecheck(params[0])) {
                ConstructionObject o = this.C.find(params[0]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setObtuse(false);
                return;
            }
            boolean acute = Interpreter.truetest(params[0]);
            if (NParams == 2) {
                ConstructionObject o = this.C.find(params[1]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setObtuse(!acute);
                return;
            } else {
                this.C.Obtuse = !acute;
            }
            return;
        }
        if (NParams >= 1 && Interpreter.ptest(f2, "obtuse")) {
            if (NParams == 1 && !Interpreter.truecheck(params[0])) {
                ConstructionObject o = this.C.find(params[0]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setObtuse(false);
                return;
            }
            boolean obtuse = Interpreter.truetest(params[0]);
            if (NParams == 2) {
                ConstructionObject o = this.C.find(params[1]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setObtuse(obtuse);
                return;
            } else {
                this.C.Obtuse = obtuse;
            }
            return;
        }
        if (NParams >= 1 && Interpreter.ptest(f2, "solid")) {
            if (NParams == 1 && !Interpreter.truecheck(params[0])) {
                ConstructionObject o = this.C.find(params[0]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setSolid(false);
                return;
            }
            boolean solid = Interpreter.truetest(params[0]);
            if (NParams == 2) {
                ConstructionObject o = this.C.find(params[1]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setSolid(solid);
                return;
            } else {
                this.C.Solid = solid;
            }
            return;
        }
        if (NParams == 3 && Interpreter.ptest(f2, "restrict")) {
            try {
                PrimitiveCircleObject c2 = (PrimitiveCircleObject)this.C.find(params[0]);
                if (c2.setRange(params[1], params[2])) return;
                throw new Exception("");
            }
            catch (Exception e3) {
                throw new ConstructionException(Zirkel.name("exception.notfound"));
            }
        }
        if (NParams >= 1 && Interpreter.ptest(f2, "fill")) {
            if (NParams == 1) {
                ConstructionObject o = this.C.find(params[0]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setFilled(true);
                o.setBack(true);
                return;
            }
            fill = Interpreter.truetest(params[0]);
            ConstructionObject o = this.C.find(params[1]);
            if (o == null) {
                throw new ConstructionException(Zirkel.name("exception.notfound"));
            }
            o.setFilled(fill);
            o.setBack(fill);
            return;
        }
        if (NParams >= 1 && Interpreter.ptest(f2, "valid")) {
            if (NParams == 1) {
                ConstructionObject o = this.C.find(params[0]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                if (o instanceof PlumbObject) {
                    ((PlumbObject)o).setRestricted(false);
                    return;
                } else {
                    if (!(o instanceof IntersectionObject)) return;
                    ((IntersectionObject)o).setRestricted(false);
                }
                return;
            }
            fill = Interpreter.truetest(params[0]);
            ConstructionObject o = this.C.find(params[1]);
            if (o == null) {
                throw new ConstructionException(Zirkel.name("exception.notfound"));
            }
            if (o instanceof PlumbObject) {
                ((PlumbObject)o).setRestricted(false);
                return;
            } else {
                if (!(o instanceof IntersectionObject)) return;
                ((IntersectionObject)o).setRestricted(false);
            }
            return;
        }
        if (NParams >= 1 && (Interpreter.ptest(f2, "rename") || Interpreter.ptest(f2, "name"))) {
            if (NParams == 1 && !Interpreter.truecheck(params[0])) {
                ConstructionObject o = this.C.find(params[0]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setShowName(true);
                return;
            }
            ConstructionObject o = this.C.find(params[0]);
            if (o == null) {
                boolean shownames = Interpreter.truetest(params[0]);
                if (NParams == 2) {
                    o = this.C.find(params[1]);
                    if (o == null) {
                        throw new ConstructionException(Zirkel.name("exception.notfound"));
                    }
                    o.setShowName(Interpreter.truetest(params[0]));
                    return;
                } else {
                    this.C.ShowNames = shownames;
                }
                return;
            } else {
                if (params[1].equals("")) return;
                o.setName(params[1]);
            }
            return;
        }
        if (NParams == 2 && Interpreter.ptest(f2, "away")) {
            ConstructionObject o = this.C.find(params[0]);
            ConstructionObject p = this.C.find(params[1]);
            if (!(o instanceof IntersectionObject) || !(p instanceof PointObject)) {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            ((IntersectionObject)o).setAway(p.getName());
            return;
        }
        if (NParams == 2 && Interpreter.ptest(f2, "close")) {
            ConstructionObject o = this.C.find(params[0]);
            ConstructionObject p = this.C.find(params[1]);
            if (!(o instanceof IntersectionObject) || !(p instanceof PointObject)) {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            ((IntersectionObject)o).setAway(p.getName(), false);
            return;
        }
        if (NParams >= 1 && Interpreter.ptest(f2, "value")) {
            if (NParams == 1 && !Interpreter.truecheck(params[0])) {
                ConstructionObject o = this.C.find(params[0]);
                if (o == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                o.setShowValue(true);
                return;
            }
            ConstructionObject o = this.C.find(params[0]);
            if (o == null) {
                try {
                    Interpreter.truetest(params[0]);
                }
                catch (Exception e4) {
                    throw new ConstructionException(Zirkel.name("exception.notfound"));
                }
                if (NParams == 2) {
                    o = this.C.find(params[1]);
                    if (o == null) {
                        throw new ConstructionException(Zirkel.name("exception.notfound"));
                    }
                    o.setShowValue(Interpreter.truetest(params[0]));
                    return;
                } else {
                    this.C.ShowValues = true;
                }
                return;
            }
            if (NParams == 2) {
                if (o instanceof SegmentObject) {
                    SegmentObject os = (SegmentObject)o;
                    if (!os.canFix()) {
                        throw new ConstructionException(Zirkel.name("exception.canfix"));
                    }
                    os.setFixed(true, params[1]);
                    os.validate();
                    return;
                } else if (o instanceof CircleObject) {
                    CircleObject os = (CircleObject)o;
                    if (!os.canFix()) {
                        throw new ConstructionException(Zirkel.name("exception.canfix"));
                    }
                    os.setFixed(true, params[1]);
                    os.validate();
                    return;
                } else if (o instanceof FixedCircleObject) {
                    FixedCircleObject os = (FixedCircleObject)o;
                    os.setFixed(params[1]);
                    os.validate();
                    return;
                } else if (o instanceof AngleObject) {
                    AngleObject os = (AngleObject)o;
                    if (!os.canFix()) {
                        throw new ConstructionException(Zirkel.name("exception.canfix"));
                    }
                    os.setFixed(params[1]);
                    os.validate();
                    return;
                } else if (o instanceof FixedAngleObject) {
                    FixedAngleObject os = (FixedAngleObject)o;
                    os.setFixed(params[1]);
                    os.validate();
                    return;
                } else {
                    if (!(o instanceof ExpressionObject)) throw new ConstructionException(Zirkel.name("exception.parameter"));
                    ExpressionObject os = (ExpressionObject)o;
                    os.setFixed(params[1]);
                    os.validate();
                }
                return;
            } else {
                if (NParams != 3) throw new ConstructionException(Zirkel.name("exception.parameter"));
                if (!(o instanceof PointObject)) throw new ConstructionException(Zirkel.name("exception.parameter"));
                PointObject os = (PointObject)o;
                if (!os.moveablePoint()) {
                    throw new ConstructionException(Zirkel.name("exception.canfix"));
                }
                os.setFixed(params[1], params[2]);
                os.validate();
            }
            return;
        }
        i = Interpreter.findFunction(function, zc);
        if (i >= 0) {
            int j = 0;
            while (j < NParams) {
                params[j] = this.extend(params[j]);
                ++j;
            }
            OCs[i].construct(this.C, name, params, NParams);
            if (Parameter) {
                if (VN >= V.size()) {
                    throw new ConstructionException(Zirkel.name("exception.macroparameter"));
                }
                ConstructionObject o = this.C.last();
                o.setMainParameter();
                if (!o.isMainParameter()) throw new ConstructionException(Zirkel.name("exception.macroparameter"));
                this.C.addParameter(o);
                this.C.Prompts.addElement(comment);
                return;
            } else if (Target) {
                if (VN + 1 != V.size()) {
                    throw new ConstructionException(Zirkel.name("exception.macrotarget"));
                }
                ConstructionObject o = this.C.last();
                o.setTarget(true);
                this.C.addTarget(o);
                return;
            } else {
                if (!Prompt) return;
                ConstructionObject o = this.C.last();
                this.C.PromptFor.addElement(o.getName());
            }
            return;
        }
        Macro m = zc.chooseMacro(function);
        if (m == null) {
            throw new ConstructionException(Zirkel.name("exception.function"));
        }
        this.MR.setMacro(m, zc);
        this.MR.run(zc, this.C, name, params, NParams);
        if (Target) {
            ConstructionObject o = this.C.find(name);
            if (o == null) {
                throw new ConstructionException(Zirkel.name("exception.macrotarget"));
            }
            o.setTarget(true);
            this.C.addTarget(o);
            return;
        } else {
            ConstructionObject o;
            if (!Prompt || (o = this.C.find(name)) == null) return;
            this.C.PromptFor.addElement(o.getName());
        }
    }

    public void interpret(ZirkelCanvas zc, String s) throws ConstructionException {
        this.interpret(zc, s, "");
    }

    public static boolean truetest(String s) throws ConstructionException {
        if ((s = s.toLowerCase()).equals("true") || s.equals(Zirkel.name("true"))) {
            return true;
        }
        if (s.equals("false") || s.equals(Zirkel.name("false"))) {
            return false;
        }
        throw new ConstructionException(Zirkel.name("exception.boolean"));
    }

    public static boolean truecheck(String s) {
        if ((s = s.toLowerCase()).equals("true") || s.equals(Zirkel.name("true"))) {
            return true;
        }
        return s.equals("false") || s.equals(Zirkel.name("false"));
    }

    public static boolean test(String f2, String tag, String s) {
        return f2.equalsIgnoreCase(Zirkel.name(String.valueOf(tag) + "." + s, "")) || f2.equals(Zirkel.name(String.valueOf(tag) + ".short." + s, "")) || f2.equals(Zirkel.name(String.valueOf(tag) + "." + s + ".short", "")) || f2.equalsIgnoreCase(s);
    }

    public static int startTest(String tag, String s) {
        int i = Interpreter.startTest0(Zirkel.name(tag, tag).toLowerCase(), s.toLowerCase());
        if (i > 0) {
            return i;
        }
        i = Interpreter.startTest0(Zirkel.name(String.valueOf(tag) + ".short", tag), s);
        if (i > 0) {
            return i;
        }
        return Interpreter.startTest0(tag, s.toLowerCase());
    }

    public static int startTest0(String tag, String s) {
        if (s.startsWith(String.valueOf(tag) + " ")) {
            return tag.length() + 1;
        }
        return -1;
    }

    public static boolean ptest(String f2, String s) {
        return Interpreter.test(f2, "function", s);
    }

    public static boolean nametest(String f2, String s) {
        return Interpreter.test(f2, "name", s);
    }

    public String extend(String s) {
        ConstructionObject o;
        if (s.startsWith("c(") && s.endsWith(")")) {
            ConstructionObject o2 = this.C.find(s = s.substring(2, s.length() - 1));
            if (o2 instanceof PrimitiveCircleObject) {
                return ((PrimitiveCircleObject)o2).getP1().getName();
            }
        } else if (s.startsWith("a(") && s.endsWith(")")) {
            ConstructionObject o3 = this.C.find(s = s.substring(2, s.length() - 1));
            if (o3 instanceof TwoPointLineObject) {
                return ((TwoPointLineObject)o3).getP1().getName();
            }
        } else if (s.startsWith("b(") && s.endsWith(")") && (o = this.C.find(s = s.substring(2, s.length() - 1))) instanceof TwoPointLineObject) {
            return ((TwoPointLineObject)o).getP2().getName();
        }
        return s;
    }

    public static int findFunction(String function, ZirkelCanvas zc) {
        int i = 0;
        while (i < OCs.length) {
            if (Interpreter.nametest(function, OCs[i].getTag()) && zc.enabled(ONs[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

