/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel;

import atp.sHotEqn;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.TextField;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import rene.dialogs.Warning;
import rene.gui.Global;
import rene.gui.MyCheckboxMenuItem;
import rene.gui.MyMenuItem;
import rene.util.FileName;
import rene.util.ImageSelection;
import rene.util.MyVector;
import rene.util.PngEncoder;
import rene.util.sort.SortObject;
import rene.util.sort.Sorter;
import rene.util.xml.XmlReader;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTagPI;
import rene.util.xml.XmlTree;
import rene.util.xml.XmlWriter;
import rene.zirkel.DragThread;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvasInterface;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.ChangedListener;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionDisplayPanel;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.construction.Interpreter;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.IntersectionConstructor;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.dialogs.AgainQuestion;
import rene.zirkel.dialogs.DefineMacro;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.dialogs.MessageWindow;
import rene.zirkel.dialogs.ReplaceMacroQuestion;
import rene.zirkel.dialogs.SelectDialog;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.Drawing;
import rene.zirkel.graphics.LatexOutput;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics11;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.graphics.MyGraphicsEPS;
import rene.zirkel.graphics.MyGraphicsFig;
import rene.zirkel.graphics.MyGraphicsPDF;
import rene.zirkel.graphics.MyGraphicsSvg;
import rene.zirkel.graphics.PolygonDrawer;
import rene.zirkel.graphics.TrackPainter;
import rene.zirkel.listener.AddEventListener;
import rene.zirkel.listener.DoneListener;
import rene.zirkel.listener.StatusListener;
import rene.zirkel.macro.Macro;
import rene.zirkel.macro.MacroBar;
import rene.zirkel.macro.MacroItem;
import rene.zirkel.macro.MacroMenu;
import rene.zirkel.macro.MacroRunner;
import rene.zirkel.macro.MacroSelectDialog;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.AreaObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.RayObject;
import rene.zirkel.objects.SegmentObject;
import rene.zirkel.objects.TwoPointLineObject;
import rene.zirkel.objects.UserFunctionObject;
import rene.zirkel.structures.CoordinatesXY;
import rene.zirkel.tools.AnimatorTool;
import rene.zirkel.tools.BinderTool;
import rene.zirkel.tools.BreakpointAnimator;
import rene.zirkel.tools.EditTool;
import rene.zirkel.tools.LabelMover;
import rene.zirkel.tools.MetaMover;
import rene.zirkel.tools.MoverTool;
import rene.zirkel.tools.ObjectTracker;
import rene.zirkel.tools.SaveJob;
import rene.zirkel.tools.SetAwayTool;
import rene.zirkel.tools.SetCurveCenterTool;
import rene.zirkel.tools.SetFixedAngle;
import rene.zirkel.tools.SetFixedCircle;
import rene.zirkel.tools.SetRangeTool;
import rene.zirkel.tools.SetTargetsTool;
import rene.zirkel.tools.Tracker;
import rene.zirkel.tools.ZoomerTool;

public class ZirkelCanvas
extends Panel
implements MouseListener,
MouseMotionListener,
ItemListener,
AddEventListener,
ActionListener,
ChangedListener,
MouseWheelListener {
    ObjectConstructor OC = new MoverTool();
    Construction C = new Construction();
    Construction COriginal;
    StatusListener SL = null;
    public Image I = null;
    MyGraphics IG;
    Image Background = null;
    FontMetrics FM;
    double PointSize = 4.0;
    double MinPointSize = 4.0;
    double FontSize = 14.0;
    double MinFontSize = 14.0;
    public int IW = 0;
    public int IH = 0;
    public double Xmin;
    public double DX;
    public double Ymin;
    public double DY;
    boolean ShowHidden = false;
    Frame F = new Frame();
    boolean ReadOnly;
    boolean AllowRightMouse = true;
    PopupMenu PM;
    CheckboxMenuItem CheckboxHidden;
    MenuItem Replay;
    MenuItem Empty;
    boolean Job = false;
    String Last = "";
    Vector Targets = new Vector();
    ConstructionObject[] TargetO;
    ConstructionObject[] TargetS;
    int ShowColor = 0;
    public static double EditFactor = 1000000.0;
    public static double LengthsFactor = 100.0;
    public static double AnglesFactor = 1.0;
    public boolean Visual = Global.getParameter("options.visual", true);
    boolean All;
    boolean Interactive = true;
    public int GridColor = 0;
    public int GridThickness = 2;
    public boolean ShowGrid = false;
    public boolean AxesOnly = false;
    public boolean GridLabels = true;
    public boolean GridBold = false;
    public boolean GridLarge = false;
    public Dimension UseSize = null;
    ZirkelCanvasInterface ZCI;
    DoneListener DL;
    int Moved = 0;
    boolean Dragging = false;
    boolean RightClicked = false;
    boolean Control = false;
    public boolean SmartBoardPreview = false;
    DragThread DT = null;
    ConstructionObject LastPaint = null;
    boolean Frozen = false;
    MessageWindow MW;
    final double PointSizeFactor = 240.0;
    int CC = 0;
    MyVector Breaks = new MyVector();
    int[] xg = new int[64];
    int[] yg = new int[64];
    public double SelectionPointFactor = Global.getParameter("selectionsize", 2);
    public double Scale = 1.0;
    static char[] c = new char[20];
    int nc;
    MyVector V = new MyVector();
    boolean NewPoint = false;
    boolean IntersectionYes = false;
    MyVector Indicated = new MyVector();
    PointObject IndicatePoint = null;
    boolean Preview = false;
    ConstructionObject LastNonPreview = null;
    MoveableObject PreviewObject = null;
    Vector Macros = new Vector();
    public boolean ProtectMacros = false;
    public MacroMenu MM = null;
    public String MacroCurrentComment;
    MacroBar MBar;
    TextField TF;
    Image OldBackground = null;
    MyVector Drawings = new MyVector();
    int PointLast;
    int LineLast;
    int AngleLast;
    sHotEqn HE = null;
    public ConstructionDisplayPanel CDP = null;

    public ZirkelCanvas(boolean readonly, boolean replay, boolean hidden) {
        this.ReadOnly = readonly;
        boolean bl = this.AllowRightMouse = !readonly;
        if (Global.getParameter("options.nopopupmenu", false)) {
            this.PM = null;
        } else if (this.ReadOnly) {
            this.PM = new PopupMenu();
            this.CheckboxHidden = new MyCheckboxMenuItem(Zirkel.name("popup.hidden"));
            this.CheckboxHidden.addItemListener(this);
            if (hidden) {
                this.PM.add(this.CheckboxHidden);
            }
            this.Replay = new MyMenuItem(Zirkel.name("popup.replay"));
            this.Replay.addActionListener(this);
            if (replay) {
                this.PM.add(this.Replay);
            }
            if (hidden || replay) {
                this.add(this.PM);
            } else {
                this.PM = null;
            }
        } else {
            this.PM = new PopupMenu();
            this.Empty = new MyMenuItem(Zirkel.name("popup.empty"));
            this.add(this.PM);
        }
        this.C.CL = this;
        this.clear();
        this.updateDigits();
        this.C.addAddEventListener(this);
        this.addMouseWheelListener(this);
    }

    public ZirkelCanvas(boolean readonly) {
        this(readonly, true, true);
    }

    public ZirkelCanvas() {
        this(false, true, true);
    }

    public Dimension getMinimumSize() {
        if (this.Background == null || !Global.getParameter("background.usesize", false)) {
            if (this.UseSize != null) {
                return this.UseSize;
            }
            return new Dimension(600, 600);
        }
        int iw = this.Background.getWidth(this);
        if (iw < 10) {
            return new Dimension(600, 600);
        }
        int ih = this.Background.getHeight(this);
        if (Global.getParameter("background.usewidth", false)) {
            int w = this.getSize().width;
            int h = (int)((double)ih / (double)iw * (double)w + 0.5);
            return new Dimension(w, h);
        }
        return new Dimension(iw, ih);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void updateDigits() {
        EditFactor = Math.pow(10.0, Global.getParameter("digits.edit", 5));
        LengthsFactor = Math.pow(10.0, Global.getParameter("digits.lengths", 5));
        AnglesFactor = Math.pow(10.0, Global.getParameter("digits.angles", 0));
    }

    public void itemStateChanged(ItemEvent e2) {
        if (e2.getSource() == this.CheckboxHidden) {
            this.ShowHidden = this.CheckboxHidden.getState();
            this.repaint();
        }
    }

    public void setZirkelCanvasListener(ZirkelCanvasInterface zci) {
        this.ZCI = zci;
    }

    public String loadImage() {
        return this.ZCI.loadImage();
    }

    public Image doLoadImage(String filename) {
        return this.ZCI.doLoadImage(filename);
    }

    public void actionPerformed(ActionEvent e2) {
        block3: {
            block2: {
                if (!this.Interactive) {
                    return;
                }
                if (e2.getSource() != this.Replay) break block2;
                if (this.ZCI == null) break block3;
                this.ZCI.replayChosen();
                break block3;
            }
            Enumeration en = this.Macros.elements();
            while (en.hasMoreElements()) {
                MacroItem m = (MacroItem)en.nextElement();
                if (m.I != e2.getSource()) continue;
                if (this.ZCI == null) break;
                this.ZCI.runMacro(m.M);
                break;
            }
        }
    }

    public double col(double x) {
        return (x - this.Xmin) / this.DX * (double)this.IW;
    }

    public double row(double y) {
        return (double)this.IH - (y - this.Ymin) / this.DY * (double)this.IH;
    }

    public int width() {
        return this.IW;
    }

    public int height() {
        return this.IH;
    }

    public double x(int c2) {
        return this.Xmin + this.DX * (double)c2 / (double)this.IW;
    }

    public double y(int r) {
        return this.Ymin + this.DY * (double)(this.IH - r) / (double)this.IH;
    }

    public double dx(int c2) {
        return this.DX * (double)c2 / (double)this.IW;
    }

    public double dy(int r) {
        return this.DY * (double)r / (double)this.IH;
    }

    public double dx(double c2) {
        return this.DX * c2 / (double)this.IW;
    }

    public double dy(double r) {
        return this.DY * r / (double)this.IH;
    }

    public double maxX() {
        return this.Xmin + this.DX;
    }

    public double minX() {
        return this.Xmin;
    }

    public double maxY() {
        return this.Ymin + this.DY;
    }

    public double minY() {
        return this.Ymin;
    }

    public boolean isInside(double x, double y) {
        return x >= this.Xmin && x < this.Xmin + this.DX && y >= this.Ymin && y < this.Ymin + this.DY;
    }

    public double dCenter(double x, double y) {
        double dx = x - (this.Xmin + this.DX / 2.0);
        double dy = y - (this.Ymin + this.DY / 2.0);
        return Math.sqrt(dx * dx + dy * dy) / Math.max(this.DX / 2.0, this.DY / 2.0);
    }

    public void recompute() {
        if (this.IH < this.IW) {
            this.Xmin = this.C.getX() - this.C.getW();
            this.DX = this.C.getW() * 2.0;
            this.DY = this.DX / (double)this.IW * (double)this.IH;
            this.Ymin = this.C.getY() - this.DY / 2.0;
        } else {
            this.Ymin = this.C.getY() - this.C.getW();
            this.DY = this.C.getW() * 2.0;
            this.DX = this.DY / (double)this.IH * (double)this.IW;
            this.Xmin = this.C.getX() - this.DY / 2.0;
        }
        this.C.setH(this.DY);
        if (this.DX > 0.0) {
            this.C.setPixel((double)this.getSize().width / this.DX);
        }
    }

    public void setDoneListener(DoneListener dl) {
        this.DL = dl;
    }

    public void addObject(ConstructionObject o) {
        this.C.add(o);
        if (this.Preview) {
            o.setIndicated(true);
            o.setSelectable(false);
        }
        this.C.updateCircleDep();
    }

    public void added(Construction c2, ConstructionObject o) {
        if (this.displayJob() && this.TargetO.length > 0) {
            boolean olddone = true;
            int i = 0;
            while (i < this.TargetO.length) {
                if (this.TargetS[i] != null && !this.TargetS[i].isInConstruction()) {
                    this.TargetS[i] = null;
                }
                if (this.TargetS[i] == null) {
                    olddone = false;
                    if (this.TargetO[i].equals(o)) {
                        this.TargetS[i] = o;
                    }
                }
                ++i;
            }
            boolean done = true;
            int i2 = 0;
            while (i2 < this.TargetO.length) {
                if (this.TargetS[i2] == null) {
                    done = false;
                    break;
                }
                ++i2;
            }
            if (done && this.DL != null && !olddone) {
                this.repaint();
                this.DL.notifyDone();
            }
        }
        this.repaint();
    }

    public boolean check(Construction c2) {
        int n = this.TargetO.length;
        int i = 0;
        while (i < n) {
            this.TargetS[i] = null;
            ++i;
        }
        int found = 0;
        Enumeration e2 = c2.elements();
        block1: while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isKeep()) continue;
            int i2 = 0;
            while (i2 < n) {
                if (this.TargetS[i2] == null && o.equals(this.TargetO[i2])) {
                    this.TargetS[i2] = o;
                    ++found;
                    continue block1;
                }
                ++i2;
            }
        }
        return found == n;
    }

    public void check() {
        if (this.displayJob() && this.TargetO.length > 0) {
            boolean olddone = true;
            int i = 0;
            while (i < this.TargetO.length) {
                if (this.TargetS[i] != null && !this.TargetS[i].isInConstruction()) {
                    this.TargetS[i] = null;
                }
                if (this.TargetS[i] == null) {
                    olddone = false;
                }
                ++i;
            }
            boolean done = this.check(this.C);
            if (done && this.DL != null && !olddone) {
                this.repaint();
                this.DL.notifyDone();
            }
        }
    }

    public synchronized void mousePressed(MouseEvent e2) {
        if (!this.Interactive) {
            return;
        }
        this.SmartBoardPreview = false;
        this.clearIndicated();
        this.clearPreview();
        this.repaint();
        this.requestFocus();
        this.Dragging = false;
        this.RightClicked = false;
        this.Moved = 0;
        if (e2.isMetaDown() && this.AllowRightMouse) {
            if (!this.ReadOnly) {
                ConstructionObject o = this.selectLabel(e2.getX(), e2.getY());
                if (o != null) {
                    this.Dragging = true;
                    this.setTool(new LabelMover(this.OC, this, e2.getX(), e2.getY(), o, e2.isShiftDown()));
                    return;
                }
                if (e2.isShiftDown() && e2.isControlDown()) {
                    o = this.selectObject(e2.getX(), e2.getY());
                    if (o == null) {
                        return;
                    }
                    o.toggleHidden();
                    this.repaint();
                    return;
                }
                if (e2.isControlDown()) {
                    o = this.selectObject(e2.getX(), e2.getY());
                    if (o == null) {
                        return;
                    }
                    new EditConditionals(this.getFrame(), o);
                    this.validate();
                    this.repaint();
                    return;
                }
            }
            ConstructionObject p = this.selectImmediateMoveableObject(e2.getX(), e2.getY());
            this.RightClicked = true;
            if (p != null) {
                this.Dragging = true;
                this.setTool(new MetaMover(this.OC, this, p, e2));
                return;
            }
            if (!Global.getParameter("options.nomousezoom", false)) {
                if (this.selectObjects(e2.getX(), e2.getY()).size() == 0) {
                    this.setTool(new ZoomerTool(this.OC, e2, this));
                }
                return;
            }
        } else {
            if (!this.SmartBoardPreview && Global.getParameter("smartboard", false) && this.OC.useSmartBoard()) {
                this.OC.mouseMoved(e2, this, Global.getParameter("options.indicate.simple", false));
                this.SmartBoardPreview = true;
                return;
            }
            this.Control = e2.isControlDown();
            this.OC.mousePressed(e2, this);
            this.Control = false;
        }
    }

    public synchronized void mouseReleased(MouseEvent e2) {
        if (!this.Interactive) {
            return;
        }
        if (this.DT != null) {
            this.DT.waitReady();
        }
        if (this.RightClicked) {
            MyVector v;
            this.RightClicked = false;
            this.OC.mouseReleased(e2, this);
            if (this.Moved <= 2 && this.AllowRightMouse && !this.ReadOnly && (v = this.selectObjects(e2.getX(), e2.getY())).size() > 0) {
                ConstructionObject o = this.select(v, e2.getX(), e2.getY());
                if (o != null) {
                    new EditTool().mousePressed(e2, o, this);
                    this.check();
                    return;
                }
                this.repaintCD();
                return;
            }
            if (this.Moved <= 2 && this.PM != null && !Global.getParameter("restricted", false)) {
                int n = 2;
                if (this.ReadOnly || !Global.getParameter("options.doubleclick", false)) {
                    n = 1;
                }
                if (e2.getClickCount() >= n && (this.ReadOnly || this.Macros.size() != 0)) {
                    this.PM.show(e2.getComponent(), e2.getX(), e2.getY());
                }
            }
            this.repaintCD();
            return;
        }
        if (this.SmartBoardPreview && Global.getParameter("smartboard", false)) {
            this.Control = e2.isControlDown();
            this.clearIndicated();
            this.clearPreview();
            this.repaint();
            this.Dragging = false;
            this.OC.mousePressed(e2, this);
            this.SmartBoardPreview = false;
            this.mouseReleased(e2);
            return;
        }
        if (!this.Dragging) {
            this.OC.mouseReleased(e2, this);
            this.Dragging = false;
            this.repaintCD();
            return;
        }
        if (this.Moved <= 1) {
            if (this.OC instanceof LabelMover) {
                ((LabelMover)this.OC).resetPoint();
                this.OC.mouseReleased(e2, this);
            } else if (this.OC instanceof MetaMover) {
                this.OC.mouseReleased(e2, this);
                if (!this.ReadOnly) {
                    new EditTool().mousePressed(e2, this);
                }
            }
        } else {
            this.OC.mouseReleased(e2, this);
        }
        this.repaintCD();
        this.check();
        this.Dragging = false;
    }

    public synchronized void mouseClicked(MouseEvent e2) {
    }

    public synchronized void mouseExited(MouseEvent e2) {
        if (!this.Interactive) {
            return;
        }
        this.clearIndicated();
        this.clearPreview();
        this.repaint();
        this.SmartBoardPreview = false;
        this.RightClicked = false;
        this.repaintCD();
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public synchronized void mouseMoved(MouseEvent e2) {
        if (!this.Interactive || !Global.getParameter("options.indicate", true)) {
            return;
        }
        if (Global.getParameter("smartboard", false)) {
            return;
        }
        Count.setAllAlternate(true);
        this.OC.mouseMoved(e2, this, Global.getParameter("options.indicate.simple", false));
        Count.setAllAlternate(false);
        this.repaintCD();
    }

    public synchronized void mouseDragged(MouseEvent e2) {
        if (!this.Interactive) {
            return;
        }
        if (this.DT == null) {
            this.DT = new DragThread(this);
        }
        if (this.SmartBoardPreview && Global.getParameter("smartboard", false)) {
            this.OC.mouseMoved(e2, this, Global.getParameter("options.indicate.simple", false));
        } else {
            this.DT.mouseDragged(e2);
            ++this.Moved;
        }
        this.repaintCD();
    }

    public synchronized void doMouseDragged(MouseEvent e2) {
        this.OC.mouseDragged(e2, this);
    }

    public void newImage() {
        this.I = null;
        this.repaint();
    }

    public void setFrozen(boolean f2) {
        this.Frozen = f2;
    }

    public synchronized void paint(Graphics g) {
        if (this.Frozen) {
            return;
        }
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (this.I == null || this.IW != w || this.IH != h) {
            if (w == 0 || h == 0) {
                return;
            }
            this.IW = w;
            this.IH = h;
            this.I = this.createImage(this.IW, this.IH);
            if (!Global.getParameter("printscalepreview", false) || !Global.getParameter("printscale.sizes", false)) {
                if (!Global.getParameter("simplegraphics", false)) {
                    this.IG = new MyGraphics13(this.I.getGraphics(), this);
                    this.IG.setSize(this.IW, this.IH);
                } else {
                    this.IG = new MyGraphics11(this.I.getGraphics());
                    this.IG.setSize(this.IW, this.IH);
                }
                this.PointSize = (double)this.IH / 240.0;
                this.FontSize = this.PointSize * 4.0;
                this.MinPointSize = Global.getParameter("minpointsize", 4);
                if (this.PointSize < this.MinPointSize) {
                    this.PointSize = this.MinPointSize;
                }
                this.MinFontSize = Global.getParameter("minfontsize", 14);
                if (this.FontSize < this.MinFontSize) {
                    this.FontSize = this.MinFontSize;
                }
                this.IG.setDefaultFont((int)this.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            } else {
                double dpi = (double)this.IW / Global.getParameter("printscale.width", 5.0);
                if (!Global.getParameter("simplegraphics", false)) {
                    this.IG = new MyGraphics13(this.I.getGraphics(), Global.getParameter("printscale.linewidth", 0.02) * dpi, this, null);
                    this.IG.setSize(this.IW, this.IH);
                } else {
                    this.IG = new MyGraphics11(this.I.getGraphics());
                    this.IG.setSize(this.IW, this.IH);
                }
                this.PointSize = Global.getParameter("printscale.pointsize", 0.07) * dpi;
                this.FontSize = Global.getParameter("printscale.textsize", 0.3) * dpi;
                this.IG.setDefaultFont((int)this.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            }
            this.recompute();
            this.C.dovalidate();
        }
        this.IG.clearRect(0, 0, this.IW, this.IH, this.getBackground());
        if (this.Background != null) {
            int bw = this.Background.getWidth(this);
            int bh = this.Background.getHeight(this);
            if (bw == this.IW && bh == this.IH) {
                this.IG.drawImage(this.Background, 0, 0, this);
            } else if (Global.getParameter("background.tile", true) && bw < this.IW && bh < this.IH) {
                int i = this.IW % bw / 2 - bw;
                while (i < this.IW) {
                    int j = this.IH % bh / 2 - bh;
                    while (j < this.IH) {
                        this.IG.drawImage(this.Background, i, j, this);
                        j += bh;
                    }
                    i += bw;
                }
            } else if (Global.getParameter("background.center", true)) {
                this.IG.drawImage(this.Background, (this.IW - bw) / 2, (this.IH - bh) / 2, this);
            } else {
                this.IG.drawImage(this.Background, 0, 0, this.IW, this.IH, this);
            }
        }
        if (this.MW == null) {
            this.C.computeTracks(this);
            this.dopaint(this.IG);
        }
        if (Global.getParameter("printscale.middle", false) && Global.getParameter("printscalepreview", false)) {
            this.IG.setColor(Color.red);
            int PW = Global.getParameter("printscale.w", this.IW);
            int PH = Global.getParameter("printscale.h", this.IH);
            this.IG.drawRect(this.IW / 2 - PW / 2 - 3, this.IH / 2 - PH / 2 - 3, PW + 7, PH + 7);
        }
        g.drawImage(this.I, 0, 0, this);
    }

    public synchronized void resetGraphics() {
        this.I = null;
        this.repaint();
    }

    public void updateBreakHide() {
        this.Breaks.removeAllElements();
        Enumeration e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o == this.LastPaint || o == this.C.last()) break;
            if (!o.isBreak()) continue;
            this.Breaks.addElement(o);
        }
        e2 = this.C.elements();
        ConstructionObject NextBreak = null;
        Enumeration eb = this.Breaks.elements();
        if (eb.hasMoreElements()) {
            NextBreak = (ConstructionObject)eb.nextElement();
        }
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (NextBreak != null && NextBreak.isHideBreak()) {
                o.setBreakHide(true);
            } else {
                o.setBreakHide(false);
            }
            if (o == NextBreak) {
                NextBreak = eb.hasMoreElements() ? (ConstructionObject)eb.nextElement() : null;
            }
            if (o == this.LastPaint) break;
        }
    }

    void dopaint(MyGraphics IG) {
        ConstructionObject o;
        if (this.ShowGrid) {
            if (!this.AxesOnly) {
                this.paintAxes(IG);
            } else {
                this.paintGrid(IG);
            }
        }
        long time = System.currentTimeMillis();
        this.updateBreakHide();
        Enumeration e2 = this.C.elements();
        int n = 0;
        while (e2.hasMoreElements()) {
            o = (ConstructionObject)e2.nextElement();
            o.HasZ = false;
            o.IsDrawn = false;
            try {
                if (!o.selected()) {
                    o.Value = -o.getZ();
                    o.HasZ = true;
                    ++n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (o == this.LastPaint) break;
        }
        e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            o = (ConstructionObject)e2.nextElement();
            if (o.isBack() && !o.HasZ && !o.isFillBackground()) {
                o.paint(IG, this);
                o.IsDrawn = true;
            }
            if (o == this.LastPaint) break;
        }
        if (n > 0) {
            SortObject[] os = new ConstructionObject[n];
            e2 = this.C.elements();
            n = 0;
            while (e2.hasMoreElements()) {
                ConstructionObject o2 = (ConstructionObject)e2.nextElement();
                if (!o2.HasZ) continue;
                os[n++] = o2;
            }
            Sorter.sort(os);
            int i = 0;
            while (i < n) {
                ((ConstructionObject)os[i]).paint(IG, this);
                ((ConstructionObject)os[i]).IsDrawn = true;
                ++i;
            }
        }
        e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            o = (ConstructionObject)e2.nextElement();
            if (!(o.selected() || o.isFillBackground() || o.IsDrawn)) {
                o.paint(IG, this);
                o.IsDrawn = true;
            }
            if (o == this.LastPaint) break;
        }
        e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            o = (ConstructionObject)e2.nextElement();
            if (!o.isFillBackground() && !o.IsDrawn) {
                o.paint(IG, this);
                o.IsDrawn = true;
            }
            if (o == this.LastPaint) break;
        }
        if (this.LastPaint == null) {
            this.paintTrack(IG);
        }
        e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            o = (ConstructionObject)e2.nextElement();
            if (!o.IsDrawn) {
                o.paint(IG, this);
                o.IsDrawn = true;
            }
            if (o == this.LastPaint) break;
        }
        if (this.Interactive && this.IndicatePoint != null) {
            this.IndicatePoint.paint(IG, this);
        }
        if ((time = System.currentTimeMillis() - time) > 250L && PolygonDrawer.step < 50) {
            PolygonDrawer.step *= 2;
        }
        if (time < 100L && PolygonDrawer.step > 4) {
            PolygonDrawer.step /= 2;
        }
        this.paintDrawings(IG);
    }

    void dopaintFig(MyGraphicsFig IG) {
        if (this.ShowGrid) {
            this.paintGrid(IG);
        }
        IG.pushLayer(true);
        int layer = 0;
        while (true) {
            ConstructionObject o;
            IG.pushLayer();
            int l = 0;
            Enumeration e2 = this.C.elements();
            while (e2.hasMoreElements()) {
                o = (ConstructionObject)e2.nextElement();
                if (o == this.LastPaint) break;
                if (l == layer && o.isBack()) {
                    o.paint(IG, this);
                }
                if (o.isBreak() && ++l > layer) break;
            }
            if (l < layer) break;
            l = 0;
            e2 = this.C.elements();
            while (e2.hasMoreElements()) {
                o = (ConstructionObject)e2.nextElement();
                if (o == this.LastPaint) break;
                if (l == layer && !o.isBack() && !o.selected()) {
                    o.paint(IG, this);
                }
                if (o.isBreak() && ++l > layer) break;
            }
            l = 0;
            e2 = this.C.elements();
            while (e2.hasMoreElements()) {
                o = (ConstructionObject)e2.nextElement();
                if (o == this.LastPaint) break;
                if (l == layer && !o.isBack() && o.selected()) {
                    o.paint(IG, this);
                }
                if (o.isBreak() && ++l > layer) break;
            }
            ++layer;
        }
        IG.pushLayer(false);
        if (this.LastPaint == null) {
            this.paintTrack(IG);
        }
    }

    public void setGrid() {
        this.ShowGrid = Global.getParameter("showgrid", false);
        this.AxesOnly = Global.getParameter("axesonly", false);
        this.GridThickness = Global.getParameter("grid.thickness", 2);
        this.GridColor = Global.getParameter("grid.colorindex", 0);
        this.GridBold = Global.getParameter("grid.bold", false);
        this.GridLarge = Global.getParameter("grid.large", false);
        this.GridLabels = Global.getParameter("grid.labels", true);
    }

    void paintGrid(MyGraphics IG) {
        int r;
        if (this.GridThickness == 0) {
            IG.setColor(ZirkelFrame.Colors[Global.getParameter("grid.colorindex", 0)]);
        } else {
            IG.setColor(ZirkelFrame.LightColors[this.GridColor]);
        }
        IG.setFont(this.GridLarge, this.GridBold);
        double gridsize = this.getGridSize();
        int dd = this.IH / 200;
        if (dd < 1) {
            dd = 1;
        }
        double x1 = Math.floor((this.C.getX() - this.C.getW()) / gridsize - 1.0) * gridsize;
        int xi = 0;
        while (x1 < this.C.getX() + this.C.getW() && xi < 64) {
            int c2 = (int)this.col(x1);
            this.xg[xi++] = c2;
            x1 += gridsize;
        }
        double y1 = Math.floor((this.C.getY() - this.C.getW()) / gridsize - 1.0) * gridsize;
        int yi = 0;
        while (y1 < this.C.getY() + this.C.getW() && yi < 64) {
            r = (int)this.row(y1);
            this.yg[yi++] = r;
            y1 += gridsize;
        }
        int i = 0;
        while (i < xi) {
            int j = 0;
            while (j < yi) {
                IG.drawLine(this.xg[i], this.yg[j] - dd, this.xg[i], this.yg[j] + dd);
                IG.drawLine(this.xg[i] - dd, this.yg[j], this.xg[i] + dd, this.yg[j]);
                ++j;
            }
            ++i;
        }
        if (this.GridThickness != 3) {
            if (0.0 < this.C.getX() + this.C.getW() && 0.0 > this.C.getX() - this.C.getW()) {
                int c3 = (int)this.col(0.0);
                if (this.GridThickness != 1) {
                    IG.drawLine(c3, 0.0, c3, this.IH);
                } else {
                    IG.drawThickLine(c3, 0.0, c3, this.IH);
                }
            }
            if (0.0 < this.C.getY() + this.C.getW() && 0.0 > this.C.getY() - this.C.getW()) {
                r = (int)this.row(0.0);
                if (this.GridThickness != 1) {
                    IG.drawLine(0.0, r, this.IW, r);
                } else {
                    IG.drawThickLine(0.0, r, this.IW, r);
                }
            }
        }
        dd *= 2;
        double labelsize = Math.pow(10.0, Math.floor(Math.log(this.C.getW() * 2.0) / Math.log(10.0))) / 10.0;
        while (this.C.getW() * 2.0 / labelsize >= 10.0) {
            labelsize *= 10.0;
        }
        if (this.C.getW() * 2.0 / labelsize < 5.0) {
            labelsize /= 2.0;
        }
        FontMetrics fm = IG.getFontMetrics();
        int FH = fm.getHeight();
        x1 = Math.floor((this.C.getX() - this.C.getW()) / labelsize - 1.0) * labelsize;
        int lh = (int)this.row(0.0);
        if (lh < 0 || lh > this.IH - FH) {
            lh = this.IH - FH;
        }
        while (x1 < this.C.getX() + this.C.getW()) {
            int c4 = (int)this.col(x1);
            String s = this.format(x1);
            if (s.length() > 0) {
                if (this.GridLabels) {
                    IG.drawString(s, c4 + 3, lh + FH);
                }
                IG.drawLine(c4, lh - dd, c4, lh + dd);
            }
            x1 += labelsize;
        }
        int lw = (int)this.col(0.0);
        if (lw < 0 || lw > this.IW - 20) {
            lw = 0;
        }
        y1 = Math.floor((this.C.getY() - this.C.getW()) / labelsize - 1.0) * labelsize;
        while (y1 < this.C.getY() + this.C.getW()) {
            int r2 = (int)this.row(y1);
            String s = this.format(y1);
            if (s.length() > 0) {
                if (this.GridLabels) {
                    IG.drawString(s, lw + 3, r2 + FH);
                }
                IG.drawLine(lw - dd, r2, lw + dd, r2);
            }
            y1 += labelsize;
        }
    }

    void paintAxes(MyGraphics IG) {
        int r;
        if (this.GridThickness == 0) {
            IG.setColor(ZirkelFrame.Colors[this.GridColor]);
        } else {
            IG.setColor(ZirkelFrame.LightColors[this.GridColor]);
        }
        IG.setFont(this.GridLarge, this.GridBold);
        double gridsize = this.getGridSize();
        double x1 = Math.floor((this.C.getX() - this.C.getW()) / gridsize - 1.0) * gridsize;
        int r0 = (int)this.row(0.0);
        int dd = this.IH / 200;
        if (dd < 1) {
            dd = 1;
        }
        while (x1 < this.C.getX() + this.C.getW()) {
            int c2 = (int)this.col(x1);
            IG.drawLine(c2, r0 - dd, c2, r0 + dd);
            x1 += gridsize;
        }
        double y1 = Math.floor((this.C.getY() - this.C.getW()) / gridsize - 1.0) * gridsize;
        int c0 = (int)this.col(0.0);
        while (y1 < this.C.getY() + this.C.getW()) {
            r = (int)this.row(y1);
            IG.drawLine(c0 - dd, r, c0 + dd, r);
            y1 += gridsize;
        }
        if (this.GridThickness != 3) {
            if (0.0 < this.C.getX() + this.C.getW() && 0.0 > this.C.getX() - this.C.getW()) {
                int c3 = (int)this.col(0.0);
                if (this.GridThickness != 1) {
                    IG.drawLine(c3, 0.0, c3, this.IH);
                } else {
                    IG.drawThickLine(c3, 0.0, c3, this.IH);
                }
            }
            if (0.0 < this.C.getY() + this.C.getW() && 0.0 > this.C.getY() - this.C.getW()) {
                r = (int)this.row(0.0);
                if (this.GridThickness != 1) {
                    IG.drawLine(0.0, r, this.IW, r);
                } else {
                    IG.drawThickLine(0.0, r, this.IW, r);
                }
            }
        }
        dd *= 2;
        double labelsize = Math.pow(10.0, Math.floor(Math.log(this.C.getW() * 2.0) / Math.log(10.0))) / 10.0;
        while (this.C.getW() * 2.0 / labelsize >= 10.0) {
            labelsize *= 10.0;
        }
        if (this.C.getW() * 2.0 / labelsize < 5.0) {
            labelsize /= 2.0;
        }
        FontMetrics fm = IG.getFontMetrics();
        int FH = fm.getHeight();
        x1 = Math.floor((this.C.getX() - this.C.getW()) / labelsize - 1.0) * labelsize;
        int lh = (int)this.row(0.0);
        if (lh < 0 || lh > this.IH - FH) {
            lh = this.IH - FH;
        }
        while (x1 < this.C.getX() + this.C.getW()) {
            int c4 = (int)this.col(x1);
            String s = this.format(x1);
            if (this.GridLabels) {
                IG.drawString(s, c4 + 4, lh + FH);
            }
            if (s.length() > 0) {
                IG.drawLine(c4, lh - dd, c4, lh + dd);
            }
            x1 += labelsize;
        }
        int lw = (int)this.col(0.0);
        if (lw < 0 || lw > this.IW - 20) {
            lw = 0;
        }
        y1 = Math.floor((this.C.getY() - this.C.getW()) / labelsize - 1.0) * labelsize;
        while (y1 < this.C.getY() + this.C.getW()) {
            int r2 = (int)this.row(y1);
            String s = this.format(y1);
            if (this.GridLabels) {
                IG.drawString(s, lw + 3, r2 + FH);
            }
            if (s.length() > 0) {
                IG.drawLine(lw - dd, r2, lw + dd, r2);
            }
            y1 += labelsize;
        }
    }

    public double pointSize() {
        return this.PointSize;
    }

    public double angleSize() {
        return 4.0 * this.FontSize;
    }

    public double selectionSize() {
        return this.SelectionPointFactor * this.PointSize;
    }

    public int scale(int x) {
        return (int)(this.Scale * (double)x);
    }

    public String format(double x) {
        double h;
        this.nc = 0;
        boolean minus = false;
        if (x < -1.0E-12) {
            minus = true;
            x = -x;
        }
        if (this.rekformat(h = (x += 1.0E-12) - Math.floor(x), 8)) {
            ZirkelCanvas.c[this.nc++] = 46;
        }
        while (x >= 1.0) {
            double s = Math.floor(x / 10.0);
            ZirkelCanvas.c[this.nc++] = (char)(48 + (int)(x - s * 10.0));
            x = s;
        }
        if (this.nc > 0 && minus) {
            ZirkelCanvas.c[this.nc++] = 45;
        }
        int i = 0;
        while (i < this.nc / 2) {
            char hc = c[this.nc - 1 - i];
            ZirkelCanvas.c[this.nc - 1 - i] = c[i];
            ZirkelCanvas.c[i] = hc;
            ++i;
        }
        return new String(c, 0, this.nc);
    }

    boolean rekformat(double h, int k) {
        double x = Math.floor(h *= 10.0);
        if (k == 0) {
            int i = (int)x;
            if (i > 0) {
                ZirkelCanvas.c[this.nc++] = (char)(48 + i);
                return true;
            }
            return false;
        }
        int i = (int)x;
        if (this.rekformat(h - x, k - 1) || i > 0) {
            ZirkelCanvas.c[this.nc++] = (char)(48 + i);
            return true;
        }
        return false;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paintUntil(ConstructionObject o) {
        if (this.LastPaint == o) {
            return;
        }
        this.LastPaint = o;
        this.repaint();
    }

    public void validate() {
        this.dovalidate();
        if (this.OC instanceof TrackPainter) {
            ((TrackPainter)((Object)this.OC)).validate(this);
        }
    }

    public synchronized void dovalidate() {
        this.C.dovalidate();
    }

    public void sort(MyVector V) {
        if (V.size() < 2) {
            return;
        }
        Sorter.QuickSort(V.getArray(), 0, V.size() - 1);
    }

    public void sortRow(MyVector V) {
        Object[] o = new ConstructionObject[V.size()];
        V.copyInto(o);
        V.removeAllElements();
        Enumeration e2 = this.C.elements();
        block0: while (e2.hasMoreElements()) {
            ConstructionObject oo = (ConstructionObject)e2.nextElement();
            int i = 0;
            while (i < o.length) {
                if (o[i] == oo) {
                    V.addElement(oo);
                    continue block0;
                }
                ++i;
            }
        }
    }

    public ConstructionObject selectCircleLine(int x, int y, boolean multiple) {
        MyVector v = this.selectCircleLineObjects(x, y, multiple, false);
        return this.select(v);
    }

    public ConstructionObject selectCircleLine(int x, int y) {
        return this.selectCircleLine(x, y, true);
    }

    public ConstructionObject selectPointonObject(int x, int y, boolean multiple) {
        MyVector v = this.selectPointonObjects(x, y, multiple, false, true);
        return this.select(v);
    }

    public ConstructionObject selectPointonObject(int x, int y) {
        return this.selectPointonObject(x, y, true);
    }

    public MyVector selectCircleLineObjects(int x, int y, boolean multiple, boolean testlocal) {
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isSelectable() || !(o instanceof PrimitiveLineObject) && !(o instanceof PrimitiveCircleObject) || !o.nearto(x, y, true, this) || !multiple && o.selected()) continue;
            if (testlocal) {
                Enumeration ev = this.V.elements();
                while (ev.hasMoreElements()) {
                    ConstructionObject ov = (ConstructionObject)ev.nextElement();
                    if (!o.locallyLike(ov)) continue;
                    o = null;
                    break;
                }
            }
            if (o == null) continue;
            this.V.addElement(o);
        }
        return this.V;
    }

    public MyVector selectCircleLineObjects(int x, int y, boolean multiple) {
        return this.selectCircleLineObjects(x, y, multiple, false);
    }

    public MyVector selectCircleLineObjects(int x, int y) {
        return this.selectCircleLineObjects(x, y, true, false);
    }

    public MyVector selectPointonObjects(int x, int y, boolean multiple, boolean testlocal, boolean all) {
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isSelectable() || !(o instanceof PointonObject) || !all && o.isDecorative() || !o.nearto(x, y, true, this) || !multiple && o.selected()) continue;
            if (testlocal) {
                Enumeration ev = this.V.elements();
                while (ev.hasMoreElements()) {
                    ConstructionObject ov = (ConstructionObject)ev.nextElement();
                    if (!o.locallyLike(ov)) continue;
                    o = null;
                    break;
                }
            }
            if (o == null) continue;
            this.V.addElement(o);
        }
        return this.V;
    }

    public MyVector selectPointonObjects(int x, int y, boolean multiple) {
        return this.selectPointonObjects(x, y, multiple, false, true);
    }

    public MyVector selectPointonObjects(int x, int y) {
        return this.selectPointonObjects(x, y, true, false, true);
    }

    public MyVector selectObjects(int x, int y, boolean multiple) {
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isSelectable() || !o.nearto(x, y, this) || !multiple && o.selected()) continue;
            this.V.addElement(o);
        }
        return this.V;
    }

    public MyVector selectObjects(int x, int y) {
        return this.selectObjects(x, y, true);
    }

    public ConstructionObject selectObject(int x, int y, boolean multiple) {
        MyVector v = this.selectObjects(x, y, multiple);
        return this.select(v, x, y);
    }

    public ConstructionObject selectObject(int x, int y) {
        return this.selectObject(x, y, true);
    }

    public MyVector selectConstructableObjects(int x, int y, boolean multiple) {
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.valid() || !o.isFlag() || !o.nearto(x, y, this) || !multiple && o.selected()) continue;
            this.V.addElement(o);
        }
        return this.V;
    }

    public MyVector selectConstructableObjects(int x, int y) {
        return this.selectConstructableObjects(x, y, true);
    }

    public ConstructionObject selectConstructableObject(int x, int y) {
        MyVector v = this.selectConstructableObjects(x, y, true);
        return this.select(v, x, y);
    }

    public PrimitiveLineObject selectLine(int x, int y, boolean multiple) {
        this.selectLineObjects(x, y, multiple);
        return (PrimitiveLineObject)this.select(this.V);
    }

    public void selectLineObjects(int x, int y, boolean multiple) {
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isSelectable() || !(o instanceof PrimitiveLineObject) || !o.nearto(x, y, this) || !multiple && o.selected()) continue;
            this.V.addElement(o);
        }
    }

    public PrimitiveLineObject selectLine(int x, int y) {
        return this.selectLine(x, y, true);
    }

    public void selectPointsOrLines(int x, int y, boolean multiple) {
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isSelectable() || !(o instanceof PrimitiveLineObject) && !(o instanceof PointObject) || !o.nearto(x, y, this) || !multiple && o.selected()) continue;
            this.V.addElement(o);
        }
    }

    public TwoPointLineObject selectTwoPointLine(int x, int y, boolean multiple) {
        this.selectTwoPointLines(x, y, multiple);
        return (TwoPointLineObject)this.select(this.V);
    }

    public void selectTwoPointLines(int x, int y, boolean multiple) {
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isSelectable() || !(o instanceof TwoPointLineObject) || !o.nearto(x, y, this) || !multiple && o.selected()) continue;
            this.V.addElement(o);
        }
    }

    public TwoPointLineObject selectTwoPointLine(int x, int y) {
        return this.selectTwoPointLine(x, y, true);
    }

    public SegmentObject selectSegment(int x, int y, boolean multiple) {
        this.selectSegments(x, y, multiple);
        return (SegmentObject)this.select(this.V);
    }

    public void selectSegments(int x, int y, boolean multiple) {
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isSelectable() || !(o instanceof SegmentObject) || !o.nearto(x, y, this) || !multiple && o.selected()) continue;
            this.V.addElement(o);
        }
    }

    public SegmentObject selectSegment(int x, int y) {
        return this.selectSegment(x, y, true);
    }

    public RayObject selectRay(int x, int y, boolean multiple) {
        this.selectRays(x, y, multiple);
        return (RayObject)this.select(this.V);
    }

    public void selectRays(int x, int y, boolean multiple) {
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isSelectable() || !(o instanceof RayObject) || !o.nearto(x, y, this) || !multiple && o.selected()) continue;
            this.V.addElement(o);
        }
    }

    public RayObject selectRay(int x, int y) {
        return this.selectRay(x, y, true);
    }

    public PrimitiveCircleObject selectCircle(int x, int y, boolean multiple) {
        this.selectCircles(x, y, multiple);
        return (PrimitiveCircleObject)this.select(this.V);
    }

    public void selectCircles(int x, int y, boolean multiple) {
        ConstructionObject o;
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        boolean haveNotFilled = false;
        while (e2.hasMoreElements()) {
            o = (ConstructionObject)e2.nextElement();
            if (!o.isSelectable() || !(o instanceof PrimitiveCircleObject) || !o.nearto(x, y, this) || !multiple && o.selected()) continue;
            this.V.addElement(o);
            if (o.isFilledForSelect()) continue;
            haveNotFilled = true;
        }
        if (haveNotFilled) {
            e2 = this.V.elements();
            while (e2.hasMoreElements()) {
                o = (ConstructionObject)e2.nextElement();
                if (!o.isFilledForSelect()) continue;
                this.V.removeElement(o);
            }
        }
    }

    public PrimitiveCircleObject selectCircle(int x, int y) {
        return this.selectCircle(x, y, true);
    }

    public PointObject selectPoint(int x, int y, boolean multiple) {
        this.selectPointObjects(x, y, multiple);
        return (PointObject)this.select(this.V);
    }

    public void selectPointObjects(int x, int y, boolean multiple) {
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isSelectable() || !(o instanceof PointObject) || !o.nearto(x, y, this) || !multiple && o.selected()) continue;
            this.V.addElement(o);
        }
    }

    public PointObject selectPoint(int x, int y) {
        return this.selectPoint(x, y, true);
    }

    public PointObject selectPoint(int x, int y, boolean multiple, ConstructionObject until) {
        this.selectPointObjects(x, y, multiple, until);
        return (PointObject)this.select(this.V);
    }

    public void selectPointObjects(int x, int y, boolean multiple, ConstructionObject until) {
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o == until) break;
            if (!o.isSelectable() || !(o instanceof PointObject) || !o.nearto(x, y, this) || !multiple && o.selected()) continue;
            this.V.addElement(o);
        }
    }

    public PointObject selectPoint(int x, int y, ConstructionObject until) {
        return this.selectPoint(x, y, true, until);
    }

    public boolean isNewPoint() {
        return this.NewPoint;
    }

    public PointObject selectCreatePoint(int x, int y, boolean multiple, boolean any, boolean all) {
        ConstructionObject o;
        this.NewPoint = false;
        if (this.Preview) {
            PointObject p = new PointObject(this.C, this.x(x), this.y(y));
            this.addObject(p);
            p.setSuperHidden(true);
            this.PreviewObject = p;
            return p;
        }
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            o = (ConstructionObject)e2.nextElement();
            if (o.isSelectable() && o instanceof PointObject && o.nearto(x, y, this) && (multiple || !o.selected())) {
                this.V.addElement(o);
            }
            this.sort(this.V);
        }
        if (this.V.size() > 0) {
            if (any) {
                return (PointObject)this.V.elementAt(0);
            }
            o = this.select(this.V, this.Control || !Global.getParameter("options.indicate", true));
            if (o != null) {
                return (PointObject)o;
            }
            return null;
        }
        ConstructionObject oc = this.tryCreateIntersection(x, y, true, all);
        if (oc != null) {
            return (PointObject)oc;
        }
        if (!this.IntersectionYes) {
            return null;
        }
        MyVector w = this.selectPointonObjects(x, y, true, false, all);
        this.filter(w, x, y, true);
        if (w.size() > 0) {
            oc = this.select(w, !this.Control);
            if (oc == null) {
                return null;
            }
            if (oc != null) {
                boolean yes = true;
                if (Global.getParameter("options.pointon", false)) {
                    AgainQuestion q = new AgainQuestion(this.F, Zirkel.name("question.pointon"), Zirkel.name("question.title"));
                    q.center(this.F);
                    q.setVisible(true);
                    yes = q.yes();
                    Global.setParameter("options.pointon", q.again());
                }
                if (yes) {
                    PointObject o2 = new PointObject(this.C, this.x(x), this.y(y), oc);
                    if (this.ShowGrid && !Global.getParameter("grid.leftsnap", false)) {
                        o2.snap(this);
                    }
                    o2.setUseAlpha(true);
                    this.addObject(o2);
                    this.validate();
                    o2.setDefaults();
                    this.NewPoint = true;
                    return o2;
                }
                return null;
            }
        }
        PointObject p = new PointObject(this.C, this.x(x), this.y(y));
        if (this.ShowGrid) {
            p.snap(this);
        }
        this.addObject(p);
        p.setDefaults();
        this.NewPoint = true;
        return p;
    }

    public ConstructionObject tryCreateIntersection(int x, int y, boolean ask, boolean all) {
        MyVector w = this.selectPointonObjects(x, y, true, true, true);
        this.sort(w);
        this.IntersectionYes = true;
        if (w.size() < 2) {
            return null;
        }
        ConstructionObject P1 = (ConstructionObject)w.elementAt(0);
        ConstructionObject P2 = (ConstructionObject)w.elementAt(1);
        if (!(P1 instanceof PointonObject) || !(P2 instanceof PointonObject)) {
            return null;
        }
        if (!((PointonObject)((Object)P1)).canInteresectWith(P2) || !((PointonObject)((Object)P2)).canInteresectWith(P1) || !all && P1.isDecorative() || !all && P2.isDecorative()) {
            return null;
        }
        IntersectionObject[] o = IntersectionConstructor.construct(P1, P2, this.C);
        if (o.length == 1 && !o[0].valid()) {
            return null;
        }
        if (o.length == 2 && !o[0].valid() && !o[1].valid()) {
            return null;
        }
        if (ask && Global.getParameter("options.intersection", false)) {
            AgainQuestion q = new AgainQuestion(this.F, Zirkel.name("question.intersection"), Zirkel.name("question.title"));
            q.center(this.F);
            q.setVisible(true);
            this.IntersectionYes = q.yes();
            Global.setParameter("options.intersection", q.again());
        }
        if (this.IntersectionYes) {
            if (o.length == 1 || !o[1].valid()) {
                this.addObject(o[0]);
                o[0].autoAway();
                o[0].validate(this.x(x), this.y(y));
                this.validate();
                o[0].setDefaults();
                o[0].setRestricted(this.getRestricted());
                return o[0];
            }
            if (!o[0].valid()) {
                this.addObject(o[1]);
                o[1].autoAway();
                this.validate();
                o[1].setDefaults();
                o[1].setRestricted(this.getRestricted());
                return o[1];
            }
            IntersectionObject oc = o[0];
            double d0 = o[0].distanceTo(x, y, this);
            double d1 = o[1].distanceTo(x, y, this);
            if (d1 < d0) {
                oc = o[1];
            }
            this.addObject(oc);
            oc.autoAway();
            oc.validate(this.x(x), this.y(y));
            this.validate();
            oc.setDefaults();
            oc.setRestricted(this.getRestricted());
            this.NewPoint = true;
            return oc;
        }
        return null;
    }

    public PointObject selectCreatePoint(int x, int y) {
        return this.selectCreatePoint(x, y, true, false, true);
    }

    public PointObject selectCreatePoint(int x, int y, boolean multiple) {
        return this.selectCreatePoint(x, y, multiple, false, true);
    }

    public ConstructionObject selectMoveablePoint(int x, int y) {
        ConstructionObject o;
        ConstructionObject s = this.findSelectedObject();
        if (s instanceof PointObject && ((MoveableObject)((Object)s)).moveable() && s.nearto(x, y, this)) {
            return s;
        }
        this.V.removeAllElements();
        Enumeration e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            o = (ConstructionObject)e2.nextElement();
            if (!o.isSelectable() || !(o instanceof PointObject) || !((MoveableObject)((Object)o)).moveable() || !o.nearto(x, y, this)) continue;
            this.V.addElement(o);
        }
        if (this.V.size() == 1) {
            return (ConstructionObject)this.V.elementAt(0);
        }
        o = this.select(this.V);
        if (o != null) {
            o.setSelected(true);
        }
        return null;
    }

    public ConstructionObject selectWithSelector(int x, int y, Selector sel, ConstructionObject until, boolean choice) {
        ConstructionObject o;
        this.V.removeAllElements();
        Enumeration e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            o = (ConstructionObject)e2.nextElement();
            if (o == until) break;
            if (!o.isSelectable() || !sel.isAdmissible(this, o) || !o.nearto(x, y, this)) continue;
            this.V.addElement(o);
        }
        if (this.V.size() == 1) {
            return (ConstructionObject)this.V.elementAt(0);
        }
        if (!choice) {
            if (this.V.size() > 0) {
                return (ConstructionObject)this.V.elementAt(0);
            }
            return null;
        }
        o = this.select(this.V, x, y);
        return o;
    }

    public ConstructionObject selectWithSelector(int x, int y, Selector sel, ConstructionObject until) {
        return this.selectWithSelector(x, y, sel, until, true);
    }

    public ConstructionObject selectWithSelector(int x, int y, Selector sel, boolean choice) {
        return this.selectWithSelector(x, y, sel, null, choice);
    }

    public ConstructionObject selectWithSelector(int x, int y, Selector sel) {
        return this.selectWithSelector(x, y, sel, null, true);
    }

    public ConstructionObject selectImmediateMoveablePoint(int x, int y) {
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isSelectable() || !(o instanceof PointObject) || !((MoveableObject)((Object)o)).moveable() || !o.nearto(x, y, this)) continue;
            this.V.addElement(o);
        }
        if (this.V.size() == 0) {
            return null;
        }
        return (ConstructionObject)this.V.elementAt(0);
    }

    public ConstructionObject selectMoveableObject(int x, int y) {
        ConstructionObject s = this.findSelectedObject();
        if (s instanceof MoveableObject && ((MoveableObject)((Object)s)).moveable() && s.nearto(x, y, this)) {
            return s;
        }
        this.selectMoveableObjects(x, y);
        if (this.V.size() == 1) {
            return (ConstructionObject)this.V.elementAt(0);
        }
        ConstructionObject o = this.select(this.V);
        if (o != null) {
            if (!Global.getParameter("options.choice", true)) {
                return o;
            }
            o.setSelected(true);
        }
        return null;
    }

    public void selectMoveableObjects(int x, int y, boolean control) {
        this.V.removeAllElements();
        ConstructionObject s = this.findSelectedObject();
        if (s instanceof MoveableObject && ((MoveableObject)((Object)s)).moveable() && s.nearto(x, y, this)) {
            this.V.addElement(s);
            return;
        }
        if (control && s instanceof FixedCircleObject && s.nearto(x, y, this) && ((FixedCircleObject)s).fixedByNumber()) {
            this.V.addElement(s);
            return;
        }
        if (control && s instanceof FixedAngleObject && s.nearto(x, y, this) && ((FixedAngleObject)s).fixedByNumber()) {
            this.V.addElement(s);
            return;
        }
        Enumeration e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!control && o.isSelectable() && o instanceof MoveableObject && ((MoveableObject)((Object)o)).moveable() && o.nearto(x, y, this)) {
                this.V.addElement(o);
                continue;
            }
            if (control && o instanceof FixedCircleObject && o.nearto(x, y, this) && ((FixedCircleObject)o).fixedByNumber()) {
                this.V.addElement(o);
                continue;
            }
            if (!control || !(o instanceof FixedAngleObject) || !o.nearto(x, y, this) || !((FixedAngleObject)o).fixedByNumber()) continue;
            this.V.addElement(o);
        }
        this.filter(this.V, x, y);
    }

    public void selectMoveableObjects(int x, int y) {
        this.selectMoveableObjects(x, y, false);
    }

    public ConstructionObject selectImmediateMoveableObject(int x, int y) {
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isSelectable() || !(o instanceof MoveableObject) || !((MoveableObject)((Object)o)).moveable() || !o.nearto(x, y, this)) continue;
            this.V.addElement(o);
        }
        this.filter(this.V, x, y);
        if (this.V.size() == 0) {
            return null;
        }
        return (ConstructionObject)this.V.elementAt(0);
    }

    public void filter(MyVector v, int x, int y, boolean choice) {
        ConstructionObject o;
        boolean HasPoints = false;
        boolean HasNotFilled = false;
        Enumeration e2 = v.elements();
        while (e2.hasMoreElements()) {
            o = (ConstructionObject)e2.nextElement();
            if (o instanceof PointObject) {
                HasPoints = true;
            }
            if (o.isFilledForSelect()) continue;
            HasNotFilled = true;
        }
        if (HasPoints) {
            e2 = v.elements();
            while (e2.hasMoreElements()) {
                o = (ConstructionObject)e2.nextElement();
                if (o.onlynearto(x, y, this)) continue;
                v.removeElement(o);
            }
        } else if (HasNotFilled) {
            e2 = v.elements();
            while (e2.hasMoreElements()) {
                o = (ConstructionObject)e2.nextElement();
                if (!o.isFilledForSelect()) continue;
                v.removeElement(o);
            }
        }
        this.sort(v);
        if (!choice) {
            v.truncate(1);
        }
    }

    public void filter(MyVector v, int x, int y) {
        this.filter(v, x, y, Global.getParameter("options.choice", true) || this.Control);
    }

    public ConstructionObject select(MyVector v, int x, int y, boolean choice) {
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            return (ConstructionObject)v.elementAt(0);
        }
        this.filter(v, x, y);
        if (v.size() == 1) {
            return (ConstructionObject)v.elementAt(0);
        }
        if (!choice) {
            return (ConstructionObject)v.elementAt(0);
        }
        this.sortRow(this.V);
        this.RightClicked = false;
        SelectDialog d2 = new SelectDialog(this.F, v);
        if (d2.isAborted()) {
            return null;
        }
        return d2.getObject();
    }

    public ConstructionObject select(MyVector v, int x, int y) {
        return this.select(v, x, y, Global.getParameter("options.choice", true) || this.Control);
    }

    public ConstructionObject select(MyVector v, boolean choice) {
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            return (ConstructionObject)v.elementAt(0);
        }
        if (!choice) {
            return (ConstructionObject)v.elementAt(0);
        }
        this.sortRow(this.V);
        this.RightClicked = false;
        SelectDialog d2 = new SelectDialog(this.F, v);
        if (d2.isAborted()) {
            return null;
        }
        return d2.getObject();
    }

    public ConstructionObject select(MyVector v) {
        return this.select(v, Global.getParameter("options.choice", true) || this.Control);
    }

    public ConstructionObject selectLabel(int x, int y) {
        Enumeration e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isSelectable() || !o.textcontains(x, y, this)) continue;
            return o;
        }
        return null;
    }

    public ConstructionObject findSelectedObject() {
        Enumeration e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.selected()) continue;
            return o;
        }
        return null;
    }

    public void indicate(MyVector v, boolean showname) {
        if (v.size() == 1) {
            if (showname) {
                this.setCursor(new Cursor(1));
            } else if (v.elementAt(0) instanceof PointObject) {
                this.setCursor(new Cursor(12));
            }
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.Indicated.equalsIdentical(v)) {
            return;
        }
        Enumeration e2 = this.Indicated.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).setIndicated(false);
        }
        this.Indicated.removeAllElements();
        e2 = v.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            this.Indicated.addElement(o);
            o.setIndicated(true, showname);
        }
        this.repaint();
    }

    public void indicate(MyVector v) {
        this.indicate(v, false);
    }

    public void clearIndicated() {
        this.IndicatePoint = null;
        if (this.Indicated.size() == 0) {
            return;
        }
        Enumeration e2 = this.Indicated.elements();
        while (e2.hasMoreElements()) {
            ((ConstructionObject)e2.nextElement()).setIndicated(false);
        }
        this.Indicated.removeAllElements();
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
    }

    public void movePreview(MouseEvent e2) {
        if (this.PreviewObject != null) {
            this.PreviewObject.move(this.x(e2.getX()), this.y(e2.getY()));
            this.validate();
            this.repaint();
        }
    }

    public void prepareForPreview(MouseEvent e2) {
        this.LastNonPreview = this.C.last();
        this.Preview = true;
    }

    public boolean isPreview() {
        return this.Preview;
    }

    public void clearPreview() {
        if (!this.Preview) {
            return;
        }
        this.C.clearAfter(this.LastNonPreview);
        this.LastNonPreview = null;
        this.PreviewObject = null;
        this.Preview = false;
        Count.fixAll(false);
    }

    public void setPreviewObject(MoveableObject o) {
        this.PreviewObject = o;
    }

    public ConstructionObject indicateTryCreateIntersection(int x, int y, boolean ask) {
        MyVector w = this.selectPointonObjects(x, y, true, true, false);
        this.sort(w);
        this.IntersectionYes = true;
        if (w.size() < 2) {
            return null;
        }
        IntersectionObject[] o = IntersectionConstructor.construct((ConstructionObject)w.elementAt(0), (ConstructionObject)w.elementAt(1), this.C);
        if (o.length == 1 && !o[0].valid()) {
            return null;
        }
        if (o.length == 2) {
            if (!o[1].valid()) {
                if (!o[0].valid()) {
                    return null;
                }
            } else {
                IntersectionObject h = o[0];
                o[0] = o[1];
                o[1] = h;
            }
        }
        IntersectionObject oc = o[0];
        if (o.length == 2 && o[1].valid()) {
            double d0 = o[0].distanceTo(x, y, this);
            double d1 = o[1].distanceTo(x, y, this);
            if (d1 < d0) {
                oc = o[1];
            }
        }
        oc.setDefaults();
        oc.setIndicated(true);
        oc.setType(2);
        oc.setColorType(1);
        this.IndicatePoint = oc;
        this.indicate(w);
        oc.validate(this.x(x), this.y(y));
        return oc;
    }

    public void indicateCreatePoint(int x, int y, boolean multiple) {
        Enumeration e2 = this.C.elements();
        this.V.removeAllElements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isSelectable() && o instanceof PointObject && o.nearto(x, y, this) && (multiple || !o.selected())) {
                this.V.addElement(o);
            }
            this.sort(this.V);
        }
        if (this.V.size() > 0) {
            this.IndicatePoint = null;
            this.filter(this.V, x, y, false);
            this.indicate(this.V);
            return;
        }
        PointObject oc = (PointObject)this.indicateTryCreateIntersection(x, y, true);
        if (oc != null) {
            return;
        }
        MyVector w = this.selectPointonObjects(x, y, true, false, false);
        this.filter(w, x, y, true);
        if (w.size() >= 1) {
            if (!w.equalsIdentical(this.Indicated)) {
                oc = new PointObject(this.C, this.x(x), this.y(y), (ConstructionObject)w.elementAt(0));
                if (this.ShowGrid && !Global.getParameter("grid.leftsnap", false)) {
                    oc.snap(this);
                }
                oc.setUseAlpha(true);
                oc.validate();
                oc.setIndicated(true);
                oc.setType(2);
                oc.setColorType(1);
                this.IndicatePoint = oc;
                this.indicate(w);
            } else if (this.IndicatePoint != null) {
                this.IndicatePoint.setType(2);
                this.IndicatePoint.setColorType(1);
                this.IndicatePoint.move(this.x(x), this.y(y));
                this.IndicatePoint.project((ConstructionObject)w.elementAt(0));
                this.repaint();
            }
        } else {
            this.clearIndicated();
        }
    }

    public void indicateCircleLineObjects(int x, int y) {
        MyVector w = this.selectCircleLineObjects(x, y);
        this.filter(this.V, x, y);
        this.indicate(w);
    }

    public void indicatePointonObjects(int x, int y) {
        MyVector w = this.selectPointonObjects(x, y, true, false, false);
        this.filter(this.V, x, y);
        this.indicate(w);
    }

    public void indicateIntersectedObjects(int x, int y, boolean all) {
        MyVector w = this.selectPointonObjects(x, y, true, false, all);
        if (!w.equalsIdentical(this.Indicated) && w.size() >= 2) {
            IntersectionObject[] o = IntersectionConstructor.construct((ConstructionObject)w.elementAt(0), (ConstructionObject)w.elementAt(1), this.C);
            IntersectionObject oc = o[0];
            if (o.length == 2) {
                double d0 = o[0].distanceTo(x, y, this);
                double d1 = o[1].distanceTo(x, y, this);
                if (d1 < d0) {
                    oc = o[1];
                }
                oc.autoAway();
            }
            oc.validate();
            oc.setDefaults();
            oc.setIndicated(true);
            oc.setColorType(1);
            oc.setType(2);
            this.IndicatePoint = oc;
        } else {
            this.IndicatePoint = null;
        }
        this.indicate(w);
    }

    public void indicateLineObjects(int x, int y) {
        this.selectLineObjects(x, y, true);
        this.filter(this.V, x, y);
        this.indicate(this.V);
    }

    public void indicatePointObjects(int x, int y) {
        this.selectPointObjects(x, y, true);
        this.filter(this.V, x, y);
        this.indicate(this.V);
    }

    public void indicatePointObjects(int x, int y, ConstructionObject until) {
        this.selectPointObjects(x, y, true, until);
        this.filter(this.V, x, y);
        this.indicate(this.V);
    }

    public void indicatePointsOrLines(int x, int y) {
        this.selectPointsOrLines(x, y, true);
        this.filter(this.V, x, y);
        this.indicate(this.V);
    }

    public void indicateSegments(int x, int y) {
        this.selectSegments(x, y, true);
        this.filter(this.V, x, y);
        this.indicate(this.V);
    }

    public void indicateRays(int x, int y) {
        this.selectRays(x, y, true);
        this.filter(this.V, x, y);
        this.indicate(this.V);
    }

    public void indicateTwoPointLines(int x, int y) {
        this.selectTwoPointLines(x, y, true);
        this.filter(this.V, x, y);
        this.indicate(this.V);
    }

    public void indicateCircles(int x, int y) {
        this.selectCircles(x, y, true);
        this.filter(this.V, x, y);
        this.indicate(this.V);
    }

    public void indicateMoveableObjects(int x, int y, boolean control) {
        this.selectMoveableObjects(x, y, control);
        this.filter(this.V, x, y);
        this.indicate(this.V);
    }

    public void indicateMoveableObjects(int x, int y) {
        this.indicateMoveableObjects(x, y, false);
    }

    public void indicateWithSelector(int x, int y, Selector sel) {
        this.selectWithSelector(x, y, sel, false);
        this.filter(this.V, x, y);
        this.indicate(this.V);
    }

    public void indicateWithSelector(int x, int y, Selector sel, ConstructionObject until) {
        this.selectWithSelector(x, y, sel, until, false);
        this.filter(this.V, x, y);
        this.indicate(this.V);
    }

    public void indicateConstructableObjects(int x, int y) {
        this.selectConstructableObjects(x, y);
        this.filter(this.V, x, y);
        this.indicate(this.V);
    }

    public void indicateObjects(int x, int y, boolean showname) {
        this.selectObjects(x, y);
        this.filter(this.V, x, y);
        this.indicate(this.V, showname);
    }

    public void indicateObjects(int x, int y) {
        this.indicateObjects(x, y, false);
    }

    public void setTool(ObjectConstructor oc) {
        if (this.OC != null) {
            this.OC.invalidate(this);
        }
        this.OC = oc;
        this.OC.showStatus(this);
        this.clearIndicated();
        this.clearPreview();
    }

    public void setSuddenTool(ObjectConstructor oc) {
        this.OC = oc;
    }

    public void reset() {
        this.clearPreview();
        this.clearIndicated();
        this.OC.reset(this);
    }

    public void clearSelected() {
        Enumeration e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.setSelected(false);
        }
        this.repaint();
    }

    public synchronized void clear() {
        this.displayJob(false);
        if (this.OC != null) {
            this.OC.invalidate(this);
        }
        this.C.clear();
        this.recompute();
        this.setDefaultColor(0);
        this.setDefaultColorType(0);
        this.setDefaultType(2);
        this.setGrid();
        this.reloadCD();
    }

    public synchronized void back() {
        this.reset();
        ConstructionObject O = this.C.lastByNumber();
        if (O == null) {
            return;
        }
        if (O.isKeep()) {
            return;
        }
        this.delete(O);
        while ((O = this.C.lastByNumber()) != null && O.mustHide(this) && !O.isHideBreak() && !O.isKeep()) {
            this.delete(O);
        }
        this.validate();
    }

    public synchronized void undo() {
        this.reset();
        this.C.undo();
    }

    public void delete(ConstructionObject o) {
        if (this.C.last() == null) {
            return;
        }
        if (o.isKeep()) {
            return;
        }
        this.C.clearConstructables();
        o.setFlag(true);
        this.C.determineChildren();
        this.C.delete(false);
    }

    public void delete(Vector v) {
        if (this.C.last() == null) {
            return;
        }
        this.C.clearConstructables();
        Enumeration e2 = v.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (o.isKeep()) {
                return;
            }
            o.setFlag(true);
        }
        this.C.determineChildren();
        this.C.delete(false);
    }

    public boolean depends(ConstructionObject o, ConstructionObject on) {
        this.C.clearConstructables();
        on.setFlag(true);
        this.C.determineChildren();
        return o.isFlag();
    }

    public void addStatusListener(StatusListener sl) {
        this.SL = sl;
    }

    public void showStatus(String s) {
        if (this.SL != null) {
            this.SL.showStatus(s);
        }
    }

    public void showStatus() {
        if (this.OC != null) {
            this.OC.showStatus(this);
        }
    }

    public boolean showHidden() {
        return this.ShowHidden;
    }

    public void setDefaultColor(int c2) {
        this.C.DefaultColor = c2;
    }

    public int getDefaultColor() {
        return this.C.DefaultColor;
    }

    public void setDefaultType(int c2) {
        this.C.DefaultType = c2;
    }

    public int getDefaultType() {
        return this.C.DefaultType;
    }

    public void setPartial(boolean flag) {
        this.C.Partial = flag;
    }

    public boolean getPartial() {
        return this.C.Partial;
    }

    public void setRestricted(boolean flag) {
        this.C.Restricted = flag;
    }

    public boolean getRestricted() {
        return this.C.Restricted;
    }

    public void setPartialLines(boolean flag) {
        this.C.PartialLines = flag;
    }

    public boolean getPartialLines() {
        return this.C.PartialLines;
    }

    public void setVectors(boolean flag) {
        this.C.Vectors = flag;
    }

    public boolean getVectors() {
        return this.C.Vectors;
    }

    public void setLongNames(boolean flag) {
        this.C.LongNames = flag;
    }

    public boolean getLongNames() {
        return this.C.LongNames;
    }

    public void setLargeFont(boolean flag) {
        this.C.LargeFont = flag;
    }

    public boolean getLargeFont() {
        return this.C.LargeFont;
    }

    public void setBoldFont(boolean flag) {
        this.C.BoldFont = flag;
    }

    public boolean getBoldFont() {
        return this.C.BoldFont;
    }

    public void setObtuse(boolean flag) {
        this.C.Obtuse = flag;
    }

    public boolean getObtuse() {
        return this.C.Obtuse;
    }

    public void setSolid(boolean flag) {
        this.C.Solid = flag;
    }

    public boolean getSolid() {
        return this.C.Solid;
    }

    public void setShowNames(boolean flag) {
        this.C.ShowNames = flag;
    }

    public boolean getShowNames() {
        return this.C.ShowNames;
    }

    public void setShowValues(boolean flag) {
        this.C.ShowValues = flag;
    }

    public boolean getShowValues() {
        return this.C.ShowValues;
    }

    public void setDefaultColorType(int c2) {
        this.C.DefaultColorType = c2;
    }

    public int getDefaultColorType() {
        return this.C.DefaultColorType;
    }

    public void setShowHidden(boolean flag) {
        this.ShowHidden = flag;
        this.repaint();
    }

    public boolean getShowHidden() {
        return this.ShowHidden;
    }

    public void setHidden(boolean flag) {
        this.C.Hidden = flag;
    }

    public boolean hides(ConstructionObject o) {
        if (this.OC instanceof SetTargetsTool) {
            return !o.isFlag();
        }
        return false;
    }

    public void save(OutputStream o, boolean construction, boolean macros, boolean protectedmacros, Vector Macros, String Restrict) throws IOException {
        XmlWriter xml;
        boolean utf = Global.getParameter("options.utf", true);
        if (utf) {
            xml = new XmlWriter(new PrintWriter((Writer)new OutputStreamWriter(o, "UTF8"), true));
            xml.printEncoding(utf ? "utf-8" : "iso-8859-1");
        } else {
            xml = new XmlWriter(new PrintWriter((Writer)new OutputStreamWriter(o), true));
            xml.printXml();
        }
        xml.startTagNewLine("CaR", "version", Global.getParameter("program.version", "unknown"));
        if (macros) {
            Sorter.sort(Macros);
            Enumeration e2 = Macros.elements();
            while (e2.hasMoreElements()) {
                Macro m = ((MacroItem)e2.nextElement()).M;
                if (!protectedmacros && m.isProtected()) continue;
                m.saveMacro(xml);
            }
        }
        if (construction) {
            xml.startTagStart("Construction");
            if (this.isJob()) {
                xml.printArg("job", "true");
                xml.printArg("last", this.Last);
                int i = 1;
                Enumeration e3 = this.Targets.elements();
                while (e3.hasMoreElements()) {
                    xml.printArg("target" + i, (String)e3.nextElement());
                    ++i;
                }
            }
            xml.startTagEndNewLine();
            xml.startTagStart("Window");
            xml.printArg("x", "" + this.C.getX());
            xml.printArg("y", "" + this.C.getY());
            xml.printArg("w", "" + this.C.getW());
            if (this.ShowGrid) {
                xml.printArg("showgrid", "true");
            }
            xml.finishTagNewLine();
            if (this.ShowGrid) {
                xml.startTagStart("Grid");
                if (this.AxesOnly) {
                    xml.printArg("axesonly", "true");
                }
                xml.printArg("color", "" + this.GridColor);
                xml.printArg("thickness", "" + this.GridThickness);
                if (!this.GridLabels) {
                    xml.printArg("nolabels", "true");
                } else {
                    if (this.GridLarge) {
                        xml.printArg("large", "true");
                    }
                    if (this.GridBold) {
                        xml.printArg("bold", "true");
                    }
                }
                xml.finishTagNewLine();
            }
            if (this.getConstruction().BackgroundFile != null && !this.getConstruction().BackgroundFile.equals("")) {
                xml.startTagStart("Background");
                xml.printArg("file", this.getConstruction().BackgroundFile);
                if (this.getConstruction().ResizeBackground) {
                    xml.printArg("resize", "true");
                }
                xml.finishTagNewLine();
            }
            if (!this.C.getComment().equals("")) {
                xml.startTagNewLine("Comment");
                xml.printParagraphs(this.C.getComment(), 60);
                xml.endTagNewLine("Comment");
            }
            if (!this.C.getJobComment().equals("")) {
                xml.startTagNewLine("Assignment");
                xml.printParagraphs(this.C.getJobComment(), 60);
                xml.endTagNewLine("Assignment");
            }
            if (!Restrict.equals("")) {
                xml.finishTag("Restrict", "icons", Restrict);
            }
            if (this.OC instanceof ObjectTracker) {
                ((ObjectTracker)this.OC).save(xml);
            } else if (this.OC instanceof Tracker) {
                ((Tracker)this.OC).save(xml);
            } else if (this.OC instanceof AnimatorTool) {
                ((AnimatorTool)this.OC).save(xml);
            } else if (this.OC instanceof BreakpointAnimator) {
                ((BreakpointAnimator)this.OC).save(xml);
            }
            this.saveDrawings(xml);
            xml.startTagNewLine("Objects");
            this.C.save(xml);
            xml.endTagNewLine("Objects");
            xml.endTagNewLine("Construction");
        }
        xml.endTagNewLine("CaR");
    }

    public void load(InputStream in, boolean construction, boolean macros) throws Exception {
        if (construction) {
            this.C.clear();
            this.All = false;
            this.paint(this.getGraphics());
        } else {
            this.All = true;
        }
        XmlReader xml = new XmlReader();
        xml.init(in);
        XmlTree tree = xml.scan();
        if (tree == null) {
            throw new ConstructionException("XML file not recognized");
        }
        Enumeration e2 = tree.getContent();
        while (e2.hasMoreElements()) {
            tree = (XmlTree)e2.nextElement();
            if (tree.getTag() instanceof XmlTagPI) continue;
            if (tree.getTag().name().equals("CaR")) break;
            throw new ConstructionException("CaR tag not found");
        }
        e2 = tree.getContent();
        boolean all = false;
        while (e2.hasMoreElements()) {
            tree = (XmlTree)e2.nextElement();
            XmlTag tag = tree.getTag();
            if (tag.name().equals("Macro")) {
                if (!macros) continue;
                try {
                    Count.setAllAlternate(true);
                    Macro m = new Macro(this, tree);
                    int i = 0;
                    i = 0;
                    while (i < this.Macros.size()) {
                        if (((MacroItem)this.Macros.elementAt((int)i)).M.getName().equals(m.getName())) {
                            all = this.replaceMacro(m, i, all);
                            break;
                        }
                        ++i;
                    }
                    if (i >= this.Macros.size()) {
                        this.appendMacro(m);
                    }
                }
                catch (ConstructionException ex) {
                    Count.setAllAlternate(false);
                    throw ex;
                }
                Count.setAllAlternate(false);
                continue;
            }
            if (tag.name().equals("Construction")) {
                if (!construction) continue;
                boolean job = false;
                if (tag.hasParam("job")) {
                    job = true;
                    this.Last = tag.getValue("last");
                    if (this.Last == null) {
                        throw new ConstructionException(Zirkel.name("exception.job"));
                    }
                    String Target = tag.getValue("target");
                    if (Target == null) {
                        this.Targets = new Vector();
                        int i = 1;
                        while (true) {
                            String s = tag.getValue("target" + i);
                            ++i;
                            if (s != null) {
                                this.Targets.addElement(s);
                                continue;
                            }
                            break;
                        }
                    } else {
                        this.Targets = new Vector();
                        this.Targets.addElement(Target);
                    }
                    if (this.Targets.size() == 0) {
                        throw new ConstructionException(Zirkel.name("exception.job"));
                    }
                }
                this.C.load(tree, this);
                if (!job) break;
                if (this.C.find(this.Last) == null) {
                    throw new ConstructionException(Zirkel.name("exception.job"));
                }
                Enumeration et = this.Targets.elements();
                while (et.hasMoreElements()) {
                    String s = (String)et.nextElement();
                    if (this.C.find(s) != null || s.startsWith("~") && this.C.find(s.substring(1)) != null) continue;
                    throw new ConstructionException(Zirkel.name("exception.job"));
                }
                this.Job = true;
                break;
            }
            throw new ConstructionException("Construction not found");
        }
        this.recompute();
        this.C.translateOffsets(this);
        this.resetSum();
        this.validate();
        this.repaint();
        this.reloadCD();
        this.repaint();
    }

    public void resetSum() {
        Enumeration e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof ExpressionObject)) continue;
            ((ExpressionObject)o).reset();
        }
    }

    public void warning(String s, String help) {
        Warning w = new Warning(this.F, s, Zirkel.name("warning"), true, help);
        w.center(this.F);
        w.setVisible(true);
    }

    public void warning(String s) {
        this.warning(s, "");
    }

    public void load(InputStream in) throws Exception {
        try {
            this.C.Loading = true;
            this.load(in, true, true);
            this.C.Loading = false;
        }
        catch (Exception e2) {
            this.C.Loading = false;
            throw e2;
        }
    }

    public String getComment() {
        return this.C.getComment();
    }

    public void setComment(String s) {
        this.C.setComment(s);
    }

    public String getJobComment() {
        return this.C.getJobComment();
    }

    public void setJobComment(String s) {
        this.C.setJobComment(s);
    }

    public void setFrame(Frame f2) {
        this.F = f2;
    }

    public Frame getFrame() {
        return this.F;
    }

    public void magnify(double f2) {
        this.C.setXYW(this.C.getX(), this.C.getY(), this.C.getW() * f2);
        this.recompute();
        this.validate();
        this.repaint();
    }

    public void shift(double dx, double dy) {
        this.C.setXYW(this.C.getX() + dx * this.C.getW(), this.C.getY() + dy * this.C.getW(), this.C.getW());
        this.recompute();
        this.validate();
        this.repaint();
    }

    public void paintTrack(MyGraphics g) {
        if (!(this.OC instanceof TrackPainter)) {
            return;
        }
        ((TrackPainter)((Object)this.OC)).paint(g, this);
    }

    public void updateTexts(ConstructionObject o, String oldname) {
        this.C.updateTexts(o, oldname);
    }

    public Construction getConstruction() {
        return this.C;
    }

    public void setShowGrid(boolean flag) {
        this.ShowGrid = flag;
        this.repaint();
    }

    public void toggleShowGrid() {
        if (this.ShowGrid && !this.AxesOnly) {
            this.AxesOnly = true;
        } else if (this.ShowGrid) {
            this.ShowGrid = false;
        } else {
            this.AxesOnly = false;
            this.ShowGrid = true;
        }
        Global.setParameter("showgrid", this.ShowGrid);
        Global.setParameter("axesonly", this.AxesOnly);
        this.repaint();
    }

    public boolean showGrid() {
        return this.ShowGrid;
    }

    public void setJob(ConstructionObject last) {
        this.Job = true;
        this.Last = last.getName();
        this.Targets = new Vector();
    }

    public void addJobTarget(ConstructionObject target, boolean visible) {
        if (visible) {
            this.Targets.addElement("~" + target.getName());
        } else {
            this.Targets.addElement(target.getName());
        }
    }

    public void clearTargets() {
        this.Targets = new Vector();
    }

    public void clearJob() {
        this.Job = false;
    }

    public boolean isJob() {
        Enumeration e2 = this.Targets.elements();
        while (e2.hasMoreElements()) {
            String s = (String)e2.nextElement();
            if (this.C.find(s) != null || s.startsWith("~") && this.C.find(s.substring(1)) != null) continue;
            return false;
        }
        return this.Job && this.C.find(this.Last) != null && this.Targets.size() > 0;
    }

    public boolean inTargets(String s) {
        Enumeration e2 = this.Targets.elements();
        while (e2.hasMoreElements()) {
            if (!((String)e2.nextElement()).equals(s)) continue;
            return true;
        }
        return false;
    }

    public void displayJob(boolean flag) {
        this.clearSelected();
        if (!(this.OC instanceof SaveJob)) {
            this.OC.reset(this);
        }
        if (flag) {
            String s;
            ConstructionObject o;
            this.C.setOriginalOrder(true);
            if (this.displayJob() || !this.isJob()) {
                return;
            }
            Construction Cnew = new Construction();
            Cnew.setXYW(this.C.getX(), this.C.getY(), this.C.getW());
            Enumeration e2 = this.C.elements();
            while (e2.hasMoreElements()) {
                o = (ConstructionObject)e2.nextElement();
                o.setJobTarget(true, false);
                o.setJobTarget(false, false);
            }
            e2 = this.C.elements();
            while (e2.hasMoreElements()) {
                o = (ConstructionObject)e2.nextElement();
                Cnew.add(o);
                o.setKeep(true);
                if (this.inTargets(o.getName()) || this.inTargets("~" + o.getName())) {
                    o.setJobTarget(true, false);
                }
                if (o.getName().equals(this.Last)) break;
            }
            while (e2.hasMoreElements()) {
                o = (ConstructionObject)e2.nextElement();
                if (!this.inTargets(o.getName()) && !this.inTargets("~" + o.getName())) continue;
                Cnew.add(o);
                o.setKeep(true);
                o.setJobTarget(true, this.inTargets("~" + o.getName()));
            }
            int n = 0;
            e2 = this.Targets.elements();
            while (e2.hasMoreElements()) {
                s = (String)e2.nextElement();
                if (s.startsWith("~")) continue;
                ++n;
            }
            this.TargetO = new ConstructionObject[n];
            this.TargetS = new ConstructionObject[n];
            n = 0;
            e2 = this.Targets.elements();
            while (e2.hasMoreElements()) {
                s = (String)e2.nextElement();
                if (s.startsWith("~")) continue;
                this.TargetO[n] = Cnew.find(s);
                this.TargetS[n] = null;
                ++n;
            }
            this.COriginal = this.C;
            this.C = Cnew;
            this.C.addAddEventListener(this);
            this.C.setComment(this.COriginal.getJobComment());
            this.recompute();
            this.reloadCD();
            this.repaint();
        } else {
            if (!this.displayJob()) {
                return;
            }
            this.C.removeAddEventListener(this);
            this.C = this.COriginal;
            this.COriginal = null;
            Enumeration e3 = this.C.elements();
            while (e3.hasMoreElements()) {
                ConstructionObject o = (ConstructionObject)e3.nextElement();
                o.setKeep(false);
                o.setJobTarget(false, false);
            }
            this.C.setOriginalOrder(false);
            this.recompute();
            this.reloadCD();
            this.repaint();
        }
    }

    public void freeJob() {
        Enumeration e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.setKeep(false);
            o.setJobTarget(false, false);
            this.repaint();
        }
    }

    public boolean displayJob() {
        return this.COriginal != null;
    }

    public void setShowColor(int i) {
        this.ShowColor = i;
        this.repaint();
    }

    public int getShowColor() {
        return this.ShowColor;
    }

    public ObjectConstructor getOC() {
        return this.OC;
    }

    public Vector getMacros() {
        return this.Macros;
    }

    public boolean haveMacros() {
        return this.Macros.size() > 0;
    }

    public boolean haveNonprotectedMacros() {
        Enumeration e2 = this.Macros.elements();
        while (e2.hasMoreElements()) {
            MacroItem m = (MacroItem)e2.nextElement();
            if (m.M.isProtected()) continue;
            return true;
        }
        return false;
    }

    boolean defineMacro() {
        this.clearSelected();
        Vector P = this.C.getParameters();
        if (P.size() == 0) {
            this.warning(Zirkel.name("definemacro.noparams"));
            return false;
        }
        DefineMacro d2 = new DefineMacro(this.F, this);
        d2.center(this.getFrame());
        d2.setVisible(true);
        if (d2.isAborted() || d2.getName().equals("")) {
            return false;
        }
        Macro m = new Macro(this, d2.getName(), d2.getComment(), d2.getParams());
        try {
            this.defineMacro(this.C, m, d2.targetsOnly(), d2.invisible(), d2.getPromptFor(), d2.hideduplicates());
        }
        catch (ConstructionException e2) {
            this.warning(e2.getDescription());
            this.OC.reset(this);
            return false;
        }
        this.storeMacro(m, false);
        this.OC.reset(this);
        return true;
    }

    public Macro copyMacro(Macro m, String name, boolean[] fixed) {
        try {
            Macro macro = (Macro)m.clone();
            macro.Name = name;
            boolean[] f2 = new boolean[fixed.length];
            int i = 0;
            while (i < f2.length) {
                f2[i] = fixed[i];
                ++i;
            }
            macro.Fixed = f2;
            this.storeMacro(macro, true);
            return macro;
        }
        catch (Exception e2) {
            return m;
        }
    }

    public void defineMacro(Construction c2, Macro m, boolean targetsonly, boolean superhide, String[] prompt, boolean hideduplicates) throws ConstructionException {
        ConstructionObject o;
        Vector P = c2.getParameters();
        Vector T = c2.getTargets();
        c2.setTranslation(m);
        c2.clearTranslations();
        if (T.size() == 0) {
            c2.determineConstructables();
        } else {
            c2.clearConstructables();
            c2.setParameterAsConstructables();
            int i = 0;
            while (i < T.size()) {
                c2.determineConstructables((ConstructionObject)T.elementAt(i));
                ++i;
            }
        }
        Count.setAllAlternate(true);
        m.clearTranslators();
        Enumeration e2 = c2.elements();
        while (e2.hasMoreElements()) {
            o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof TwoPointLineObject) || !this.canConvert(c2, (TwoPointLineObject)o) || !o.isMainParameter()) continue;
            ((TwoPointLineObject)o).getP1().setFlag(false);
            ((TwoPointLineObject)o).getP2().setFlag(false);
        }
        e2 = c2.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o2 = (ConstructionObject)e2.nextElement();
            if (o2.isFlag() && (!o2.isParameter() || o2.isMainParameter() || this.needed(c2, o2, null))) {
                ConstructionObject fo;
                ConstructionObject oc;
                if (o2 instanceof PointObject && o2.isParameter()) {
                    PointObject p = (PointObject)o2;
                    oc = p.isSpecialParameter() && p.dependsOnParametersOnly() ? p.copy() : new PointObject(c2, p.getX(), p.getY());
                } else if (o2 instanceof FunctionObject && o2.isParameter()) {
                    fo = new FunctionObject(c2);
                    ((FunctionObject)fo).setExpressions("x", "0", "0");
                    ((FunctionObject)fo).setRange("-10", "10", "0.1");
                    oc = fo;
                } else if (o2 instanceof UserFunctionObject && o2.isParameter()) {
                    fo = new UserFunctionObject(c2);
                    ((UserFunctionObject)fo).setExpressions("x", "0");
                    oc = fo;
                } else if (o2 instanceof ExpressionObject && o2.isParameter()) {
                    oc = new ExpressionObject(c2, 0.0, 0.0);
                    ((ExpressionObject)oc).setExpression(String.valueOf(o2.getValue()), o2.getConstruction());
                    ((ExpressionObject)oc).setCurrentValue(o2.getValue());
                } else if (o2 instanceof TwoPointLineObject && this.canConvert(c2, (TwoPointLineObject)o2) && o2.isParameter()) {
                    oc = new PrimitiveLineObject(c2);
                } else if (o2 instanceof PrimitiveLineObject && !(o2 instanceof TwoPointLineObject) && !(o2 instanceof FixedAngleObject) && o2.isParameter()) {
                    oc = new PrimitiveLineObject(c2);
                } else if (o2 instanceof PrimitiveCircleObject && o2.isParameter()) {
                    oc = new PrimitiveCircleObject(c2, ((PrimitiveCircleObject)o2).getP1());
                    oc.translateConditionals();
                    oc.translate();
                } else if (o2 instanceof AreaObject && o2.isParameter()) {
                    oc = new AreaObject(c2, new Vector());
                    oc.translateConditionals();
                    oc.translate();
                } else {
                    oc = o2.copy();
                }
                if (oc == null) continue;
                m.add(oc);
                if (o2.isMainParameter()) {
                    oc.setName(o2.getName());
                }
                if (targetsonly && !o2.isTarget() && !o2.isParameter()) {
                    if (superhide) {
                        oc.setSuperHidden(true);
                    } else {
                        oc.setHidden(true);
                    }
                }
                if (o2.isParameter() && o2.isHidden()) {
                    oc.setHidden(true);
                }
                o2.setTranslation(oc);
                continue;
            }
            o2.setTranslation(null);
        }
        e2 = c2.elements();
        while (e2.hasMoreElements()) {
            o = (ConstructionObject)e2.nextElement();
            if (!o.isFlag() || o.isParameter()) continue;
            o.laterTranslate(c2);
        }
        Count.setAllAlternate(false);
        c2.clearErrors();
        m.runTranslators(c2);
        e2 = c2.getErrors();
        if (e2.hasMoreElements()) {
            this.warning((String)e2.nextElement(), "macroerror");
        }
        ConstructionObject[] Params = new ConstructionObject[P.size()];
        int i = 0;
        while (i < P.size()) {
            Params[i] = ((ConstructionObject)P.elementAt(i)).getTranslation();
            ++i;
        }
        m.setParams(Params);
        String[] p = new String[prompt.length];
        int j = 0;
        while (j < prompt.length) {
            ConstructionObject o3 = c2.find(prompt[j]);
            if (o3 == null || o3.getTranslation() == null || !(o3 instanceof FixedCircleObject) && !(o3 instanceof FixedAngleObject) && !(o3 instanceof ExpressionObject)) {
                throw new ConstructionException(Zirkel.name("exception.prompt"));
            }
            int i2 = 0;
            while (i2 < P.size()) {
                ConstructionObject op = (ConstructionObject)P.elementAt(i2);
                if (op == o3) {
                    throw new ConstructionException(Zirkel.name("exception.prompt.parameter"));
                }
                ++i2;
            }
            p[j] = o3.getTranslation().getName();
            ++j;
        }
        m.setPromptFor(p);
        int i3 = 0;
        while (i3 < prompt.length) {
            m.setPromptName(i3, prompt[i3]);
            ++i3;
        }
        m.hideDuplicates(hideduplicates);
    }

    public boolean needed(Construction c2, ConstructionObject o, ConstructionObject besides) {
        Enumeration e2 = c2.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject u = (ConstructionObject)e2.nextElement();
            if (!u.isFlag() || u == besides || !c2.dependsDirectlyOn(u, o)) continue;
            return true;
        }
        return false;
    }

    public boolean canConvert(Construction c2, TwoPointLineObject o) {
        PointObject p1 = o.getP1();
        PointObject p2 = o.getP2();
        if (p1.isMainParameter() || p2.isMainParameter()) {
            return false;
        }
        return !this.needed(c2, p1, o) && !this.needed(c2, p2, o);
    }

    public void defineMacro(String name, String comment, Construction c2) throws ConstructionException {
        Vector T = c2.getTargets();
        String[] Prompts = new String[c2.Prompts.size()];
        int i = 0;
        while (i < Prompts.length) {
            Prompts[i] = (String)c2.Prompts.elementAt(i);
            ++i;
        }
        Macro m = new Macro(this, name, comment, Prompts);
        this.defineMacro(c2, m, T.size() > 0 && !c2.ShowAll, c2.SuperHide, c2.getPromptFor(), true);
        this.storeMacro(m, true);
    }

    public void storeMacro(Macro m, boolean all) {
        int i = 0;
        i = 0;
        while (i < this.Macros.size()) {
            if (((MacroItem)this.Macros.elementAt((int)i)).M.getName().equals(m.getName())) {
                this.All = this.replaceMacro(m, i, all);
                break;
            }
            ++i;
        }
        if (i >= this.Macros.size()) {
            this.appendMacro(m);
        }
    }

    public void appendMacro(Macro m) {
        if (!this.ReadOnly) {
            if (this.ProtectMacros) {
                m.setProtected(true);
            }
            if (this.MM == null) {
                this.MM = new MacroMenu(this.PM, "", null);
            }
            MacroItem mi = this.MM.add(m, m.getName());
            mi.I.addActionListener(this);
            this.Macros.addElement(mi);
        } else {
            if (this.MM == null) {
                this.MM = new MacroMenu(null, "", null);
            }
            MacroItem mi = this.MM.add(m, m.getName());
            if (mi.I != null) {
                mi.I.addActionListener(this);
            }
            this.Macros.addElement(mi);
        }
    }

    public boolean replaceMacro(Macro m, int i, boolean all) {
        MacroItem e2 = (MacroItem)this.Macros.elementAt(i);
        if (all) {
            this.Macros.setElementAt(new MacroItem(m, e2.I), i);
            return true;
        }
        ReplaceMacroQuestion d2 = new ReplaceMacroQuestion(this.getFrame(), m);
        d2.center(this.getFrame());
        d2.setVisible(true);
        if (d2.isNo()) {
            return false;
        }
        MacroItem newitem = new MacroItem(m, e2.I);
        this.MM.replace((MacroItem)this.Macros.elementAt(i), newitem);
        this.Macros.setElementAt(newitem, i);
        return d2.isAll();
    }

    public Macro chooseMacro() {
        if (this.Macros.size() == 0) {
            this.warning(Zirkel.name("definemacro.nomacro"));
            return null;
        }
        MacroSelectDialog d2 = new MacroSelectDialog(this.getFrame(), this.MM, false);
        d2.setVisible(true);
        return d2.getMacro();
    }

    public Vector chooseMacros() {
        if (this.Macros.size() == 0) {
            this.warning(Zirkel.name("definemacro.nomacro"));
            return null;
        }
        MacroSelectDialog d2 = new MacroSelectDialog(this.getFrame(), this.MM, true);
        d2.setVisible(true);
        return d2.getMacros();
    }

    public Macro chooseMacro(String name) {
        Enumeration e2 = this.Macros.elements();
        while (e2.hasMoreElements()) {
            Macro m = ((MacroItem)e2.nextElement()).M;
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public void deleteMacros(Vector v) {
        Enumeration e2 = v.elements();
        while (e2.hasMoreElements()) {
            MacroItem m = (MacroItem)e2.nextElement();
            this.deleteMacro(m);
        }
    }

    public void deleteMacro(MacroItem m) {
        this.Macros.removeElement(m);
        if (m.I != null) {
            m.I.removeActionListener(this);
            this.MM.remove(m);
        }
    }

    public void clearMacros() {
        Enumeration e2 = this.Macros.elements();
        while (e2.hasMoreElements()) {
            MacroItem m = (MacroItem)e2.nextElement();
            if (m.I == null) continue;
            m.I.removeActionListener(this);
            this.MM.remove(m);
        }
        this.Macros.removeAllElements();
    }

    public void clearNonprotectedMacros() {
        Vector<MacroItem> V = new Vector<MacroItem>();
        Enumeration e2 = this.Macros.elements();
        while (e2.hasMoreElements()) {
            MacroItem m = (MacroItem)e2.nextElement();
            if (m.M.isProtected()) continue;
            V.addElement(m);
        }
        this.deleteMacros(V);
    }

    public void clearProtectedMacros() {
        Vector<MacroItem> V = new Vector<MacroItem>();
        Enumeration e2 = this.Macros.elements();
        while (e2.hasMoreElements()) {
            MacroItem m = (MacroItem)e2.nextElement();
            if (!m.M.isProtected()) continue;
            V.addElement(m);
        }
        this.deleteMacros(V);
    }

    public void protectMacros() {
        Enumeration e2 = this.Macros.elements();
        while (e2.hasMoreElements()) {
            MacroItem m = (MacroItem)e2.nextElement();
            m.M.setProtected(true);
        }
    }

    public void renameMacro(Macro macro, String name) {
        Enumeration e2 = this.Macros.elements();
        while (e2.hasMoreElements()) {
            MacroItem m = (MacroItem)e2.nextElement();
            if (m.I == null || m.M != macro) continue;
            this.deleteMacro(m);
            break;
        }
        macro.setName(name);
        this.appendMacro(macro);
    }

    public void setMacroBar(MacroBar m) {
        this.MBar = m;
    }

    public void updateMacroBar() {
        if (this.MBar != null) {
            this.MBar.update(this.Macros);
        }
    }

    public void setTextField(TextField t) {
        this.TF = t;
    }

    public void setPrompt(String s) {
        if (this.TF != null) {
            this.TF.setText(s);
        }
    }

    public void loadRun(InputStream is) {
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        String s = "";
        String comment = "";
        try {
            while ((s = in.readLine()) != null) {
                int n = s.indexOf("//");
                if (n >= 0) {
                    comment = s.substring(n + 2).trim();
                    s = s.substring(0, n);
                } else {
                    comment = "";
                }
                s = s.trim();
                int k = 0;
                k = Interpreter.startTest("macro", s);
                if (k >= 0) {
                    this.loadMacro(in, s.substring(k).trim());
                    continue;
                }
                if (s.equals("")) continue;
                this.C.interpret(this, s, comment);
            }
        }
        catch (ConstructionException e2) {
            this.warning(String.valueOf(e2.getDescription()) + " --- " + s);
        }
        catch (Exception e3) {
            this.warning(String.valueOf(e3.toString()) + " --- " + s);
            e3.printStackTrace();
        }
        this.C.updateCircleDep();
    }

    public void loadMacro(BufferedReader in, String name) throws ConstructionException {
        Construction c2 = new Construction();
        c2.clear();
        String s = "";
        String comment = "";
        String macrocomment = "";
        boolean inComment = true;
        boolean newLine = true;
        block4: while (true) {
            try {
                while (true) {
                    if ((s = in.readLine()) == null) {
                        throw new ConstructionException(Zirkel.name("exception.macroend"));
                    }
                    s = s.trim();
                    int n = s.indexOf("//");
                    if (inComment && n == 0) {
                        String h = s.substring(n + 2).trim();
                        if (newLine) {
                            macrocomment = String.valueOf(macrocomment) + h;
                            newLine = false;
                            continue;
                        }
                        if (h.equals("")) {
                            macrocomment = String.valueOf(macrocomment) + "\n";
                            newLine = true;
                            continue;
                        }
                        macrocomment = String.valueOf(macrocomment) + " " + h;
                        newLine = false;
                        continue;
                    }
                    inComment = false;
                    if (n >= 0) {
                        comment = s.substring(n + 2).trim();
                        s = s.substring(0, n);
                    } else {
                        comment = "";
                    }
                    s = s.trim();
                    if (s.equals(Zirkel.name("end")) || s.toLowerCase().equals("end")) break block4;
                    if (s.equals("")) continue;
                    c2.interpret(this, s, comment);
                }
            }
            catch (InvalidException n) {
                continue;
            }
            catch (ConstructionException e2) {
                throw new ConstructionException(String.valueOf(e2.getDescription()) + " --- " + s);
            }
            catch (IOException e3) {
                this.warning(e3.toString());
                return;
            }
            break;
        }
        this.defineMacro(name, macrocomment, c2);
    }

    public double getGridSize() {
        double gridsize = Math.pow(10.0, Math.floor(Math.log(this.C.getW() * 2.0) / Math.log(10.0))) / 10.0;
        if (this.C.getW() * 2.0 / gridsize >= 30.0) {
            gridsize *= 5.0;
        }
        if (this.C.getW() * 2.0 / gridsize < 10.0) {
            gridsize /= 2.0;
        }
        return gridsize;
    }

    public synchronized void print(Graphics g, int W, int H) {
        if (this.IW == 0 || this.I == null) {
            return;
        }
        this.startWaiting();
        int w = this.IW;
        int h = this.IH;
        this.Scale = (double)W / (double)w;
        this.PointSize *= this.Scale;
        double fontsize = this.FontSize * this.Scale;
        MyGraphics11 mg = new MyGraphics11(g);
        mg.setSize(w, h);
        ((MyGraphics)mg).setDefaultFont((int)fontsize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
        this.IW = W;
        this.IH = H;
        this.recompute();
        if (this.Background != null) {
            int bw = this.Background.getWidth(this);
            int bh = this.Background.getHeight(this);
            if (bw == this.IW && bh == this.IH) {
                ((MyGraphics)mg).drawImage(this.Background, 0, 0, this);
            } else if (Global.getParameter("background.tile", true) && bw < this.IW && bh < this.IH) {
                int i = this.IW % bw / 2 - bw;
                while (i < this.IW) {
                    int j = this.IH % bh / 2 - bh;
                    while (j < this.IH) {
                        ((MyGraphics)mg).drawImage(this.Background, i, j, this);
                        j += bh;
                    }
                    i += bw;
                }
            } else if (Global.getParameter("background.center", true)) {
                ((MyGraphics)mg).drawImage(this.Background, (this.IW - bw) / 2, (this.IH - bh) / 2, this);
            } else {
                ((MyGraphics)mg).drawImage(this.Background, 0, 0, this.IW, this.IH, this);
            }
        }
        this.dopaint(mg);
        this.Interactive = true;
        this.Scale = 1.0;
        this.I = null;
        this.endWaiting();
        this.repaint();
    }

    public LatexOutput createBB(String filename, int w, int h, double dpi) {
        try {
            String path = "";
            if (Global.getParameter("options.fullpath", true)) {
                path = FileName.pathAndSeparator(filename);
            }
            PrintWriter out = new PrintWriter(new FileOutputStream(String.valueOf(path) + FileName.purefilename(filename) + ".bb"));
            out.println("%%BoundingBox: 0 0 " + w + " " + h);
            out.close();
            out = new PrintWriter(new FileOutputStream(String.valueOf(path) + FileName.purefilename(filename) + ".ztx"));
            LatexOutput lout = new LatexOutput(out);
            lout.open(w, h, dpi, String.valueOf(path) + FileName.filename(filename));
            return lout;
        }
        catch (Exception e2) {
            this.warning(e2.toString());
            return null;
        }
    }

    public synchronized boolean savePNG(String filename, boolean latex) {
        LatexOutput lout = null;
        if (this.IW == 0 || this.I == null) {
            return false;
        }
        if (Global.getParameter("printscale.middle", true)) {
            this.savePreviewAsPNG(filename);
            return true;
        }
        double dpi = Global.getParameter("printscale.dpi", 300);
        if (!Global.getParameter("printscale.sizes", false)) {
            int w = Global.getParameter("printscale.w", this.IW);
            int h = Global.getParameter("printscale.h", this.IH);
            if (latex) {
                lout = this.createBB(filename, w, h, dpi);
            }
            int IWold = this.IW;
            this.IW = w;
            this.IH = h;
            this.Scale = (double)this.IW / (double)IWold;
            this.I = this.createImage(this.IW, this.IH);
            if (!Global.getParameter("simplegraphics", false)) {
                this.IG = new MyGraphics13(this.I.getGraphics(), this.Scale, this, lout);
                this.IG.setSize(w, h);
            } else {
                this.IG = new MyGraphics11(this.I.getGraphics());
                this.IG.setSize(w, h);
            }
            double pointsize = this.PointSize * this.Scale;
            double fontsize = this.FontSize * this.Scale;
            if (this.Scale < 1.0) {
                if (Global.getParameter("options.minpointsize", false) && pointsize < this.MinPointSize) {
                    pointsize = this.MinPointSize;
                }
                if (Global.getParameter("options.minfontsize", false) && fontsize < this.MinFontSize) {
                    fontsize = this.MinFontSize;
                }
            }
            this.IG.setDefaultFont((int)fontsize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            this.PointSize = pointsize;
        } else {
            int IWOld = this.IW;
            dpi = Global.getParameter("printscale.dpi", 300.0);
            this.IW = (int)(Global.getParameter("printscale.width", 5.0) / 2.54 * dpi);
            this.IH = (int)(Global.getParameter("printscale.height", 5.0) / 2.54 * dpi);
            if (latex) {
                lout = this.createBB(filename, this.IW, this.IH, dpi);
            }
            this.I = this.createImage(this.IW, this.IH);
            if (!Global.getParameter("simplegraphics", false)) {
                this.IG = new MyGraphics13(this.I.getGraphics(), Global.getParameter("printscale.linewidth", 0.02) / 2.54 * dpi, this, lout);
                this.IG.setSize(this.IW, this.IH);
            } else {
                this.IG = new MyGraphics11(this.I.getGraphics());
                this.IG.setSize(this.IW, this.IH);
            }
            this.PointSize = Global.getParameter("printscale.pointsize", 0.07) / 2.54 * dpi;
            this.IG.setDefaultFont((int)(Global.getParameter("printscale.textsize", 0.3) / 2.54 * dpi), Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            this.Scale = (double)this.IW / (double)IWOld;
        }
        this.recompute();
        if (Global.getParameter("options.bitmapbackground", false)) {
            this.IG.clearRect(0, 0, this.IW, this.IH, this.getBackground());
        } else {
            this.IG.clearRect(0, 0, this.IW, this.IH, Color.white);
        }
        if (this.Background != null) {
            int bw = this.Background.getWidth(this);
            int bh = this.Background.getHeight(this);
            if (bw == this.IW && bh == this.IH) {
                this.IG.drawImage(this.Background, 0, 0, this);
            } else if (Global.getParameter("background.tile", true) && bw < this.IW && bh < this.IH) {
                int i = this.IW % bw / 2 - bw;
                while (i < this.IW) {
                    int j = this.IH % bh / 2 - bh;
                    while (j < this.IH) {
                        this.IG.drawImage(this.Background, i, j, this);
                        j += bh;
                    }
                    i += bw;
                }
            } else if (Global.getParameter("background.center", true)) {
                this.IG.drawImage(this.Background, (this.IW - bw) / 2, (this.IH - bh) / 2, this);
            } else {
                this.IG.drawImage(this.Background, 0, 0, this.IW, this.IH, this);
            }
        }
        this.dopaint(this.IG);
        if (lout != null) {
            lout.close();
        }
        this.Interactive = true;
        if (!filename.equals("")) {
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filename));
                PngEncoder png = new PngEncoder(this.I, false, 0, 9);
                png.setDPI(dpi);
                out.write(png.pngEncode());
                out.close();
            }
            catch (Exception e2) {
                this.warning(e2.toString());
            }
        } else {
            try {
                Clipboard clipboard = this.getToolkit().getSystemClipboard();
                ImageSelection is = new ImageSelection(this.I);
                clipboard.setContents(is, null);
            }
            catch (Exception e3) {
                this.Scale = 1.0;
                this.I = null;
                this.repaint();
                return false;
            }
        }
        this.Scale = 1.0;
        this.I = null;
        this.repaint();
        return true;
    }

    public void savePreviewAsPNG(String filename) {
        int PW = Global.getParameter("printscale.w", this.IW);
        int PH = Global.getParameter("printscale.h", this.IH);
        Image i = this.createImage(PW, PH);
        Graphics g = i.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, PW, PH);
        g.drawImage(this.I, -(this.IW - PW) / 2, -(this.IH - PH) / 2, this);
        if (!filename.equals("")) {
            try {
                FileOutputStream out = new FileOutputStream(filename);
                PngEncoder png = new PngEncoder(i, false, 0, 9);
                out.write(png.pngEncode());
                out.close();
            }
            catch (Exception e2) {
                this.warning(e2.toString());
            }
        } else {
            try {
                Clipboard clipboard = this.getToolkit().getSystemClipboard();
                ImageSelection is = new ImageSelection(this.I);
                clipboard.setContents(is, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void saveFIG(String filename) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(filename));
            MyGraphicsFig fig = new MyGraphicsFig(out, this.IW, this.IH);
            fig.setSize(this.IW, this.IH);
            this.dopaintFig(fig);
            fig.close();
            out.close();
        }
        catch (Exception e2) {
            this.warning(e2.toString());
            e2.printStackTrace();
        }
    }

    public void saveSVG(String filename) {
        try {
            OutputStream o = new FileOutputStream(filename);
            if (ZirkelFrame.isCompressed(filename)) {
                o = new GZIPOutputStream(o);
            }
            PrintWriter out = new PrintWriter(new OutputStreamWriter(o, "UTF8"));
            MyGraphicsSvg svg = new MyGraphicsSvg(out, this.IW, this.IH);
            svg.setSize(this.IW, this.IH);
            double fontsize = this.FontSize;
            svg.setDefaultFont((int)fontsize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            this.dopaint(svg);
            svg.close();
            out.close();
        }
        catch (Exception e2) {
            this.warning(e2.toString());
            e2.printStackTrace();
        }
    }

    public void savePDF(String filename) {
        PrintWriter out = null;
        try {
            OutputStream o = new FileOutputStream(filename);
            if (ZirkelFrame.isCompressed(filename)) {
                o = new GZIPOutputStream(o);
            }
            out = new PrintWriter(new OutputStreamWriter(o, "CP1252"));
        }
        catch (Exception e2) {
            this.warning(e2.toString());
            e2.printStackTrace();
        }
        int iw = this.IW;
        int ih = this.IH;
        this.IW = (int)((double)Global.getParameter("printscale.width", this.IW * 2) / 2.54 * 72.0 + 0.5);
        this.IH = (int)((double)Global.getParameter("printscale.height", this.IH * 2) / 2.54 * 72.0 + 0.5);
        double ps = this.PointSize;
        this.Scale = (double)this.IW / (double)iw;
        double pointsize = this.PointSize * this.Scale;
        double fontsize = this.FontSize * this.Scale + 1.0;
        double linewidth = this.Scale;
        if (Global.getParameter("printscale.sizes", false)) {
            pointsize = Global.getParameter("printscale.pointsize", 0.07) / 2.54 * 72.0;
            fontsize = Global.getParameter("printscale.fontsize", 0.3) / 2.54 * 72.0;
            linewidth = Global.getParameter("printscale.linewidth", 0.02) / 2.54 * 72.0;
        }
        this.PointSize = pointsize;
        this.recompute();
        MyGraphicsPDF pdf = new MyGraphicsPDF(out, this.IW, this.IH, linewidth);
        pdf.setSize(this.IW, this.IH);
        pdf.setDefaultFont((int)fontsize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
        try {
            this.dopaint(pdf);
            pdf.close();
            out.close();
        }
        catch (Exception e3) {
            this.warning(e3.toString());
            e3.printStackTrace();
        }
        this.IW = iw;
        this.IH = ih;
        this.Scale = 1.0;
        this.PointSize = ps;
        this.I = null;
        this.repaint();
    }

    public void saveEPS(String filename) {
        OutputStream o = null;
        try {
            o = new FileOutputStream(filename);
            if (ZirkelFrame.isCompressed(filename)) {
                o = new GZIPOutputStream(o);
            }
        }
        catch (Exception e2) {
            this.warning(e2.toString());
            e2.printStackTrace();
        }
        int iw = this.IW;
        int ih = this.IH;
        this.IW = (int)((double)Global.getParameter("printscale.width", this.IW * 2) / 2.54 * 72.0 + 0.5);
        this.IH = (int)((double)Global.getParameter("printscale.height", this.IH * 2) / 2.54 * 72.0 + 0.5);
        double ps = this.PointSize;
        this.Scale = (double)this.IW / (double)iw;
        double pointsize = this.PointSize * this.Scale;
        double fontsize = this.FontSize * this.Scale + 1.0;
        double linewidth = this.Scale;
        if (Global.getParameter("printscale.sizes", false)) {
            pointsize = Global.getParameter("printscale.pointsize", 0.07) / 2.54 * 72.0;
            fontsize = Global.getParameter("printscale.fontsize", 0.3) / 2.54 * 72.0;
            linewidth = Global.getParameter("printscale.linewidth", 0.02) / 2.54 * 72.0;
        }
        this.PointSize = pointsize;
        this.recompute();
        try {
            MyGraphicsEPS eps = new MyGraphicsEPS(o, this.IW, this.IH);
            eps.setSize(this.IW, this.IH);
            eps.setLineWidth(linewidth);
            eps.setDefaultFont((int)fontsize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            this.dopaint(eps);
            eps.close();
            o.close();
        }
        catch (Exception e3) {
            this.warning(e3.toString());
            e3.printStackTrace();
        }
        this.IW = iw;
        this.IH = ih;
        this.Scale = 1.0;
        this.PointSize = ps;
        this.I = null;
        this.repaint();
    }

    public void returnPressed() {
        if (this.OC instanceof MacroRunner) {
            ((MacroRunner)this.OC).returnPressed(this);
        }
    }

    public void bind(PointObject p) {
        this.setTool(new BinderTool(this, p, this.OC));
    }

    public void setAway(IntersectionObject p, boolean away) {
        this.setTool(new SetAwayTool(this, p, away, this.OC));
    }

    public void setCurveCenter(FunctionObject p) {
        this.setTool(new SetCurveCenterTool(this, p, this.OC));
    }

    public void range(PrimitiveCircleObject c2) {
        this.setTool(new SetRangeTool(this, c2, this.OC));
    }

    public void set(FixedAngleObject a2) {
        this.setTool(new SetFixedAngle(this, a2, this.OC));
    }

    public void set(FixedCircleObject c2) {
        this.setTool(new SetFixedCircle(this, c2, this.OC));
    }

    public boolean enabled(String function) {
        if (this.ZCI != null) {
            return this.ZCI.enabled(function);
        }
        return true;
    }

    public void pause(boolean flag) {
        this.OC.pause(flag);
    }

    public void setReadOnly(boolean flag) {
        this.ReadOnly = flag;
    }

    public void allowRightMouse(boolean flag) {
        this.AllowRightMouse = flag;
    }

    public boolean changed() {
        return this.C.changed();
    }

    public void grab(boolean flag) {
        if (flag) {
            this.OldBackground = this.Background;
            this.Background = this.createImage(this.IW, this.IH);
            Graphics G = this.Background.getGraphics();
            G.drawImage(this.I, 0, 0, this);
        } else {
            this.Background = this.OldBackground;
            this.OldBackground = null;
        }
        this.repaint();
    }

    public void setBackground(Image i) {
        this.Background = i;
        this.repaint();
    }

    public void setInteractive(boolean flag) {
        this.Interactive = flag;
    }

    public ObjectConstructor getCurrentTool() {
        return this.OC;
    }

    public synchronized void addDrawing(Drawing d2) {
        this.Drawings.addElement(d2);
    }

    public synchronized void clearDrawings() {
        this.Drawings.removeAllElements();
        this.repaint();
    }

    public synchronized void paintDrawings(MyGraphics g) {
        Enumeration e2 = this.Drawings.elements();
        while (e2.hasMoreElements()) {
            Drawing d2 = (Drawing)e2.nextElement();
            Enumeration ec = d2.elements();
            if (!ec.hasMoreElements()) continue;
            g.setColor(ZirkelFrame.Colors[d2.getColor()]);
            CoordinatesXY xy = (CoordinatesXY)ec.nextElement();
            int c2 = (int)this.col(xy.X);
            int r = (int)this.row(xy.Y);
            while (ec.hasMoreElements()) {
                xy = (CoordinatesXY)ec.nextElement();
                int c1 = (int)this.col(xy.X);
                int r1 = (int)this.row(xy.Y);
                g.drawLine(c2, r, c1, r1);
                c2 = c1;
                r = r1;
            }
        }
    }

    public void saveDrawings(XmlWriter xml) {
        Enumeration e2 = this.Drawings.elements();
        while (e2.hasMoreElements()) {
            Drawing d2 = (Drawing)e2.nextElement();
            Enumeration ec = d2.elements();
            if (!ec.hasMoreElements()) continue;
            xml.startTagNewLine("Draw", "color", "" + d2.getColor());
            while (ec.hasMoreElements()) {
                CoordinatesXY xy = (CoordinatesXY)ec.nextElement();
                xml.startTagStart("Point");
                xml.printArg("x", "" + xy.X);
                xml.printArg("y", "" + xy.Y);
                xml.finishTagNewLine();
            }
            xml.endTagNewLine("Draw");
        }
    }

    public void loadDrawings(XmlTree tree) throws ConstructionException {
        XmlTag tag = tree.getTag();
        if (!tag.name().equals("Draw")) {
            return;
        }
        Drawing d2 = new Drawing();
        try {
            if (tag.hasParam("color")) {
                d2.setColor(Integer.parseInt(tag.getValue("color")));
            }
        }
        catch (Exception e2) {
            throw new ConstructionException("Illegal Draw Parameter");
        }
        Enumeration e3 = tree.getContent();
        while (e3.hasMoreElements()) {
            XmlTree t = (XmlTree)e3.nextElement();
            tag = t.getTag();
            if (!tag.name().equals("Point")) continue;
            try {
                double x = new Double(tag.getValue("x"));
                double y = new Double(tag.getValue("y"));
                d2.addXY(x, y);
            }
            catch (Exception ex) {
                throw new ConstructionException("Illegal Draw Parameter");
            }
        }
        this.Drawings.addElement(d2);
    }

    public void renameABC(ConstructionObject o, boolean enforce, boolean reset) {
        if (!enforce) {
            if (o instanceof PointObject) {
                int i = 65;
                while (i <= 90) {
                    ConstructionObject h = this.C.find("" + (char)i);
                    if (h == null) {
                        o.setName("" + (char)i);
                        o.setShowName(true);
                        this.repaint();
                        break;
                    }
                    ++i;
                }
            } else if (o instanceof AngleObject || o instanceof FixedAngleObject) {
                int i = 97;
                while (i <= 122) {
                    ConstructionObject h = this.C.find("\\" + (char)i);
                    if (h == null) {
                        o.setName("\\" + (char)i);
                        o.setShowName(true);
                        this.repaint();
                        break;
                    }
                    ++i;
                }
            } else if (o instanceof PrimitiveLineObject) {
                int i = 97;
                while (i <= 122) {
                    ConstructionObject h = this.C.find("" + (char)i);
                    if (h == null) {
                        o.setName("" + (char)i);
                        o.setShowName(true);
                        this.repaint();
                        break;
                    }
                    ++i;
                }
            }
        } else {
            if (reset) {
                this.PointLast = 0;
                this.LineLast = 0;
                this.AngleLast = 0;
            }
            if (o instanceof PointObject) {
                String name = "" + (char)(65 + this.PointLast);
                ConstructionObject h = this.C.find(name);
                if (h != null && h != o) {
                    h.setName("***temp***");
                    String s = o.getName();
                    o.setName(name);
                    h.setName(s);
                } else {
                    o.setName(name);
                }
                ++this.PointLast;
            } else if (o instanceof AngleObject || o instanceof FixedAngleObject) {
                String name = "\\" + (char)(97 + this.AngleLast);
                ConstructionObject h = this.C.find(name);
                if (h != null && h != o) {
                    h.setName("***temp***");
                    String s = o.getName();
                    o.setName(name);
                    h.setName(s);
                } else {
                    o.setName(name);
                }
                ++this.AngleLast;
            } else if (o instanceof PrimitiveLineObject) {
                String name = "" + (char)(97 + this.LineLast);
                ConstructionObject h = this.C.find(name);
                if (h != null && h != o) {
                    h.setName("***temp***");
                    String s = o.getName();
                    o.setName(name);
                    h.setName(s);
                } else {
                    o.setName(name);
                }
                ++this.LineLast;
            }
        }
    }

    public void selectAllMoveableVisibleObjects() {
        Enumeration e2 = this.C.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!(o instanceof MoveableObject) || !((MoveableObject)((Object)o)).moveable() || o.mustHide(this)) continue;
            o.setStrongSelected(true);
        }
    }

    public void hideDuplicates(ConstructionObject from) {
        ConstructionObject o;
        Enumeration e2 = this.C.elements();
        if (from != null) {
            while (e2.hasMoreElements()) {
                o = (ConstructionObject)e2.nextElement();
                if (o == from) break;
            }
        }
        block1: while (e2.hasMoreElements()) {
            o = (ConstructionObject)e2.nextElement();
            if (o.mustHide(this) || o.isKeep()) continue;
            Enumeration ex = this.C.elements();
            while (ex.hasMoreElements()) {
                ConstructionObject o1 = (ConstructionObject)ex.nextElement();
                if (o1 == o) continue block1;
                if (o1.mustHide(this) || o1.isKeep() || !o.equals(o1)) continue;
                o.setHidden(true);
                continue block1;
            }
        }
    }

    public void hideDuplicates() {
        this.hideDuplicates(null);
    }

    public void createCurve() {
        FunctionObject f2 = new FunctionObject(this.C);
        f2.setDefaults();
        this.C.add(f2);
        f2.setExpressions("x", "x", "0");
        f2.edit(this);
        if (f2.EditAborted) {
            this.delete(f2);
        }
        this.repaint();
        this.reloadCD();
    }

    public void createFunction() {
        UserFunctionObject f2 = new UserFunctionObject(this.C);
        f2.setDefaults();
        f2.setShowName(true);
        f2.setShowValue(true);
        this.C.add(f2);
        f2.setExpressions("x", "0");
        f2.edit(this);
        if (f2.EditAborted) {
            this.delete(f2);
        }
        this.repaint();
        this.reloadCD();
    }

    public void editLast() {
        if (this.C.last() == null) {
            return;
        }
        this.C.last().edit(this);
    }

    public void breakpointLast(boolean flag, boolean hiding) {
        ConstructionObject o = this.C.last();
        if (o == null) {
            return;
        }
        if (hiding) {
            o.setHideBreak(flag);
        } else {
            o.setBreak(flag);
        }
    }

    public void notifyChanged() {
        if (!this.C.Loading) {
            this.reloadCD();
        }
    }

    public void startWaiting() {
        this.Interactive = false;
        this.showMessage(Zirkel.name("message.saving"));
    }

    public void endWaiting() {
        this.Interactive = true;
        this.hideMessage();
    }

    public void showMessage(String s) {
        this.hideMessage();
        this.MW = new MessageWindow(this.F, s);
        this.MW.setVisible(true);
    }

    public void hideMessage() {
        if (this.MW != null) {
            this.MW.setVisible(false);
            this.MW.dispose();
            this.MW = null;
        }
    }

    public void setHotEqn(String s) {
        if (this.HE == null) {
            this.HE = new sHotEqn(this);
        }
        this.HE.setEquation(s);
    }

    public int paintHotEqn(int c2, int r, Graphics g) {
        if (this.HE == null) {
            return 0;
        }
        return this.HE.paint(c2, r, g);
    }

    public void reloadCD() {
        if (this.CDP != null && this.C != null) {
            this.CDP.reload();
        }
    }

    public void repaintCD() {
        if (this.CDP != null && this.C != null) {
            this.CDP.updateDisplay();
        }
    }

    public void callCDAction(String action) {
        if (this.CDP != null && this.C != null) {
            this.CDP.doAction(action);
        }
    }

    public void callCDItem(String action, boolean flag) {
        if (this.CDP != null && this.C != null) {
            this.CDP.itemAction(action, flag);
        }
    }

    public void callCDToggleItem(String action) {
        if (this.CDP != null && this.C != null) {
            this.CDP.itemToggleAction(action);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e2) {
        if (Global.getParameter("options.nomousezoom", false)) {
            return;
        }
        if (e2.getScrollType() == 1) {
            if (e2.getWheelRotation() < 0) {
                this.magnify(1.0 / Math.sqrt(Math.sqrt(2.0)));
            } else {
                this.magnify(Math.sqrt(Math.sqrt(2.0)));
            }
        } else {
            int n = e2.getScrollAmount();
            if (e2.getWheelRotation() < 0) {
                this.magnify(1.0 / Math.pow(2.0, (double)n / 12.0));
            } else {
                this.magnify(Math.pow(2.0, (double)n / 12.0));
            }
        }
    }

    public void replace(ConstructionObject o, ConstructionObject by) {
        this.C.replace(o, by);
    }
}

