/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.InputStream;
import rene.gui.Global;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;

class LogoWindow
extends Window
implements Runnable {
    ZirkelFrame ZF;
    Image I;

    public LogoWindow(ZirkelFrame zf) {
        super(zf);
        this.setSize(400, 300);
        Dimension d2 = this.getSize();
        String name = "zirkelframe";
        int x = Global.getParameter(String.valueOf(name) + ".x", 100);
        int y = Global.getParameter(String.valueOf(name) + ".y", 100);
        int w = Global.getParameter(String.valueOf(name) + ".w", 600);
        int h = Global.getParameter(String.valueOf(name) + ".h", 600);
        this.setLocation(x + w / 2 - d2.width / 2, y + h / 2 - d2.height / 2);
        this.loadLogo();
        this.setVisible(true);
        new Thread(this).start();
    }

    public void loadLogo() {
        try {
            InputStream in = this.getClass().getResourceAsStream("/rene/zirkel/logowindow.gif");
            int pos = 0;
            int n = in.available();
            byte[] b2 = new byte[200000];
            while (n > 0) {
                int k = in.read(b2, pos, n);
                if (k < 0) break;
                pos += k;
                n = in.available();
            }
            in.close();
            this.I = Toolkit.getDefaultToolkit().createImage(b2, 0, pos);
            MediaTracker T = new MediaTracker(this);
            T.addImage(this.I, 0);
            T.waitForAll();
        }
        catch (Exception e2) {
            this.setVisible(false);
            this.I = null;
        }
    }

    public void paint(Graphics g) {
        if (this.I == null) {
            return;
        }
        g.drawImage(this.I, 0, 0, this);
        Graphics2D G = (Graphics2D)g;
        G.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setFont(new Font("Dialog", 1, 14));
        String s = String.valueOf(Zirkel.name("version")) + " " + Zirkel.name("program.version");
        g.setColor(Color.black);
        g.drawString(s, 45, 270);
    }

    public void run() {
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(false);
        this.dispose();
    }
}

